      SUBROUTINE MN_CDF(IDELIM)
C
C     READS IN A SERIES OF DATA POINTS FROM A FILE
C     THE ORDER CARD OR THE CURRENT SET OF ORDER PARAMETERS
C     DEFINE THE NUMBER OF WORDS PER POINT
C     Times can also be interpretted. Recognized forms and the ORDER name are:
C     DATE    yymmdd
C     TIME    hhmmss or hhmm  (first occurence is used to find out which it is)
C     VAXTIME char*23
C     CAN ALSO BE USED TO READ IN AN NTUPLE
C     THE NTUPLE CARD MUST BE PRESENT AND THE ORDER CARD NOT
C     THE NTUPLE CARD MUST CONTAIN THE NUMBER OF DIMENSIONS AND THE
C     VARIABLE NAMES
C
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mnflg.inc"
#include "mntyq.inc"
#include "mncmd.inc"
#include "mncmt.inc"
#include "mntim.inc"
#include "mnlun.inc"
C
      integer mcrd
      PARAMETER (MCRD=9)
      CHARACTER*10 CRDNAM(MCRD)
C
      integer mpntmx
      PARAMETER (MPNTMX=100 000)
#include "mnscr.inc"
      REAL BUFDAT(MPNTMX)
      EQUIVALENCE(SCRATCH(1),BUFDAT(1))
C
      INTEGER IDBIN(MDIMMX)
      REAL ADLO(MDIMMX),ADHI(MDIMMX)
      REAL ACONT(3)
      CHARACTER*10 TCOMM
      CHARACTER*32 TNAME(MDIMMX),TNDEF(2)
C
      INTEGER IDLSTA(1000),IDLSTB(1000)
C
      CHARACTER*255 TCARD,TCRD2
      CHARACTER*133 TEXT
      CHARACTER*80 TITLE
      CHARACTER*23 CTIME,CTIME1,CTIME2
      CHARACTER*1  TMODE
      LOGICAL QOPEN,QXERR,QYERR,QXERRL,QXERRH,QYERRL,QYERRH
      LOGICAL QCID,QCTIT,QCLIM,QCNTU,QCORD,QCTIM,QTIME,QMAX,QEND,QEOF
      REAL RNUM(MDIMMX)
      INTEGER IXREF(MDIMMX)
      INTEGER NNUM,NDUMMY
*
      integer idelim,ndhis0,ierr,nidl,idtref,itmref,idbref
     + ,lent,lenc,lnblnk
     + ,jcmd,ida,idb,istr,nchar,nval,ndim,nchr,ii,nwppt
     + ,npntmx,nord,i,j,npnt,maxnum,nloop,nchr1,nchr2,idate,itime
     + ,idbtim,nptr,nwrd,nbppt,ntmode,nh,nptrh,nptrd,nwh
     + ,nptr1,nptr2,nn,nwdat,nwtot,nhdate,nhtime,nsdate,nstime,nnid
      real rval,xxlo,xxhi,x,y,dxl,dxh,dyl,dyh,edlo,edhi,edent
     + ,xaa,xab,xba,xbb
*
      integer  icmtyp,istrng,inttyp,isltyp,isttyp
      real     reltyp,am_tdif
      external icmtyp,istrng,inttyp,isltyp,isttyp,reltyp,am_tdif
C
      DATA CRDNAM/'ID', 'TITLE', 'LIMIT',
     1 'DATA', 'END', 'ORDER', 'NTUPLE', 'TIME', ' '/
      DATA TNDEF/'X', 'Y'/
C
      NDHIS0 = NDHIS
C
      QOPEN = .FALSE.
      CALL MN_FIL(2,LUNDIN,FIL_DT,IDELIM,IERR)
      IF(IERR.NE.0) GOTO 9000
      QOPEN = .TRUE.
C
      NIDL = 0
C
C     Set up the reference time and time mode
C
      TMODE  = TIMNAM(NMTIME)(1:1)
      IDTREF = NDTREF
      ITMREF = NTMREF
      IDBREF = 0
      IF(IDTREF.NE.0 .OR. ITMREF.NE.0) CALL M_PKTS(IDTREF,ITMREF,IDBREF)
C
      QCID = .FALSE.
      QCTIT = .FALSE.
      QCLIM = .FALSE.
      QCNTU = .FALSE.
      QCORD = .FALSE.
      QCTIM = .FALSE.
      QMAX  = .FALSE.
      TCARD = ' '
C
2500  CONTINUE
      READ(LUNDIN,'(A)',ERR=9100,END=9200) TEXT
C
      IF(TEXT(1:1).EQ.TSCOMM .OR. TEXT(1:2).EQ.' '//TSCOMM) THEN
          GOTO 2500
      ENDIF
C
      LENT = LNBLNK(TEXT)
      IF(LENT.LE.0) GOTO 2500
C
      IF(TCARD.EQ.' ') THEN
          TCARD = TEXT
      ELSE
          LENC = LNBLNK(TCARD)
          TCRD2 = TCARD(1:LENC) // TEXT(1:LENT)
          TCARD = TCRD2
      ENDIF
      LENC = LNBLNK(TCARD)
      IF(TCARD(LENC:LENC).EQ.TSCONT) THEN
          TCRD2 = TCARD(1:LENC-1)
          TCARD = TCRD2
          GOTO 2500
      ENDIF
C
      CALL QUOTYP(TCARD // ' ')
2600  CONTINUE
      QEND  = .FALSE.
      QEOF  = .FALSE.
      JCMD = ICMTYP(.TRUE.,IDELIM,CRDNAM)
      COMND2 = ' '
      IF(JCMD.GT.0) COMND2 = CRDNAM(JCMD)
C
C     SEE IF WE HAVE STARTED READING DATA ALREADY
C
      IF(JCMD.EQ.0) THEN
          CALL RESTYP
          RVAL = RELTYP(.TRUE.,IDELIM)
          IF(RVAL.NE.0.0 .OR. IDELIM.LE.0) THEN
              CALL RESTYP
              GOTO 3000
          ENDIF
      ENDIF
      IF(IDELIM.GT.0 .OR. JCMD.EQ.0) THEN
          CALL MN_DCK(IDELIM,JCMD,MCRD,CRDNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('MN_CDF')
          GOTO 9000
      ENDIF
C
C     READ IN THE NUMBERS OR TEXT IF APPROPRIATE
C
      TCARD = ' '
      NNUM = 0
      IF(COMND2.EQ.'ID' .OR. COMND2.EQ.'LIMIT') THEN
          IF(IDELIM.LT.0) THEN
              CALL MN_ERR('MN_CDF','Error in ' // COMND2 //
     +         ' card.')
              GOTO 9000
          ENDIF
 2620     CONTINUE
          RVAL = RELTYP(.TRUE.,IDELIM)
          CALL MN_RCK(RVAL,IDELIM,IERR)
          IF(IERR.EQ.2) GOTO 2625
          IF(IERR.GT.0) GOTO 9000
          NNUM = NNUM + 1
          RNUM(NNUM) = RVAL
          IF(NNUM.LT.2 .AND. IDELIM.EQ.0) GOTO 2620
      ENDIF
 2625 CONTINUE
C
C     IDENTIFIER CARD
C
      IF(COMND2.EQ.'ID') THEN
          QCID = .TRUE.
          IDA = NINT(RNUM(1))
          IF(NNUM.GT.1) THEN
              IDB = NINT(RNUM(2))
              IF(IDB.LT.0 .OR. IDB.GE.1000) THEN
                  WRITE(TXTERR,'(1X,I4,'' is not valid as a secondary''
     1             ,'' ID'')') IDB
                  CALL M_EMSG('MN_CDF',TXTERR)
                  WRITE(TXTERR,'('' It will be set to'',I4)') NDIDB
                  CALL M_EMSG('MN_CDF',TXTERR)
                  IDB = NDIDB
              ENDIF
          ELSE
              IDB = NDIDB
          ENDIF
C
C     TITLE CARD
C
      ELSEIF(COMND2.EQ.'TITLE') THEN
          QCTIT = .TRUE.
          IF(IDELIM.LT.0) THEN
              WRITE(TXTERR,'(''Plot'',I7,I4
     1         ,''  Error in '',A,'' card.''
     1         ,'' No title given'')') IDA,IDB,COMND2
              CALL M_EMSG('MN_CDF',TXTERR)
              GOTO 2500
          ENDIF
          ISTR = ISTRNG(.TRUE.,TEXT,NCHAR)
          CALL ZERTYP('.FALSE.')
          TITLE = TEXT(1:NCHAR)
C
C     LIMITS
C
      ELSEIF(COMND2.EQ.'LIMIT') THEN
          IF(NNUM.LT.2) THEN
              CALL M_EMSG('MN_CDF','Must specify lower and upper' //
     +         ' limits on LIMIT card')
              GOTO 2500
          ENDIF
          QCLIM = .TRUE.
          XXLO = RNUM(1)
          XXHI = RNUM(2)
          IF(XXHI.LE.XXLO) THEN
              WRITE(TXTERR,'(''Error in specified limits'',2G11.4
     1         ,'' They will be ignored'')') XXLO,XXHI
              CALL M_EMSG('MN_CDF',TXTERR)
              XXLO = 0.0
              XXHI = 0.0
          ENDIF
C
C     SIGNAL BEGINNING OF DATA POINTS
C
      ELSE IF(COMND2.EQ.'DATA') THEN
          GOTO 3000
C
C     SIGNAL END OF DATA - NOT VALID AS I AM NOT READING DATA POINTS
C
      ELSE IF(COMND2.EQ.'END') THEN
          CALL M_EMSG('MN_CDF','END card not valid here. I am not' //
     +     ' reading in data points')
C
C     DEFINE THE ORDER OF THE VARIABLES
C
      ELSE IF(COMND2.EQ.'ORDER') THEN
          QCORD = .TRUE.
          CALL M_SORD(1,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9000
C
C     Define the time mode and the reference time
C
      ELSE IF(COMND2.EQ.'TIME') THEN
          QCTIM = .TRUE.
          CALL M_STIM(1,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9000
C
          TMODE  = TIMNAM(NMTIME)
          IDTREF = NDTREF
          ITMREF = NTMREF
          IDBREF = 0
          IF(IDTREF.NE.0 .OR. ITMREF.NE.0)
     +     CALL M_PKTS(IDTREF,ITMREF,IDBREF)
C
C     NTUPLE CARD
C
      ELSE IF(COMND2.EQ.'NTUPLE') THEN
          QCNTU = .TRUE.
          IF(IDELIM.LT.0) THEN
              CALL MN_ERR('MN_CDF','Error in ' // COMND2 //
     +         ' card. No dimension given')
              GOTO 9000
          ENDIF
          NVAL = INTTYP(.TRUE.,IDELIM)
          CALL MN_NCK(NVAL,IDELIM,IERR)
          IF(IERR.NE.0) GOTO 9000
          NDIM = NVAL
C
C         GET THE VARIABLE NAMES
C
          NNUM = 0
          NDUMMY = 0
          CALL VZERO_i(IXREF,20)
          DO 2640 II=1,NDIM
 2630         CONTINUE
              NCHR = ISLTYP(.TRUE.,IDELIM,TCOMM)
              NNUM = NNUM + 1
              CALL M_LUPC(TCOMM(1:NCHR),TNAME(II))
              IF(TNAME(II).EQ.'DUMMY' .AND. IDELIM.GE.0) THEN
                  NDUMMY = NDUMMY + 1
                  GOTO 2630
              ELSE
                  IXREF(NNUM) = II
              ENDIF
              IF(IDELIM.LT.0) GOTO 2645
 2640     CONTINUE
 2645     CONTINUE
          IF(NNUM.LT.NDIM+NDUMMY) THEN
              WRITE(TXTERR,'(''Not enough variable''
     1         ,'' names given for Ntuple'',I7,I4)') IDA,IDB
              CALL MN_ERR('MN_CDF',TXTERR)
              GOTO 9000
          ENDIF
      ENDIF
      GOTO 2500
C
C     FINISHED READING THE DATA CARDS
C     CHECK WHAT I HAVE SPECIFIED AND SET REST TO DEFAULT
C
3000  CONTINUE
      IF(.NOT.QCID) THEN
          CALL M_EMSG('MN_CDF','You have not given ID card.' //
     +     ' The histogram id will be set to 1')
          IDA = 1
          IDB = NDIDB
      ENDIF
      NIDL = NIDL + 1
      IF(NIDL.GT.1000) THEN
          CALL M_EMSG('MN_CDF','Ran out of room to keep track' //
     +     ' of which plots have been fetched')
          CALL M_EMSG('MN_CDF','This does not affect the fetch')
          NIDL = 1000
      ENDIF
      IDLSTA(NIDL) = IDA
      IDLSTB(NIDL) = IDB
C
      IF(.NOT.QCTIT) THEN
          TITLE = ' '
      ENDIF
C
      IF(.NOT.QCLIM) THEN
          XXLO = 0.0
          XXHI = 0.0
      ENDIF
C
      IF(.NOT.QCNTU) THEN
          TNAME(1) = TNDEF(1)
          TNAME(2) = TNDEF(2)
      ENDIF
C
      QTIME = .FALSE.
      IF(QCNTU) THEN
          IF(QCORD) THEN
              CALL M_EMSG('MN_CDF','ORDER card is invalid' //
     +         ' for an Ntuple. It will be ignored')
          ENDIF
          NDIM = -IABS(NDIM)
          NWPPT = IABS(NDIM)
          NPNTMX = MPNTMX / IABS(NDIM)
C
C     USE THE ORDER TO SET UP A CROSS-REFERENCE TABLE FOR THE NUMBERS
C
      ELSE
          NDIM = -1
          CALL VZERO_i(IXREF(1),20)
          NORD = 0
          DO 3100 I=1,20
              IF(IORDMN(I).LE.0) GOTO 3110
              DO 3090 J=1,MORD-1
                  IF(IORDMN(I).EQ.J) THEN
                      IF(J.LE.4) THEN
                          IXREF(I) = J
                      ELSEIF(J.LE.8) THEN
                          IXREF(I) = J - 2
                      ELSEIF(J.LE.12) THEN
                          IXREF(I) = J - 6
                      ELSEIF(J.EQ.MDUMMY) THEN
                          IXREF(I) = 0
C                     All date and time formats
                      ELSEIF(J.GT.MDUMMY) THEN
                          QTIME = .TRUE.
                          IXREF(I) = -(J-MDUMMY)
                      ENDIF
                      GOTO 3091
                  ENDIF
3090          CONTINUE
3091          CONTINUE
              IF(IXREF(I).NE.0) NORD = NORD + 1
3100      CONTINUE
3110      CONTINUE
          NWPPT = 2 * ((NORD - 1) / 2 + 1)
          NPNTMX = MPNTMX / NWPPT
      ENDIF
C
      NPNT  = 0
      MAXNUM = 0
      QXERR  = .FALSE.
      QYERR  = .FALSE.
      QXERRL = .FALSE.
      QXERRH = .FALSE.
      QYERRL = .FALSE.
      QYERRH = .FALSE.
      CALL VZERO_r(BUFDAT,MPNTMX)
C
C     DON'T READ IN THE NEXT LINE IF WE HAVE ALREADY STARTED READING DATA
C
      IF(JCMD.EQ.0) GOTO 4100
C
4000  CONTINUE
      READ(LUNDIN,'(A)',ERR=4040,END=4050) TCARD
      GOTO 4100
4040  CONTINUE
      CALL MN_ERR('MN_CDF','Error reading in data cards ***')
      GOTO 5000
4050  CONTINUE
      QEOF = .TRUE.
      GOTO 5000
4100  CONTINUE
      CALL QUOTYP(TCARD // ' ')
      TCARD = ' '
C
C     EXTRACT THE DATA
C
      NNUM = 0
4200  CONTINUE
C
C     SEE IF WE ARE STARTING A NEW PLOT
C
      JCMD = ICMTYP(.TRUE.,IDELIM,CRDNAM)
      IF(IDELIM.EQ.ICHAR(TSCOMM)) GOTO 4250
      COMND2 = ' '
      IF(JCMD.GT.0) THEN
          COMND2 = CRDNAM(JCMD)
          IF(COMND2.NE.'END') THEN
              CALL RESTYP
          ELSE
              QEND = .TRUE.
          ENDIF
          GOTO 5000
      ELSE
          CALL RESTYP
      ENDIF
C
C     Dummy
C
      IF(IXREF(NNUM+1).EQ.0) THEN
          NCHR = ISTTYP(.TRUE.,IDELIM,TEXT)
C
C     Normal number
C
      ELSEIF(QCNTU .OR. IXREF(NNUM+1).GT.0) THEN
          RVAL = RELTYP(.TRUE.,IDELIM)
          CALL MN_RCK(RVAL,IDELIM,IERR)
          IF(IERR.GT.0) THEN
              IF(IERR.EQ.2 .AND. IDELIM.GE.0) GOTO 4200
              IF(IERR.EQ.2 .AND. IDELIM.LT.0) GOTO 4250
              GOTO 9000
          ENDIF
C
C     See if this entry is supposed to be a time
C
      ELSEIF(.NOT.QCNTU) THEN
          NLOOP = 0
4220      CONTINUE
          NLOOP = NLOOP + 1
          IF(IXREF(NNUM+1).EQ.-6) THEN
              NCHR1 = ISTTYP(.TRUE.,IDELIM,CTIME1)
              NCHR2 = ISTTYP(.TRUE.,IDELIM,CTIME2)
              CTIME = ' '
              IF(NCHR1.GT.0 .AND. NCHR2.GT.0)
     +         CTIME = CTIME1(1:NCHR1) // ' ' // CTIME2(1:NCHR2)
              CALL M_VTIM(CTIME,IDATE,ITIME)
          ELSE
              NVAL = INTTYP(.TRUE.,IDELIM)
              CALL MN_NCK(NVAL,IDELIM,IERR)
              IF(IERR.GT.0) THEN
                  IF(IERR.EQ.2 .AND. IDELIM.GE.0) GOTO 4200
                  IF(IERR.EQ.2 .AND. IDELIM.LT.0) GOTO 4250
                  GOTO 9000
              ENDIF
          ENDIF
C
          IF(IXREF(NNUM+1).EQ.-1) THEN
              IF(NLOOP.EQ.1) IDATE = NVAL
              IF(NLOOP.EQ.2) ITIME = NVAL
          ELSEIF(IXREF(NNUM+1).EQ.-2) THEN
              IDATE = NVAL
              ITIME = 0
          ELSEIF(IXREF(NNUM+1).EQ.-3) THEN
              IDATE = 800101
              ITIME = NVAL
          ELSEIF(IXREF(NNUM+1).EQ.-4) THEN
              IF(NLOOP.EQ.1) IDATE = NVAL
              IF(NLOOP.EQ.2) ITIME = NVAL*100
          ELSEIF(IXREF(NNUM+1).EQ.-5) THEN
              IDATE = 800101
              ITIME = NVAL*100
          ENDIF
          IF(NLOOP.EQ.1 .AND.
     +       (IXREF(NNUM+1).EQ.-1 .OR. IXREF(NNUM+1).EQ.-4)) GOTO 4220
C
*ICB          IF(IDATE.LT.800101 .OR. IDATE.GT.1991231 .OR.
          IF(IDATE.LT.000101 .OR. IDATE.GT.991231 .OR.
     +       ITIME.LT.0      .OR. ITIME.GT.240000) THEN
              CALL M_EMSG('MN_CDF','Bad time found in card:')
              CALL MN_ERR('MN_CDF',TCARD)
              GOTO 9000
          ENDIF

          CALL M_PKTS(IDATE,ITIME,IDBTIM)
C
C         Store the first point as the reference time if no TIME card
C         and reference time has not been set
C
          IF(IDTREF.EQ.0 .AND. ITMREF.EQ.0 .AND. NPNT.EQ.0) THEN
              IDTREF = IDATE
              ITMREF = ITIME
              IDBREF = IDBTIM
          ENDIF
          RVAL = AM_TDIF(IDBREF,IDBTIM,TMODE)
      ENDIF
C
      NNUM = NNUM + 1
      RNUM(NNUM) = RVAL
      IF(IDELIM.EQ.0) GOTO 4200
C
4250  CONTINUE
C
      IF(NNUM.LE.0) GOTO 4000
      NPNT = NPNT + 1
C
      IF(NPNT.GT.NPNTMX) THEN
          IF(.NOT.QMAX) THEN
              WRITE(TXTERR,'(''I only have temporary storage space''
     +         ,'' for'',I5,'' points.'')') NPNTMX
              CALL M_EMSG('MN_CDF',TXTERR)
              CALL M_EMSG('MN_CDF','I will ignore the rest')
          ENDIF
          QMAX = .TRUE.
          NPNT = NPNTMX
          GOTO 4000
      ENDIF
      NPTR = NWPPT*(NPNT-1)
C
      IF(QCNTU) THEN
          IF(NNUM.NE.IABS(NDIM)+NDUMMY) THEN
              WRITE(TXTERR,'(''Point'',I6,'' has'',I4
     +         ,'' numbers when I was expecting'',I4,''+'',I4)')
     +         NPNT,NNUM,IABS(NDIM),NDUMMY
              CALL M_EMSG('MN_CDF',TXTERR)
              CALL M_EMSG('MN_CDF','It will be ignored')
              NPNT = NPNT - 1
              GOTO 4000
          ENDIF
          DO I=1,NNUM
              IF(IXREF(I).GT.0) THEN
                  BUFDAT(NPTR + IXREF(I)) = RNUM(I)
              ENDIF
          ENDDO
      ELSE
          MAXNUM = MAX0(MAXNUM,NNUM)
          X = 0.0
          Y = 0.0
          DXL = 0.0
          DXH = 0.0
          DYL = 0.0
          DYH = 0.0
          DO 4300 I=1,NNUM
              IF(IXREF(I).EQ.0) GOTO 4300
C
C             Time is always assumed to be the x-axis
C
              IF(IXREF(I).GT.0) THEN
                  BUFDAT(NPTR + IXREF(I)) = RNUM(I)
              ELSE
                  BUFDAT(NPTR + 1)        = RNUM(I)
              ENDIF
              IF(IXREF(I).EQ.1 .OR. IXREF(I).LT.0) THEN
                  X = RNUM(I)
              ELSE IF(IXREF(I).EQ.3) THEN
                  QXERR = .TRUE.
                  QXERRL = .TRUE.
              ELSE IF(IXREF(I).EQ.4) THEN
                  QYERR = .TRUE.
                  QYERRL = .TRUE.
              ELSE IF(IXREF(I).EQ.5) THEN
                  QXERRH = .TRUE.
              ELSE IF(IXREF(I).EQ.6) THEN
                  QYERRH = .TRUE.
              ENDIF
4300      CONTINUE
C
          IF((XXLO.NE.0.0 .OR. XXHI.NE.0.0) .AND.
     +       (X.LT.XXLO .OR. X.GT.XXHI)) THEN
              WRITE(TXTERR,'(''Point'',2(1PG11.4)
     +         ,'' outside given limits'',2(1PG11.4))')
     +         X,Y,XXLO,XXHI
              CALL M_EMSG('MN_CDF',TXTERR)
              CALL M_EMSG('MN_CDF','It will be ignored')
              NPNT = NPNT - 1
              GOTO 4000
          ENDIF
      ENDIF
      GOTO 4000
C
C     READ IN ALL THE DATA CHECK IT OUT AND FILL THE HEADER
C
 5000 CONTINUE
      WRITE(TXTMES,'('' Plot'',I7,I4
     +  ,''  Data for'',I6,'' points read in'')')
     + IDA,IDB,NPNT
      CALL MN_MES(LUNTTO,'ME',TXTMES)
C
C     BOOK THE NEW HISTOGRAM AND ESTABLISH POINTERS
C
      NWRD = NWPPT * NPNT
      NBPPT = 0
      NTMODE = 0
      IF(QTIME) THEN
          if(tmode.eq.'D') then
              ntmode = 1
          elseif(tmode.eq.'H') then
              ntmode = 2
          elseif(tmode.eq.'M') then
              ntmode = 3
          else
              ntmode = 4
          endif
      ENDIF
      CALL MN_HNW(IDA,IDB,NDIM,NWRD,NH,NPTRH,NPTRD,NWH,NBPPT,NTMODE)
C
C     CHECK THAT THE ERRORS ARE DONE PROPERLY
C
      IF(NPNT.GT.0 .AND. .NOT.QCNTU .AND.
     +   NWPPT.GE.4 .AND. .NOT.QYERR) THEN
          CALL MN_MES(LUNTTO,'ME'
     +     ,' Errors are square root of the number of entries')
      ENDIF
C
      EDLO  = 1.0E+30
      EDHI  = -1.0E+30
      EDENT = 0.0
      CALL VZERO_i(IDBIN,MDIMMX)
      CALL VFILL(ADLO,MDIMMX,1.0E+30)
      CALL VFILL(ADHI,MDIMMX,-1.0E+30)
      call vzero_r(acont,3)
      DXL = 0.0
      DYL = 0.0
      DXH = 0.0
      DYH = 0.0
      DO 5200 II=1,NPNT
          NPTR1 = NWPPT*(II-1)
          NPTR2 = NPTRD + NWPPT*(II-1) - 1
          IF(QCNTU) THEN
              CALL UCOPY_r(BUFDAT(NPTR1+1),RDAT(NPTR2+1),NWPPT)
              EDENT = EDENT + 1.0
              EDLO  = 0.0
              EDHI  = 1.0
              DO 5150 NN=1,IABS(NDIM)
                  ADLO(NN) = AMIN1(ADLO(NN),BUFDAT(NPTR1+NN))
                  ADHI(NN) = AMAX1(ADHI(NN),BUFDAT(NPTR1+NN))
5150          CONTINUE
          ELSE
              X   = BUFDAT(NPTR1 + 1)
              Y   = BUFDAT(NPTR1 + 2)
              IF(NWPPT.GT.2) THEN
                  DXL = BUFDAT(NPTR1 + 3)
                  DYL = BUFDAT(NPTR1 + 4)
              ENDIF
              DXH = DXL
              DYH = DYL
              IF(NWPPT.GT.4) THEN
                  IF(QXERRH) DXH = BUFDAT(NPTR1 + 5)
                  IF(QYERRH) DYH = BUFDAT(NPTR1 + 6)
              ELSE
                  DXH = DXL
                  DYH = DYL
              ENDIF
C
              IF(.NOT.QXERR) THEN
                  IF(II.EQ.1) XAA = X
                  IF(II.EQ.2) XAB = X
                  IF(II.EQ.NPNT-1) XBA = X
                  IF(II.EQ.NPNT)   XBB = X
              ENDIF
C
              IF(NWPPT.GT.2 .AND. .NOT.QYERR) THEN
                  DYL = SQRT(ABS(Y))
                  IF(NWPPT.GT.4) DYH = DYL
              ENDIF
C
              RDAT(NPTR2 + 1) = X
              RDAT(NPTR2 + 2) = Y
              IF(NWPPT.GT.2) THEN
                  RDAT(NPTR2 + 3) = DXL
                  RDAT(NPTR2 + 4) = DYL
              ENDIF
              IF(NWPPT.GT.4) THEN
                  RDAT(NPTR2 + 5) = DXH
                  RDAT(NPTR2 + 6) = DYH
              ENDIF
C
              ADLO(1)  = AMIN1(ADLO(1),X-DXL)
              ADHI(1)  = AMAX1(ADHI(1),X+DXH)
              EDENT = EDENT + Y
              EDLO  = AMIN1(EDLO,Y-DYL)
              EDHI  = AMAX1(EDHI,Y+DYH)
              acont(2) = acont(2) + y
          ENDIF
 5200 CONTINUE
C
C     Set up the plot limits when no errors are given
C     or for time plots put them 5% outside the range found
C
      IF(QTIME) THEN
          ADLO(1) = ADLO(1) - 0.05*(ADHI(1)-ADLO(1))
          ADHI(1) = ADHI(1) + 0.05*(ADHI(1)-ADLO(1))
C
      ELSEIF(.NOT.QXERR .AND. NPNT.GT.1) THEN
          IF(ABS(XAA-ADLO(1)).LT.1.0E-6*ADLO(1))
     +     ADLO(1) = ADLO(1) - 0.5*ABS(XAB - XAA)
          IF(ABS(XBB-ADHI(1)).LT.1.0E-6*ADHI(1))
     +     ADHI(1) = ADHI(1) + 0.5*ABS(XBB - XBA)
      ENDIF
C
      IF(.NOT.QCNTU .AND. (XXLO.NE.0.0 .OR. XXHI.NE.0.0)) THEN
          ADLO(1) = XXLO
          ADHI(1) = XXHI
      ENDIF
C
      NWDAT = NWPPT * NPNT
      NWTOT = NWH + NWDAT
      NHDATE = 0
      NHTIME = 0
      NSDATE = 0
      NSTIME = 0
      IF(QTIME) THEN
          NSDATE = IDTREF
          NSTIME = ITMREF
      ENDIF
      CALL MN_HDU(RDAT(NPTRH),NWTOT,NWH,NWDAT,IDA,IDB,NDIM,NWPPT,NPNT
     + ,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     + ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,ACONT)
      CALL MN_PTU(NH,NWTOT,IDA,IDB,NPTRH,NPTRD,TITLE,FIL_DT,' ',TNAME)
      CALL MN_MSU(IDA,IDB,NDIM,NWH,NH)
C
C     READ IN NEXT SET OF DATA POINTS IF THERE IS ONE
C
      QCID = .FALSE.
      QCTIT = .FALSE.
      QCLIM = .FALSE.
      QCNTU = .FALSE.
      QCORD = .FALSE.
      QCTIM = .FALSE.
      QMAX  = .FALSE.
      TCARD = ' '
      IF(.NOT.QEOF .AND. QEND) GOTO 2500
      IF(.NOT.QEOF .AND. .NOT.QEND) GOTO 2600
C
 9000 CONTINUE
      GOTO 9900
C
 9100 CONTINUE
      CALL MN_ERR('MN_CDF','Error reading in data.')
      GOTO 9900
C
 9200 CONTINUE
      CALL MN_MES(LUNTTO,'ME',' MN_CDF: End of file reading in data.')
      GOTO 9900
C
 9900 CONTINUE
      IF(QOPEN) CLOSE(UNIT=LUNDIN)
cif      IF(QIF.AND.IFIIFL.GT.0.AND.IERR.NE.0)IFIIFL= IFIIFL - 1
C
C     CHECK THAT I GOT THE HISTOGRAMS I WANTED
C
      NNID = 2
      CALL MN_HNG('MN_CDF',NNID,NDHIS0,NIDL,IDLSTA,IDLSTA,IDLSTB,IDLSTB)
C
C     Clear out the TYPSCN buffer
C
      CALL ZERTYQ('.FALSE.')
C
      RETURN
      END
