      subroutine m_chset(tvar,tval,ierr)
*
*------------------------------------------------------------------------------
*     Set a character array element, histogram title or Ntuple variable name
*------------------------------------------------------------------------------
*
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mnprs.inc"
#include "mntyq.inc"
#include "mnlun.inc"
*
      character*(*) tvar,tval
      integer ierr
*
      integer icmd,iset,ivar,nelem,npnt,idelim,n1,n2
      integer nchr,len1,len2
      logical qpass
      character*32 comand
      character*255 txt1,txt2
*
      integer iqstyp,iqstyq,lnblnk
*
*-----------------------------------------------------------------------
*
      ierr = 0
*ICB      write(6,'('' Variable: '',A)') tvar
*ICB      write(6,'('' Value: '',A)') tval
*
*     Find what to fill
*
      call quotyp(tvar)
      call m_tget(icmd,comand,iset,ivar,nelem,npnt,idelim,n1,n2,qpass)
      if(.not.qpass) then
        ierr = 1
        return
      endif
*
*     Cannot change the value of an Ntuple variable
*
      if(icmd.ge.4) then
        txterr = 'I do not support changing of ' // COMAND
        call m_emsg('M_CHSET',txterr)
        ierr = 1
        goto 9000
      endif
*
*     Get the string including parsing
*
      len2 = lnblnk(tval)
      if(len2.gt.0) then
        call quotyp(tval(:len2))
        nchr = iqstyp(.true.,idelim,txt1)
      else
        call waityq('Give the string: ')
        txt1 = ' '
        nchr = iqstyq(.true.,idelim,txt1)
      endif
      call mn_tvl(txt1,txt2)
*
*     Know what to fill - now fill it
*
*     A character array element
*
      if(icmd.eq.1) then
        if(n1.eq.0 .and. n2.eq.0) then
          tchar(iset) = txt2
        elseif(n1.gt.0 .and. n2.gt.0) then
          tchar(iset)(n1:n2) = txt2
        elseif(n1.gt.0) then
          tchar(iset)(n1:) = txt2
        elseif(n2.gt.0) then
          tchar(iset)(:n2) = txt2
        else
          ierr = 1
          goto 9000
        endif
*
*     A title
*
      elseif(icmd.eq.2) then
        if(n1.eq.0 .and. n2.eq.0) then
          tdtit(iset) = txt2
        elseif(n1.gt.0 .and. n2.gt.0) then
          tdtit(iset)(n1:n2) = txt2
        elseif(n1.gt.0) then
          tdtit(iset)(n1:) = txt2
        elseif(n2.gt.0) then
          tdtit(iset)(:n2) = txt2
        else
          ierr = 1
          goto 9000
        endif
*
*     An Ntuple variable name
*
      elseif(icmd.eq.3) then
        if(n1.eq.0 .and. n2.eq.0) then
          tdnam(ivar,iset) = txt2
        elseif(n1.gt.0 .and. n2.gt.0) then
          tdnam(ivar,iset)(n1:n2) = txt2
        elseif(n1.gt.0) then
          tdnam(ivar,iset)(n1:) = txt2
        elseif(n2.gt.0) then
          tdnam(ivar,iset)(:n2) = txt2
        else
          ierr = 1
          goto 9000
        endif
      endif
*
      len1 = lnblnk(tvar)
      len2 = max0(1,lnblnk(txt2))
      if(qecho) write(luntto,5000) tvar(:len1),txt2(:len2)
 5000 format(1X,A,' = ',A)
*
 9000 continue
      end
