      SUBROUTINE TYQRED(QWAIT)
C
C     Gets the next input string
C     QWAIT is used in the menu driven version  to set the priority
C     of the call for getting the next command. .FALSE. means that
C     the answer should not be stacked
C
      IMPLICIT NONE
C
#include "mntyq.inc"
#include "mncmd.inc"
#include "mncmt.inc"
#include "mnlun.inc"
#include "mndbg.inc"
#if ( defined(L3_CPC) )
#include "mncpc_g.inc"
#endif

C
      LOGICAL QWAIT,QEXIT,QCONT
      CHARACTER*255 TEXT,TXT2,TXTO,TXTC
      CHARACTER*2 TSTR,TSTR2
      CHARACTER TCOMM*40,TTPARM*80
      INTEGER NCHAR,NNCHAR,NCHAR2,NNCHRO,NNPARM
      INTEGER I,N1,N2,NN,NN1,NN2,IDELIM,ISTR,LENT,NIFLV,NFDEP
     + ,NVAL,NMAX,NSTEP,ILEV,IOERR,ICMD,IND
      LOGICAL QSQ,QDQ,QSKIP
C
      character concat*255
      INTEGER  ISTRNG,ICMTYP,LNBLNK
      EXTERNAL ISTRNG,ICMTYP,concat
C
      CHARACTER*10 TYQNAM(8)
      DATA TYQNAM/'RETURN','ENDDO','ELSE','ENDIF','ELIF','IF','FI',' '/
C
      TEXT = ' '
      TXTC = ' '
 1000 CONTINUE
      QCONT = .FALSE.
 1100 CONTINUE
C
C     Reading from terminal or a file
C
      IF(LUNCMD.GT.0) THEN
          TEXT = ' '
#if ( defined(L3_CPC) )
C
C         Get a command from CLUSCOM common block
C         This read form is used in the L3 Online Histogram display
C
          IF(LUNCMD.EQ.LUNTTI) THEN
              IF(QWAIT) THEN
                  CALL SEND_MES('P',TPRCMD(1:NPRCMD))
              ELSE
                  CALL SEND_MES('Q',TPRCMD(1:NPRCMD))
              ENDIF
              CALL RECV_CMD
              TEXT  = TMN_CMD
              NCHAR = LNBLNK(TEXT)
          ELSE
#endif

              ISTR = ISTRNG(QWAIT,TEXT,NCHAR)
#if ( defined(L3_CPC) )
          ENDIF
#endif

C
C         Only add a record if the unit is not LUNJNK.
C         LUNJNK is used at the start of fitting in a funny way
C
          IF(LUNCMD.NE.LUNJNK .AND. NTDEP.GT.0)
     1     IUNREC(NTDEP) = IUNREC(NTDEP) + 1
          NNCHAR = NCHAR
          IF(NCHAR.LE.0) THEN
              TEXT   = ' '
              NNCHAR = 1
          ENDIF
          if(qdebug .and. ndebug.ge.110) then
            write(luntto,'('' Record: '',I6,1X,A)')
     +       iunrec(ntdep),text(:nnchar)
          endif
C
C     READING FROM AN INTERNALLY DEFINED COMMAND
C
      ELSE
          IP1CMD(NTDEP) = IP1CMD(NTDEP) + 1
          IF(IP1CMD(NTDEP).GT.IP2CMD(NTDEP)) THEN
              QEXIT = .TRUE.
              GOTO 5000
          ELSE
              TEXT = TOPRBF(IP1CMD(NTDEP))
              NNCHAR = LNBLNK(TEXT)
              IF(NNCHAR.LE.0) THEN
                  TEXT = ' '
                  NNCHAR = 1
              ENDIF
          ENDIF
      ENDIF
*
*     Check for a comment and return command in text and comment in txtc
*
      call tyqcomm(text,nnchar,txtc)
*
*     If we are defining a command just ignore the comment line
*     Don't forget to clear out the string
*
      if(tprcmd(1:nprcmd).eq.'DEFINE>' .and.
     + text.eq.' ' .and. txtc.ne.' ') then
        CALL ZERTYP('.FALSE.')
        goto 1100
      endif
C
C     Concatenate the continuation line
C
 1200 CONTINUE
      IF(QCONT) THEN
          IF(NNCHAR.GT.1 .OR.
     +       (NNCHAR.EQ.1 .AND. TEXT(NNCHAR:NNCHAR).NE.' ')) THEN
              TXTO = TXT2(:NCHAR2-1) // TEXT(:NNCHAR)
              NNCHAR = NCHAR2 + NNCHAR - 1
          ELSE
              TXTO = TXT2(:NCHAR2-1)
              NNCHAR = NCHAR2 - 1
          ENDIF
          TEXT   = TXTO
      ENDIF
C
C     Check for a continuation line
C
      IF(TEXT(NNCHAR:NNCHAR).EQ.TSCONT) THEN
          QCONT  = .TRUE.
          CALL ZERTYP('.FALSE.')
          CALL WAITYP('_' // TPRCMD(:NPRCMD))
          TXT2   = TEXT
          NCHAR2 = NNCHAR
          GOTO 1100
      ENDIF
C
C     LOOK FOR PARAMETERS IN THE COMMAND STRING OR FOR THE DO LOOP
C     VARIABLE IF WE ARE IN A DO LOOP
C     NO POINT IN LOOKING IF 1 OR FEWER CHARACTERS ARE IN THE BUFFER
C     Also do not look if this is an DO loop.
C     If it is an IF block then do the translation in case there is an ELIF
C
C
      IF(TPRCMD(1:NPRCMD).NE.'DEFINE>' .AND. QDSKIP) GOTO 2000
      IF(TPRCMD(1:NPRCMD).NE.'DEFINE>' .AND. NTDEP.GT.0) THEN
          IF(QIF(NTDEP)) then
*ICB              if(.NOT.QCOND(IIFLV(NTDEP),NTDEP)) GOTO 2000
          endif
      ENDIF
C
      IF(NNCHAR.GT.1 .AND. (QRFILE .OR. LUNCMD.EQ.0)) THEN
C
C         FIRST SUBSTITUTE PARAMETERS
C
          DO 1500 I=1,9
              NNPARM = IPMCMD(I,NTDEP)
              TTPARM = TPMCMD(I,NTDEP)
              TSTR = '@ '
              N1 = 1
              WRITE(TSTR(2:2),'(I1)') I
 1400         CONTINUE
              NN = INDEX(TEXT(N1:NNCHAR),TSTR)
              N2 = N1 + NN - 1
              IF(NN.EQ.0) THEN
                  GOTO 1500
C
C             Do not do substitution if we are in DEFINE and the symbol
C             is @@. Just replace the @@ by a @.
C
              ELSEIF(TPRCMD(1:NPRCMD).EQ.'DEFINE>' .AND.
     +         N2.GT.1 .AND. TEXT(N2-1:N2-1).EQ.'@') THEN
                  IF(N2.GT.2) THEN
                      TXTO = TEXT(1:N2-2) // TEXT(N2:NNCHAR)
                  ELSE
                      TXTO = TEXT(N2:NNCHAR)
                  ENDIF
C
                  NNCHAR = NNCHAR - 1
                  TEXT = TXTO
                  N1 = N2 + 1
                  IF(N1.LT.NNCHAR) GOTO 1400
C
C             Do the parameter substitution
C
              ELSE
                  IF(NNPARM.EQ.-1) THEN
C
C                     TURN OFF AND ON BREAK ENABLE
C
                      WRITE(TXTMES,'('' Parameter'',I2
     1                 ,'' found but not given.'')') I
                      CALL MN_MES(LUNTTO,'M',TXTMES)
                      WRITE(TXTMES,'('' Command: '',A)')
     +                 TEXT(1:min0(70,NNCHAR))
                      CALL MN_MES(LUNTTO,'E',TXTMES)
C
                      CALL TYQINQ(I,IDELIM)
                      NNPARM = IPMCMD(I,NTDEP)
                      TTPARM = TPMCMD(I,NTDEP)
                  ENDIF
C
C                 SUBSTITUTE THE PARAMETER
C
                  IF(N2.GT.1 .AND. NNPARM.GT.0) THEN
                      TXTO = TEXT(1:N2-1) // TTPARM(1:NNPARM)
                  ELSE IF(N2.LE.1 .AND. NNPARM.GT.0) THEN
                      TXTO = TTPARM(1:NNPARM)
                  ELSE IF(N2.GT.1 .AND. NNPARM.LE.0) THEN
                      TXTO = TEXT(1:N2-1)
                  ELSE
                      TXTO = ' '
                  ENDIF
                  NNCHRO = N2 - 1 + NNPARM
C
                  IF(N2+2.LE.NNCHAR) THEN
                      IF(NNCHRO.GT.0) THEN
                          TXT2 = TXTO(1:NNCHRO) // TEXT(N2+2:NNCHAR)
                      ELSE
                          TXT2 = TEXT(N2+2:NNCHAR)
                      ENDIF
                      TEXT   = TXT2
                      NNCHAR = NNCHRO + (NNCHAR-N2-2) + 1
                  ELSE
                      IF (NNCHRO.GT.0) THEN
                          TEXT = TXTO(1:NNCHRO)
                          NNCHAR = NNCHRO
                      ELSE
                          TEXT = ' '
                          NNCHAR = 1
                      ENDIF
                      GOTO 1500
                  ENDIF
                  N1 = N2 + NNPARM
                  IF(N1.LT.NNCHAR) GOTO 1400
              ENDIF
1500      CONTINUE
C
C         THEN SUBSTITUTE FOR LOOP VARIABLES
C         LOOK FOR BOTH LOWER AND UPPER CASE
C
          DO 1700 I=1,NFORDP(NTDEP)
              TSTR = '@' // TFORNM(I,NTDEP)
              CALL M_LLWC(TSTR,TSTR2)
              N1 = 1
1600          CONTINUE
              NN1 = INDEX(TEXT(N1:NNCHAR),TSTR)
              NN2 = INDEX(TEXT(N1:NNCHAR),TSTR2)
              IF(NN1.EQ.0) THEN
                  NN = NN2
              ELSE IF(NN2.EQ.0) THEN
                  NN = NN1
              ELSE
                  NN = MIN0(NN1,NN2)
              ENDIF
              N2 = N1 + NN - 1
              IF(NN.EQ.0) THEN
                  GOTO 1700
              ELSE
                  WRITE(TTPARM,'(I15)') IFORVL(I,NTDEP)
                  CALL M_LTRM(TTPARM,TTPARM)
                  NNPARM = LNBLNK(TTPARM)
                  IF(N2.GT.1 .AND. NNPARM.GT.0) THEN
                      TXTO = TEXT(1:N2-1) // TTPARM(1:NNPARM)
                  ELSE IF(N2.LE.1 .AND. NNPARM.GT.0) THEN
                      TXTO = TTPARM(1:NNPARM)
                  ELSE IF(N2.GT.1 .AND. NNPARM.LE.0) THEN
                      TXTO = TEXT(1:N2-1)
                  ELSE
                      TXTO = ' '
                  ENDIF
                  NNCHRO = N2 - 1 + NNPARM
C
                  IF(N2+2.LE.NNCHAR) THEN
                      IF(NNCHRO.GT.0) THEN
                          TXT2 = TXTO(1:NNCHRO) // TEXT(N2+2:NNCHAR)
                      ELSE
                          TXT2 = TEXT(N2+2:NNCHAR)
                      ENDIF
                      TEXT   = TXT2
                      NNCHAR = NNCHRO + (NNCHAR-N2-2) + 1
                  ELSE
                      IF (NNCHRO.GT.0) THEN
                          TEXT = TXTO(1:NNCHRO)
                          NNCHAR = NNCHRO
                      ELSE
                          TEXT = ' '
                          NNCHAR = 1
                      ENDIF
                      GOTO 1700
                  ENDIF
                  N1 = N2 + NNPARM
                  GOTO 1600
              ENDIF
1700      CONTINUE
      ENDIF
C
C     Now do alias substitution
C
      CALL M_APRS(TEXT,NNCHAR)
*
*     See if the string is now a comment
*     Return command in text and comment in txt2
*     If there was a comment text before concatenate them
*
      call tyqcomm(text,nnchar,txt2)
*
*     If we are defining a command just ignore the comment line
*
      if(tprcmd(1:nprcmd).eq.'DEFINE>' .and.
     + text.eq.' ' .and. txt2.ne.' ') then
        goto 1100
      elseif(txt2.ne.' ') then
        if(txtc.eq.' ') then
          txtc = txt2
        else
          txtc = concat(txt2,txtc)
        endif
      endif
C
C     Now we have the string to put in the TYPSCN buffer to interpret
C
 2000 CONTINUE
      CALL QUOTYP(TEXT(1:NNCHAR))
      STRING = ' '
      STRING = TEXT(1:NNCHAR)
C
      QEXIT = .FALSE.
      IF(QRFILE .AND. NCHAR.EQ.1 .AND. ICHAR(TEXT(1:1)).EQ.26) THEN
          QEXIT = .TRUE.
          INQUIRE(UNIT=LUNCMD,NAME=TXT2)
          LENT = LNBLNK(TXT2)
          N2 = LENT
          DO 2100 I=LENT,1,-1
              IF(TXT2(I:I).EQ.'/' .OR. TXT2(I:I).EQ.']' .OR.
     +           TXT2(I:I).EQ.':') THEN
                  N1 = I+1
                  GOTO 2120
              ELSEIF(TXT2(I:I).EQ.';') THEN
                  N2 = I-1
              ENDIF
 2100     CONTINUE
          N1 = 1
 2120     CONTINUE
          N2 = MAX0(N1,N2)
          WRITE(TXTMES,'('' End of Macro '',A,'', Unit='',I3
     1     ,''. Exiting'')') TXT2(N1:N2),LUNCMD
          CALL MN_MES(LUNTTO,'ME',TXTMES)
C
C     Do not interpret ENDDO and RETURN if we are defining a new command
C
      ELSEIF(QRFILE) THEN
          ICMD = ICMTYP(.TRUE.,IDELIM,TYQNAM)
          TCOMM = ' '
          CALL ICMSTR(TCOMM)
C
C         LOOK FOR THE RETURN, ENDDO, ELSE, ENDIF, OR GOTO COMMANDS
C
          NIFLV = IIFLV(NTDEP)
C
C         ECHO THE COMMAND IF IT IS WANTED
C
          IF(.NOT.QIF(NTDEP)) then
            CALL TYQECH(STRING,TCOMM,TXTC)
          ELSEIF(QIF(NTDEP)) THEN
            IF(QCOND(NIFLV,NTDEP)) THEN
              CALL TYQECH(STRING,TCOMM,TXTC)
            elseif(niflv.eq.1) then
              if(tcomm.eq.'ELIF'  .or. tcomm.eq.'ELSE' .or.
     +           tcomm.eq.'ENDIF' .or. tcomm.eq.'FI') then
                CALL TYQECH(STRING,TCOMM,TXTC)
              endif
            elseif(niflv.gt.1 .and. qcond(niflv-1,ntdep)) then
              if(tcomm.eq.'ELIF'  .or. tcomm.eq.'ELSE' .or.
     +           tcomm.eq.'ENDIF' .or. tcomm.eq.'FI') then
                CALL TYQECH(STRING,TCOMM,TXTC)
              endif
            ENDIF
          ENDIF
*
*         ELSE when not DEFINING a command
*
          IF(ICMD.GT.0 .AND. TPRCMD(1:NPRCMD).NE.'DEFINE>' .AND.
     +     .NOT.QDSKIP .AND. TCOMM.EQ.'ELSE') THEN
            IF(.NOT.QIF(NTDEP))THEN
              TXTERR = 'ELSE found when you are not in a' //
     +         ' conditional block.  Ignored.'
              CALL M_EMSG('TYQRED',TXTERR)
            ELSEIF(NIFLV.EQ.1 )THEN
              QCOND(NIFLV,NTDEP) = .NOT.QCONDI(NIFLV,NTDEP)
            ELSEIF(NIFLV.GT.1) THEN
              IF(QCOND(NIFLV-1,NTDEP)) THEN
                QCOND(NIFLV,NTDEP) = .NOT.QCONDI(NIFLV,NTDEP)
              ENDIF
            ENDIF
            GOTO 1000
*
*         ENDIF when not DEFINING a command
*
          ELSEIF(ICMD.GT.0 .AND. TPRCMD(1:NPRCMD).NE.'DEFINE>' .AND.
     +     .NOT.QDSKIP .AND.
     +       (TCOMM.EQ.'ENDIF' .or. TCOMM.EQ.'FI')) THEN
              IF(.NOT.QIF(NTDEP)) THEN
                  TXTERR = 'ENDIF/FI found when you are not in a' //
     +             ' conditional block.  Ignored.'
                  CALL M_EMSG('TYQRED',TXTERR)
              ELSE
                  QCOND(NIFLV,NTDEP) = .FALSE.
                  QCONDI(NIFLV,NTDEP) = .FALSE.
                  IF(NIFLV .GT. 0) NIFLV = NIFLV - 1
                  IF(NIFLV .LE. 0) QIF(NTDEP) = .FALSE.
                  IIFLV(NTDEP) = NIFLV
              ENDIF
              GOTO 1000
*
*         IF found when not DEFINING a command and
*         not inside a DO loop that is being skipped
*
          ELSEIF(QIF(NTDEP) .AND. ICMD.GT.0 .AND.
     +     TPRCMD(1:NPRCMD).NE.'DEFINE>' .AND.
     +     .NOT.QDSKIP .AND. TCOMM.EQ.'IF') THEN
              IF(.NOT.QCOND(NIFLV,NTDEP)) THEN
                  NIFLV = NIFLV + 1
                  QCOND(NIFLV,NTDEP) = .FALSE.
                  QCONDI(NIFLV,NTDEP) = .FALSE.
                  IIFLV(NTDEP) = NIFLV
                  CALL ZERTYP('.FALSE.')
                  GOTO 1000
              ELSE
                  CALL RESTYP
              ENDIF
*
*         ELIF found when not DEFINING a command and
*         not inside a DO loop that is being skipped
*         See if we are inside an IF block that is being skipped
*
          ELSEIF(QIF(NTDEP) .AND. ICMD.GT.0 .AND.
     +     TPRCMD(1:NPRCMD).NE.'DEFINE>' .AND.
     +     .NOT.QDSKIP .AND. TCOMM.EQ.'ELIF') THEN
              IF(QCOND(NIFLV,NTDEP)) THEN
                  QCOND(NIFLV,NTDEP) = .FALSE.
                  CALL ZERTYP('.FALSE.')
                  GOTO 1000
              ELSE
                  CALL RESTYP
              ENDIF
*
*         ENDDO found when not DEFINING a command and when not
*         inside an IF block that is not being executed.
*
          ELSEIF(ICMD.GT.0 .AND. TPRCMD(1:NPRCMD).NE.'DEFINE>' .AND.
     +         TCOMM.EQ.'ENDDO') THEN
              IF(QIF(NTDEP) .AND. .NOT.QDSKIP) THEN
                IF(.NOT.QCOND(NIFLV,NTDEP)) THEN
                  CALL ZERTYP('.FALSE.')
                  GOTO 1000
                ENDIF
              endif
*
              NFDEP = NFORDP(NTDEP)
              IF(NFDEP.LE.0) THEN
                  TXTERR = 'ENDDO command found when you are not' //
     1             ' in a DO loop. It will be ignored'
                  CALL M_EMSG('TYQRED',TXTERR)
                  GOTO 1000
              ENDIF
              IFORVL(NFDEP,NTDEP) = IFORVL(NFDEP,NTDEP) +
     1         IFORST(NFDEP,NTDEP)
              NVAL  = IFORVL(NFDEP,NTDEP)
              NMAX  = IFORMX(NFDEP,NTDEP)
              NSTEP = IFORST(NFDEP,NTDEP)
              IF(QDSKIP .OR.
     +         (NSTEP.GT.0 .AND. NVAL.GT.NMAX) .OR.
     +         (NSTEP.LT.0 .AND. NVAL.LT.NMAX)) THEN
                  NFORDP(NTDEP) = NFORDP(NTDEP) - 1
              ELSE
                IF(LUNCMD.GT.0) THEN
                  REWIND LUNCMD
                  IUNREC(NTDEP) = 0
                  if(qdebug .and. ndebug.ge.110) then
                    WRITE(LUNTTO,'('' *** Rewinding and skipping to''
     +               ,'' record'',I4,'' ***'')')
     +               IFORBG(NFORDP(NTDEP),NTDEP)
                  endif
                  DO 2200 I=1,IFORBG(NFORDP(NTDEP),NTDEP)
                    READ(LUNCMD,'(A)',ERR=2220) TEXT
                    IUNREC(NTDEP) = IUNREC(NTDEP) + 1
                    if(qdebug .and. ndebug.ge.111) then
                      WRITE(LUNTTO,'('' Record'',I4
     +                 ,''  Text: '',A)') IUNREC(NTDEP),TEXT
                    endif
                    GOTO 2200
 2220               CONTINUE
                    CALL M_EMSG('TYQRED','Error reading file')
                    QEXIT = .TRUE.
                    GOTO 5000
 2200             CONTINUE
                ELSE
                  IP1CMD(NTDEP) = IFORBG(NFORDP(NTDEP),NTDEP)
                ENDIF
              ENDIF
C
C             If we are skipping commands in a DO loop then RETURN here
C             else clear out the typscn buffer so the next command gets read
C
              IF(QDSKIP) THEN
                  CALL RESTYP
                  RETURN
              ELSE
                  CALL ZERTYP('.FALSE.')
                  GOTO 1000
              ENDIF
*
*         RETURN found when not DEFINING a command and
*         not inside a DO loop that is being skipped nor an IF block
*
          ELSEIF(ICMD.GT.0 .AND. TPRCMD(1:NPRCMD).NE.'DEFINE>' .AND.
     +     .NOT.QDSKIP .AND. TCOMM.EQ.'RETURN') THEN
              IF(QIF(NTDEP)) THEN
                IF(QCOND(NIFLV,NTDEP)) THEN
                  QEXIT = .TRUE.
                  WRITE(TXTMES,'('' RETURN command found, unit='',I4
     +             ,''. Exiting'')') LUNCMD
                  CALL MN_MES(LUNTTO,'ME',TXTMES)
                else
                  call zertyp('.FALSE.')
                  goto 1000
                ENDIF
              ELSE
                QEXIT = .TRUE.
                WRITE(TXTMES,'('' RETURN command found, unit='',I4
     +           ,''. Exiting'')') LUNCMD
                CALL MN_MES(LUNTTO,'ME',TXTMES)
              ENDIF
*
*         In an IF block
*
          ELSEIF(QIF(NTDEP) .AND. .NOT.QDSKIP) THEN
              IF(.NOT.QCOND(NIFLV,NTDEP)) THEN
                  CALL ZERTYP('.FALSE.')
                  GOTO 1000
              ELSE
                  CALL RESTYP
              ENDIF
          ELSE
              CALL RESTYP
          ENDIF
      ENDIF
C
5000  CONTINUE
      IF(QEXIT) THEN
          IF(LUNCMD.GT.0) THEN
              CLOSE(UNIT=LUNCMD)
              CALL CLEO_FRELUN(LUNCMD,'MN_FIL')
          ENDIF
          IF(QIF(NTDEP)) THEN
              QIF(NTDEP)   = .FALSE.
              IIFLV(NTDEP) = 0
              DO 3100 ILEV=1,MXIFLV
                  QCOND(ILEV,NTDEP) = .FALSE.
                  QCONDI(ILEV,NTDEP) = .FALSE.
 3100         CONTINUE
              CALL M_EMSG('TYQRED','Unclosed conditional' //
     +         ' in this file.  It will be terminated.')
cif              ELSE
cif                  IFIIFL = IFIIFL - 1
cif              ENDIF
          ENDIF
          IF(NFORDP(NTDEP).GT.0) THEN
              CALL M_EMSG('TYQRED','Unclosed DO loop in' //
     +         ' this file. It will be terminated')
              NFORDP(NTDEP) = 0
          ENDIF
          NTDEP = NTDEP - 1
          IF(NTDEP.GT.0) THEN
              LUNCMD = IUNCMD(NTDEP)
          ELSE
              LUNCMD = LUNTTI
              NTDEP  = 0
              QRFILE = .FALSE.
          ENDIF
          QTREAD = .TRUE.
          CALL ZERTYP('.FALSE.')
          IF(LUNCMD.GT.0) CALL UNITYP(LUNCMD,LUNTTO)
          GOTO 1000
      ENDIF
C
C     LOG COMMAND IF WE ARE READING COMMANDS FROM THE TERMINAL
C
      IF(LUNCMD.EQ.LUNTTI) THEN
          NTCMD = NTCMD + 1
          IF(NTCMD.GT.MTCMD) THEN
              QTLOOP = .TRUE.
              NTCMD = 1
          ENDIF
          TXTCMD(NTCMD) = TEXT(1:NNCHAR)
C
C         Write the command to the log file if the option is turned on
C
          IF(QALOG) THEN
              WRITE(LUNLOG,'(A)',IOSTAT=IOERR) TEXT(1:NNCHAR)
              IF(IOERR.NE.0) CALL MN_ERR('TYQRED'
     +         ,'Error writing to the log file')
          ENDIF
      ENDIF
C
      END
