      SUBROUTINE M_USRI (NFUSER,NCPAR,TITLE,TCPAR
     1 ,CPAR,DCPAR,CPARLO,CPARHI)
C
C     Subroutine to initialize the parameters for a USER function
C     If the user wishes he can write his own version of this routine
C     to speed up the initialization
C
C     Input parameters:
C     NFUSER  is the user function number
C
C     Output parameters:
C     NCPAR   are the number of parameters in the user function
C     TITLE   is the title of the function (default is User Function)
C     TCPAR   are the parameter names (defaults are NORM, PARM01, PARM02...)
C     CPAR    are the intial values of the parameters
C     DCPAR   are the initial step sizes
C     CPARLO  are the lower limits on the parameters
C     CPARHI  are the upper limits on the parameters
C
#include "mnlun.inc"
C
      CHARACTER*(*) TITLE,TCPAR(*)
      REAL CPAR(*),DCPAR(*),CPARLO(*),CPARHI(*)
C
      CHARACTER*80 TEXT
      CHARACTER*30 TPRMPT
      CHARACTER*10 TCOMM
C
      NCPAR = 0
      CALL WAITYQ('Give number of parameters: ')
      NCPAR = INTTYQ(.TRUE.,IDELIM)
      CALL MN_NCK(NCPAR,IDELIM,IERR)
      IF(IERR.GT.0) GOTO 9000
C
      LENT = MNLLEN(TITLE)
      IF(LENT.GT.0) WRITE(LUNTTO,'('' Default title: '',A)')
     1 TITLE(1:LENT)
      CALL WAITYQ('Give title for function: ')
      TEXT = ' '
      NCHAR = IQSTYQ(.TRUE.,IDELIM,TEXT)
      IF(NCHAR.GT.0) TITLE = TEXT(1:NCHAR)
C
      WRITE(LUNTTO,'('' Give parameter names:'')')
      DO 3000 JJ=1,NCPAR
          TPRMPT = 'Parameter    (<CR>=PARM00): '
          WRITE(TPRMPT(10:12),'(I3)') JJ
          TCOMM = ' '
          IF(JJ.EQ.1) THEN
              TPRMPT(20:25) = 'NORM'
              TCPAR(JJ)  = 'NORM'
          ELSE
              WRITE(TPRMPT(24:25),'(I2.2)') JJ-1
              TCPAR(JJ) = 'PARM00'
              WRITE(TCPAR(JJ)(5:6),'(I2.2)') JJ-1
          ENDIF
          CALL WAITYQ(TPRMPT(1:MNLLEN(TPRMPT)+1))
          NCHR = ISLTYQ(.TRUE.,IDELIM,TCOMM)
          IF(NCHR.GT.0 .AND. TCOMM.NE.' ') CALL M_LUPC(TCOMM,TCPAR(JJ))
3000  CONTINUE
C
9000  CONTINUE
      RETURN
      END
