      SUBROUTINE MN_BLM(NMODE,ntmodi,IDELIM,THLP,NBIN,ALO,AHI,NNUM,IERR)
C
C     SUBROUTINE TO GET BIN DEFINITIONS OR LIMITS
C
C     NMODE = 1 means bin definitions and limits. If nbin is negative at
C               input, then automatic binning is used.
C     NMODE = 2 means limits only
C     NMODE = 3 means bin numbers for rebinning
C     NMODE = 4 means limits only, 0,0 is allowed
C     NMODE = 5 means bin definitions and limits, 0,0,0 is allowed
C     NMODE = 6 means bin definitions and limits, whatever the starting
C               values. 0,0,0 is allowed
C     ntmode  = 0 means not in time mode
C     ntmode  = 1 means a date
C     ntmode >= 2 means a time
C
C     If -1 is given as the number of bins use automatic binning.
C     Note that the number of bins returned can be zero for mode 1.
C     This is used in MN_PRJ.
C
      IMPLICIT NONE
C
      INTEGER NMODE,ntmodi,IDELIM,NBIN,NNUM,IERR
      REAL ALO,AHI
      CHARACTER*(*) THLP
C
      CHARACTER*15 TBIN(4),TLIM(3),TREB(4)
      INTEGER IBIN(4,0:2),ILIM(3,0:2),IREB(4)
C
      integer ntmode
      INTEGER LBIN
      REAL BLO,BHI,BWID
C
      REAL RINP(10),RNUM(10)
      CHARACTER*80 THELP,THEAD
      CHARACTER*80 TEXT
      LOGICAL QAUTO
C
      DATA TBIN/
     1  'Number of bins'
     2 ,'Lower limit'
     3 ,'Upper limit'
     Z ,' '/
      DATA TLIM/
     1  'Lower limit'
     2 ,'Upper limit'
     Z ,' '/
      DATA TREB/
     1  'First bin'
     2 ,'Last bin'
     3 ,'No. of new bins'
     Z ,' '/
      DATA IBIN/2,1,1,0
     + ,        2,6,6,0
     + ,        2,7,7,0/
      DATA ILIM/1,1,0
     + ,        6,6,0
     + ,        7,7,0/
      DATA IREB/2,2,2,0/
C
      IERR = 0
      NNUM = 0
      IF(NMODE.LT.1 .OR. NMODE.GT.6) THEN
          WRITE(TEXT,'(''MN_BLM called with an invalid mode''
     1     ,I6)') NMODE
          CALL MN_ERR('MN_BLM',TEXT)
          IERR = -2
          CALL ZERTYQ('.FALSE.')
          GOTO 9000
      ENDIF
*
      ntmode = min0(2,max0(0,ntmodi))
*
      LBIN = NBIN
      BLO = ALO
      BHI = AHI
      QAUTO = .FALSE.
C
      THELP = THLP
      IF(NMODE.EQ.1 .OR. NMODE.EQ.5 .OR. NMODE.EQ.6) THEN
          IF(NBIN.GE.0 .OR. NMODE.EQ.6) THEN
              THEAD = 'Parameters are number of bins,' //
     1         ' lower and upper limits'
              RINP(1) = FLOAT(NBIN)
              RINP(2) = ALO
              RINP(3) = AHI
              CALL MN_ENM(IDELIM,THELP,THEAD,4,TBIN,IBIN(1,ntmode),RINP
     1         ,NNUM,RNUM,IERR)
              IF(NNUM.GE.1) LBIN = NINT(RNUM(1))
              IF(NNUM.GE.2) BLO  = RNUM(2)
              IF(NNUM.GE.3) BHI  = RNUM(3)
              IF(LBIN.EQ.-1) THEN
                  QAUTO = .TRUE.
                  IF(NBIN.LE.1) NBIN = 100
                  CALL BINSIZ(ALO,AHI,NBIN,BLO,BHI,LBIN,BWID)
                  NNUM = 3
              ENDIF
          ELSE
              QAUTO = .TRUE.
              NBIN = -IABS(NBIN)
              IF(NBIN.LE.1) NBIN = 100
              CALL BINSIZ(ALO,AHI,NBIN,BLO,BHI,LBIN,BWID)
              NNUM = 3
          ENDIF
      ELSE IF(NMODE.EQ.2 .OR. NMODE.EQ.4) THEN
          THEAD = 'Parameters are lower and upper limits'
          RINP(1) = ALO
          RINP(2) = AHI
          CALL MN_ENM(IDELIM,THELP,THEAD,3,TLIM,ILIM(1,ntmode),RINP
     1     ,NNUM,RNUM,IERR)
          IF(NNUM.GE.1) BLO  = RNUM(1)
          IF(NNUM.GE.2) BHI  = RNUM(2)
      ELSE IF(NMODE.EQ.3) THEN
          THEAD = 'Parameters are first bin, last bin,' //
     1     ' number of new bins'
          RINP(1) = ALO
          RINP(2) = AHI
          RINP(3) = FLOAT(NBIN)
          CALL MN_ENM(IDELIM,THELP,THEAD,4,TREB,IREB,RINP
     1     ,NNUM,RNUM,IERR)
          IF(NNUM.GE.1) BLO  = RNUM(1)
          IF(NNUM.GE.2) BHI  = RNUM(2)
          IF(NNUM.GE.3) LBIN = NINT(RNUM(3))
      ENDIF
      IF(IERR.NE.0) THEN
          CALL ZERTYQ('.FALSE.')
          GOTO 9000
      ENDIF
C
C     CHECK THE NUMBER OF BINS AND LIMITS
C
      IF(NMODE.EQ.3 .AND. BLO.GT.BHI) THEN
          WRITE(TEXT,'(''Error in bin range''
     1     ,I6,'' ->'',I6)') NINT(BLO),NINT(BHI)
          CALL MN_ERR('MN_BLM',TEXT)
          IERR = -1
          GOTO 9000
      ENDIF
C
      IF((NMODE.EQ.1 .AND. LBIN.LT.0) .OR.
     +   (NMODE.EQ.3 .AND. LBIN.LE.0) .OR.
     +   (NMODE.EQ.5 .AND. LBIN.LT.0) .OR.
     +   (NMODE.EQ.6 .AND. LBIN.LT.0)) THEN
          WRITE(TEXT,'(''Error in number of bins''
     +     ,I6)') LBIN
          CALL MN_ERR('MN_BLM',TEXT)
          IERR = -1
          GOTO 9000
      ENDIF
C
      IF((NMODE.EQ.5 .OR. NMODE.EQ.6) .AND. LBIN.EQ.0 .AND.
     +   (BLO.NE.0.0 .OR. BHI.NE.0.0) .AND. BLO.GE.BHI) THEN
          WRITE(TEXT,'(''Error in limits''
     +     ,2(1PG11.4))') BLO,BHI
          CALL MN_ERR('MN_BLM',TEXT)
          IERR = -1
          GOTO 9000
C
      ELSEIF((NMODE.EQ.1 .AND. BLO.GE.BHI) .OR.
     +       (NMODE.EQ.2 .AND. BLO.GE.BHI)) THEN
          WRITE(TEXT,'(''Error in limits''
     +     ,2(1PG11.4))') BLO,BHI
          CALL MN_ERR('MN_BLM',TEXT)
          IERR = -1
          GOTO 9000
      ENDIF
C
      IF(NMODE.EQ.4 .AND. BLO.GE.BHI .AND.
     +   (BLO.NE.0.0 .OR. BHI.NE.0.0)) THEN
          WRITE(TEXT,'(''Error in limits''
     1     ,2(1PG11.4))') BLO,BHI
          CALL MN_ERR('MN_BLM',TEXT)
          IERR = -1
          GOTO 9000
      ENDIF
C
      IF(NMODE.EQ.3 .AND. (NINT(BLO).LE.0 .OR.
     +    NINT(BLO).LT.NINT(ALO) .OR. NINT(BHI).GT.NINT(AHI))) THEN
          WRITE(TEXT,'(''Error in bin number'',2I6)')
     +     NINT(BLO),NINT(BHI)
          CALL MN_ERR('MN_BLM',TEXT)
          IERR = -1
          GOTO 9000
      ENDIF
C
      IF(NMODE.EQ.1 .OR. NMODE.EQ.3 .OR. NMODE.EQ.5 .OR. NMODE.EQ.6)THEN
          NBIN = LBIN
          IF(QAUTO) NBIN = -IABS(LBIN)
      ENDIF
      ALO  = BLO
      AHI  = BHI
C
9000  CONTINUE
      RETURN
      END
