#include "kuip.h"
#include "kfor.h"
#include "kcom.h"
#include "ksig.h"

#if ( defined(VMS) )
void mn_call(void)
#endif
#if ( defined(UNIX) ) && ( defined(LINUX) )
void mn_call_(void)
#endif
#if ( defined(UNIX) ) && ( !defined(LINUX) )
void mn_call_(void)
#endif

{
#if ( defined(VMS) )
  void m_start_();
  void m_stop_();
#endif
#if ( defined(UNIX) ) && ( defined(LINUX) )
  void m_start_();
  void m_stop_();
#endif
#if ( defined(UNIX) ) && ( !defined(LINUX) )
  void m_start_();
  void m_stop_();
#endif

  int what_loop(void);

#if ( defined(VMS) )
  m_start_();
#endif
#if ( defined(UNIX) ) && ( defined(LINUX) )
  m_start_();
#endif
#if ( defined(UNIX) ) && ( !defined(LINUX) )
  m_start_();
#endif


  ku_trap( 1, -1);         /* Install signal handler */

  while( 1 ) {
    if( what_loop() == 1 )
      break;
    else {
      /* this branch is for VMS exceptions only */
      reset_break();
    }
  }

#if ( defined(VMS) )
  m_stop_();
#endif
#if ( defined(UNIX) ) && ( defined(LINUX) )
  m_stop_();
#endif
#if ( defined(UNIX) ) && ( !defined(LINUX) )
  m_stop_();
#endif


  kc_break.jump_set = 0;
  ku_trap( 0, -1 );             /* remove signal handler */
  ku_shut();                    /* clean up the mess */

}


int what_loop()
{
#if ( defined(VMS) )
  void m_run_();
#endif
#if ( defined(UNIX) ) && ( defined(LINUX) )
  void m_run__();
#endif
#if ( defined(UNIX) ) && ( !defined(LINUX) )
  void m_run_();
#endif


#ifdef vms

  /*
   * The signal handler calls LIB$SIG_TO_RET which lets what_loop return
   * the error number ( 1 == SS$_NORMAL )
   */
  VAXC$ESTABLISH( signal_handler );

#endif

  /* catch exceptions saving signal mask */
  if( sigsetjmp( kc_break.stack, 1 ) != 0 ) { /* saving signal mask */
    /* longjmp happened */
    reset_break();
  }
  kc_break.jump_set = 1;

#if ( defined(VMS) )
  m_run_();
#endif
#if ( defined(UNIX) ) && ( defined(LINUX) )
  m_run_();
#endif
#if ( defined(UNIX) ) && ( !defined(LINUX) )
  m_run_();
#endif


  kc_break.intr_count = 0;    /* reset the ^C counter */

  return 1;
}
