///////////////////////////////////////////////////////////////////////////////
// $Id: tilecache.h,v 1.1 2004/09/29 20:08:08 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    tilecache.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of a tile cache class
*/

#ifndef TILECACHE_H
#define TILECACHE_H

// Qt includes
#include <qintdict.h>

// forward declarations
class QPixmap;

///////////////////////////////////////////////////////////////////////////////

//! This class holds the modified tile pixmaps of a tile group
/*!
*/

class TileCache {
public:
	TileCache();
	TileCache(const TileCache& other) {
		copy(other);
	}

	~TileCache();

	TileCache& operator=(const TileCache& other) {
		if (&other == this) return *this;
		copy(other);

		return *this;
	}

	QPixmap* pixmap(uint index);

	void insertPixmap(uint index, QPixmap* pixmap);
	
protected:
	QIntDict<QPixmap> m_pixmaps;

private:
	void copy(const TileCache& other);
};

#endif

// End of file

