///////////////////////////////////////////////////////////////////////////////
// $Id: tileset.cpp,v 1.5 2004/11/30 15:37:18 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    tileset.cpp
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Implementation of the tile set handler class
*/

// Qt includes
#include <qfileinfo.h>
#include <qimage.h>
#include <qpixmap.h>

// local includes
#include "indexfile.h"
#include "tilegroup.h"
#include "tileset.h"

///////////////////////////////////////////////////////////////////////////////

TileSet::TileSet() : m_count(0)
{
	m_groups.setAutoDelete(true);
}

///////////////////////////////////////////////////////////////////////////////

TileSet::~TileSet()
{
}

///////////////////////////////////////////////////////////////////////////////

bool TileSet::load(const QString& filename)
{
	IndexFile file;

	if (!file.openFile(filename)) return false;

	QStringList files = file.files();
	m_groups.clear();
	m_groups.resize(files.count() * 2 + 1);

	QFileInfo fileinfo(filename);
	QString path = fileinfo.dirPath(true);

	int index = 0;
	QString groupfile = path + "/%0/tiles.idx";
	for (QStringList::iterator it = files.begin(); it != files.end(); ++it, ++index)
	{
		if ((*it).isEmpty()) continue; // no group for this index

		TileGroup* g = new TileGroup();
		if (!g->load(groupfile.arg(*it)))
		{
			qWarning("Failed to load tilegroup %s",
					static_cast<const char*>( QFile::encodeName(groupfile.arg(*it)) ));
			delete g;
			continue;
		}
		g->setName(*it);
		m_groups.insert(index, g);
	}

	m_count = files.count();
	
	return true;
}

///////////////////////////////////////////////////////////////////////////////

QString TileSet::name(int index) const
{
	TileGroup* group = 0;
	if (!m_groups.isEmpty())
	{
		group = m_groups[index];
	}

	if (group != 0) return group->name();

	return QString::null;
}

///////////////////////////////////////////////////////////////////////////////

TileGroup* TileSet::group(int index)
{
	TileGroup* group = 0;
	if (!m_groups.isEmpty())
	{
		group = m_groups[index];
	}

	return group;
}

///////////////////////////////////////////////////////////////////////////////

void TileSet::copy(const TileSet& other)
{
	m_groups.clear();

	QIntDictIterator<TileGroup> it(other.m_groups);
	for (; it.current() != 0; ++it)
	{
		TileGroup* group = it.current();
		m_groups.insert(it.currentKey(), new TileGroup(*group));
	}
}

// End of file

