/*
 * ConnectionMgr manages a single connection from the user interface, 
 * and forward the commands to the appropriate agent.
 * 
 * Copyright © 2007, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307 USA.
 *
 */
#ifndef __PROCESSMGR_H__
#define __PROCESSMGR_H__

#include <iostream>

class ProcessMgr 
{
 private:
   std::string m_errMsg;
   ProcessMgr ();

 public:
   static ProcessMgr* createInstance();
   ~ProcessMgr();
   bool launchProcess (std::string appPath);
   std::string getErrorMessage();

};

#endif //__PROCESSMGR_H__
