
#define BTP_FILE_POOL_PRIVATE
#include <libbtpeer.h>

#include <apr.h>
#include <apr_pools.h>
#include <apr_general.h>
#include <apr_errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "libtap/tap.h"

static void run_tests (apr_pool_t* p) {
    btp_file_pool* fp;
    apr_file_t* fh;
    
    ok(fp = btp_file_pool_create(p, 3), "Created a 3 file pool");
    ok1(btp_file_pool_get(fp, "test1", &fh) == APR_SUCCESS);
    ok1(fp->first == fp->last);
    ok1(btp_file_pool_get(fp, "test2", &fh) == APR_SUCCESS);
    ok1(fp->first != fp->last);
    ok1(fp->first->next == fp->last);
    ok1(fp->last->prev == fp->first);
    ok1(btp_file_pool_get(fp, "test3", &fh) == APR_SUCCESS);
    ok1(fp->first->next != fp->last);
    ok1(fp->first->next->next == fp->last);
    ok1(fp->last->prev->prev == fp->first);
    ok1(btp_file_pool_get(fp, "test4", &fh) == APR_SUCCESS);
    ok(
        !strcmp(((btp_file_pool_file*)fp->first->d)->path, "test4"),
        "First file is now test4"
    );
    ok(
        !strcmp(((btp_file_pool_file*)fp->first->next->d)->path, "test3"),
        "Second file is now test3"
    );
    ok(
        !strcmp(
            ((btp_file_pool_file*)fp->first->next->next->d)->path, "test2"
        ),
        "Third file is now test2"
    );
    ok(fp->last == fp->first->next->next, "3rd and last pointers match");
    ok(
        !strcmp(((btp_file_pool_file*)fp->last->d)->path, "test2"),
        "Last file is now test2"
    );
    btp_file_pool_del_record(fp, (btp_file_pool_file*)fp->first->next->d);
    ok(fp->n == 2, "Dropped record for test3");
    ok1(fp->first->next->next == NULL);
    ok1(btp_file_pool_get(fp, "test1", &fh) == APR_SUCCESS);
    ok(
        !strcmp(((btp_file_pool_file*)fp->first->d)->path, "test1"),
        "First file is now test1"
    );
    ok(
        !strcmp(((btp_file_pool_file*)fp->last->d)->path, "test2"),
        "Last file is now test2"
    );
    ok1(btp_file_pool_get(fp, "test2", &fh) == APR_SUCCESS);
    ok(
        !strcmp(((btp_file_pool_file*)fp->first->d)->path, "test2"),
        "First file is now test2"
    );
    ok(
        !strcmp(((btp_file_pool_file*)fp->first->next->d)->path, "test1"),
        "Second file is now test1"
    );
    ok(fp->max++, "Increased max");
    ok1(btp_file_pool_get(fp, "test1", &fh) == APR_SUCCESS);
    ok1(btp_file_pool_get(fp, "test4", &fh) == APR_SUCCESS);
    ok1(btp_file_pool_get(fp, "test3", &fh) == APR_SUCCESS);
    ok1(btp_file_pool_get(fp, "test4", &fh) == APR_SUCCESS);
    ok(
        !strcmp(((btp_file_pool_file*)fp->first->d)->path, "test4"),
        "First file is now test4"
    );
    ok(
        !strcmp(((btp_file_pool_file*)fp->first->next->d)->path, "test3"),
        "Second file is now test3"
    );
    ok(
        !strcmp(
            ((btp_file_pool_file*)fp->first->next->next->d)->path, "test1"
        ),
        "Third file is now test1"
    );
    ok(
        !strcmp(
            ((btp_file_pool_file*)fp->first->next->next->next->d)->path,
            "test2"
        ),
        "Fourth file is now test2"
    );
    ok(
        !strcmp(((btp_file_pool_file*)fp->last->d)->path, "test2"),
        "Last file is now test2"
    );
    btp_file_pool_del_record(fp, ((btp_file_pool_file*)fp->last->d));
    ok(fp->n == 3, "Dropped record for test2");
    ok(
        !strcmp(((btp_file_pool_file*)fp->last->d)->path, "test1"),
        "Last file is now test1"
    );
    btp_file_pool_del_record(fp, ((btp_file_pool_file*)fp->first->d));
    ok(fp->n == 2, "Dropped record for test4");
    ok(
        !strcmp(((btp_file_pool_file*)fp->first->d)->path, "test3"),
        "First file is now test3"
    );
    
    return;
}

int main (int argc, const char* const* argv) {
    apr_pool_t *pool;
    
    if(apr_app_initialize(&argc, &argv, NULL) != APR_SUCCESS) {
        fprintf(stderr, "apr_app_initialize() failed!\n");
        fflush(stderr);
        exit(20);
    }
 
    atexit(apr_terminate);
 
    if(apr_pool_initialize() != APR_SUCCESS) {
        fprintf(stderr, "apr_pool_initialize() failed!\n");
        fflush(stderr);
        exit(2);
    }
 
    if(apr_pool_create(&pool, NULL) != APR_SUCCESS) {
        fprintf(stderr, "apr_pool_create() failed!\n");
        fflush(stderr);
        exit(3);
    }

    plan_no_plan();
    run_tests(pool);

    exit(exit_status());
}
