/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: datatype.c,v 1.9 2004/08/27 18:32:53 ostborn Exp $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <zlib.h>

#include "config.h"
#include "mdatatypes.h"
#include "datatype.h"

/* begin of Record */

int mdata_Record_to_xml(gzFile *fd, mdata *data) {
	return 0;
}

int mdata_Record_free(mdata *data) {
	if (!data) return -1;
	if (data->type != M_DATA_TYPE_RECORD) return -1;

	if (data->data.record.record)	mrecord_free(data->data.record.record);

	return 0;
}

int mdata_Record_setdata(mdata *data, const char *str, mlogrec *record) {

	data->key = str;
	assert(data->key);

	data->data.record.record = 	record;

	return 0;
}

int mdata_Record_from_xml(mstate_stack *m, int tagtype, mdata *data, int type, const xmlChar *value, const xmlChar **attrs) {
	return 0;
}

int mdata_Record_append(mdata *dst, mdata *src) {
	return 0;
}

mdata *mdata_Record_init() {
	mdata *data = mdata_init();
	assert(data);

	data->key		= NULL;
	data->type		= M_DATA_TYPE_RECORD;

#ifdef DEBUG_DATATYPES
	fprintf(stderr, "%s.%d: got %ld (%d)\n", __FILE__, __LINE__, data->id, data->type);
#endif
/* init specifics */
	data->data.record.record	= NULL;

	return data;
}

mdata *mdata_Record_copy(mdata *src) {
	mdata *data = mdata_Record_init();
	assert(data);
	mdata_Record_setdata(data, src->key, src->data.record.record);

	return data;
}

mdata *mdata_Record_create(const char *str, mlogrec *record) {
	mdata *data = mdata_Record_init();
	assert(data);
	mdata_Record_setdata(data, str, record);

	return data;
}

/* end of Record */
