/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.4 2003/07/08 10:25:50 miham Exp $
*/
#ifndef _INPUT_PLUGIN_CONFIG_H_
#define _INPUT_PLUGIN_CONFIG_H_

#include <pcre.h>

#include "mconfig.h"
#include "mrecord.h"
#include "mio.h"

typedef struct {
	char	*inputfilename;

	mfile	inputfile;
	buffer	*buf;

	/* For keeping last record .. We need this for "repeating messages" lines .. */
	mlogrec	*internal_copy;
	/* For keeping the remaining repeatnum */
	int	repeatnum;
	/* For knowing if we ignored last line... */
	int	lastignored;

	/* 0 - short; 1 - normal; 2 - detailed; other - error :-) */
	int	loglevel;
	/* 0 - hasn't; 1 - has; other - error :-) */
	int	has_identlog;
	/* For those loglevels where self IP does not get printed in the log 
	 * this is a MUST for loglevel 0 + 1 */
	char	*self_host;
	
	pcre	*match_timestamp;

	/* For matching linetypes */
	pcre	*match_linetype;
	
	/* For matching TCP packetlog-line */
	pcre	*match_tcpline;
	/* For matching UDP packetlog-line */
	pcre	*match_udpline;
	/* For matching ICMP packetlog-line */
	pcre	*match_icmpline;
	/* For matching "repeating messages" line */
	pcre	*match_repline;

  /******* For ipmon lines (added 6/9/03) */
        pcre        *match_ipmon;
        pcre_extra  *match_ipmon_extra;


	/* Exact regexp for IP address */
	pcre	*match_ip;

	/* For matching linetypes - we need to use this plenty times */
	pcre_extra	*match_linetype_extra;
	
	/* For matching TCP packetlog-line - we need to use this plenty times */
	pcre_extra	*match_tcp_extra;
	/* For matching UDP packetlog-line - we need to use this plenty times */
	pcre_extra	*match_udp_extra;
	/* For matching ICMP packetlog-line - we need to use this plenty times */
	pcre_extra	*match_icmp_extra;
	/* For matching "repeating messages" line - we need to use this plenty times */
	pcre_extra	*match_rep_extra;

	/* For ignored source hosts */
	mlist		*ignored_shosts;
	/* For ignored destination hosts */
	mlist		*ignored_dhosts;
	/* For ignored source ports */
	mlist		*ignored_sports;
	/* For ignored destination ports */
	mlist		*ignored_dports;
} config_input;

int mplugins_input_ippl_get_next_record(mconfig *ext_conf, mlogrec *record);

#endif
