/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: mplugins.h,v 1.21 2002/12/30 11:27:22 ostborn Exp $
*/

#ifndef _M_PLUGINS_H_
#define _M_PLUGINS_H_

#include "mconfig.h"
#include "mstate.h"
#include "mrecord.h"

typedef struct {
	int (*dlinit)(mconfig *);
	int (*dlclose)(mconfig *);
	int (*parse_config)(mconfig *, const char *, const char *);
	int (*set_defaults)(mconfig *);
	int (*get_next_record)(mconfig *, mlogrec *record);
	int (*insert_record)(mconfig *, mlist *state_list, mlogrec *record);
	int (*gen_report)(mconfig *, mstate *state, const char *subpath);
	int (*gen_history)(mconfig *, mlist *history, const char *subpath);

	void * handle;
	void * config;
} mplugin;

int mplugins_setup(mconfig *conf);
int mplugins_load_plugins(mconfig *conf);
int mplugins_unload_plugins(mconfig *conf);
int mplugins_free(mconfig *conf);

#if 0
int mplugins_load_datatypes();
#endif

#endif

