#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>

#include "mtree.h"

mtree * mtree_init() {
	mtree *t = malloc(sizeof(mtree));
	assert(t);

	t->parent = NULL;
	t->childs = NULL;
	t->num_childs = 0;
	t->data = NULL;

	return t;
}

int mtree_is_empty(const mtree *t) {
	return (t->data == NULL && t->num_childs == 0);
}

int mtree_add_child(mtree *t, mtree *child) {
	t->childs = !t->childs ?
		malloc(sizeof(mtree *) * (t->num_childs + 1)) :
		realloc(t->childs, sizeof(mtree *) * (t->num_childs + 1));

	child->parent = t;
	t->childs[t->num_childs++] = child;

	return 0;
}

mtree * mtree_search(mtree *t, const char *name) {
	int i;
	if (!t)
		return NULL;

	if (!t->data)
		return NULL;
	
	if (0 == strcmp(name, t->data->key))
		return t;

	for (i = 0; i < t->num_childs; i++) {
		mtree * ret;

		if (( ret = mtree_search(t->childs[i], name)) != NULL)
			return ret;
	}
	return NULL;
}

void mtree_free(mtree *t) {
	int i;
	if (!t)
		return;

	for (i = 0; i < t->num_childs; i++) {
		mtree_free(t->childs[i]);
	}
	free(t->childs);
	
	mdata_free(t->data);
	free(t);
}

int mtree_pretty_print(const mtree *t, int level) {
	int i;
	if (!t) return -1;
	if (!t->data) return -1;

	for (i = 0; i < level; i++)
		fprintf(stderr, "| ");
	
	fprintf(stderr, "+ %s\n", t->data->key);
/*	mdata_show(t->data);*/

	for (i = 0; i < t->num_childs; i++) {
		mtree_pretty_print(t->childs[i], level + 1);
	}

	return 0;
}


int mtree_print(const mtree *t) {
	if (!t) {
		fprintf(stderr, "- no tree\n");
		return -1;
	}
	if (!t->data) {
		fprintf(stderr, "- empty tree\n");
		return -1;
	}

	mtree_pretty_print(t, 0);

	return 0;
}

int mtree_is_child(const mtree *t, const char *name) {
	int i;
	if (!t) return 0;
	if (!t->data) return 0;
	
	if (0 == strcmp(t->data->key, name))
		return 1;

	for (i = 0; i < t->num_childs; i++) {
		if (mtree_is_child(t->childs[i], name))
			return 1;
	}

	return 0;
}

/**
 *
 * @return number of elements - 1 as the root element is ignored
 */

int mtree_num_elements(const mtree *t) {
	int i, cnt;
	if (!t) return 0;
	if (!t->data) return 0;

	cnt = t->num_childs;

	for (i = 0; i < t->num_childs; i++) {
		cnt += mtree_num_elements(t->childs[i]);
	}

	return cnt;
}
