/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s) (alphabetical order):
 *  Chase Tingley <tingley@sundell.net>
 *  David Perry <d.perry@utoronto.ca>
 *  Jens Bannmann <jens.b@web.de>
 *  Jochen <bugs@krickelkrackel.de>
 *  Pavol Vaskovic <pali@pali.sk>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

var mgTabBox;
var mmbURL;

function mgInitPrefPanel() {
  mgTabBox = document.getElementById("mgTabBox");
  mmbURL = document.getElementById("middlemouse.contentLoadURL");

  mgComponentLoader.initMouseService();

  for (var i = 0; i < eltIDs.length; i++) {
    var elt = document.getElementById(eltIDs[i]);
    elt.mgDefaults = mgDefaultPrefs.getPref(elt.id);

    try {
      switch(typeof mgDefaultPrefs.prefs[elt.id][0]) {
        case "number":
          elt.value = mgPrefs.prefs.getIntPref(elt.id);
          elt.mgPrefType = "Int";
          elt.addEventListener("input", function (){mgCheckIntPref(this)}, true);
          break;
        case "boolean":
          elt.checked = mgPrefs.prefs.getBoolPref(elt.id);
          elt.mgPrefType = "Bool";
          break;
        case "string":
          elt.color = mgPrefs.prefs.getCharPref(elt.id);
          elt.mgPrefType = "Char";
          break;
        default:
          break;
      }
    }
    catch(e) {}
  }
  mmbURL.checked = mgPrefs.root.getBoolPref("middlemouse.contentLoadURL");

  if (navigator.platform.indexOf("Mac") == 0)
    document.getElementById("modifier.meta").hidden = false;

  onMouseButtonChange();
  toggleStrokes();
  toggleRockers();
  toggleWheelRockers()
  toggleTrailSettingsBox();
  toggleStatusSettingsBox();
  document.getElementById("version").setAttribute("value", mgAppInfo.mozgestVersion);

  var statics = document.getElementsByAttribute("mgStatic", "*")

  for (var x = 0; x < statics.length; x++)
    statics[x].hidden = !mgMouseEvents;

  document.getElementById("trailSettingsBox").hidden = !mgNativeTrails;

  try {
    mgTabBox.selectedIndex = mgPrefs.prefs.getIntPref("selectedTabIndex");
  }
  catch (e) {}
}

function savePrefs() {
  for (var i = 0; i < eltIDs.length; i++) {
    var elt = document.getElementById(eltIDs[i]);

    switch(elt.mgPrefType) {
      case "Int":
        mgPrefs.prefs.setIntPref(elt.id, elt.value);
        break;
      case "Bool":
        mgPrefs.prefs.setBoolPref(elt.id, elt.checked);
        break;
      case "Char":
        mgPrefs.prefs.setCharPref(elt.id, elt.color);
        break;
      default:
        break;
    }
  }
  mgPrefs.root.setBoolPref("middlemouse.contentLoadURL", mmbURL.checked);
}

function mgCheckIntPref(elt) {
  if (elt.value < elt.mgDefaults[1] ||
      elt.value > elt.mgDefaults[2] ||
      isNaN(elt.value))
    elt.setAttribute("mgNotValid", true);
  else
    elt.removeAttribute("mgNotValid");
}

function toggleLmbOnlyOptions() {
  var button = document.getElementById('mousebutton').selectedIndex;

  if (document.getElementById('lefthanded').checked)
    button = Math.abs(button - 2);

  toggleElements((button != 0)
      || document.getElementById("modifier.ctrl").checked
      || document.getElementById("modifier.alt").checked
      || document.getElementById("modifier.shift").checked,
      new Array("lmbGestureLimit", "dragdropDelay"));
}

function onMouseButtonChange() {
  var button = document.getElementById('mousebutton').selectedIndex;

  if (document.getElementById('lefthanded').checked)
    button = Math.abs(button - 2);

  document.getElementById('buttonOptionsDeck').selectedIndex = button;
  toggleLmbOnlyOptions();
}


function toggleStrokes() {
  toggleElements(!document.getElementById("enableStrokes").checked,
                 new Array("grid", "diagonalTolerance", "delay"));
}

function toggleRockers() {
  toggleElements(!document.getElementById("enableRockers").checked,
                 new Array("staticRockers"));
}

function toggleWheelRockers() {
  toggleElements(!document.getElementById("enableWheelRockers").checked,
                 new Array("staticWheelRockers"));
}

function toggleTrailSettingsBox() {
  toggleElements(!document.getElementById("trails.enabled").checked,
                 new Array("trails.width", "trails.color", "trails.interval"));
}

function toggleStatusSettingsBox() {
  toggleElements(!document.getElementById("status.enabled").checked,
                 new Array("status.timeout"));
}

function toggleElements(d, idArray) {
  for (var i = 0; i < idArray.length; i++)
    document.getElementById(idArray[i]).disabled = d;
}

function resetToDefault() {
  if (!confirm(document.documentElement.getAttribute("mgResetWarn")))
    return;

  for (each in mgDefaultPrefs.prefs) {
    if (each.indexOf("sideBar") == 0)
      continue;

    var pref = mgDefaultPrefs.prefs[each][0];

    switch(typeof pref) {
      case "number":
        mgPrefs.prefs.setIntPref(each, pref);
        break;
      case "boolean":
        mgPrefs.prefs.setBoolPref(each, pref);
        break;
      case "string":
        mgPrefs.prefs.setCharPref(each, pref);
        break;
      default:
        break;
    }
  }
  mgInitPrefPanel();
  mgTabBox.selectedIndex = 0;
}

function openMappingsWindow() {
  mgCommon.openDialog("chrome://mozgest/content/pref/mappings.xul");
}

function openPrintWindow() {
  if (mgCommon.checkWindowOpen('chrome://mozgest/content/sidebar/mozgestSidebar.xul'))
    return;

  try {
    var appS = Components.classes["@mozilla.org/appshell/appShellService;1"]
               .getService().QueryInterface(Components.interfaces.nsIAppShellService);

    var ioService = Components.classes["@mozilla.org/network/io-service;1"]
                    .getService(Components.interfaces.nsIIOService);
    var pURI = ioService.newURI('chrome://mozgest/content/sidebar/mozgestSidebar.xul',
                                null, null);
    appS.createTopLevelWindow(null, pURI, true, false, 4094, null, null);
  }
  catch (e) {}
}

function mgExitPrefPanel() {
  mgPrefs.prefs.setIntPref("selectedTabIndex", mgTabBox.selectedIndex);
}