/*
 * Decompiled with CFR 0.152.
 */
package logformat.trace;

import base.drawable.Category;
import base.drawable.Composite;
import base.drawable.Drawable;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import base.drawable.YCoordMap;
import java.util.Date;
import java.util.HashMap;
import logformat.trace.InputLog;

public class Print {
    private static String in_filename;
    private static String out_filename;
    private static boolean enable_endtime_check;
    private static String help_msg;

    public static final void main(String[] stringArray) {
        Kind kind;
        double d = Double.NEGATIVE_INFINITY;
        long l = Integer.MIN_VALUE;
        Drawable drawable = null;
        Print.parseCmdLineArgs(stringArray);
        HashMap<Integer, Category> hashMap = new HashMap<Integer, Category>();
        HashMap<Topology, Category> hashMap2 = new HashMap<Topology, Category>();
        long l2 = 0L;
        Date date = new Date();
        InputLog inputLog = new InputLog(in_filename);
        Date date2 = new Date();
        while ((kind = inputLog.peekNextKind()) != Kind.EOF) {
            double d2;
            Category category;
            if (kind == Kind.TOPOLOGY) {
                Topology topology = inputLog.getNextTopology();
                category = Category.getShadowCategory(topology);
                hashMap.put(new Integer(category.getIndex()), category);
                hashMap2.put(topology, category);
                System.out.println("trace.Print: " + topology);
                System.out.println("trace.Print: " + category);
                continue;
            }
            if (kind == Kind.YCOORDMAP) {
                YCoordMap yCoordMap = inputLog.getNextYCoordMap();
                System.out.println("trace.Print: " + yCoordMap);
                continue;
            }
            if (kind == Kind.CATEGORY) {
                category = inputLog.getNextCategory();
                hashMap.put(new Integer(category.getIndex()), category);
                System.out.println("trace.Print: " + category);
                continue;
            }
            if (kind == Kind.PRIMITIVE) {
                Primitive primitive = inputLog.getNextPrimitive();
                primitive.resolveCategory(hashMap);
                System.out.println(++l2 + " : " + primitive);
                if (!enable_endtime_check) continue;
                if (!primitive.isTimeOrdered()) {
                    System.out.println("**** Primitive Time Error ****");
                    System.exit(1);
                }
                if (d > (d2 = primitive.getLatestTime())) {
                    System.out.println("**** Violation of Increasing Endtime Order ****\n\t Offended Drawable -> " + l + " : " + drawable + "\n" + "\t Offending Primitive -> " + l2 + " : " + primitive + "\n" + "   previous drawable endtime ( " + d + " ) " + " > current drawable endtiime ( " + d2 + " ) ");
                    System.exit(1);
                    continue;
                }
                l = l2;
                drawable = primitive;
                d = d2;
                continue;
            }
            if (kind == Kind.COMPOSITE) {
                Composite composite = inputLog.getNextComposite();
                composite.resolveCategory(hashMap);
                System.out.println(++l2 + " : " + composite);
                if (!enable_endtime_check) continue;
                if (!composite.isTimeOrdered()) {
                    System.out.println("**** Composite Time Error ****");
                    System.exit(1);
                }
                if (d > (d2 = composite.getLatestTime())) {
                    System.out.println("**** Violation of Increasing Endtime Order ****\n\t Offended Drawable -> " + l + " : " + drawable + "\n" + "\t Offending Composite -> " + l2 + " : " + composite + "\n" + "   previous drawable endtime ( " + d + " ) " + " > current drawable endtiime ( " + d2 + " ) ");
                    System.exit(1);
                    continue;
                }
                l = l2;
                drawable = composite;
                d = d2;
                continue;
            }
            System.err.println("trace.Print: Unrecognized return from peekNextKind() = " + kind);
        }
        inputLog.close();
        Date date3 = new Date();
        System.err.println("\n");
        System.err.println("Number of Drawables = " + l2);
        System.err.println("timeElapsed between 1 & 2 = " + (date2.getTime() - date.getTime()) + " msec");
        System.err.println("timeElapsed between 2 & 3 = " + (date3.getTime() - date2.getTime()) + " msec");
    }

    private static void parseCmdLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        enable_endtime_check = false;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("-")) {
                    if (stringArray[n].equals("-h") || stringArray[n].equals("--h") || stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                        System.out.println(help_msg);
                        stringBuffer2.append("-h ");
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-tc")) {
                        enable_endtime_check = true;
                        stringBuffer.append("\n endtime_order_check = true");
                        ++n;
                        continue;
                    }
                    stringBuffer2.append(stringArray[n] + " ");
                    ++n;
                    continue;
                }
                stringBuffer2.append(stringArray[n] + " ");
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + Print.indexOrderStr(n) + " command line argument.");
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            String string = Print.indexOrderStr(n);
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + Print.indexOrderStr(n) + " command line argument.  It needs a number.");
            numberFormatException.printStackTrace();
        }
        in_filename = stringBuffer2.toString().trim();
        if (in_filename == null) {
            System.err.println("The Program needs a TRACE filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int n) {
        switch (n) {
            case 1: {
                return Integer.toString(n) + "st";
            }
            case 2: {
                return Integer.toString(n) + "nd";
            }
            case 3: {
                return Integer.toString(n) + "rd";
            }
        }
        return Integer.toString(n) + "th";
    }

    static {
        System.loadLibrary("TraceInput");
        help_msg = "Usage: java trace.Print [options] trace_filename.\n options: \n\t [-h|--h|-help|--help]            \t Display this message.\n\t [-tc]                            \t Check increasing endtime order\n";
    }
}

