/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import logformat.slog2.CategoryMap;
import viewer.legends.CategoryIcon;
import viewer.legends.LegendComparators;

public class LegendTableModel
extends AbstractTableModel {
    public static final int ICON_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int VISIBILITY_COLUMN = 2;
    public static final int SEARCHABILITY_COLUMN = 3;
    private static final String[] COLUMN_TITLES = new String[]{"Topo", "Name", "V", "S"};
    private static final String[] COLUMN_TOOLTIPS = new String[]{"Topology/Color", "Category Name", "Visibility", "Searchability"};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$viewer$legends$CategoryIcon == null ? (class$viewer$legends$CategoryIcon = LegendTableModel.class$("viewer.legends.CategoryIcon")) : class$viewer$legends$CategoryIcon, class$java$lang$String == null ? (class$java$lang$String = LegendTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = LegendTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = LegendTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean};
    private static final Color[] COLUMN_TITLE_FORE_COLORS = new Color[]{Color.magenta, Color.pink, Color.green, Color.yellow};
    private static final Color[] COLUMN_TITLE_BACK_COLORS = new Color[]{Color.black, Color.gray, Color.darkGray.darker(), Color.blue.darker()};
    private static final boolean[] COLUMN_TITLE_RAISED_ICONS = new boolean[]{false, false, true, false};
    private static final Object[] COLUMN_SAMPLES = new Object[]{CategoryIcon.BLANK_ICON, "ABCDEFGHIJKLMNOP", Boolean.TRUE, Boolean.TRUE};
    private List objdef_list = null;
    private List icon_list = null;
    static /* synthetic */ Class class$viewer$legends$CategoryIcon;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public LegendTableModel(CategoryMap categoryMap) {
        this.objdef_list = new ArrayList(categoryMap.values());
        this.sortNormally(LegendComparators.CASE_SENSITIVE_ORDER);
    }

    private void initIconListFromCategoryList() {
        this.icon_list = new ArrayList(this.objdef_list.size());
        Iterator iterator = this.objdef_list.iterator();
        while (iterator.hasNext()) {
            Category category = (Category)iterator.next();
            CategoryIcon categoryIcon = new CategoryIcon(category);
            this.icon_list.add(categoryIcon);
        }
    }

    private void sortNormally(Comparator comparator) {
        Collections.sort(this.objdef_list, comparator);
        this.initIconListFromCategoryList();
    }

    private void sortReversely(Comparator comparator) {
        Collections.sort(this.objdef_list, comparator);
        Collections.reverse(this.objdef_list);
        this.initIconListFromCategoryList();
    }

    public void arrangeOrder(Comparator comparator) {
        this.sortNormally(comparator);
        super.fireTableDataChanged();
    }

    public void reverseOrder(Comparator comparator) {
        this.sortReversely(comparator);
        super.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.objdef_list.size();
    }

    public int getColumnCount() {
        return COLUMN_TITLES.length;
    }

    public Class getColumnClass(int n) {
        return COLUMN_CLASSES[n];
    }

    public String getColumnName(int n) {
        return COLUMN_TITLES[n];
    }

    public Color getColumnNameForeground(int n) {
        return COLUMN_TITLE_FORE_COLORS[n];
    }

    public Color getColumnNameBackground(int n) {
        return COLUMN_TITLE_BACK_COLORS[n];
    }

    public boolean isRaisedColumnNameIcon(int n) {
        return COLUMN_TITLE_RAISED_ICONS[n];
    }

    public String getColumnToolTip(int n) {
        return COLUMN_TOOLTIPS[n];
    }

    public Object getColumnTypicalValue(int n) {
        return COLUMN_SAMPLES[n];
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.icon_list.get(n);
            }
            case 1: {
                Category category = (Category)this.objdef_list.get(n);
                return category.getName();
            }
            case 2: {
                Category category = (Category)this.objdef_list.get(n);
                if (category.isVisible()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 3: {
                Category category = (Category)this.objdef_list.get(n);
                if (category.isSearchable()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        System.err.println("LegendTableModel.getValueAt(" + n + "," + n2 + ") fails!");
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public void setValueAt(Object object, int n, int n2) {
        Category category = (Category)this.objdef_list.get(n);
        switch (n2) {
            case 0: {
                ColorAlpha colorAlpha = (ColorAlpha)object;
                category.setColor(colorAlpha);
                CategoryIcon categoryIcon = (CategoryIcon)this.icon_list.get(n);
                categoryIcon.setDisplayedColor(colorAlpha);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 1: {
                category.setName((String)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 2: {
                category.setVisible((Boolean)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            case 3: {
                category.setSearchable((Boolean)object);
                this.fireTableCellUpdated(n, n2);
                break;
            }
            default: {
                System.err.print("LegendTableModel.setValueAt(" + n + "," + n2 + ") fails!");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

