/* GIMP Raw Photo plugin
 * Copyright (C) 2002,2003 Bradley Broom <dobroom@swbell.net>
 *
 * Based on the
 * GIMP Dimage color plugin
 * Copyright (C) 2002 Laurent HOUDARD <lhoudard@netcourrier.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PREVIEW_H
#define PREVIEW_H

#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libeog/eog-image.h>
#include <stdio.h>

typedef struct {
  MRI_Region	r;
  gint		shrink;
  gint		expand;
} Region;

typedef struct 
{
  MRI	  *mri;
  const PersistentVals *loadopt;
  gint     width;
  gint     height;
  gint     xoff;
  gint     yoff;
  gint     bpp;
  gint	   aWidth;	/* Actual (realized) width */
  gint	   aHeight;	/* Actual (realized) height */
  gdouble  scale;
  Region   region;
  guchar  *bits;
  GtkWidget *image_view;
  EogImage *ui_image;
  GdkPixbuf *pixbuf;
  GtkWidget *menu;
  int	   previewRunning;
  int	   previewIdleTag;
  MRI_Link *Renderer;
  MRI_ProcessIterator *pip;
  int *hvals;
  PersistentVals vals;
  GtkWidget *progressBar;
  MRI_Region grayWorldRegion;	/* Region used to calc. gray world gains. */
  MRI_Region previewRegion;	/* Region to display in preview. */
  FILE *tracefd;
} Preview;

void do_preview ();
void rotate_preview (int);
void preview_set_gray_world_region (void);
void preview_set_preview_region (void);

extern MRI_Link *MakeRenderRaw (MRI *mri,
	    	       MRI_Link *head,
		       int N, int *counts,
		       int shrink,
	    	       PersistentVals *loadopt,
		       FILE *tracefd);

extern GtkWidget *CreatePreviewPane (UI_RunVals *runVals);
extern GtkWidget *GenPreviewInterpolationMenu ();

#endif
