import os.path
import shutil
import zope.interface

from multibuild.builder.hooks import interfaces, register, apt, spawn

class Hook(apt.Hook):
    zope.interface.implements(interfaces.IHookEnvironment)
    zope.interface.classProvides(interfaces.IHookEnvironmentFactory)

    name = "environment-default"

    def __init__(self, id, dist, arch, user, log):
        self.id, self.dist, self.arch, self.user, self.log = id, dist, arch, user, log
        self.path = os.path.expanduser("~/build/chroot-%s" % id)

        try:
            os.stat(self.path)
        except OSError:
            raise RuntimeError, "Environment does not exist"

    def cleanup(self, build):
        self.uninstall_apt(build)
        shutil.rmtree(self.build_path)

    def install(self, build, packages):
        self.install_apt(build, packages)

    def prepare(self, build):
        f = self.run("dpkg --print-installation-architecture")
        self.arch_root = f.readline().strip()
        if f.close():
            raise RuntimeError, "dpkg failed"

        self.build_dir = "/build/%s/%d" % (self.user, os.getpid())
        self.build_path = "%s/%s" % (self.path, self.build_dir)
        self.run(['mkdir', '-p', self.build_dir])

        self.prepare_apt()

    def run(self, cmd, dir = None, root = False):
        if isinstance(cmd, list):
            cmd = ' '.join(cmd)
        cmd = cmd.replace("'", r"'\''")
        if dir is not None:
            cmd = "cd '%s'; %s" % (dir.replace("'", r"'\''"), cmd)
        if root:
            pcmd = "sudo chroot '%s' sh -c 'set -e; %s' 2>&1" % (self.path, cmd)
        else:
            pcmd = "sudo chroot '%s' su -s /bin/sh -c 'set -e; %s' '%s' 2>&1" % (self.path, cmd, self.user)
        return spawn.spawn(pcmd)

    run_dir = run

    def suexec(self, cmd):
        return self.run(cmd, root = True)

register(Hook)
