import os, signal

class spawn(object):
    status = None

    def __init__(self, cmd):
        outread, outwrite = os.pipe()
        self.pid = os.fork()
        if not self.pid:
            # Child
            inread = os.open('/dev/null', os.O_RDONLY)
            os.dup2(inread, 0)
            os.dup2(outwrite, 1)
            os.close(inread)
            os.close(outread)
            os.close(outwrite)
            os.setsid()
            try:
                os.execv('/bin/sh', ['sh', '-c', cmd])
            except:
                os._exit(127)
        else:
            # Parent
            os.close(outwrite)
            self.file = os.fdopen(outread, 'r')

    def __iter__(self):
        return iter(self.file)

    def __getattr__(self, name):
        return getattr(self.file, name)

    def close(self):
        self.file.close()
        return self.wait()

    def kill(self, signal = signal.SIGINT):
        self.file.close()
        try:
            os.kill(-self.pid, signal)
        except OSError, e:
            import errno
            if e.errno not in (errno.EPERM, errno.ESRCH):
                raise

    def wait(self):
        if self.status is None:
            pid, status = os.waitpid(self.pid, 0)
            if pid == self.pid:
                self.status = status
        return self.status

