import os

class Hook(object):
    @staticmethod
    def filename_changes(build):
        arch = build.environment.arch
        if arch == 'all':
            arch = build.environment.arch_root
        return "%s_%s_%s.changes" % (build.package, build.version.complete_noepoch, arch)

    @staticmethod
    def dirname(build):
        return "%s-%s" % (build.package, build.version.upstream)

    def get_files(self, build):
        f = file(os.path.join(build.environment.build_path, self.dirname(build), "debian", "files"))
        return [i.split()[0] for i in f]


