/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 gnusearch.h  -  Definition of a representation of a search in progress

    begin                : Wed May 30 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef __GNUSEARCH_H_INCLUDED__
#define __GNUSEARCH_H_INCLUDED__

class MGnuDirector;
class MGnuPreferences;
class MGnuNode;

class MGnuSearch : protected SGnuSearch
{
//friend class MGnuDirector;
public: 
	MGnuSearch(MGnuDirector* pControl,
				const CString& search,
				const SHA1Hash& sha1,
				int type,
				int size = 0,
				int sizeMode = LIMIT_NONE,
				bool bForceStrictGrouping = false);
	~MGnuSearch();

	void SetSearchString(const CString& s, bool bLock = true);
	void SetSearchStringAndFilename(const CString& s, const CString& sFilename);
	void SetFilename(const CString& sFilename);
	void SetFileHandle(long nHandle) {m_FileHandle = nHandle;}
	long GetFileHandle() { return m_FileHandle; }

	CString GetSearchString();
	CString GetFilename();
	int GetSizeFilterMode() { return m_SizeFilterMode; }
	int GetSizeFilterValue() { return m_SizeFilterValue; }
	int GetType() { return m_nType; }
	void SetType(int nType) { m_nType = nType; }

	void AddSha1Hash(const SHA1Hash& sha1);
	void RemoveSha1Hash(const SHA1Hash& sha1);
	bool IsInList(const SHA1Hash& sha1);
	
	void SendQuery();
	void SendSpecificQuery(const CString& sText, const SHA1Hash& sha1);

	bool IsFull();
	void Clear();

	bool CheckLimit(int, DWORD, DWORD);
	bool CheckAgainstResult(const Result &);

	// updated flag for MGnuDownload
	bool IsUpdated() { return m_bUpdated; }
	void SetUpdated(bool bUpdated) { m_bUpdated = bUpdated; }

	bool IsAutoget() { return m_bAutoget; }
	void SetAutoget(bool bSet) { m_bAutoget = bSet; }
	
	int  GetResultsCount() { return m_nHits; }

	void GetResults(vector<Result>& vecRes);
	void GetAllResults(SGnuSearch* pGS, vector<Result>* pRV, vector<ResultGroup>* pGV);

	DWORD GetID() { return m_dwID; }
	void SetID(DWORD dwID) { m_dwID = dwID; }

	void GetSGnuSearch(SGnuSearch& gs) const;
protected:
	bool UpdateExisting(const Result & result); // just checks wether the result is in the list and updates it
	bool UpdateGroups(const Result & result);
protected:
	// search kitchen
	char*   m_szSearch;
	vector<char*> m_PlusWords;
	vector<char*> m_MinusWords;
	// results lists, sets, maps
	mutable MMutex m_mutex;
	// main results storage
	ResultVec m_vecResults;
	// types for maps and indexes
	typedef set<int>                   tIndexSet;
	typedef map<SHA1Hash, tIndexSet>   tSha1Index;
	typedef set<CString>               tStringSet;
	typedef map<tStringSet, tIndexSet> tStringsIndes;
	typedef map<DWORD, tIndexSet>      tSizeIndex;
	typedef map<int, int>              tIndexMap;
	// maps and indexes
	tSha1Index    m_mapSha1;
	tStringsIndes m_mapStrings;
	tSizeIndex    m_mapSize;
	// groups
	struct tGroup {
		DWORD     dwID;
		tIndexSet set;
	};
	typedef vector<tGroup> tGroupVec;
	tGroupVec  m_vecGroups;
	tIndexMap  m_mapGroupIndex;

	// updated flag
	bool   m_bUpdated;
	
	// file handle
	long m_nFileHandle;

	// grouping mode switch
	bool m_bStrictSha1Grouping;
	bool m_bForceStrictGrouping;

	// packet
	BYTE*  m_Packet;
	int    m_nPacketLength;
	//
	MGnuDirector* m_pDirector;
	MGnuPreferences* m_pPrefs;
};

#endif //__GNUSEARCH_H_INCLUDED__

