// Copyright (C) 2004-2007 MySQL AB
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as published by
// the Free Software Foundation
//
// There are special exceptions to the terms and conditions of the GPL 
// as it is applied to this software. View the full text of the 
// exception in file EXCEPTIONS in the directory of this software 
// distribution.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 

using System;
using System.Diagnostics;
using NUnit.Framework;

namespace MySql.Data.MySqlClient.Tests
{
	[TestFixture]
	public class UsageAdvisorTests : BaseTest
	{
		[TestFixtureSetUp]
		protected override void FixtureSetup()
		{
			csAdditions = ";Usage Advisor=true;";
			base.FixtureSetup();
		}

		protected override void Setup()
		{
			base.Setup();
			execSQL("DROP TABLE IF EXISTS Test");
			createTable("CREATE TABLE Test (id int, name VARCHAR(200))", "INNODB");
		}

		[Explicit]
		[Test]
		public void NotReadingEveryField()
		{
			execSQL("INSERT INTO Test VALUES (1, 'Test1')");
			execSQL("INSERT INTO Test VALUES (2, 'Test2')");
			execSQL("INSERT INTO Test VALUES (3, 'Test3')");
			execSQL("INSERT INTO Test VALUES (4, 'Test4')");

			Trace.Listeners.Clear();
			GenericListener listener = new GenericListener();
			Trace.Listeners.Add(listener);

			MySqlCommand cmd = new MySqlCommand("SELECT * FROM Test; SELECT * FROM Test WHERE id > 2", conn);
			MySqlDataReader reader = null;
			try
			{
				reader = cmd.ExecuteReader();
				reader.Read();
				int id = reader.GetInt32(0);
				reader.Read();

				Assert.IsTrue(reader.NextResult());
				Assert.IsTrue(listener.Find("Fields not accessed:  name") != 0);

				reader.Read();
				listener.Clear();

				Assert.AreEqual("Test3", reader.GetString(1));
				Assert.IsFalse(reader.NextResult());
				Assert.IsTrue(listener.Find("Fields not accessed:  id") > 0);
			}
			catch (Exception ex)
			{
				Assert.Fail(ex.Message);
			}
			finally
			{
				if (reader != null) reader.Close();
			}

		}

		[Explicit]
		[Test]
		public void NotReadingEveryRow()
		{
			execSQL("INSERT INTO Test VALUES (1, 'Test1')");
			execSQL("INSERT INTO Test VALUES (2, 'Test2')");
			execSQL("INSERT INTO Test VALUES (3, 'Test3')");
			execSQL("INSERT INTO Test VALUES (4, 'Test4')");

			Trace.Listeners.Clear();
			GenericListener listener = new GenericListener();
			Trace.Listeners.Add(listener);

			MySqlCommand cmd = new MySqlCommand("SELECT * FROM Test; SELECT * FROM Test WHERE id > 2", conn);
			MySqlDataReader reader = null;
			try
			{
				reader = cmd.ExecuteReader();
				reader.Read();
				reader.Read();

				listener.Clear();
				Assert.IsTrue(reader.NextResult());
				Assert.IsTrue(listener.Find("Reason: Not all rows in resultset were read.") > 0);

				reader.Read();
				reader.Read();
				listener.Clear();

				Assert.IsFalse(reader.NextResult());
				Assert.IsTrue(listener.Find("Reason: Not all rows in resultset were read.") > 0);
			}
			catch (Exception ex)
			{
				Assert.Fail(ex.Message);
			}
			finally
			{
				if (reader != null) reader.Close();
			}

		}

	}
}
