/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.packet.PartEnumeration;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import java.sql.SQLException;
import java.util.Hashtable;

public class FetchInfo {
    private ConnectionSapDB connection;
    private String cursorName;
    private DBTechTranslator[] columnInfo;
    private int recordSize;
    private Hashtable columnMapping = null;
    private String _fetchparamstring;
    private String[] columnNames;
    boolean marker = false;

    public FetchInfo(ConnectionSapDB connectionSapDB, String string, DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        this.connection = connectionSapDB;
        this.cursorName = string;
        if (dBTechTranslatorArray == null || stringArray == null) {
            this.columnInfo = null;
            return;
        }
        this.setMetaData(dBTechTranslatorArray, stringArray);
    }

    private void describe() throws SQLException {
        ConnectionSapDB connectionSapDB = this.connection;
        DBTechTranslator[] dBTechTranslatorArray = null;
        String[] stringArray = null;
        RequestPacket requestPacket = connectionSapDB.getRequestPacket();
        requestPacket.initDbsCommand(false, "DESCRIBE \"" + this.cursorName + "\"", 1003);
        ReplyPacket replyPacket = connectionSapDB.execute(requestPacket, this, 1);
        PartEnumeration partEnumeration = replyPacket.partEnumeration();
        while (partEnumeration.hasMoreElements()) {
            partEnumeration.nextElement();
            int n = partEnumeration.partKind();
            if (n == 2) {
                stringArray = replyPacket.parseColumnNames();
                continue;
            }
            if (n == 14) {
                dBTechTranslatorArray = replyPacket.parseShortFields(this.connection.isSpaceoptionSet, false, null, false);
                continue;
            }
            if (n != 32) continue;
            dBTechTranslatorArray = replyPacket.parseShortFields(this.connection.isSpaceoptionSet, false, null, true);
        }
        this.setMetaData(dBTechTranslatorArray, stringArray);
    }

    private void setMetaData(DBTechTranslator[] dBTechTranslatorArray, String[] stringArray) throws SQLException {
        int n = dBTechTranslatorArray.length;
        this.recordSize = 0;
        if (n == stringArray.length) {
            this.columnInfo = dBTechTranslatorArray;
            for (int i = 0; i < n; ++i) {
                DBTechTranslator dBTechTranslator = dBTechTranslatorArray[i];
                dBTechTranslator.setColName(stringArray[i]);
                dBTechTranslator.setColIndex(i);
                int n2 = dBTechTranslator.getPhysicalLength() + dBTechTranslator.getBufpos() - 1;
                this.recordSize = Math.max(this.recordSize, n2);
            }
        } else {
            int n3 = 0;
            this.columnInfo = new DBTechTranslator[stringArray.length];
            for (int i = 0; i < n; ++i) {
                if (!dBTechTranslatorArray[i].isOutput()) continue;
                DBTechTranslator dBTechTranslator = this.columnInfo[n3] = dBTechTranslatorArray[i];
                dBTechTranslator.setColName(stringArray[n3]);
                dBTechTranslator.setColIndex(n3++);
                int n4 = dBTechTranslator.getPhysicalLength() + dBTechTranslator.getBufpos() - 1;
                this.recordSize = Math.max(this.recordSize, n4);
            }
        }
    }

    private void setColMapping() {
        int n = this.columnInfo.length;
        this.columnMapping = new Hashtable(2 * n);
        for (int i = 0; i < n; ++i) {
            DBTechTranslator dBTechTranslator = this.columnInfo[i];
            this.columnMapping.put(dBTechTranslator.getColumnName(), dBTechTranslator);
        }
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public ReplyPacket executeFetchNext(int n) throws SQLException {
        String string = "FETCH NEXT \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        ReplyPacket replyPacket = this.executeFetchCommand(string, n);
        return replyPacket;
    }

    public ReplyPacket executeFetchAbsolute(long l, int n) throws SQLException {
        String string = "FETCH ABSOLUTE " + l + " \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        ReplyPacket replyPacket = this.executeFetchCommand(string, n);
        return replyPacket;
    }

    public ReplyPacket executeFetchRelative(long l, int n) throws SQLException {
        String string = "FETCH RELATIVE " + l + " \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        return this.executeFetchCommand(string, n);
    }

    public ReplyPacket executeFetchFirst(int n) throws SQLException {
        String string = "FETCH FIRST \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        return this.executeFetchCommand(string, n);
    }

    public ReplyPacket executeFetchLast(int n) throws SQLException {
        String string = "FETCH LAST \"" + this.cursorName + "\" INTO " + this.getFetchParamString();
        return this.executeFetchCommand(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplyPacket executeFetchCommand(String string, int n) throws SQLException {
        RequestPacket requestPacket = this.connection.getRequestPacket();
        int n2 = requestPacket.switchSqlMode(2);
        requestPacket.initDbsCommand(false, string, 1003);
        if (n > 1) {
            requestPacket.setMassCommand();
        } else {
            n = 1;
        }
        requestPacket.addResultCount(n);
        try {
            ReplyPacket replyPacket = this.connection.execute(requestPacket, this, 2);
            return replyPacket;
        }
        finally {
            requestPacket.switchSqlMode(n2);
        }
    }

    private String getFetchParamString() throws SQLException {
        if (this.columnInfo == null) {
            this.describe();
        }
        if (this._fetchparamstring == null) {
            StringBuffer stringBuffer = new StringBuffer("?");
            for (int i = 1; i < this.columnInfo.length; ++i) {
                stringBuffer.append(", ?");
            }
            this._fetchparamstring = stringBuffer.toString();
        }
        return this._fetchparamstring;
    }

    public final DBTechTranslator getColumnInfo(String string) throws SQLException {
        String string2;
        Object v;
        if (this.columnInfo == null) {
            this.describe();
        }
        if (this.columnMapping == null) {
            this.setColMapping();
        }
        if ((v = this.columnMapping.get(string)) == null && (v = this.columnMapping.get(string2 = string.toUpperCase())) != null) {
            this.columnMapping.put(string2, v);
        }
        return (DBTechTranslator)v;
    }

    public DBTechTranslator[] getColInfo() throws SQLException {
        if (this.columnInfo == null) {
            this.describe();
        }
        return this.columnInfo;
    }

    int numberOfColumns() {
        return this.columnInfo.length;
    }

    int getRecordSize() {
        return this.recordSize;
    }
}

