
%x str1 str2 comment

%{
#include <stdlib.h>
#include <memory.h>
#include <string.h>

#define YYSTYPE void*
#include "myx_sql_parser.tab.hh" // autogenerated by bison

#define YY_READ_BUF_SIZE  (2*1024*1024)
#undef YY_BUF_SIZE
#define YY_BUF_SIZE       (2*1024*1024)

extern int yy_token_match(int token, const char *value);
extern int yy_unknown_token(const char *value);

char *str_buffer= 0;
size_t str_buffer_size= 0;
char *str_buffer_ptr= 0;

void realloc_str_buffer()
{
  char *tmp= malloc(str_buffer_size << 1);
  memcpy(tmp, str_buffer, str_buffer_size);
  free(str_buffer);
  str_buffer= tmp;
  str_buffer_ptr= str_buffer + str_buffer_size;
  str_buffer_size <<= 1;
}

#define YY_DECL int yylex(void **yylval)

extern stmtStart(const char *value);

extern yy_custom_input(char *buf, int *result, int max_size);
#define YY_INPUT(buf,result,max_size) yy_custom_input(buf, &result, max_size)
%}

DISCARD ((d|D)(i|I)(s|S)(c|C)(a|A)(r|R)(d|D))
INTO ((i|I)(n|N)(t|T)(o|O))
FROM_UNIXTIME ((f|F)(r|R)(o|O)(m|M)_(u|U)(n|N)(i|I)(x|X)(t|T)(i|I)(m|M)(e|E))
BIT_XOR ((b|B)(i|I)(t|T)_(x|X)(o|O)(r|R))
COMPRESSED_SYM ((c|C)(o|O)(m|M)(p|P)(r|R)(e|E)(s|S)(s|S)(e|E)(d|D))
MONTH_SYM ((m|M)(o|O)(n|N)(t|T)(h|H))|((s|S)(q|Q)(l|L)_(t|T)(s|S)(i|I)_(m|M)(o|O)(n|N)(t|T)(h|H))
RENAME ((r|R)(e|E)(n|N)(a|A)(m|M)(e|E))
INTERVAL_SYM ((i|I)(n|N)(t|T)(e|E)(r|R)(v|V)(a|A)(l|L))
INSERT_METHOD ((i|I)(n|N)(s|S)(e|E)(r|R)(t|T)_(m|M)(e|E)(t|T)(h|H)(o|O)(d|D))
REGEXP ((r|R)(e|E)(g|G)(e|E)(x|X)(p|P))|((r|R)(l|L)(i|I)(k|K)(e|E))
CLIENT_SYM ((c|C)(l|L)(i|I)(e|E)(n|N)(t|T))
IMPORT ((i|I)(m|M)(p|P)(o|O)(r|R)(t|T))
HOSTS_SYM ((h|H)(o|O)(s|S)(t|T)(s|S))
NVARCHAR_SYM ((n|N)(v|V)(a|A)(r|R)(c|C)(h|H)(a|A)(r|R))
UNDO_SYM ((u|U)(n|N)(d|D)(o|O))
BINARY ((b|B)(i|I)(n|N)(a|A)(r|R)(y|Y))
EXTRACT_SYM ((e|E)(x|X)(t|T)(r|R)(a|A)(c|C)(t|T))
CONSTRAINT ((c|C)(o|O)(n|N)(s|S)(t|T)(r|R)(a|A)(i|I)(n|N)(t|T))
QUERY_SYM ((q|Q)(u|U)(e|E)(r|R)(y|Y))
SERIALIZABLE_SYM ((s|S)(e|E)(r|R)(i|I)(a|A)(l|L)(i|I)(z|Z)(a|A)(b|B)(l|L)(e|E))
INNER_SYM ((i|I)(n|N)(n|N)(e|E)(r|R))
X509_SYM ((x|X)509)
TIMESTAMP_ADD ((t|T)(i|I)(m|M)(e|E)(s|S)(t|T)(a|A)(m|M)(p|P)(a|A)(d|D)(d|D))
ERRORS ((e|E)(r|R)(r|R)(o|O)(r|R)(s|S))
HOUR_SYM ((h|H)(o|O)(u|U)(r|R))|((s|S)(q|Q)(l|L)_(t|T)(s|S)(i|I)_(h|H)(o|O)(u|U)(r|R))
DEALLOCATE_SYM ((d|D)(e|E)(a|A)(l|L)(l|L)(o|O)(c|C)(a|A)(t|T)(e|E))
MASTER_SSL_KEY_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(s|S)(s|S)(l|L)_(k|K)(e|E)(y|Y))
PREPARE_SYM ((p|P)(r|R)(e|E)(p|P)(a|A)(r|R)(e|E))
OPEN_SYM ((o|O)(p|P)(e|E)(n|N))
ANALYZE_SYM ((a|A)(n|N)(a|A)(l|L)(y|Y)(z|Z)(e|E))
DUPLICATE_SYM ((d|D)(u|U)(p|P)(l|L)(i|I)(c|C)(a|A)(t|T)(e|E))
HELP_SYM ((h|H)(e|E)(l|L)(p|P))
DECIMAL_SYM ((d|D)(e|E)(c|C))|((d|D)(e|E)(c|C)(i|I)(m|M)(a|A)(l|L))
NO_WRITE_TO_BINLOG ((n|N)(o|O)_(w|W)(r|R)(i|I)(t|T)(e|E)_(t|T)(o|O)_(b|B)(i|I)(n|N)(l|L)(o|O)(g|G))
SPECIFIC_SYM ((s|S)(p|P)(e|E)(c|C)(i|I)(f|F)(i|I)(c|C))
WHEN_SYM ((w|W)(h|H)(e|E)(n|N))
READS_SYM ((r|R)(e|E)(a|A)(d|D)(s|S))
CONCAT_WS ((c|C)(o|O)(n|N)(c|C)(a|A)(t|T)_(w|W)(s|S))
LOCATE ((l|L)(o|O)(c|C)(a|A)(t|T)(e|E))
NUMERIC_SYM ((n|N)(u|U)(m|M)(e|E)(r|R)(i|I)(c|C))
ITERATE_SYM ((i|I)(t|T)(e|E)(r|R)(a|A)(t|T)(e|E))
SUM_SYM ((s|S)(u|U)(m|M))
DIRECTORY_SYM ((d|D)(i|I)(r|R)(e|E)(c|C)(t|T)(o|O)(r|R)(y|Y))
MASTER_PASSWORD_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(p|P)(a|A)(s|S)(s|S)(w|W)(o|O)(r|R)(d|D))
UPDATE_SYM ((u|U)(p|P)(d|D)(a|A)(t|T)(e|E))
AVG_SYM ((a|A)(v|V)(g|G))
ROWS_SYM ((r|R)(o|O)(w|W)(s|S))
BETWEEN_SYM ((b|B)(e|E)(t|T)(w|W)(e|E)(e|E)(n|N))
ONE_SHOT_SYM ((o|O)(n|N)(e|E)_(s|S)(h|H)(o|O)(t|T))
PROCESSLIST_SYM ((p|P)(r|R)(o|O)(c|C)(e|E)(s|S)(s|S)(l|L)(i|I)(s|S)(t|T))
PRIMARY_SYM ((p|P)(r|R)(i|I)(m|M)(a|A)(r|R)(y|Y))
OUTFILE ((o|O)(u|U)(t|T)(f|F)(i|I)(l|L)(e|E))
TINYINT ((i|I)(n|N)(t|T)1)|((t|T)(i|I)(n|N)(y|Y)(i|I)(n|N)(t|T))
XOR ((x|X)(o|O)(r|R))
DEFINER_SYM ((d|D)(e|E)(f|F)(i|I)(n|N)(e|E)(r|R))
RESTORE_SYM ((r|R)(e|E)(s|S)(t|T)(o|O)(r|R)(e|E))
UNDEFINED_SYM ((u|U)(n|N)(d|D)(e|E)(f|F)(i|I)(n|N)(e|E)(d|D))
MASTER_HOST_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(h|H)(o|O)(s|S)(t|T))
WEEK_SYM ((s|S)(q|Q)(l|L)_(t|T)(s|S)(i|I)_(w|W)(e|E)(e|E)(k|K))|((w|W)(e|E)(e|E)(k|K))
FORCE_SYM ((f|F)(o|O)(r|R)(c|C)(e|E))
BACKUP_SYM ((b|B)(a|A)(c|C)(k|K)(u|U)(p|P))
REPEATABLE_SYM ((r|R)(e|E)(p|P)(e|E)(a|A)(t|T)(a|A)(b|B)(l|L)(e|E))
SET ((s|S)(e|E)(t|T))
LONGBLOB ((l|L)(o|O)(n|N)(g|G)(b|B)(l|L)(o|O)(b|B))
YEARWEEK ((y|Y)(e|E)(a|A)(r|R)(w|W)(e|E)(e|E)(k|K))
MASTER_LOG_FILE_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(l|L)(o|O)(g|G)_(f|F)(i|I)(l|L)(e|E))
TO_SYM ((t|T)(o|O))
CONVERT_SYM ((c|C)(o|O)(n|N)(v|V)(e|E)(r|R)(t|T))
CHECK_SYM ((c|C)(h|H)(e|E)(c|C)(k|K))
GEOMETRY_SYM ((g|G)(e|E)(o|O)(m|M)(e|E)(t|T)(r|R)(y|Y))
FRAC_SECOND_SYM ((f|F)(r|R)(a|A)(c|C)_(s|S)(e|E)(c|C)(o|O)(n|N)(d|D))|((s|S)(q|Q)(l|L)_(t|T)(s|S)(i|I)_(f|F)(r|R)(a|A)(c|C)_(s|S)(e|E)(c|C)(o|O)(n|N)(d|D))
ALGORITHM_SYM ((a|A)(l|L)(g|G)(o|O)(r|R)(i|I)(t|T)(h|H)(m|M))
VALUES ((v|V)(a|A)(l|L)(u|U)(e|E)(s|S))
DECLARE_SYM ((d|D)(e|E)(c|C)(l|L)(a|A)(r|R)(e|E))
OR_SYM ((o|O)(r|R))
CLOSE_SYM ((c|C)(l|L)(o|O)(s|S)(e|E))
VALUE_SYM ((v|V)(a|A)(l|L)(u|U)(e|E))
EXTENDED_SYM ((e|E)(x|X)(t|T)(e|E)(n|N)(d|D)(e|E)(d|D))
FIELD_FUNC ((f|F)(i|I)(e|E)(l|L)(d|D))
FULL ((f|F)(u|U)(l|L)(l|L))
EXECUTE_SYM ((e|E)(x|X)(e|E)(c|C)(u|U)(t|T)(e|E))
PRIVILEGES ((p|P)(r|R)(i|I)(v|V)(i|I)(l|L)(e|E)(g|G)(e|E)(s|S))
UNIQUE_USERS ((u|U)(n|N)(i|I)(q|Q)(u|U)(e|E)_(u|U)(s|S)(e|E)(r|R)(s|S))
SQL_BUFFER_RESULT ((s|S)(q|Q)(l|L)_(b|B)(u|U)(f|F)(f|F)(e|E)(r|R)_(r|R)(e|E)(s|S)(u|U)(l|L)(t|T))
MIN_SYM ((m|M)(i|I)(n|N))
IDENTIFIED_SYM ((i|I)(d|D)(e|E)(n|N)(t|T)(i|I)(f|F)(i|I)(e|E)(d|D))
STD_SYM ((s|S)(t|T)(d|D))|((s|S)(t|T)(d|D)(d|D)(e|E)(v|V))|((s|S)(t|T)(d|D)(d|D)(e|E)(v|V)_(p|P)(o|O)(p|P))
BLOB_SYM ((b|B)(l|L)(o|O)(b|B))
ROUND ((r|R)(o|O)(u|U)(n|N)(d|D))
SQL_BIG_RESULT ((s|S)(q|Q)(l|L)_(b|B)(i|I)(g|G)_(r|R)(e|E)(s|S)(u|U)(l|L)(t|T))
CONTAINS_SYM ((c|C)(o|O)(n|N)(t|T)(a|A)(i|I)(n|N)(s|S))
NAMES_SYM ((n|N)(a|A)(m|M)(e|E)(s|S))
STARTING ((s|S)(t|T)(a|A)(r|R)(t|T)(i|I)(n|N)(g|G))
ENCRYPT ((e|E)(n|N)(c|C)(r|R)(y|Y)(p|P)(t|T))
REAL ((r|R)(e|E)(a|A)(l|L))
UNTIL_SYM ((u|U)(n|N)(t|T)(i|I)(l|L))
FROM ((f|F)(r|R)(o|O)(m|M))
BIT_AND ((b|B)(i|I)(t|T)_(a|A)(n|N)(d|D))
TRUE_SYM ((t|T)(r|R)(u|U)(e|E))
CONTINUE_SYM ((c|C)(o|O)(n|N)(t|T)(i|I)(n|N)(u|U)(e|E))
SUBSTRING ((m|M)(i|I)(d|D))|((s|S)(u|U)(b|B)(s|S)(t|T)(r|R))|((s|S)(u|U)(b|B)(s|S)(t|T)(r|R)(i|I)(n|N)(g|G))
GEOMETRYCOLLECTION ((g|G)(e|E)(o|O)(m|M)(e|E)(t|T)(r|R)(y|Y)(c|C)(o|O)(l|L)(l|L)(e|E)(c|C)(t|T)(i|I)(o|O)(n|N))
POINTFROMTEXT ((p|P)(o|O)(i|I)(n|N)(t|T)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))
LIKE ((l|L)(i|I)(k|K)(e|E))
MATCH ((m|M)(a|A)(t|T)(c|C)(h|H))
BYTE_SYM ((b|B)(y|Y)(t|T)(e|E))
DO_SYM ((d|D)(o|O))
UTC_TIMESTAMP_SYM ((u|U)(t|T)(c|C)_(t|T)(i|I)(m|M)(e|E)(s|S)(t|T)(a|A)(m|M)(p|P))
SMALLINT ((i|I)(n|N)(t|T)2)|((s|S)(m|M)(a|A)(l|L)(l|L)(i|I)(n|N)(t|T))
CALL_SYM ((c|C)(a|A)(l|L)(l|L))
SIMPLE_SYM ((s|S)(i|I)(m|M)(p|P)(l|L)(e|E))
IF ((i|I)(f|F))
UNIQUE_SYM ((u|U)(n|N)(i|I)(q|Q)(u|U)(e|E))
DEFAULT ((d|D)(e|E)(f|F)(a|A)(u|U)(l|L)(t|T))
CHECKSUM_SYM ((c|C)(h|H)(e|E)(c|C)(k|K)(s|S)(u|U)(m|M))
FUNCTION_SYM ((f|F)(u|U)(n|N)(c|C)(t|T)(i|I)(o|O)(n|N))
COLLATION_SYM ((c|C)(o|O)(l|L)(l|L)(a|A)(t|T)(i|I)(o|O)(n|N))
HIGH_PRIORITY ((h|H)(i|I)(g|G)(h|H)_(p|P)(r|R)(i|I)(o|O)(r|R)(i|I)(t|T)(y|Y))
MAX_UPDATES_PER_HOUR ((m|M)(a|A)(x|X)_(u|U)(p|P)(d|D)(a|A)(t|T)(e|E)(s|S)_(p|P)(e|E)(r|R)_(h|H)(o|O)(u|U)(r|R))
HANDLER_SYM ((h|H)(a|A)(n|N)(d|D)(l|L)(e|E)(r|R))
OPTION ((o|O)(p|P)(t|T)(i|I)(o|O)(n|N))
LIMIT ((l|L)(i|I)(m|M)(i|I)(t|T))
USE_SYM ((u|U)(s|S)(e|E))
BEGIN_SYM ((b|B)(e|E)(g|G)(i|I)(n|N))
DUMPFILE ((d|D)(u|U)(m|M)(p|P)(f|F)(i|I)(l|L)(e|E))
ENGINE_SYM ((e|E)(n|N)(g|G)(i|I)(n|N)(e|E))
OUT_SYM ((o|O)(u|U)(t|T))
EXPANSION_SYM ((e|E)(x|X)(p|P)(a|A)(n|N)(s|S)(i|I)(o|O)(n|N))
USAGE ((u|U)(s|S)(a|A)(g|G)(e|E))
INDEX_SYM ((i|I)(n|N)(d|D)(e|E)(x|X))
MLINEFROMTEXT ((m|M)(l|L)(i|I)(n|N)(e|E)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))|((m|M)(u|U)(l|L)(t|T)(i|I)(l|L)(i|I)(n|N)(e|E)(s|S)(t|T)(r|R)(i|I)(n|N)(g|G)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))
DES_DECRYPT_SYM ((d|D)(e|E)(s|S)_(d|D)(e|E)(c|C)(r|R)(y|Y)(p|P)(t|T))
SUBSTRING_INDEX ((s|S)(u|U)(b|B)(s|S)(t|T)(r|R)(i|I)(n|N)(g|G)_(i|I)(n|N)(d|D)(e|E)(x|X))
ELT_FUNC ((e|E)(l|L)(t|T))
MASTER_SERVER_ID_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(s|S)(e|E)(r|R)(v|V)(e|E)(r|R)_(i|I)(d|D))
GROUP_CONCAT_SYM ((g|G)(r|R)(o|O)(u|U)(p|P)_(c|C)(o|O)(n|N)(c|C)(a|A)(t|T))
CASCADED ((c|C)(a|A)(s|S)(c|C)(a|A)(d|D)(e|E)(d|D))
LOCAL_SYM ((l|L)(o|O)(c|C)(a|A)(l|L))
BOOL_SYM ((b|B)(o|O)(o|O)(l|L))
USE_FRM ((u|U)(s|S)(e|E)_(f|F)(r|R)(m|M))
BOTH ((b|B)(o|O)(t|T)(h|H))
MASTER_SSL_CIPHER_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(s|S)(s|S)(l|L)_(c|C)(i|I)(p|P)(h|H)(e|E)(r|R))
LABEL_SYM ((l|L)(a|A)(b|B)(e|E)(l|L))
MEDIUMTEXT ((m|M)(e|E)(d|D)(i|I)(u|U)(m|M)(t|T)(e|E)(x|X)(t|T))
MINUTE_SYM ((m|M)(i|I)(n|N)(u|U)(t|T)(e|E))|((s|S)(q|Q)(l|L)_(t|T)(s|S)(i|I)_(m|M)(i|I)(n|N)(u|U)(t|T)(e|E))
MUTEX_SYM ((m|M)(u|U)(t|T)(e|E)(x|X))
DISTINCT ((d|D)(i|I)(s|S)(t|T)(i|I)(n|N)(c|C)(t|T))|((d|D)(i|I)(s|S)(t|T)(i|I)(n|N)(c|C)(t|T)(r|R)(o|O)(w|W))
UTC_DATE_SYM ((u|U)(t|T)(c|C)_(d|D)(a|A)(t|T)(e|E))
CAST_SYM ((c|C)(a|A)(s|S)(t|T))
SAVEPOINT_SYM ((s|S)(a|A)(v|V)(e|E)(p|P)(o|O)(i|I)(n|N)(t|T))
INFILE ((i|I)(n|N)(f|F)(i|I)(l|L)(e|E))
CURTIME ((c|C)(u|U)(r|R)(r|R)(e|E)(n|N)(t|T)_(t|T)(i|I)(m|M)(e|E))|((c|C)(u|U)(r|R)(t|T)(i|I)(m|M)(e|E))
SECOND_MICROSECOND_SYM ((s|S)(e|E)(c|C)(o|O)(n|N)(d|D)_(m|M)(i|I)(c|C)(r|R)(o|O)(s|S)(e|E)(c|C)(o|O)(n|N)(d|D))
ADDDATE_SYM ((a|A)(d|D)(d|D)(d|D)(a|A)(t|T)(e|E))
CASE_SYM ((c|C)(a|A)(s|S)(e|E))
INT_SYM ((i|I)(n|N)(t|T))|((i|I)(n|N)(t|T)4)|((i|I)(n|N)(t|T)(e|E)(g|G)(e|E)(r|R))
GET_FORMAT ((g|G)(e|E)(t|T)_(f|F)(o|O)(r|R)(m|M)(a|A)(t|T))
RETURNS_SYM ((r|R)(e|E)(t|T)(u|U)(r|R)(n|N)(s|S))
RAID_STRIPED_SYM ((s|S)(t|T)(r|R)(i|I)(p|P)(e|E)(d|D))
BTREE_SYM ((b|B)(t|T)(r|R)(e|E)(e|E))
SQL_CACHE_SYM ((s|S)(q|Q)(l|L)_(c|C)(a|A)(c|C)(h|H)(e|E))
EXPORT_SET ((e|E)(x|X)(p|P)(o|O)(r|R)(t|T)_(s|S)(e|E)(t|T))
TRANSACTION_SYM ((t|T)(r|R)(a|A)(n|N)(s|S)(a|A)(c|C)(t|T)(i|I)(o|O)(n|N))
COMMENT_SYM ((c|C)(o|O)(m|M)(m|M)(e|E)(n|N)(t|T))
FIXED_SYM ((f|F)(i|I)(x|X)(e|E)(d|D))
TEMPTABLE_SYM ((t|T)(e|E)(m|M)(p|P)(t|T)(a|A)(b|B)(l|L)(e|E))
MAX_ROWS ((m|M)(a|A)(x|X)_(r|R)(o|O)(w|W)(s|S))
SUBDATE_SYM ((s|S)(u|U)(b|B)(d|D)(a|A)(t|T)(e|E))
COLUMNS ((c|C)(o|O)(l|L)(u|U)(m|M)(n|N)(s|S))|((f|F)(i|I)(e|E)(l|L)(d|D)(s|S))
RELAY_LOG_POS_SYM ((r|R)(e|E)(l|L)(a|A)(y|Y)_(l|L)(o|O)(g|G)_(p|P)(o|O)(s|S))
STDDEV_SAMP_SYM ((s|S)(t|T)(d|D)(d|D)(e|E)(v|V)_(s|S)(a|A)(m|M)(p|P))
OFFSET_SYM ((o|O)(f|F)(f|F)(s|S)(e|E)(t|T))
MASTER_PORT_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(p|P)(o|O)(r|R)(t|T))
MPOLYFROMTEXT ((m|M)(p|P)(o|O)(l|L)(y|Y)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))|((m|M)(u|U)(l|L)(t|T)(i|I)(p|P)(o|O)(l|L)(y|Y)(g|G)(o|O)(n|N)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))
QUARTER_SYM ((q|Q)(u|U)(a|A)(r|R)(t|T)(e|E)(r|R))|((s|S)(q|Q)(l|L)_(t|T)(s|S)(i|I)_(q|Q)(u|U)(a|A)(r|R)(t|T)(e|E)(r|R))
RAID_CHUNKS ((r|R)(a|A)(i|I)(d|D)_(c|C)(h|H)(u|U)(n|N)(k|K)(s|S))
RELEASE_SYM ((r|R)(e|E)(l|L)(e|E)(a|A)(s|S)(e|E))
DELETE_SYM ((d|D)(e|E)(l|L)(e|E)(t|T)(e|E))
SSL_SYM ((s|S)(s|S)(l|L))
LOG_SYM ((l|L)(o|O)(g|G))
ROLLBACK_SYM ((r|R)(o|O)(l|L)(l|L)(b|B)(a|A)(c|C)(k|K))
NDBCLUSTER_SYM ((n|N)(d|D)(b|B))|((n|N)(d|D)(b|B)(c|C)(l|L)(u|U)(s|S)(t|T)(e|E)(r|R))
WHERE ((w|W)(h|H)(e|E)(r|R)(e|E))
CREATE ((c|C)(r|R)(e|E)(a|A)(t|T)(e|E))
OLD_PASSWORD ((o|O)(l|L)(d|D)_(p|P)(a|A)(s|S)(s|S)(w|W)(o|O)(r|R)(d|D))
REPEAT_SYM ((r|R)(e|E)(p|P)(e|E)(a|A)(t|T))
MASTER_POS_WAIT ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(p|P)(o|O)(s|S)_(w|W)(a|A)(i|I)(t|T))
GOTO_SYM ((g|G)(o|O)(t|T)(o|O))
MEDIUM_SYM ((m|M)(e|E)(d|D)(i|I)(u|U)(m|M))
ROW_SYM ((r|R)(o|O)(w|W))
USING ((u|U)(s|S)(i|I)(n|N)(g|G))
LEADING ((l|L)(e|E)(a|A)(d|D)(i|I)(n|N)(g|G))
ROLLUP_SYM ((r|R)(o|O)(l|L)(l|L)(u|U)(p|P))
DETERMINISTIC_SYM ((d|D)(e|E)(t|T)(e|E)(r|R)(m|M)(i|I)(n|N)(i|I)(s|S)(t|T)(i|I)(c|C))
PACK_KEYS_SYM ((p|P)(a|A)(c|C)(k|K)_(k|K)(e|E)(y|Y)(s|S))
ONE_SYM ((o|O)(n|N)(e|E))
GREATEST_SYM ((g|G)(r|R)(e|E)(a|A)(t|T)(e|E)(s|S)(t|T))
COMMITTED_SYM ((c|C)(o|O)(m|M)(m|M)(i|I)(t|T)(t|T)(e|E)(d|D))
SOUNDS_SYM ((s|S)(o|O)(u|U)(n|N)(d|D)(s|S))
GEOMCOLLFROMTEXT ((g|G)(e|E)(o|O)(m|M)(c|C)(o|O)(l|L)(l|L)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))|((g|G)(e|E)(o|O)(m|M)(e|E)(t|T)(r|R)(y|Y)(c|C)(o|O)(l|L)(l|L)(e|E)(c|C)(t|T)(i|I)(o|O)(n|N)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))
OPTIONALLY ((o|O)(p|P)(t|T)(i|I)(o|O)(n|N)(a|A)(l|L)(l|L)(y|Y))
DATE_ADD_INTERVAL ((d|D)(a|A)(t|T)(e|E)_(a|A)(d|D)(d|D))
LOCKS_SYM ((l|L)(o|O)(c|C)(k|K)(s|S))
VARBINARY ((v|V)(a|A)(r|R)(b|B)(i|I)(n|N)(a|A)(r|R)(y|Y))
TRUNCATE_SYM ((t|T)(r|R)(u|U)(n|N)(c|C)(a|A)(t|T)(e|E))
LEAVE_SYM ((l|L)(e|E)(a|A)(v|V)(e|E))
VAR_SAMP_SYM ((v|V)(a|A)(r|R)_(s|S)(a|A)(m|M)(p|P))
GROUP ((g|G)(r|R)(o|O)(u|U)(p|P))
LINES ((l|L)(i|I)(n|N)(e|E)(s|S))
REPLICATION ((r|R)(e|E)(p|P)(l|L)(i|I)(c|C)(a|A)(t|T)(i|I)(o|O)(n|N))
FLUSH_SYM ((f|F)(l|L)(u|U)(s|S)(h|H))
INOUT_SYM ((i|I)(n|N)(o|O)(u|U)(t|T))
THEN_SYM ((t|T)(h|H)(e|E)(n|N))
MPOINTFROMTEXT ((m|M)(p|P)(o|O)(i|I)(n|N)(t|T)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))|((m|M)(u|U)(l|L)(t|T)(i|I)(p|P)(o|O)(i|I)(n|N)(t|T)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))
TEMPORARY ((t|T)(e|E)(m|M)(p|P)(o|O)(r|R)(a|A)(r|R)(y|Y))
OUTER ((o|O)(u|U)(t|T)(e|E)(r|R))
TABLE_SYM ((t|T)(a|A)(b|B)(l|L)(e|E))
ENUM ((e|E)(n|N)(u|U)(m|M))
DELAYED_SYM ((d|D)(e|E)(l|L)(a|A)(y|Y)(e|E)(d|D))
SHOW ((s|S)(h|H)(o|O)(w|W))
RAID_TYPE ((r|R)(a|A)(i|I)(d|D)_(t|T)(y|Y)(p|P)(e|E))
AUTO_INC ((a|A)(u|U)(t|T)(o|O)_(i|I)(n|N)(c|C)(r|R)(e|E)(m|M)(e|E)(n|N)(t|T))
USER ((u|U)(s|S)(e|E)(r|R))|((s|S)(e|E)(s|S)(s|S)(i|I)(o|O)(n|N)_(u|U)(s|S)(e|E)(r|R))|((s|S)(y|Y)(s|S)(t|T)(e|E)(m|M)_(u|U)(s|S)(e|E)(r|R))
MASTER_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R))
ESCAPE_SYM ((e|E)(s|S)(c|C)(a|A)(p|P)(e|E))
BERKELEY_DB_SYM ((b|B)(d|D)(b|B))|((b|B)(e|E)(r|R)(k|K)(e|E)(l|L)(e|E)(y|Y)(d|D)(b|B))
LAST_SYM ((l|L)(a|A)(s|S)(t|T))
HOUR_MICROSECOND_SYM ((h|H)(o|O)(u|U)(r|R)_(m|M)(i|I)(c|C)(r|R)(o|O)(s|S)(e|E)(c|C)(o|O)(n|N)(d|D))
GEOMFROMTEXT ((g|G)(e|E)(o|O)(m|M)(e|E)(t|T)(r|R)(y|Y)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))|((g|G)(e|E)(o|O)(m|M)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))
REDUNDANT_SYM ((r|R)(e|E)(d|D)(u|U)(n|N)(d|D)(a|A)(n|N)(t|T))
DES_ENCRYPT_SYM ((d|D)(e|E)(s|S)_(e|E)(n|N)(c|C)(r|R)(y|Y)(p|P)(t|T))
SQL_SMALL_RESULT ((s|S)(q|Q)(l|L)_(s|S)(m|M)(a|A)(l|L)(l|L)_(r|R)(e|E)(s|S)(u|U)(l|L)(t|T))
RELAY_THREAD ((i|I)(o|O)_(t|T)(h|H)(r|R)(e|E)(a|A)(d|D))|((r|R)(e|E)(l|L)(a|A)(y|Y)_(t|T)(h|H)(r|R)(e|E)(a|A)(d|D))
GROUP_UNIQUE_USERS ((g|G)(r|R)(o|O)(u|U)(p|P)_(u|U)(n|N)(i|I)(q|Q)(u|U)(e|E)_(u|U)(s|S)(e|E)(r|R)(s|S))
REVOKE ((r|R)(e|E)(v|V)(o|O)(k|K)(e|E))
ROW_COUNT_SYM ((r|R)(o|O)(w|W)_(c|C)(o|O)(u|U)(n|N)(t|T))
MULTILINESTRING ((m|M)(u|U)(l|L)(t|T)(i|I)(l|L)(i|I)(n|N)(e|E)(s|S)(t|T)(r|R)(i|I)(n|N)(g|G))
MASTER_SSL_CERT_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(s|S)(s|S)(l|L)_(c|C)(e|E)(r|R)(t|T))
NAME_SYM ((n|N)(a|A)(m|M)(e|E))
EXISTS ((e|E)(x|X)(i|I)(s|S)(t|T)(s|S))
END ((e|E)(n|N)(d|D))
DOUBLE_SYM ((d|D)(o|O)(u|U)(b|B)(l|L)(e|E))|((f|F)(l|L)(o|O)(a|A)(t|T)8)
MASTER_CONNECT_RETRY_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(c|C)(o|O)(n|N)(n|N)(e|E)(c|C)(t|T)_(r|R)(e|E)(t|T)(r|R)(y|Y))
NATURAL ((n|N)(a|A)(t|T)(u|U)(r|R)(a|A)(l|L))
CONNECTION_SYM ((c|C)(o|O)(n|N)(n|N)(e|E)(c|C)(t|T)(i|I)(o|O)(n|N))
ESCAPED ((e|E)(s|S)(c|C)(a|A)(p|P)(e|E)(d|D))
BIT_SYM ((b|B)(i|I)(t|T))
BIT_OR ((b|B)(i|I)(t|T)_(o|O)(r|R))
FULLTEXT_SYM ((f|F)(u|U)(l|L)(l|L)(t|T)(e|E)(x|X)(t|T))
MICROSECOND_SYM ((m|M)(i|I)(c|C)(r|R)(o|O)(s|S)(e|E)(c|C)(o|O)(n|N)(d|D))
YEAR_SYM ((s|S)(q|Q)(l|L)_(t|T)(s|S)(i|I)_(y|Y)(e|E)(a|A)(r|R))|((y|Y)(e|E)(a|A)(r|R))
TERMINATED ((t|T)(e|E)(r|R)(m|M)(i|I)(n|N)(a|A)(t|T)(e|E)(d|D))
AGGREGATE_SYM ((a|A)(g|G)(g|G)(r|R)(e|E)(g|G)(a|A)(t|T)(e|E))
LEAVES ((l|L)(e|E)(a|A)(v|V)(e|E)(s|S))
RELOAD ((r|R)(e|E)(l|L)(o|O)(a|A)(d|D))
ON ((o|O)(n|N))
TINYBLOB ((t|T)(i|I)(n|N)(y|Y)(b|B)(l|L)(o|O)(b|B))
BEFORE_SYM ((b|B)(e|E)(f|F)(o|O)(r|R)(e|E))
AND_SYM ((a|A)(n|N)(d|D))
MAX_CONNECTIONS_PER_HOUR ((m|M)(a|A)(x|X)_(c|C)(o|O)(n|N)(n|N)(e|E)(c|C)(t|T)(i|I)(o|O)(n|N)(s|S)_(p|P)(e|E)(r|R)_(h|H)(o|O)(u|U)(r|R))
SQLWARNING_SYM ((s|S)(q|Q)(l|L)(w|W)(a|A)(r|R)(n|N)(i|I)(n|N)(g|G))
COUNT_SYM ((c|C)(o|O)(u|U)(n|N)(t|T))
CHANGE ((c|C)(h|H)(a|A)(n|N)(g|G)(e|E))
LOOP_SYM ((l|L)(o|O)(o|O)(p|P))
MASTER_LOG_POS_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(l|L)(o|O)(g|G)_(p|P)(o|O)(s|S))
RETURN_SYM ((r|R)(e|E)(t|T)(u|U)(r|R)(n|N))
DESC ((d|D)(e|E)(s|S)(c|C))
MASTER_SSL_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(s|S)(s|S)(l|L))
NATIONAL_SYM ((n|N)(a|A)(t|T)(i|I)(o|O)(n|N)(a|A)(l|L))
TRIM ((t|T)(r|R)(i|I)(m|M))
UNSIGNED ((u|U)(n|N)(s|S)(i|I)(g|G)(n|N)(e|E)(d|D))
FOR_SYM ((f|F)(o|O)(r|R))
SESSION_SYM ((s|S)(e|E)(s|S)(s|S)(i|I)(o|O)(n|N))
ENGINES_SYM ((e|E)(n|N)(g|G)(i|I)(n|N)(e|E)(s|S))
FIRST_SYM ((f|F)(i|I)(r|R)(s|S)(t|T))
MAX_USER_CONNECTIONS_SYM ((m|M)(a|A)(x|X)_(u|U)(s|S)(e|E)(r|R)_(c|C)(o|O)(n|N)(n|N)(e|E)(c|C)(t|T)(i|I)(o|O)(n|N)(s|S))
SUBJECT_SYM ((s|S)(u|U)(b|B)(j|J)(e|E)(c|C)(t|T))
SHARE_SYM ((s|S)(h|H)(a|A)(r|R)(e|E))
RELAY_LOG_FILE_SYM ((r|R)(e|E)(l|L)(a|A)(y|Y)_(l|L)(o|O)(g|G)_(f|F)(i|I)(l|L)(e|E))
SQLEXCEPTION_SYM ((s|S)(q|Q)(l|L)(e|E)(x|X)(c|C)(e|E)(p|P)(t|T)(i|I)(o|O)(n|N))
OPTIMIZE ((o|O)(p|P)(t|T)(i|I)(m|M)(i|I)(z|Z)(e|E))
NO_SYM ((n|N)(o|O))
DAY_HOUR_SYM ((d|D)(a|A)(y|Y)_(h|H)(o|O)(u|U)(r|R))
LINESTRING ((l|L)(i|I)(n|N)(e|E)(s|S)(t|T)(r|R)(i|I)(n|N)(g|G))
COMMIT_SYM ((c|C)(o|O)(m|M)(m|M)(i|I)(t|T))
CONCURRENT ((c|C)(o|O)(n|N)(c|C)(u|U)(r|R)(r|R)(e|E)(n|N)(t|T))
PROCESS ((p|P)(r|R)(o|O)(c|C)(e|E)(s|S)(s|S))
ALTER ((a|A)(l|L)(t|T)(e|E)(r|R))
MAX_QUERIES_PER_HOUR ((m|M)(a|A)(x|X)_(q|Q)(u|U)(e|E)(r|R)(i|I)(e|E)(s|S)_(p|P)(e|E)(r|R)_(h|H)(o|O)(u|U)(r|R))
ELSE ((e|E)(l|L)(s|S)(e|E))
DAY_MINUTE_SYM ((d|D)(a|A)(y|Y)_(m|M)(i|I)(n|N)(u|U)(t|T)(e|E))
SECOND_SYM ((s|S)(e|E)(c|C)(o|O)(n|N)(d|D))|((s|S)(q|Q)(l|L)_(t|T)(s|S)(i|I)_(s|S)(e|E)(c|C)(o|O)(n|N)(d|D))
INNOBASE_SYM ((i|I)(n|N)(n|N)(o|O)(b|B)(a|A)(s|S)(e|E))|((i|I)(n|N)(n|N)(o|O)(d|D)(b|B))
DIV_SYM ((d|D)(i|I)(v|V))
BIGINT ((b|B)(i|I)(g|G)(i|I)(n|N)(t|T))|((i|I)(n|N)(t|T)8)
FETCH_SYM ((f|F)(e|E)(t|T)(c|C)(h|H))
READ_SYM ((r|R)(e|E)(a|A)(d|D))
SQL_NO_CACHE_SYM ((s|S)(q|Q)(l|L)_(n|N)(o|O)_(c|C)(a|A)(c|C)(h|H)(e|E))
HAVING ((h|H)(a|A)(v|V)(i|I)(n|N)(g|G))
NULL_SYM ((n|N)(u|U)(l|L)(l|L))
SPATIAL_SYM ((s|S)(p|P)(a|A)(t|T)(i|I)(a|A)(l|L))
ADD ((a|A)(d|D)(d|D))
XA_SYM ((x|X)(a|A))
GRANT ((g|G)(r|R)(a|A)(n|N)(t|T))
KEYS ((k|K)(e|E)(y|Y)(s|S))
NCHAR_SYM ((n|N)(c|C)(h|H)(a|A)(r|R))
INSENSITIVE_SYM ((i|I)(n|N)(s|S)(e|E)(n|N)(s|S)(i|I)(t|T)(i|I)(v|V)(e|E))
LONGTEXT ((l|L)(o|O)(n|N)(g|G)(t|T)(e|E)(x|X)(t|T))
DATABASE ((d|D)(a|A)(t|T)(a|A)(b|B)(a|A)(s|S)(e|E))|((s|S)(c|C)(h|H)(e|E)(m|M)(a|A))
AFTER_SYM ((a|A)(f|F)(t|T)(e|E)(r|R))
FORMAT_SYM ((f|F)(o|O)(r|R)(m|M)(a|A)(t|T))
TABLES ((t|T)(a|A)(b|B)(l|L)(e|E)(s|S))
FAST_SYM ((f|F)(a|A)(s|S)(t|T))
LOAD ((l|L)(o|O)(a|A)(d|D))
RESTRICT ((r|R)(e|E)(s|S)(t|T)(r|R)(i|I)(c|C)(t|T))
MAX_SYM ((m|M)(a|A)(x|X))
PROCEDURE ((p|P)(r|R)(o|O)(c|C)(e|E)(d|D)(u|U)(r|R)(e|E))
NEW_SYM ((n|N)(e|E)(w|W))
SQL_CALC_FOUND_ROWS ((s|S)(q|Q)(l|L)_(c|C)(a|A)(l|L)(c|C)_(f|F)(o|O)(u|U)(n|N)(d|D)_(r|R)(o|O)(w|W)(s|S))
COALESCE ((c|C)(o|O)(a|A)(l|L)(e|E)(s|S)(c|C)(e|E))
FOUND_SYM ((f|F)(o|O)(u|U)(n|N)(d|D))
MIN_ROWS ((m|M)(i|I)(n|N)_(r|R)(o|O)(w|W)(s|S))
TIMESTAMP ((t|T)(i|I)(m|M)(e|E)(s|S)(t|T)(a|A)(m|M)(p|P))
BY ((b|B)(y|Y))
LINEFROMTEXT ((l|L)(i|I)(n|N)(e|E)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))|((l|L)(i|I)(n|N)(e|E)(s|S)(t|T)(r|R)(i|I)(n|N)(g|G)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))
UNION_SYM ((u|U)(n|N)(i|I)(o|O)(n|N))
STATUS_SYM ((s|S)(t|T)(a|A)(t|T)(u|U)(s|S))
EVENTS_SYM ((e|E)(v|V)(e|E)(n|N)(t|T)(s|S))
DESCRIBE ((d|D)(e|E)(s|S)(c|C)(r|R)(i|I)(b|B)(e|E))|((e|E)(x|X)(p|P)(l|L)(a|A)(i|I)(n|N))
SUSPEND_SYM ((s|S)(u|U)(s|S)(p|P)(e|E)(n|N)(d|D))
AVG_ROW_LENGTH ((a|A)(v|V)(g|G)_(r|R)(o|O)(w|W)_(l|L)(e|E)(n|N)(g|G)(t|T)(h|H))
ATAN ((a|A)(t|T)(a|A)(n|N))|((a|A)(t|T)(a|A)(n|N)2)
FLOAT_SYM ((f|F)(l|L)(o|O)(a|A)(t|T))|((f|F)(l|L)(o|O)(a|A)(t|T)4)
TRAILING ((t|T)(r|R)(a|A)(i|I)(l|L)(i|I)(n|N)(g|G))
TIMESTAMP_DIFF ((t|T)(i|I)(m|M)(e|E)(s|S)(t|T)(a|A)(m|M)(p|P)(d|D)(i|I)(f|F)(f|F))
STRAIGHT_JOIN ((s|S)(t|T)(r|R)(a|A)(i|I)(g|G)(h|H)(t|T)_(j|J)(o|O)(i|I)(n|N))
MEDIUMINT ((i|I)(n|N)(t|T)3)|((m|M)(e|E)(d|D)(i|I)(u|U)(m|M)(i|I)(n|N)(t|T))|((m|M)(i|I)(d|D)(d|D)(l|L)(e|E)(i|I)(n|N)(t|T))
VIEW_SYM ((v|V)(i|I)(e|E)(w|W))
EACH_SYM ((e|E)(a|A)(c|C)(h|H))
LEAST_SYM ((l|L)(e|E)(a|A)(s|S)(t|T))
COLLATE_SYM ((c|C)(o|O)(l|L)(l|L)(a|A)(t|T)(e|E))
COMPACT_SYM ((c|C)(o|O)(m|M)(p|P)(a|A)(c|C)(t|T))
CURDATE ((c|C)(u|U)(r|R)(r|R)(e|E)(n|N)(t|T)_(d|D)(a|A)(t|T)(e|E))|((c|C)(u|U)(r|R)(d|D)(a|A)(t|T)(e|E))
DAY_MICROSECOND_SYM ((d|D)(a|A)(y|Y)_(m|M)(i|I)(c|C)(r|R)(o|O)(s|S)(e|E)(c|C)(o|O)(n|N)(d|D))
MASTER_SSL_CAPATH_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(s|S)(s|S)(l|L)_(c|C)(a|A)(p|P)(a|A)(t|T)(h|H))
SENSITIVE_SYM ((s|S)(e|E)(n|N)(s|S)(i|I)(t|T)(i|I)(v|V)(e|E))
POINT_SYM ((p|P)(o|O)(i|I)(n|N)(t|T))
DELAY_KEY_WRITE_SYM ((d|D)(e|E)(l|L)(a|A)(y|Y)_(k|K)(e|E)(y|Y)_(w|W)(r|R)(i|I)(t|T)(e|E))
MIGRATE_SYM ((m|M)(i|I)(g|G)(r|R)(a|A)(t|T)(e|E))
UDF_SONAME_SYM ((s|S)(o|O)(n|N)(a|A)(m|M)(e|E))
STRING_SYM ((s|S)(t|T)(r|R)(i|I)(n|N)(g|G))
PRECISION ((p|P)(r|R)(e|E)(c|C)(i|I)(s|S)(i|I)(o|O)(n|N))
RTREE_SYM ((r|R)(t|T)(r|R)(e|E)(e|E))
WITH ((w|W)(i|I)(t|T)(h|H))
RAND ((r|R)(a|A)(n|N)(d|D))
DROP ((d|D)(r|R)(o|O)(p|P))
PARTIAL ((p|P)(a|A)(r|R)(t|T)(i|I)(a|A)(l|L))
MEDIUMBLOB ((m|M)(e|E)(d|D)(i|I)(u|U)(m|M)(b|B)(l|L)(o|O)(b|B))
WHILE_SYM ((w|W)(h|H)(i|I)(l|L)(e|E))
GRANTS ((g|G)(r|R)(a|A)(n|N)(t|T)(s|S))
NOT_SYM ((n|N)(o|O)(t|T))
INVOKER_SYM ((i|I)(n|N)(v|V)(o|O)(k|K)(e|E)(r|R))
MULTIPOINT ((m|M)(u|U)(l|L)(t|T)(i|I)(p|P)(o|O)(i|I)(n|N)(t|T))
SLAVE ((s|S)(l|L)(a|A)(v|V)(e|E))
GLOBAL_SYM ((g|G)(l|L)(o|O)(b|B)(a|A)(l|L))
VARIANCE_SYM ((v|V)(a|A)(r|R)(i|I)(a|A)(n|N)(c|C)(e|E))|((v|V)(a|A)(r|R)_(p|P)(o|O)(p|P))
POSITION_SYM ((p|P)(o|O)(s|S)(i|I)(t|T)(i|I)(o|O)(n|N))
KEY_SYM ((k|K)(e|E)(y|Y))
CHARSET ((c|C)(h|H)(a|A)(r|R)(s|S)(e|E)(t|T))
ROW_FORMAT_SYM ((r|R)(o|O)(w|W)_(f|F)(o|O)(r|R)(m|M)(a|A)(t|T))
AS ((a|A)(s|S))
MODIFIES_SYM ((m|M)(o|O)(d|D)(i|I)(f|F)(i|I)(e|E)(s|S))
KILL_SYM ((k|K)(i|I)(l|L)(l|L))
LOGS_SYM ((l|L)(o|O)(g|G)(s|S))
CHAIN_SYM ((c|C)(h|H)(a|A)(i|I)(n|N))
QUICK ((q|Q)(u|U)(i|I)(c|C)(k|K))
HOUR_MINUTE_SYM ((h|H)(o|O)(u|U)(r|R)_(m|M)(i|I)(n|N)(u|U)(t|T)(e|E))
ZEROFILL ((z|Z)(e|E)(r|R)(o|O)(f|F)(i|I)(l|L)(l|L))
FOREIGN ((f|F)(o|O)(r|R)(e|E)(i|I)(g|G)(n|N))
CONDITION_SYM ((c|C)(o|O)(n|N)(d|D)(i|I)(t|T)(i|I)(o|O)(n|N))
VARIABLES ((v|V)(a|A)(r|R)(i|I)(a|A)(b|B)(l|L)(e|E)(s|S))
INDEXES ((i|I)(n|N)(d|D)(e|E)(x|X)(e|E)(s|S))
DATE_SUB_INTERVAL ((d|D)(a|A)(t|T)(e|E)_(s|S)(u|U)(b|B))
CHANGED ((c|C)(h|H)(a|A)(n|N)(g|G)(e|E)(d|D))
UNICODE_SYM ((u|U)(n|N)(i|I)(c|C)(o|O)(d|D)(e|E))
NEXT_SYM ((n|N)(e|E)(x|X)(t|T))
RIGHT ((r|R)(i|I)(g|G)(h|H)(t|T))
DAY_SYM ((d|D)(a|A)(y|Y))|((s|S)(q|Q)(l|L)_(t|T)(s|S)(i|I)_(d|D)(a|A)(y|Y))
CONCAT ((c|C)(o|O)(n|N)(c|C)(a|A)(t|T))
DATETIME ((d|D)(a|A)(t|T)(e|E)(t|T)(i|I)(m|M)(e|E))
RAID_CHUNKSIZE ((r|R)(a|A)(i|I)(d|D)_(c|C)(h|H)(u|U)(n|N)(k|K)(s|S)(i|I)(z|Z)(e|E))
CACHE_SYM ((c|C)(a|A)(c|C)(h|H)(e|E))
STORAGE_SYM ((s|S)(t|T)(o|O)(r|R)(a|A)(g|G)(e|E))
AGAINST ((a|A)(g|G)(a|A)(i|I)(n|N)(s|S)(t|T))
NONE_SYM ((n|N)(o|O)(n|N)(e|E))
LEVEL_SYM ((l|L)(e|E)(v|V)(e|E)(l|L))
MULTIPOLYGON ((m|M)(u|U)(l|L)(t|T)(i|I)(p|P)(o|O)(l|L)(y|Y)(g|G)(o|O)(n|N))
RECOVER_SYM ((r|R)(e|E)(c|C)(o|O)(v|V)(e|E)(r|R))
MINUTE_SECOND_SYM ((m|M)(i|I)(n|N)(u|U)(t|T)(e|E)_(s|S)(e|E)(c|C)(o|O)(n|N)(d|D))
YEAR_MONTH_SYM ((y|Y)(e|E)(a|A)(r|R)_(m|M)(o|O)(n|N)(t|T)(h|H))
ASCII_SYM ((a|A)(s|S)(c|C)(i|I)(i|I))
POLYGON ((p|P)(o|O)(l|L)(y|Y)(g|G)(o|O)(n|N))
TEXT_SYM ((t|T)(e|E)(x|X)(t|T))
EXIT_SYM ((e|E)(x|X)(i|I)(t|T))
ROUTINE_SYM ((r|R)(o|O)(u|U)(t|T)(i|I)(n|N)(e|E))
TRIGGER_SYM ((t|T)(r|R)(i|I)(g|G)(g|G)(e|E)(r|R))
CASCADE ((c|C)(a|A)(s|S)(c|C)(a|A)(d|D)(e|E))
SQLSTATE_SYM ((s|S)(q|Q)(l|L)(s|S)(t|T)(a|A)(t|T)(e|E))
BOOLEAN_SYM ((b|B)(o|O)(o|O)(l|L)(e|E)(a|A)(n|N))
LONG_SYM ((l|L)(o|O)(n|N)(g|G))
REPAIR ((r|R)(e|E)(p|P)(a|A)(i|I)(r|R))
FALSE_SYM ((f|F)(a|A)(l|L)(s|S)(e|E))
MAKE_SET_SYM ((m|M)(a|A)(k|K)(e|E)_(s|S)(e|E)(t|T))
VARCHAR ((v|V)(a|A)(r|R)(c|C)(h|H)(a|A)(r|R))|((v|V)(a|A)(r|R)(c|C)(h|H)(a|A)(r|R)(a|A)(c|C)(t|T)(e|E)(r|R))
HASH_SYM ((h|H)(a|A)(s|S)(h|H))
IGNORE_SYM ((i|I)(g|G)(n|N)(o|O)(r|R)(e|E))
SQL_THREAD ((s|S)(q|Q)(l|L)_(t|T)(h|H)(r|R)(e|E)(a|A)(d|D))
CURRENT_USER ((c|C)(u|U)(r|R)(r|R)(e|E)(n|N)(t|T)_(u|U)(s|S)(e|E)(r|R))
MODE_SYM ((m|M)(o|O)(d|D)(e|E))
ISSUER_SYM ((i|I)(s|S)(s|S)(u|U)(e|E)(r|R))
UNCOMMITTED_SYM ((u|U)(n|N)(c|C)(o|O)(m|M)(m|M)(i|I)(t|T)(t|T)(e|E)(d|D))
CIPHER_SYM ((c|C)(i|I)(p|P)(h|H)(e|E)(r|R))
REFERENCES ((r|R)(e|E)(f|F)(e|E)(r|R)(e|E)(n|N)(c|C)(e|E)(s|S))
ELSEIF_SYM ((e|E)(l|L)(s|S)(e|E)(i|I)(f|F))
SIGNED_SYM ((s|S)(i|I)(g|G)(n|N)(e|E)(d|D))
TYPE_SYM ((t|T)(y|Y)(p|P)(e|E))
ALL ((a|A)(l|L)(l|L))
DYNAMIC_SYM ((d|D)(y|Y)(n|N)(a|A)(m|M)(i|I)(c|C))
CURSOR_SYM ((c|C)(u|U)(r|R)(s|S)(o|O)(r|R))
INSERT ((i|I)(n|N)(s|S)(e|E)(r|R)(t|T))
DISABLE_SYM ((d|D)(i|I)(s|S)(a|A)(b|B)(l|L)(e|E))
VARYING ((v|V)(a|A)(r|R)(y|Y)(i|I)(n|N)(g|G))
UTC_TIME_SYM ((u|U)(t|T)(c|C)_(t|T)(i|I)(m|M)(e|E))
BINLOG_SYM ((b|B)(i|I)(n|N)(l|L)(o|O)(g|G))
BENCHMARK_SYM ((b|B)(e|E)(n|N)(c|C)(h|H)(m|M)(a|A)(r|R)(k|K))
PHASE_SYM ((p|P)(h|H)(a|A)(s|S)(e|E))
SUPER_SYM ((s|S)(u|U)(p|P)(e|E)(r|R))
TINYTEXT ((t|T)(i|I)(n|N)(y|Y)(t|T)(e|E)(x|X)(t|T))
DAY_SECOND_SYM ((d|D)(a|A)(y|Y)_(s|S)(e|E)(c|C)(o|O)(n|N)(d|D))
UNLOCK_SYM ((u|U)(n|N)(l|L)(o|O)(c|C)(k|K))
SEPARATOR_SYM ((s|S)(e|E)(p|P)(a|A)(r|R)(a|A)(t|T)(o|O)(r|R))
TYPES_SYM ((t|T)(y|Y)(p|P)(e|E)(s|S))
LAST_INSERT_ID ((l|L)(a|A)(s|S)(t|T)_(i|I)(n|N)(s|S)(e|E)(r|R)(t|T)_(i|I)(d|D))
GEOMFROMWKB ((g|G)(e|E)(o|O)(m|M)(c|C)(o|O)(l|L)(l|L)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((g|G)(e|E)(o|O)(m|M)(e|E)(t|T)(r|R)(y|Y)(c|C)(o|O)(l|L)(l|L)(e|E)(c|C)(t|T)(i|I)(o|O)(n|N)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((g|G)(e|E)(o|O)(m|M)(e|E)(t|T)(r|R)(y|Y)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((g|G)(e|E)(o|O)(m|M)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((l|L)(i|I)(n|N)(e|E)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((l|L)(i|I)(n|N)(e|E)(s|S)(t|T)(r|R)(i|I)(n|N)(g|G)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((m|M)(l|L)(i|I)(n|N)(e|E)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((m|M)(p|P)(o|O)(i|I)(n|N)(t|T)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((m|M)(p|P)(o|O)(l|L)(y|Y)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((m|M)(u|U)(l|L)(t|T)(i|I)(l|L)(i|I)(n|N)(e|E)(s|S)(t|T)(r|R)(i|I)(n|N)(g|G)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((m|M)(u|U)(l|L)(t|T)(i|I)(p|P)(o|O)(i|I)(n|N)(t|T)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((m|M)(u|U)(l|L)(t|T)(i|I)(p|P)(o|O)(l|L)(y|Y)(g|G)(o|O)(n|N)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((p|P)(o|O)(i|I)(n|N)(t|T)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((p|P)(o|O)(l|L)(y|Y)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))|((p|P)(o|O)(l|L)(y|Y)(g|G)(o|O)(n|N)(f|F)(r|R)(o|O)(m|M)(w|W)(k|K)(b|B))
DATABASES ((d|D)(a|A)(t|T)(a|A)(b|B)(a|A)(s|S)(e|E)(s|S))|((s|S)(c|C)(h|H)(e|E)(m|M)(a|A)(s|S))
DATA_SYM ((d|D)(a|A)(t|T)(a|A))
MINUTE_MICROSECOND_SYM ((m|M)(i|I)(n|N)(u|U)(t|T)(e|E)_(m|M)(i|I)(c|C)(r|R)(o|O)(s|S)(e|E)(c|C)(o|O)(n|N)(d|D))
TABLESPACE ((t|T)(a|A)(b|B)(l|L)(e|E)(s|S)(p|P)(a|A)(c|C)(e|E))
ANY_SYM ((a|A)(n|N)(y|Y))|((s|S)(o|O)(m|M)(e|E))
RESOURCES ((u|U)(s|S)(e|E)(r|R)_(r|R)(e|E)(s|S)(o|O)(u|U)(r|R)(c|C)(e|E)(s|S))
TRIGGERS_SYM ((t|T)(r|R)(i|I)(g|G)(g|G)(e|E)(r|R)(s|S))
CUBE_SYM ((c|C)(u|U)(b|B)(e|E))
MOD_SYM ((m|M)(o|O)(d|D))
COLUMN_SYM ((c|C)(o|O)(l|L)(u|U)(m|M)(n|N))
RAID_0_SYM ((r|R)(a|A)(i|I)(d|D)0)
REQUIRE_SYM ((r|R)(e|E)(q|Q)(u|U)(i|I)(r|R)(e|E))
UNIX_TIMESTAMP ((u|U)(n|N)(i|I)(x|X)_(t|T)(i|I)(m|M)(e|E)(s|S)(t|T)(a|A)(m|M)(p|P))
TIME_SYM ((t|T)(i|I)(m|M)(e|E))
ENCLOSED ((e|E)(n|N)(c|C)(l|L)(o|O)(s|S)(e|E)(d|D))
DES_KEY_FILE ((d|D)(e|E)(s|S)_(k|K)(e|E)(y|Y)_(f|F)(i|I)(l|L)(e|E))
WRITE_SYM ((w|W)(r|R)(i|I)(t|T)(e|E))
NOW_SYM ((c|C)(u|U)(r|R)(r|R)(e|E)(n|N)(t|T)_(t|T)(i|I)(m|M)(e|E)(s|S)(t|T)(a|A)(m|M)(p|P))|((l|L)(o|O)(c|C)(a|A)(l|L)(t|T)(i|I)(m|M)(e|E))|((l|L)(o|O)(c|C)(a|A)(l|L)(t|T)(i|I)(m|M)(e|E)(s|S)(t|T)(a|A)(m|M)(p|P))|((n|N)(o|O)(w|W))
CONSISTENT_SYM ((c|C)(o|O)(n|N)(s|S)(i|I)(s|S)(t|T)(e|E)(n|N)(t|T))
LEFT ((l|L)(e|E)(f|F)(t|T))
DECODE_SYM ((d|D)(e|E)(c|C)(o|O)(d|D)(e|E))
MERGE_SYM ((m|M)(e|E)(r|R)(g|G)(e|E))
PURGE ((p|P)(u|U)(r|R)(g|G)(e|E))
MASTER_USER_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(u|U)(s|S)(e|E)(r|R))
MASTER_SSL_CA_SYM ((m|M)(a|A)(s|S)(t|T)(e|E)(r|R)_(s|S)(s|S)(l|L)_(c|C)(a|A))
CHAR_SYM ((c|C)(h|H)(a|A)(r|R))|((c|C)(h|H)(a|A)(r|R)(a|A)(c|C)(t|T)(e|E)(r|R))
SYSDATE ((s|S)(y|Y)(s|S)(d|D)(a|A)(t|T)(e|E))
WORK_SYM ((w|W)(o|O)(r|R)(k|K))
LOCK_SYM ((l|L)(o|O)(c|C)(k|K))
CONVERT_TZ_SYM ((c|C)(o|O)(n|N)(v|V)(e|E)(r|R)(t|T)_(t|T)(z|Z))
ISOLATION ((i|I)(s|S)(o|O)(l|L)(a|A)(t|T)(i|I)(o|O)(n|N))
JOIN_SYM ((j|J)(o|O)(i|I)(n|N))
UNKNOWN_SYM ((u|U)(n|N)(k|K)(n|N)(o|O)(w|W)(n|N))
IS ((i|I)(s|S))
ORDER_SYM ((o|O)(r|R)(d|D)(e|E)(r|R))
DATE_SYM ((d|D)(a|A)(t|T)(e|E))
LOW_PRIORITY ((l|L)(o|O)(w|W)_(p|P)(r|R)(i|I)(o|O)(r|R)(i|I)(t|T)(y|Y))
REPLACE ((r|R)(e|E)(p|P)(l|L)(a|A)(c|C)(e|E))
SERIAL_SYM ((s|S)(e|E)(r|R)(i|I)(a|A)(l|L))
SHUTDOWN ((s|S)(h|H)(u|U)(t|T)(d|D)(o|O)(w|W)(n|N))
ACTION ((a|A)(c|C)(t|T)(i|I)(o|O)(n|N))
ASC ((a|A)(s|S)(c|C))
LANGUAGE_SYM ((l|L)(a|A)(n|N)(g|G)(u|U)(a|A)(g|G)(e|E))
ENABLE_SYM ((e|E)(n|N)(a|A)(b|B)(l|L)(e|E))
FILE_SYM ((f|F)(i|I)(l|L)(e|E))
SNAPSHOT_SYM ((s|S)(n|N)(a|A)(p|P)(s|S)(h|H)(o|O)(t|T))
ASENSITIVE_SYM ((a|A)(s|S)(e|E)(n|N)(s|S)(i|I)(t|T)(i|I)(v|V)(e|E))
START_SYM ((s|S)(t|T)(a|A)(r|R)(t|T))
PASSWORD ((p|P)(a|A)(s|S)(s|S)(w|W)(o|O)(r|R)(d|D))
RESUME_SYM ((r|R)(e|E)(s|S)(u|U)(m|M)(e|E))
POLYFROMTEXT ((p|P)(o|O)(l|L)(y|Y)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))|((p|P)(o|O)(l|L)(y|Y)(g|G)(o|O)(n|N)(f|F)(r|R)(o|O)(m|M)(t|T)(e|E)(x|X)(t|T))
CROSS ((c|C)(r|R)(o|O)(s|S)(s|S))
SECURITY_SYM ((s|S)(e|E)(c|C)(u|U)(r|R)(i|I)(t|T)(y|Y))
STOP_SYM ((s|S)(t|T)(o|O)(p|P))
HOUR_SECOND_SYM ((h|H)(o|O)(u|U)(r|R)_(s|S)(e|E)(c|C)(o|O)(n|N)(d|D))
SQL_SYM ((s|S)(q|Q)(l|L))
ENCODE_SYM ((e|E)(n|N)(c|C)(o|O)(d|D)(e|E))
MODIFY_SYM ((m|M)(o|O)(d|D)(i|I)(f|F)(y|Y))
RESET_SYM ((r|R)(e|E)(s|S)(e|E)(t|T))
SELECT_SYM ((s|S)(e|E)(l|L)(e|E)(c|C)(t|T))
WARNINGS ((w|W)(a|A)(r|R)(n|N)(i|I)(n|N)(g|G)(s|S))
DUAL_SYM ((d|D)(u|U)(a|A)(l|L))
IN_SYM ((i|I)(n|N))
PREV_SYM ((p|P)(r|R)(e|E)(v|V)) 

IDENT [0-9]*[A-Za-z\_\$]+[A-Za-z\_\$0-9]*
DIGIT [0-9]+
HEXDIGIT ([0-9][A-F][a-f])+
BINDIGIT [0-1]+

%%

{DISCARD}				{ /*DISCARD*/ *yylval= yytext; return yy_token_match(DISCARD, yytext); }
{INTO}				{ /*INTO*/ *yylval= yytext; return yy_token_match(INTO, yytext); }
{FROM_UNIXTIME}				{ /*FROM_UNIXTIME*/ *yylval= yytext; return yy_token_match(FROM_UNIXTIME, yytext); }
{BIT_XOR}				{ /*BIT_XOR*/ *yylval= yytext; return yy_token_match(BIT_XOR, yytext); }
{COMPRESSED_SYM}				{ /*COMPRESSED_SYM*/ *yylval= yytext; return yy_token_match(COMPRESSED_SYM, yytext); }
{MONTH_SYM}				{ /*MONTH_SYM*/ *yylval= yytext; return yy_token_match(MONTH_SYM, yytext); }
{RENAME}				{ /*RENAME*/ *yylval= yytext; return yy_token_match(RENAME, yytext); }
{INTERVAL_SYM}				{ /*INTERVAL_SYM*/ *yylval= yytext; return yy_token_match(INTERVAL_SYM, yytext); }
{INSERT_METHOD}				{ /*INSERT_METHOD*/ *yylval= yytext; return yy_token_match(INSERT_METHOD, yytext); }
{REGEXP}				{ /*REGEXP*/ *yylval= yytext; return yy_token_match(REGEXP, yytext); }
{CLIENT_SYM}				{ /*CLIENT_SYM*/ *yylval= yytext; return yy_token_match(CLIENT_SYM, yytext); }
{IMPORT}				{ /*IMPORT*/ *yylval= yytext; return yy_token_match(IMPORT, yytext); }
{HOSTS_SYM}				{ /*HOSTS_SYM*/ *yylval= yytext; return yy_token_match(HOSTS_SYM, yytext); }
{NVARCHAR_SYM}				{ /*NVARCHAR_SYM*/ *yylval= yytext; return yy_token_match(NVARCHAR_SYM, yytext); }
{UNDO_SYM}				{ /*UNDO_SYM*/ *yylval= yytext; return yy_token_match(UNDO_SYM, yytext); }
{BINARY}				{ /*BINARY*/ *yylval= yytext; return yy_token_match(BINARY, yytext); }
{EXTRACT_SYM}				{ /*EXTRACT_SYM*/ *yylval= yytext; return yy_token_match(EXTRACT_SYM, yytext); }
{CONSTRAINT}				{ /*CONSTRAINT*/ *yylval= yytext; return yy_token_match(CONSTRAINT, yytext); }
{QUERY_SYM}				{ /*QUERY_SYM*/ *yylval= yytext; return yy_token_match(QUERY_SYM, yytext); }
{SERIALIZABLE_SYM}				{ /*SERIALIZABLE_SYM*/ *yylval= yytext; return yy_token_match(SERIALIZABLE_SYM, yytext); }
{INNER_SYM}				{ /*INNER_SYM*/ *yylval= yytext; return yy_token_match(INNER_SYM, yytext); }
{X509_SYM}				{ /*X509_SYM*/ *yylval= yytext; return yy_token_match(X509_SYM, yytext); }
{TIMESTAMP_ADD}				{ /*TIMESTAMP_ADD*/ *yylval= yytext; return yy_token_match(TIMESTAMP_ADD, yytext); }
{ERRORS}				{ /*ERRORS*/ *yylval= yytext; return yy_token_match(ERRORS, yytext); }
{HOUR_SYM}				{ /*HOUR_SYM*/ *yylval= yytext; return yy_token_match(HOUR_SYM, yytext); }
{DEALLOCATE_SYM}				{ /*DEALLOCATE_SYM*/ *yylval= yytext; return yy_token_match(DEALLOCATE_SYM, yytext); }
{MASTER_SSL_KEY_SYM}				{ /*MASTER_SSL_KEY_SYM*/ *yylval= yytext; return yy_token_match(MASTER_SSL_KEY_SYM, yytext); }
{PREPARE_SYM}				{ /*PREPARE_SYM*/ *yylval= yytext; return yy_token_match(PREPARE_SYM, yytext); }
{OPEN_SYM}				{ /*OPEN_SYM*/ *yylval= yytext; return yy_token_match(OPEN_SYM, yytext); }
{ANALYZE_SYM}				{ /*ANALYZE_SYM*/ *yylval= yytext; return yy_token_match(ANALYZE_SYM, yytext); }
{DUPLICATE_SYM}				{ /*DUPLICATE_SYM*/ *yylval= yytext; return yy_token_match(DUPLICATE_SYM, yytext); }
{HELP_SYM}				{ /*HELP_SYM*/ *yylval= yytext; return yy_token_match(HELP_SYM, yytext); }
{DECIMAL_SYM}				{ /*DECIMAL_SYM*/ *yylval= yytext; return yy_token_match(DECIMAL_SYM, yytext); }
{NO_WRITE_TO_BINLOG}				{ /*NO_WRITE_TO_BINLOG*/ *yylval= yytext; return yy_token_match(NO_WRITE_TO_BINLOG, yytext); }
{SPECIFIC_SYM}				{ /*SPECIFIC_SYM*/ *yylval= yytext; return yy_token_match(SPECIFIC_SYM, yytext); }
{WHEN_SYM}				{ /*WHEN_SYM*/ *yylval= yytext; return yy_token_match(WHEN_SYM, yytext); }
{READS_SYM}				{ /*READS_SYM*/ *yylval= yytext; return yy_token_match(READS_SYM, yytext); }
{CONCAT_WS}				{ /*CONCAT_WS*/ *yylval= yytext; return yy_token_match(CONCAT_WS, yytext); }
{LOCATE}				{ /*LOCATE*/ *yylval= yytext; return yy_token_match(LOCATE, yytext); }
{NUMERIC_SYM}				{ /*NUMERIC_SYM*/ *yylval= yytext; return yy_token_match(NUMERIC_SYM, yytext); }
{ITERATE_SYM}				{ /*ITERATE_SYM*/ *yylval= yytext; return yy_token_match(ITERATE_SYM, yytext); }
{SUM_SYM}				{ /*SUM_SYM*/ *yylval= yytext; return yy_token_match(SUM_SYM, yytext); }
{DIRECTORY_SYM}				{ /*DIRECTORY_SYM*/ *yylval= yytext; return yy_token_match(DIRECTORY_SYM, yytext); }
{MASTER_PASSWORD_SYM}				{ /*MASTER_PASSWORD_SYM*/ *yylval= yytext; return yy_token_match(MASTER_PASSWORD_SYM, yytext); }
{UPDATE_SYM}				{ /*UPDATE_SYM*/ *yylval= yytext; return yy_token_match(UPDATE_SYM, yytext); }
{AVG_SYM}				{ /*AVG_SYM*/ *yylval= yytext; return yy_token_match(AVG_SYM, yytext); }
{ROWS_SYM}				{ /*ROWS_SYM*/ *yylval= yytext; return yy_token_match(ROWS_SYM, yytext); }
{BETWEEN_SYM}				{ /*BETWEEN_SYM*/ *yylval= yytext; return yy_token_match(BETWEEN_SYM, yytext); }
{ONE_SHOT_SYM}				{ /*ONE_SHOT_SYM*/ *yylval= yytext; return yy_token_match(ONE_SHOT_SYM, yytext); }
{PROCESSLIST_SYM}				{ /*PROCESSLIST_SYM*/ *yylval= yytext; return yy_token_match(PROCESSLIST_SYM, yytext); }
{PRIMARY_SYM}				{ /*PRIMARY_SYM*/ *yylval= yytext; return yy_token_match(PRIMARY_SYM, yytext); }
{OUTFILE}				{ /*OUTFILE*/ *yylval= yytext; return yy_token_match(OUTFILE, yytext); }
{TINYINT}				{ /*TINYINT*/ *yylval= yytext; return yy_token_match(TINYINT, yytext); }
{XOR}				{ /*XOR*/ *yylval= yytext; return yy_token_match(XOR, yytext); }
{DEFINER_SYM}				{ /*DEFINER_SYM*/ *yylval= yytext; return yy_token_match(DEFINER_SYM, yytext); }
{RESTORE_SYM}				{ /*RESTORE_SYM*/ *yylval= yytext; return yy_token_match(RESTORE_SYM, yytext); }
{UNDEFINED_SYM}				{ /*UNDEFINED_SYM*/ *yylval= yytext; return yy_token_match(UNDEFINED_SYM, yytext); }
{MASTER_HOST_SYM}				{ /*MASTER_HOST_SYM*/ *yylval= yytext; return yy_token_match(MASTER_HOST_SYM, yytext); }
{WEEK_SYM}				{ /*WEEK_SYM*/ *yylval= yytext; return yy_token_match(WEEK_SYM, yytext); }
{FORCE_SYM}				{ /*FORCE_SYM*/ *yylval= yytext; return yy_token_match(FORCE_SYM, yytext); }
{BACKUP_SYM}				{ /*BACKUP_SYM*/ *yylval= yytext; return yy_token_match(BACKUP_SYM, yytext); }
{REPEATABLE_SYM}				{ /*REPEATABLE_SYM*/ *yylval= yytext; return yy_token_match(REPEATABLE_SYM, yytext); }
{SET}				{ /*SET*/ *yylval= yytext; return yy_token_match(SET, yytext); }
{LONGBLOB}				{ /*LONGBLOB*/ *yylval= yytext; return yy_token_match(LONGBLOB, yytext); }
{YEARWEEK}				{ /*YEARWEEK*/ *yylval= yytext; return yy_token_match(YEARWEEK, yytext); }
{MASTER_LOG_FILE_SYM}				{ /*MASTER_LOG_FILE_SYM*/ *yylval= yytext; return yy_token_match(MASTER_LOG_FILE_SYM, yytext); }
{TO_SYM}				{ /*TO_SYM*/ *yylval= yytext; return yy_token_match(TO_SYM, yytext); }
{CONVERT_SYM}				{ /*CONVERT_SYM*/ *yylval= yytext; return yy_token_match(CONVERT_SYM, yytext); }
{CHECK_SYM}				{ /*CHECK_SYM*/ *yylval= yytext; return yy_token_match(CHECK_SYM, yytext); }
{GEOMETRY_SYM}				{ /*GEOMETRY_SYM*/ *yylval= yytext; return yy_token_match(GEOMETRY_SYM, yytext); }
{FRAC_SECOND_SYM}				{ /*FRAC_SECOND_SYM*/ *yylval= yytext; return yy_token_match(FRAC_SECOND_SYM, yytext); }
{ALGORITHM_SYM}				{ /*ALGORITHM_SYM*/ *yylval= yytext; return yy_token_match(ALGORITHM_SYM, yytext); }
{VALUES}				{ /*VALUES*/ *yylval= yytext; return yy_token_match(VALUES, yytext); }
{DECLARE_SYM}				{ /*DECLARE_SYM*/ *yylval= yytext; return yy_token_match(DECLARE_SYM, yytext); }
{OR_SYM}				{ /*OR_SYM*/ *yylval= yytext; return yy_token_match(OR_SYM, yytext); }
{CLOSE_SYM}				{ /*CLOSE_SYM*/ *yylval= yytext; return yy_token_match(CLOSE_SYM, yytext); }
{VALUE_SYM}				{ /*VALUE_SYM*/ *yylval= yytext; return yy_token_match(VALUE_SYM, yytext); }
{EXTENDED_SYM}				{ /*EXTENDED_SYM*/ *yylval= yytext; return yy_token_match(EXTENDED_SYM, yytext); }
{FIELD_FUNC}				{ /*FIELD_FUNC*/ *yylval= yytext; return yy_token_match(FIELD_FUNC, yytext); }
{FULL}				{ /*FULL*/ *yylval= yytext; return yy_token_match(FULL, yytext); }
{EXECUTE_SYM}				{ /*EXECUTE_SYM*/ *yylval= yytext; return yy_token_match(EXECUTE_SYM, yytext); }
{PRIVILEGES}				{ /*PRIVILEGES*/ *yylval= yytext; return yy_token_match(PRIVILEGES, yytext); }
{UNIQUE_USERS}				{ /*UNIQUE_USERS*/ *yylval= yytext; return yy_token_match(UNIQUE_USERS, yytext); }
{SQL_BUFFER_RESULT}				{ /*SQL_BUFFER_RESULT*/ *yylval= yytext; return yy_token_match(SQL_BUFFER_RESULT, yytext); }
{MIN_SYM}				{ /*MIN_SYM*/ *yylval= yytext; return yy_token_match(MIN_SYM, yytext); }
{IDENTIFIED_SYM}				{ /*IDENTIFIED_SYM*/ *yylval= yytext; return yy_token_match(IDENTIFIED_SYM, yytext); }
{STD_SYM}				{ /*STD_SYM*/ *yylval= yytext; return yy_token_match(STD_SYM, yytext); }
{BLOB_SYM}				{ /*BLOB_SYM*/ *yylval= yytext; return yy_token_match(BLOB_SYM, yytext); }
{ROUND}				{ /*ROUND*/ *yylval= yytext; return yy_token_match(ROUND, yytext); }
{SQL_BIG_RESULT}				{ /*SQL_BIG_RESULT*/ *yylval= yytext; return yy_token_match(SQL_BIG_RESULT, yytext); }
{CONTAINS_SYM}				{ /*CONTAINS_SYM*/ *yylval= yytext; return yy_token_match(CONTAINS_SYM, yytext); }
{NAMES_SYM}				{ /*NAMES_SYM*/ *yylval= yytext; return yy_token_match(NAMES_SYM, yytext); }
{STARTING}				{ /*STARTING*/ *yylval= yytext; return yy_token_match(STARTING, yytext); }
{ENCRYPT}				{ /*ENCRYPT*/ *yylval= yytext; return yy_token_match(ENCRYPT, yytext); }
{REAL}				{ /*REAL*/ *yylval= yytext; return yy_token_match(REAL, yytext); }
{UNTIL_SYM}				{ /*UNTIL_SYM*/ *yylval= yytext; return yy_token_match(UNTIL_SYM, yytext); }
{FROM}				{ /*FROM*/ *yylval= yytext; return yy_token_match(FROM, yytext); }
{TRUE_SYM}				{ /*TRUE_SYM*/ *yylval= yytext; return yy_token_match(TRUE_SYM, yytext); }
{CONTINUE_SYM}				{ /*CONTINUE_SYM*/ *yylval= yytext; return yy_token_match(CONTINUE_SYM, yytext); }
{SUBSTRING}				{ /*SUBSTRING*/ *yylval= yytext; return yy_token_match(SUBSTRING, yytext); }
{GEOMETRYCOLLECTION}				{ /*GEOMETRYCOLLECTION*/ *yylval= yytext; return yy_token_match(GEOMETRYCOLLECTION, yytext); }
{POINTFROMTEXT}				{ /*POINTFROMTEXT*/ *yylval= yytext; return yy_token_match(POINTFROMTEXT, yytext); }
{LIKE}				{ /*LIKE*/ *yylval= yytext; return yy_token_match(LIKE, yytext); }
{MATCH}				{ /*MATCH*/ *yylval= yytext; return yy_token_match(MATCH, yytext); }
{BYTE_SYM}				{ /*BYTE_SYM*/ *yylval= yytext; return yy_token_match(BYTE_SYM, yytext); }
{DO_SYM}				{ /*DO_SYM*/ *yylval= yytext; return yy_token_match(DO_SYM, yytext); }
{UTC_TIMESTAMP_SYM}				{ /*UTC_TIMESTAMP_SYM*/ *yylval= yytext; return yy_token_match(UTC_TIMESTAMP_SYM, yytext); }
{SMALLINT}				{ /*SMALLINT*/ *yylval= yytext; return yy_token_match(SMALLINT, yytext); }
{CALL_SYM}				{ /*CALL_SYM*/ *yylval= yytext; return yy_token_match(CALL_SYM, yytext); }
{SIMPLE_SYM}				{ /*SIMPLE_SYM*/ *yylval= yytext; return yy_token_match(SIMPLE_SYM, yytext); }
{IF}				{ /*IF*/ *yylval= yytext; return yy_token_match(IF, yytext); }
{UNIQUE_SYM}				{ /*UNIQUE_SYM*/ *yylval= yytext; return yy_token_match(UNIQUE_SYM, yytext); }
{DEFAULT}				{ /*DEFAULT*/ *yylval= yytext; return yy_token_match(DEFAULT, yytext); }
{CHECKSUM_SYM}				{ /*CHECKSUM_SYM*/ *yylval= yytext; return yy_token_match(CHECKSUM_SYM, yytext); }
{FUNCTION_SYM}				{ /*FUNCTION_SYM*/ *yylval= yytext; return yy_token_match(FUNCTION_SYM, yytext); }
{COLLATION_SYM}				{ /*COLLATION_SYM*/ *yylval= yytext; return yy_token_match(COLLATION_SYM, yytext); }
{HIGH_PRIORITY}				{ /*HIGH_PRIORITY*/ *yylval= yytext; return yy_token_match(HIGH_PRIORITY, yytext); }
{MAX_UPDATES_PER_HOUR}				{ /*MAX_UPDATES_PER_HOUR*/ *yylval= yytext; return yy_token_match(MAX_UPDATES_PER_HOUR, yytext); }
{HANDLER_SYM}				{ /*HANDLER_SYM*/ *yylval= yytext; return yy_token_match(HANDLER_SYM, yytext); }
{OPTION}				{ /*OPTION*/ *yylval= yytext; return yy_token_match(OPTION, yytext); }
{LIMIT}				{ /*LIMIT*/ *yylval= yytext; return yy_token_match(LIMIT, yytext); }
{USE_SYM}				{ /*USE_SYM*/ *yylval= yytext; return yy_token_match(USE_SYM, yytext); }
{BEGIN_SYM}				{ /*BEGIN_SYM*/ *yylval= yytext; return yy_token_match(BEGIN_SYM, yytext); }
{DUMPFILE}				{ /*DUMPFILE*/ *yylval= yytext; return yy_token_match(DUMPFILE, yytext); }
{ENGINE_SYM}				{ /*ENGINE_SYM*/ *yylval= yytext; return yy_token_match(ENGINE_SYM, yytext); }
{OUT_SYM}				{ /*OUT_SYM*/ *yylval= yytext; return yy_token_match(OUT_SYM, yytext); }
{EXPANSION_SYM}				{ /*EXPANSION_SYM*/ *yylval= yytext; return yy_token_match(EXPANSION_SYM, yytext); }
{USAGE}				{ /*USAGE*/ *yylval= yytext; return yy_token_match(USAGE, yytext); }
{INDEX_SYM}				{ /*INDEX_SYM*/ *yylval= yytext; return yy_token_match(INDEX_SYM, yytext); }
{MLINEFROMTEXT}				{ /*MLINEFROMTEXT*/ *yylval= yytext; return yy_token_match(MLINEFROMTEXT, yytext); }
{DES_DECRYPT_SYM}				{ /*DES_DECRYPT_SYM*/ *yylval= yytext; return yy_token_match(DES_DECRYPT_SYM, yytext); }
{SUBSTRING_INDEX}				{ /*SUBSTRING_INDEX*/ *yylval= yytext; return yy_token_match(SUBSTRING_INDEX, yytext); }
{ELT_FUNC}				{ /*ELT_FUNC*/ *yylval= yytext; return yy_token_match(ELT_FUNC, yytext); }
{MASTER_SERVER_ID_SYM}				{ /*MASTER_SERVER_ID_SYM*/ *yylval= yytext; return yy_token_match(MASTER_SERVER_ID_SYM, yytext); }
{GROUP_CONCAT_SYM}				{ /*GROUP_CONCAT_SYM*/ *yylval= yytext; return yy_token_match(GROUP_CONCAT_SYM, yytext); }
{CASCADED}				{ /*CASCADED*/ *yylval= yytext; return yy_token_match(CASCADED, yytext); }
{LOCAL_SYM}				{ /*LOCAL_SYM*/ *yylval= yytext; return yy_token_match(LOCAL_SYM, yytext); }
{BOOL_SYM}				{ /*BOOL_SYM*/ *yylval= yytext; return yy_token_match(BOOL_SYM, yytext); }
{USE_FRM}				{ /*USE_FRM*/ *yylval= yytext; return yy_token_match(USE_FRM, yytext); }
{BOTH}				{ /*BOTH*/ *yylval= yytext; return yy_token_match(BOTH, yytext); }
{MASTER_SSL_CIPHER_SYM}				{ /*MASTER_SSL_CIPHER_SYM*/ *yylval= yytext; return yy_token_match(MASTER_SSL_CIPHER_SYM, yytext); }
{LABEL_SYM}				{ /*LABEL_SYM*/ *yylval= yytext; return yy_token_match(LABEL_SYM, yytext); }
{MEDIUMTEXT}				{ /*MEDIUMTEXT*/ *yylval= yytext; return yy_token_match(MEDIUMTEXT, yytext); }
{MINUTE_SYM}				{ /*MINUTE_SYM*/ *yylval= yytext; return yy_token_match(MINUTE_SYM, yytext); }
{MUTEX_SYM}				{ /*MUTEX_SYM*/ *yylval= yytext; return yy_token_match(MUTEX_SYM, yytext); }
{DISTINCT}				{ /*DISTINCT*/ *yylval= yytext; return yy_token_match(DISTINCT, yytext); }
{UTC_DATE_SYM}				{ /*UTC_DATE_SYM*/ *yylval= yytext; return yy_token_match(UTC_DATE_SYM, yytext); }
{CAST_SYM}				{ /*CAST_SYM*/ *yylval= yytext; return yy_token_match(CAST_SYM, yytext); }
{SAVEPOINT_SYM}				{ /*SAVEPOINT_SYM*/ *yylval= yytext; return yy_token_match(SAVEPOINT_SYM, yytext); }
{INFILE}				{ /*INFILE*/ *yylval= yytext; return yy_token_match(INFILE, yytext); }
{CURTIME}				{ /*CURTIME*/ *yylval= yytext; return yy_token_match(CURTIME, yytext); }
{SECOND_MICROSECOND_SYM}				{ /*SECOND_MICROSECOND_SYM*/ *yylval= yytext; return yy_token_match(SECOND_MICROSECOND_SYM, yytext); }
{ADDDATE_SYM}				{ /*ADDDATE_SYM*/ *yylval= yytext; return yy_token_match(ADDDATE_SYM, yytext); }
{CASE_SYM}				{ /*CASE_SYM*/ *yylval= yytext; return yy_token_match(CASE_SYM, yytext); }
{INT_SYM}				{ /*INT_SYM*/ *yylval= yytext; return yy_token_match(INT_SYM, yytext); }
{GET_FORMAT}				{ /*GET_FORMAT*/ *yylval= yytext; return yy_token_match(GET_FORMAT, yytext); }
{RETURNS_SYM}				{ /*RETURNS_SYM*/ *yylval= yytext; return yy_token_match(RETURNS_SYM, yytext); }
{RAID_STRIPED_SYM}				{ /*RAID_STRIPED_SYM*/ *yylval= yytext; return yy_token_match(RAID_STRIPED_SYM, yytext); }
{BTREE_SYM}				{ /*BTREE_SYM*/ *yylval= yytext; return yy_token_match(BTREE_SYM, yytext); }
{SQL_CACHE_SYM}				{ /*SQL_CACHE_SYM*/ *yylval= yytext; return yy_token_match(SQL_CACHE_SYM, yytext); }
{EXPORT_SET}				{ /*EXPORT_SET*/ *yylval= yytext; return yy_token_match(EXPORT_SET, yytext); }
{TRANSACTION_SYM}				{ /*TRANSACTION_SYM*/ *yylval= yytext; return yy_token_match(TRANSACTION_SYM, yytext); }
{COMMENT_SYM}				{ /*COMMENT_SYM*/ *yylval= yytext; return yy_token_match(COMMENT_SYM, yytext); }
{FIXED_SYM}				{ /*FIXED_SYM*/ *yylval= yytext; return yy_token_match(FIXED_SYM, yytext); }
{TEMPTABLE_SYM}				{ /*TEMPTABLE_SYM*/ *yylval= yytext; return yy_token_match(TEMPTABLE_SYM, yytext); }
{MAX_ROWS}				{ /*MAX_ROWS*/ *yylval= yytext; return yy_token_match(MAX_ROWS, yytext); }
{SUBDATE_SYM}				{ /*SUBDATE_SYM*/ *yylval= yytext; return yy_token_match(SUBDATE_SYM, yytext); }
{COLUMNS}				{ /*COLUMNS*/ *yylval= yytext; return yy_token_match(COLUMNS, yytext); }
{RELAY_LOG_POS_SYM}				{ /*RELAY_LOG_POS_SYM*/ *yylval= yytext; return yy_token_match(RELAY_LOG_POS_SYM, yytext); }
{STDDEV_SAMP_SYM}				{ /*STDDEV_SAMP_SYM*/ *yylval= yytext; return yy_token_match(STDDEV_SAMP_SYM, yytext); }
{OFFSET_SYM}				{ /*OFFSET_SYM*/ *yylval= yytext; return yy_token_match(OFFSET_SYM, yytext); }
{MASTER_PORT_SYM}				{ /*MASTER_PORT_SYM*/ *yylval= yytext; return yy_token_match(MASTER_PORT_SYM, yytext); }
{MPOLYFROMTEXT}				{ /*MPOLYFROMTEXT*/ *yylval= yytext; return yy_token_match(MPOLYFROMTEXT, yytext); }
{QUARTER_SYM}				{ /*QUARTER_SYM*/ *yylval= yytext; return yy_token_match(QUARTER_SYM, yytext); }
{RAID_CHUNKS}				{ /*RAID_CHUNKS*/ *yylval= yytext; return yy_token_match(RAID_CHUNKS, yytext); }
{RELEASE_SYM}				{ /*RELEASE_SYM*/ *yylval= yytext; return yy_token_match(RELEASE_SYM, yytext); }
{DELETE_SYM}				{ /*DELETE_SYM*/ *yylval= yytext; return yy_token_match(DELETE_SYM, yytext); }
{SSL_SYM}				{ /*SSL_SYM*/ *yylval= yytext; return yy_token_match(SSL_SYM, yytext); }
{LOG_SYM}				{ /*LOG_SYM*/ *yylval= yytext; return yy_token_match(LOG_SYM, yytext); }
{ROLLBACK_SYM}				{ /*ROLLBACK_SYM*/ *yylval= yytext; return yy_token_match(ROLLBACK_SYM, yytext); }
{NDBCLUSTER_SYM}				{ /*NDBCLUSTER_SYM*/ *yylval= yytext; return yy_token_match(NDBCLUSTER_SYM, yytext); }
{WHERE}				{ /*WHERE*/ *yylval= yytext; return yy_token_match(WHERE, yytext); }
{CREATE}				{ /*CREATE*/ *yylval= yytext; return yy_token_match(CREATE, yytext); }
{OLD_PASSWORD}				{ /*OLD_PASSWORD*/ *yylval= yytext; return yy_token_match(OLD_PASSWORD, yytext); }
{REPEAT_SYM}				{ /*REPEAT_SYM*/ *yylval= yytext; return yy_token_match(REPEAT_SYM, yytext); }
{MASTER_POS_WAIT}				{ /*MASTER_POS_WAIT*/ *yylval= yytext; return yy_token_match(MASTER_POS_WAIT, yytext); }
{GOTO_SYM}				{ /*GOTO_SYM*/ *yylval= yytext; return yy_token_match(GOTO_SYM, yytext); }
{MEDIUM_SYM}				{ /*MEDIUM_SYM*/ *yylval= yytext; return yy_token_match(MEDIUM_SYM, yytext); }
{ROW_SYM}				{ /*ROW_SYM*/ *yylval= yytext; return yy_token_match(ROW_SYM, yytext); }
{USING}				{ /*USING*/ *yylval= yytext; return yy_token_match(USING, yytext); }
{LEADING}				{ /*LEADING*/ *yylval= yytext; return yy_token_match(LEADING, yytext); }
{ROLLUP_SYM}				{ /*ROLLUP_SYM*/ *yylval= yytext; return yy_token_match(ROLLUP_SYM, yytext); }
{DETERMINISTIC_SYM}				{ /*DETERMINISTIC_SYM*/ *yylval= yytext; return yy_token_match(DETERMINISTIC_SYM, yytext); }
{PACK_KEYS_SYM}				{ /*PACK_KEYS_SYM*/ *yylval= yytext; return yy_token_match(PACK_KEYS_SYM, yytext); }
{ONE_SYM}				{ /*ONE_SYM*/ *yylval= yytext; return yy_token_match(ONE_SYM, yytext); }
{GREATEST_SYM}				{ /*GREATEST_SYM*/ *yylval= yytext; return yy_token_match(GREATEST_SYM, yytext); }
{COMMITTED_SYM}				{ /*COMMITTED_SYM*/ *yylval= yytext; return yy_token_match(COMMITTED_SYM, yytext); }
{SOUNDS_SYM}				{ /*SOUNDS_SYM*/ *yylval= yytext; return yy_token_match(SOUNDS_SYM, yytext); }
{GEOMCOLLFROMTEXT}				{ /*GEOMCOLLFROMTEXT*/ *yylval= yytext; return yy_token_match(GEOMCOLLFROMTEXT, yytext); }
{OPTIONALLY}				{ /*OPTIONALLY*/ *yylval= yytext; return yy_token_match(OPTIONALLY, yytext); }
{DATE_ADD_INTERVAL}				{ /*DATE_ADD_INTERVAL*/ *yylval= yytext; return yy_token_match(DATE_ADD_INTERVAL, yytext); }
{LOCKS_SYM}				{ /*LOCKS_SYM*/ *yylval= yytext; return yy_token_match(LOCKS_SYM, yytext); }
{VARBINARY}				{ /*VARBINARY*/ *yylval= yytext; return yy_token_match(VARBINARY, yytext); }
{TRUNCATE_SYM}				{ /*TRUNCATE_SYM*/ *yylval= yytext; return yy_token_match(TRUNCATE_SYM, yytext); }
{LEAVE_SYM}				{ /*LEAVE_SYM*/ *yylval= yytext; return yy_token_match(LEAVE_SYM, yytext); }
{VAR_SAMP_SYM}				{ /*VAR_SAMP_SYM*/ *yylval= yytext; return yy_token_match(VAR_SAMP_SYM, yytext); }
{GROUP}				{ /*GROUP*/ *yylval= yytext; return yy_token_match(GROUP, yytext); }
{LINES}				{ /*LINES*/ *yylval= yytext; return yy_token_match(LINES, yytext); }
{REPLICATION}				{ /*REPLICATION*/ *yylval= yytext; return yy_token_match(REPLICATION, yytext); }
{FLUSH_SYM}				{ /*FLUSH_SYM*/ *yylval= yytext; return yy_token_match(FLUSH_SYM, yytext); }
{INOUT_SYM}				{ /*INOUT_SYM*/ *yylval= yytext; return yy_token_match(INOUT_SYM, yytext); }
{THEN_SYM}				{ /*THEN_SYM*/ *yylval= yytext; return yy_token_match(THEN_SYM, yytext); }
{MPOINTFROMTEXT}				{ /*MPOINTFROMTEXT*/ *yylval= yytext; return yy_token_match(MPOINTFROMTEXT, yytext); }
{TEMPORARY}				{ /*TEMPORARY*/ *yylval= yytext; return yy_token_match(TEMPORARY, yytext); }
{OUTER}				{ /*OUTER*/ *yylval= yytext; return yy_token_match(OUTER, yytext); }
{TABLE_SYM}				{ /*TABLE_SYM*/ *yylval= yytext; return yy_token_match(TABLE_SYM, yytext); }
{ENUM}				{ /*ENUM*/ *yylval= yytext; return yy_token_match(ENUM, yytext); }
{DELAYED_SYM}				{ /*DELAYED_SYM*/ *yylval= yytext; return yy_token_match(DELAYED_SYM, yytext); }
{SHOW}				{ /*SHOW*/ *yylval= yytext; return yy_token_match(SHOW, yytext); }
{RAID_TYPE}				{ /*RAID_TYPE*/ *yylval= yytext; return yy_token_match(RAID_TYPE, yytext); }
{AUTO_INC}				{ /*AUTO_INC*/ *yylval= yytext; return yy_token_match(AUTO_INC, yytext); }
{USER}				{ /*USER*/ *yylval= yytext; return yy_token_match(USER, yytext); }
{MASTER_SYM}				{ /*MASTER_SYM*/ *yylval= yytext; return yy_token_match(MASTER_SYM, yytext); }
{ESCAPE_SYM}				{ /*ESCAPE_SYM*/ *yylval= yytext; return yy_token_match(ESCAPE_SYM, yytext); }
{BERKELEY_DB_SYM}				{ /*BERKELEY_DB_SYM*/ *yylval= yytext; return yy_token_match(BERKELEY_DB_SYM, yytext); }
{LAST_SYM}				{ /*LAST_SYM*/ *yylval= yytext; return yy_token_match(LAST_SYM, yytext); }
{HOUR_MICROSECOND_SYM}				{ /*HOUR_MICROSECOND_SYM*/ *yylval= yytext; return yy_token_match(HOUR_MICROSECOND_SYM, yytext); }
{GEOMFROMTEXT}				{ /*GEOMFROMTEXT*/ *yylval= yytext; return yy_token_match(GEOMFROMTEXT, yytext); }
{REDUNDANT_SYM}				{ /*REDUNDANT_SYM*/ *yylval= yytext; return yy_token_match(REDUNDANT_SYM, yytext); }
{DES_ENCRYPT_SYM}				{ /*DES_ENCRYPT_SYM*/ *yylval= yytext; return yy_token_match(DES_ENCRYPT_SYM, yytext); }
{SQL_SMALL_RESULT}				{ /*SQL_SMALL_RESULT*/ *yylval= yytext; return yy_token_match(SQL_SMALL_RESULT, yytext); }
{RELAY_THREAD}				{ /*RELAY_THREAD*/ *yylval= yytext; return yy_token_match(RELAY_THREAD, yytext); }
{GROUP_UNIQUE_USERS}				{ /*GROUP_UNIQUE_USERS*/ *yylval= yytext; return yy_token_match(GROUP_UNIQUE_USERS, yytext); }
{REVOKE}				{ /*REVOKE*/ *yylval= yytext; return yy_token_match(REVOKE, yytext); }
{ROW_COUNT_SYM}				{ /*ROW_COUNT_SYM*/ *yylval= yytext; return yy_token_match(ROW_COUNT_SYM, yytext); }
{MULTILINESTRING}				{ /*MULTILINESTRING*/ *yylval= yytext; return yy_token_match(MULTILINESTRING, yytext); }
{MASTER_SSL_CERT_SYM}				{ /*MASTER_SSL_CERT_SYM*/ *yylval= yytext; return yy_token_match(MASTER_SSL_CERT_SYM, yytext); }
{NAME_SYM}				{ /*NAME_SYM*/ *yylval= yytext; return yy_token_match(NAME_SYM, yytext); }
{EXISTS}				{ /*EXISTS*/ *yylval= yytext; return yy_token_match(EXISTS, yytext); }
{END}				{ /*END*/ *yylval= yytext; return yy_token_match(END, yytext); }
{DOUBLE_SYM}				{ /*DOUBLE_SYM*/ *yylval= yytext; return yy_token_match(DOUBLE_SYM, yytext); }
{MASTER_CONNECT_RETRY_SYM}				{ /*MASTER_CONNECT_RETRY_SYM*/ *yylval= yytext; return yy_token_match(MASTER_CONNECT_RETRY_SYM, yytext); }
{NATURAL}				{ /*NATURAL*/ *yylval= yytext; return yy_token_match(NATURAL, yytext); }
{CONNECTION_SYM}				{ /*CONNECTION_SYM*/ *yylval= yytext; return yy_token_match(CONNECTION_SYM, yytext); }
{ESCAPED}				{ /*ESCAPED*/ *yylval= yytext; return yy_token_match(ESCAPED, yytext); }
{BIT_SYM}				{ /*BIT_SYM*/ *yylval= yytext; return yy_token_match(BIT_SYM, yytext); }
{BIT_OR}				{ /*BIT_OR*/ *yylval= yytext; return yy_token_match(BIT_OR, yytext); }
{FULLTEXT_SYM}				{ /*FULLTEXT_SYM*/ *yylval= yytext; return yy_token_match(FULLTEXT_SYM, yytext); }
{MICROSECOND_SYM}				{ /*MICROSECOND_SYM*/ *yylval= yytext; return yy_token_match(MICROSECOND_SYM, yytext); }
{YEAR_SYM}				{ /*YEAR_SYM*/ *yylval= yytext; return yy_token_match(YEAR_SYM, yytext); }
{TERMINATED}				{ /*TERMINATED*/ *yylval= yytext; return yy_token_match(TERMINATED, yytext); }
{AGGREGATE_SYM}				{ /*AGGREGATE_SYM*/ *yylval= yytext; return yy_token_match(AGGREGATE_SYM, yytext); }
{LEAVES}				{ /*LEAVES*/ *yylval= yytext; return yy_token_match(LEAVES, yytext); }
{RELOAD}				{ /*RELOAD*/ *yylval= yytext; return yy_token_match(RELOAD, yytext); }
{ON}				{ /*ON*/ *yylval= yytext; return yy_token_match(ON, yytext); }
{TINYBLOB}				{ /*TINYBLOB*/ *yylval= yytext; return yy_token_match(TINYBLOB, yytext); }
{BEFORE_SYM}				{ /*BEFORE_SYM*/ *yylval= yytext; return yy_token_match(BEFORE_SYM, yytext); }
{AND_SYM}				{ /*AND_SYM*/ *yylval= yytext; return yy_token_match(AND_SYM, yytext); }
{MAX_CONNECTIONS_PER_HOUR}				{ /*MAX_CONNECTIONS_PER_HOUR*/ *yylval= yytext; return yy_token_match(MAX_CONNECTIONS_PER_HOUR, yytext); }
{SQLWARNING_SYM}				{ /*SQLWARNING_SYM*/ *yylval= yytext; return yy_token_match(SQLWARNING_SYM, yytext); }
{COUNT_SYM}				{ /*COUNT_SYM*/ *yylval= yytext; return yy_token_match(COUNT_SYM, yytext); }
{CHANGE}				{ /*CHANGE*/ *yylval= yytext; return yy_token_match(CHANGE, yytext); }
{LOOP_SYM}				{ /*LOOP_SYM*/ *yylval= yytext; return yy_token_match(LOOP_SYM, yytext); }
{MASTER_LOG_POS_SYM}				{ /*MASTER_LOG_POS_SYM*/ *yylval= yytext; return yy_token_match(MASTER_LOG_POS_SYM, yytext); }
{RETURN_SYM}				{ /*RETURN_SYM*/ *yylval= yytext; return yy_token_match(RETURN_SYM, yytext); }
{DESC}				{ /*DESC*/ *yylval= yytext; return yy_token_match(DESC, yytext); }
{MASTER_SSL_SYM}				{ /*MASTER_SSL_SYM*/ *yylval= yytext; return yy_token_match(MASTER_SSL_SYM, yytext); }
{NATIONAL_SYM}				{ /*NATIONAL_SYM*/ *yylval= yytext; return yy_token_match(NATIONAL_SYM, yytext); }
{TRIM}				{ /*TRIM*/ *yylval= yytext; return yy_token_match(TRIM, yytext); }
{UNSIGNED}				{ /*UNSIGNED*/ *yylval= yytext; return yy_token_match(UNSIGNED, yytext); }
{FOR_SYM}				{ /*FOR_SYM*/ *yylval= yytext; return yy_token_match(FOR_SYM, yytext); }
{SESSION_SYM}				{ /*SESSION_SYM*/ *yylval= yytext; return yy_token_match(SESSION_SYM, yytext); }
{ENGINES_SYM}				{ /*ENGINES_SYM*/ *yylval= yytext; return yy_token_match(ENGINES_SYM, yytext); }
{FIRST_SYM}				{ /*FIRST_SYM*/ *yylval= yytext; return yy_token_match(FIRST_SYM, yytext); }
{MAX_USER_CONNECTIONS_SYM}				{ /*MAX_USER_CONNECTIONS_SYM*/ *yylval= yytext; return yy_token_match(MAX_USER_CONNECTIONS_SYM, yytext); }
{SUBJECT_SYM}				{ /*SUBJECT_SYM*/ *yylval= yytext; return yy_token_match(SUBJECT_SYM, yytext); }
{SHARE_SYM}				{ /*SHARE_SYM*/ *yylval= yytext; return yy_token_match(SHARE_SYM, yytext); }
{RELAY_LOG_FILE_SYM}				{ /*RELAY_LOG_FILE_SYM*/ *yylval= yytext; return yy_token_match(RELAY_LOG_FILE_SYM, yytext); }
{SQLEXCEPTION_SYM}				{ /*SQLEXCEPTION_SYM*/ *yylval= yytext; return yy_token_match(SQLEXCEPTION_SYM, yytext); }
{OPTIMIZE}				{ /*OPTIMIZE*/ *yylval= yytext; return yy_token_match(OPTIMIZE, yytext); }
{NO_SYM}				{ /*NO_SYM*/ *yylval= yytext; return yy_token_match(NO_SYM, yytext); }
{DAY_HOUR_SYM}				{ /*DAY_HOUR_SYM*/ *yylval= yytext; return yy_token_match(DAY_HOUR_SYM, yytext); }
{LINESTRING}				{ /*LINESTRING*/ *yylval= yytext; return yy_token_match(LINESTRING, yytext); }
{COMMIT_SYM}				{ /*COMMIT_SYM*/ *yylval= yytext; return yy_token_match(COMMIT_SYM, yytext); }
{CONCURRENT}				{ /*CONCURRENT*/ *yylval= yytext; return yy_token_match(CONCURRENT, yytext); }
{PROCESS}				{ /*PROCESS*/ *yylval= yytext; return yy_token_match(PROCESS, yytext); }
{ALTER}				{ /*ALTER*/ *yylval= yytext; return yy_token_match(ALTER, yytext); }
{MAX_QUERIES_PER_HOUR}				{ /*MAX_QUERIES_PER_HOUR*/ *yylval= yytext; return yy_token_match(MAX_QUERIES_PER_HOUR, yytext); }
{ELSE}				{ /*ELSE*/ *yylval= yytext; return yy_token_match(ELSE, yytext); }
{DAY_MINUTE_SYM}				{ /*DAY_MINUTE_SYM*/ *yylval= yytext; return yy_token_match(DAY_MINUTE_SYM, yytext); }
{SECOND_SYM}				{ /*SECOND_SYM*/ *yylval= yytext; return yy_token_match(SECOND_SYM, yytext); }
{INNOBASE_SYM}				{ /*INNOBASE_SYM*/ *yylval= yytext; return yy_token_match(INNOBASE_SYM, yytext); }
{DIV_SYM}				{ /*DIV_SYM*/ *yylval= yytext; return yy_token_match(DIV_SYM, yytext); }
{BIGINT}				{ /*BIGINT*/ *yylval= yytext; return yy_token_match(BIGINT, yytext); }
{FETCH_SYM}				{ /*FETCH_SYM*/ *yylval= yytext; return yy_token_match(FETCH_SYM, yytext); }
{READ_SYM}				{ /*READ_SYM*/ *yylval= yytext; return yy_token_match(READ_SYM, yytext); }
{SQL_NO_CACHE_SYM}				{ /*SQL_NO_CACHE_SYM*/ *yylval= yytext; return yy_token_match(SQL_NO_CACHE_SYM, yytext); }
{HAVING}				{ /*HAVING*/ *yylval= yytext; return yy_token_match(HAVING, yytext); }
{NULL_SYM}				{ /*NULL_SYM*/ *yylval= yytext; return yy_token_match(NULL_SYM, yytext); }
{SPATIAL_SYM}				{ /*SPATIAL_SYM*/ *yylval= yytext; return yy_token_match(SPATIAL_SYM, yytext); }
{ADD}				{ /*ADD*/ *yylval= yytext; return yy_token_match(ADD, yytext); }
{XA_SYM}				{ /*XA_SYM*/ *yylval= yytext; return yy_token_match(XA_SYM, yytext); }
{GRANT}				{ /*GRANT*/ *yylval= yytext; return yy_token_match(GRANT, yytext); }
{KEYS}				{ /*KEYS*/ *yylval= yytext; return yy_token_match(KEYS, yytext); }
{NCHAR_SYM}				{ /*NCHAR_SYM*/ *yylval= yytext; return yy_token_match(NCHAR_SYM, yytext); }
{INSENSITIVE_SYM}				{ /*INSENSITIVE_SYM*/ *yylval= yytext; return yy_token_match(INSENSITIVE_SYM, yytext); }
{LONGTEXT}				{ /*LONGTEXT*/ *yylval= yytext; return yy_token_match(LONGTEXT, yytext); }
{DATABASE}				{ /*DATABASE*/ *yylval= yytext; return yy_token_match(DATABASE, yytext); }
{AFTER_SYM}				{ /*AFTER_SYM*/ *yylval= yytext; return yy_token_match(AFTER_SYM, yytext); }
{FORMAT_SYM}				{ /*FORMAT_SYM*/ *yylval= yytext; return yy_token_match(FORMAT_SYM, yytext); }
{TABLES}				{ /*TABLES*/ *yylval= yytext; return yy_token_match(TABLES, yytext); }
{FAST_SYM}				{ /*FAST_SYM*/ *yylval= yytext; return yy_token_match(FAST_SYM, yytext); }
{LOAD}				{ /*LOAD*/ *yylval= yytext; return yy_token_match(LOAD, yytext); }
{RESTRICT}				{ /*RESTRICT*/ *yylval= yytext; return yy_token_match(RESTRICT, yytext); }
{MAX_SYM}				{ /*MAX_SYM*/ *yylval= yytext; return yy_token_match(MAX_SYM, yytext); }
{PROCEDURE}				{ /*PROCEDURE*/ *yylval= yytext; return yy_token_match(PROCEDURE, yytext); }
{NEW_SYM}				{ /*NEW_SYM*/ *yylval= yytext; return yy_token_match(NEW_SYM, yytext); }
{SQL_CALC_FOUND_ROWS}				{ /*SQL_CALC_FOUND_ROWS*/ *yylval= yytext; return yy_token_match(SQL_CALC_FOUND_ROWS, yytext); }
{COALESCE}				{ /*COALESCE*/ *yylval= yytext; return yy_token_match(COALESCE, yytext); }
{FOUND_SYM}				{ /*FOUND_SYM*/ *yylval= yytext; return yy_token_match(FOUND_SYM, yytext); }
{MIN_ROWS}				{ /*MIN_ROWS*/ *yylval= yytext; return yy_token_match(MIN_ROWS, yytext); }
{TIMESTAMP}				{ /*TIMESTAMP*/ *yylval= yytext; return yy_token_match(TIMESTAMP, yytext); }
{BY}				{ /*BY*/ *yylval= yytext; return yy_token_match(BY, yytext); }
{LINEFROMTEXT}				{ /*LINEFROMTEXT*/ *yylval= yytext; return yy_token_match(LINEFROMTEXT, yytext); }
{UNION_SYM}				{ /*UNION_SYM*/ *yylval= yytext; return yy_token_match(UNION_SYM, yytext); }
{STATUS_SYM}				{ /*STATUS_SYM*/ *yylval= yytext; return yy_token_match(STATUS_SYM, yytext); }
{EVENTS_SYM}				{ /*EVENTS_SYM*/ *yylval= yytext; return yy_token_match(EVENTS_SYM, yytext); }
{DESCRIBE}				{ /*DESCRIBE*/ *yylval= yytext; return yy_token_match(DESCRIBE, yytext); }
{SUSPEND_SYM}				{ /*SUSPEND_SYM*/ *yylval= yytext; return yy_token_match(SUSPEND_SYM, yytext); }
{AVG_ROW_LENGTH}				{ /*AVG_ROW_LENGTH*/ *yylval= yytext; return yy_token_match(AVG_ROW_LENGTH, yytext); }
{ATAN}				{ /*ATAN*/ *yylval= yytext; return yy_token_match(ATAN, yytext); }
{FLOAT_SYM}				{ /*FLOAT_SYM*/ *yylval= yytext; return yy_token_match(FLOAT_SYM, yytext); }
{TRAILING}				{ /*TRAILING*/ *yylval= yytext; return yy_token_match(TRAILING, yytext); }
{TIMESTAMP_DIFF}				{ /*TIMESTAMP_DIFF*/ *yylval= yytext; return yy_token_match(TIMESTAMP_DIFF, yytext); }
{STRAIGHT_JOIN}				{ /*STRAIGHT_JOIN*/ *yylval= yytext; return yy_token_match(STRAIGHT_JOIN, yytext); }
{MEDIUMINT}				{ /*MEDIUMINT*/ *yylval= yytext; return yy_token_match(MEDIUMINT, yytext); }
{VIEW_SYM}				{ /*VIEW_SYM*/ *yylval= yytext; return yy_token_match(VIEW_SYM, yytext); }
{EACH_SYM}				{ /*EACH_SYM*/ *yylval= yytext; return yy_token_match(EACH_SYM, yytext); }
{LEAST_SYM}				{ /*LEAST_SYM*/ *yylval= yytext; return yy_token_match(LEAST_SYM, yytext); }
{COLLATE_SYM}				{ /*COLLATE_SYM*/ *yylval= yytext; return yy_token_match(COLLATE_SYM, yytext); }
{COMPACT_SYM}				{ /*COMPACT_SYM*/ *yylval= yytext; return yy_token_match(COMPACT_SYM, yytext); }
{CURDATE}				{ /*CURDATE*/ *yylval= yytext; return yy_token_match(CURDATE, yytext); }
{DAY_MICROSECOND_SYM}				{ /*DAY_MICROSECOND_SYM*/ *yylval= yytext; return yy_token_match(DAY_MICROSECOND_SYM, yytext); }
{MASTER_SSL_CAPATH_SYM}				{ /*MASTER_SSL_CAPATH_SYM*/ *yylval= yytext; return yy_token_match(MASTER_SSL_CAPATH_SYM, yytext); }
{SENSITIVE_SYM}				{ /*SENSITIVE_SYM*/ *yylval= yytext; return yy_token_match(SENSITIVE_SYM, yytext); }
{POINT_SYM}				{ /*POINT_SYM*/ *yylval= yytext; return yy_token_match(POINT_SYM, yytext); }
{DELAY_KEY_WRITE_SYM}				{ /*DELAY_KEY_WRITE_SYM*/ *yylval= yytext; return yy_token_match(DELAY_KEY_WRITE_SYM, yytext); }
{MIGRATE_SYM}				{ /*MIGRATE_SYM*/ *yylval= yytext; return yy_token_match(MIGRATE_SYM, yytext); }
{UDF_SONAME_SYM}				{ /*UDF_SONAME_SYM*/ *yylval= yytext; return yy_token_match(UDF_SONAME_SYM, yytext); }
{STRING_SYM}				{ /*STRING_SYM*/ *yylval= yytext; return yy_token_match(STRING_SYM, yytext); }
{PRECISION}				{ /*PRECISION*/ *yylval= yytext; return yy_token_match(PRECISION, yytext); }
{RTREE_SYM}				{ /*RTREE_SYM*/ *yylval= yytext; return yy_token_match(RTREE_SYM, yytext); }
{WITH}				{ /*WITH*/ *yylval= yytext; return yy_token_match(WITH, yytext); }
{RAND}				{ /*RAND*/ *yylval= yytext; return yy_token_match(RAND, yytext); }
{DROP}				{ /*DROP*/ *yylval= yytext; return yy_token_match(DROP, yytext); }
{PARTIAL}				{ /*PARTIAL*/ *yylval= yytext; return yy_token_match(PARTIAL, yytext); }
{MEDIUMBLOB}				{ /*MEDIUMBLOB*/ *yylval= yytext; return yy_token_match(MEDIUMBLOB, yytext); }
{WHILE_SYM}				{ /*WHILE_SYM*/ *yylval= yytext; return yy_token_match(WHILE_SYM, yytext); }
{GRANTS}				{ /*GRANTS*/ *yylval= yytext; return yy_token_match(GRANTS, yytext); }
{NOT_SYM}				{ /*NOT_SYM*/ *yylval= yytext; return yy_token_match(NOT_SYM, yytext); }
{INVOKER_SYM}				{ /*INVOKER_SYM*/ *yylval= yytext; return yy_token_match(INVOKER_SYM, yytext); }
{MULTIPOINT}				{ /*MULTIPOINT*/ *yylval= yytext; return yy_token_match(MULTIPOINT, yytext); }
{SLAVE}				{ /*SLAVE*/ *yylval= yytext; return yy_token_match(SLAVE, yytext); }
{GLOBAL_SYM}				{ /*GLOBAL_SYM*/ *yylval= yytext; return yy_token_match(GLOBAL_SYM, yytext); }
{VARIANCE_SYM}				{ /*VARIANCE_SYM*/ *yylval= yytext; return yy_token_match(VARIANCE_SYM, yytext); }
{POSITION_SYM}				{ /*POSITION_SYM*/ *yylval= yytext; return yy_token_match(POSITION_SYM, yytext); }
{KEY_SYM}				{ /*KEY_SYM*/ *yylval= yytext; return yy_token_match(KEY_SYM, yytext); }
{CHARSET}				{ /*CHARSET*/ *yylval= yytext; return yy_token_match(CHARSET, yytext); }
{ROW_FORMAT_SYM}				{ /*ROW_FORMAT_SYM*/ *yylval= yytext; return yy_token_match(ROW_FORMAT_SYM, yytext); }
{AS}				{ /*AS*/ *yylval= yytext; return yy_token_match(AS, yytext); }
{MODIFIES_SYM}				{ /*MODIFIES_SYM*/ *yylval= yytext; return yy_token_match(MODIFIES_SYM, yytext); }
{KILL_SYM}				{ /*KILL_SYM*/ *yylval= yytext; return yy_token_match(KILL_SYM, yytext); }
{LOGS_SYM}				{ /*LOGS_SYM*/ *yylval= yytext; return yy_token_match(LOGS_SYM, yytext); }
{CHAIN_SYM}				{ /*CHAIN_SYM*/ *yylval= yytext; return yy_token_match(CHAIN_SYM, yytext); }
{QUICK}				{ /*QUICK*/ *yylval= yytext; return yy_token_match(QUICK, yytext); }
{HOUR_MINUTE_SYM}				{ /*HOUR_MINUTE_SYM*/ *yylval= yytext; return yy_token_match(HOUR_MINUTE_SYM, yytext); }
{ZEROFILL}				{ /*ZEROFILL*/ *yylval= yytext; return yy_token_match(ZEROFILL, yytext); }
{FOREIGN}				{ /*FOREIGN*/ *yylval= yytext; return yy_token_match(FOREIGN, yytext); }
{CONDITION_SYM}				{ /*CONDITION_SYM*/ *yylval= yytext; return yy_token_match(CONDITION_SYM, yytext); }
{VARIABLES}				{ /*VARIABLES*/ *yylval= yytext; return yy_token_match(VARIABLES, yytext); }
{INDEXES}				{ /*INDEXES*/ *yylval= yytext; return yy_token_match(INDEXES, yytext); }
{DATE_SUB_INTERVAL}				{ /*DATE_SUB_INTERVAL*/ *yylval= yytext; return yy_token_match(DATE_SUB_INTERVAL, yytext); }
{CHANGED}				{ /*CHANGED*/ *yylval= yytext; return yy_token_match(CHANGED, yytext); }
{UNICODE_SYM}				{ /*UNICODE_SYM*/ *yylval= yytext; return yy_token_match(UNICODE_SYM, yytext); }
{NEXT_SYM}				{ /*NEXT_SYM*/ *yylval= yytext; return yy_token_match(NEXT_SYM, yytext); }
{RIGHT}				{ /*RIGHT*/ *yylval= yytext; return yy_token_match(RIGHT, yytext); }
{DAY_SYM}				{ /*DAY_SYM*/ *yylval= yytext; return yy_token_match(DAY_SYM, yytext); }
{CONCAT}				{ /*CONCAT*/ *yylval= yytext; return yy_token_match(CONCAT, yytext); }
{DATETIME}				{ /*DATETIME*/ *yylval= yytext; return yy_token_match(DATETIME, yytext); }
{RAID_CHUNKSIZE}				{ /*RAID_CHUNKSIZE*/ *yylval= yytext; return yy_token_match(RAID_CHUNKSIZE, yytext); }
{CACHE_SYM}				{ /*CACHE_SYM*/ *yylval= yytext; return yy_token_match(CACHE_SYM, yytext); }
{STORAGE_SYM}				{ /*STORAGE_SYM*/ *yylval= yytext; return yy_token_match(STORAGE_SYM, yytext); }
{AGAINST}				{ /*AGAINST*/ *yylval= yytext; return yy_token_match(AGAINST, yytext); }
{NONE_SYM}				{ /*NONE_SYM*/ *yylval= yytext; return yy_token_match(NONE_SYM, yytext); }
{LEVEL_SYM}				{ /*LEVEL_SYM*/ *yylval= yytext; return yy_token_match(LEVEL_SYM, yytext); }
{MULTIPOLYGON}				{ /*MULTIPOLYGON*/ *yylval= yytext; return yy_token_match(MULTIPOLYGON, yytext); }
{RECOVER_SYM}				{ /*RECOVER_SYM*/ *yylval= yytext; return yy_token_match(RECOVER_SYM, yytext); }
{MINUTE_SECOND_SYM}				{ /*MINUTE_SECOND_SYM*/ *yylval= yytext; return yy_token_match(MINUTE_SECOND_SYM, yytext); }
{YEAR_MONTH_SYM}				{ /*YEAR_MONTH_SYM*/ *yylval= yytext; return yy_token_match(YEAR_MONTH_SYM, yytext); }
{ASCII_SYM}				{ /*ASCII_SYM*/ *yylval= yytext; return yy_token_match(ASCII_SYM, yytext); }
{POLYGON}				{ /*POLYGON*/ *yylval= yytext; return yy_token_match(POLYGON, yytext); }
{TEXT_SYM}				{ /*TEXT_SYM*/ *yylval= yytext; return yy_token_match(TEXT_SYM, yytext); }
{EXIT_SYM}				{ /*EXIT_SYM*/ *yylval= yytext; return yy_token_match(EXIT_SYM, yytext); }
{ROUTINE_SYM}				{ /*ROUTINE_SYM*/ *yylval= yytext; return yy_token_match(ROUTINE_SYM, yytext); }
{TRIGGER_SYM}				{ /*TRIGGER_SYM*/ *yylval= yytext; return yy_token_match(TRIGGER_SYM, yytext); }
{CASCADE}				{ /*CASCADE*/ *yylval= yytext; return yy_token_match(CASCADE, yytext); }
{SQLSTATE_SYM}				{ /*SQLSTATE_SYM*/ *yylval= yytext; return yy_token_match(SQLSTATE_SYM, yytext); }
{BOOLEAN_SYM}				{ /*BOOLEAN_SYM*/ *yylval= yytext; return yy_token_match(BOOLEAN_SYM, yytext); }
{LONG_SYM}				{ /*LONG_SYM*/ *yylval= yytext; return yy_token_match(LONG_SYM, yytext); }
{REPAIR}				{ /*REPAIR*/ *yylval= yytext; return yy_token_match(REPAIR, yytext); }
{FALSE_SYM}				{ /*FALSE_SYM*/ *yylval= yytext; return yy_token_match(FALSE_SYM, yytext); }
{MAKE_SET_SYM}				{ /*MAKE_SET_SYM*/ *yylval= yytext; return yy_token_match(MAKE_SET_SYM, yytext); }
{VARCHAR}				{ /*VARCHAR*/ *yylval= yytext; return yy_token_match(VARCHAR, yytext); }
{HASH_SYM}				{ /*HASH_SYM*/ *yylval= yytext; return yy_token_match(HASH_SYM, yytext); }
{IGNORE_SYM}				{ /*IGNORE_SYM*/ *yylval= yytext; return yy_token_match(IGNORE_SYM, yytext); }
{SQL_THREAD}				{ /*SQL_THREAD*/ *yylval= yytext; return yy_token_match(SQL_THREAD, yytext); }
{CURRENT_USER}				{ /*CURRENT_USER*/ *yylval= yytext; return yy_token_match(CURRENT_USER, yytext); }
{MODE_SYM}				{ /*MODE_SYM*/ *yylval= yytext; return yy_token_match(MODE_SYM, yytext); }
{ISSUER_SYM}				{ /*ISSUER_SYM*/ *yylval= yytext; return yy_token_match(ISSUER_SYM, yytext); }
{UNCOMMITTED_SYM}				{ /*UNCOMMITTED_SYM*/ *yylval= yytext; return yy_token_match(UNCOMMITTED_SYM, yytext); }
{CIPHER_SYM}				{ /*CIPHER_SYM*/ *yylval= yytext; return yy_token_match(CIPHER_SYM, yytext); }
{REFERENCES}				{ /*REFERENCES*/ *yylval= yytext; return yy_token_match(REFERENCES, yytext); }
{ELSEIF_SYM}				{ /*ELSEIF_SYM*/ *yylval= yytext; return yy_token_match(ELSEIF_SYM, yytext); }
{SIGNED_SYM}				{ /*SIGNED_SYM*/ *yylval= yytext; return yy_token_match(SIGNED_SYM, yytext); }
{TYPE_SYM}				{ /*TYPE_SYM*/ *yylval= yytext; return yy_token_match(TYPE_SYM, yytext); }
{ALL}				{ /*ALL*/ *yylval= yytext; return yy_token_match(ALL, yytext); }
{DYNAMIC_SYM}				{ /*DYNAMIC_SYM*/ *yylval= yytext; return yy_token_match(DYNAMIC_SYM, yytext); }
{CURSOR_SYM}				{ /*CURSOR_SYM*/ *yylval= yytext; return yy_token_match(CURSOR_SYM, yytext); }
{INSERT}				{ /*INSERT*/ *yylval= yytext; return yy_token_match(INSERT, yytext); }
{DISABLE_SYM}				{ /*DISABLE_SYM*/ *yylval= yytext; return yy_token_match(DISABLE_SYM, yytext); }
{VARYING}				{ /*VARYING*/ *yylval= yytext; return yy_token_match(VARYING, yytext); }
{UTC_TIME_SYM}				{ /*UTC_TIME_SYM*/ *yylval= yytext; return yy_token_match(UTC_TIME_SYM, yytext); }
{BINLOG_SYM}				{ /*BINLOG_SYM*/ *yylval= yytext; return yy_token_match(BINLOG_SYM, yytext); }
{BENCHMARK_SYM}				{ /*BENCHMARK_SYM*/ *yylval= yytext; return yy_token_match(BENCHMARK_SYM, yytext); }
{PHASE_SYM}				{ /*PHASE_SYM*/ *yylval= yytext; return yy_token_match(PHASE_SYM, yytext); }
{SUPER_SYM}				{ /*SUPER_SYM*/ *yylval= yytext; return yy_token_match(SUPER_SYM, yytext); }
{TINYTEXT}				{ /*TINYTEXT*/ *yylval= yytext; return yy_token_match(TINYTEXT, yytext); }
{DAY_SECOND_SYM}				{ /*DAY_SECOND_SYM*/ *yylval= yytext; return yy_token_match(DAY_SECOND_SYM, yytext); }
{UNLOCK_SYM}				{ /*UNLOCK_SYM*/ *yylval= yytext; return yy_token_match(UNLOCK_SYM, yytext); }
{SEPARATOR_SYM}				{ /*SEPARATOR_SYM*/ *yylval= yytext; return yy_token_match(SEPARATOR_SYM, yytext); }
{TYPES_SYM}				{ /*TYPES_SYM*/ *yylval= yytext; return yy_token_match(TYPES_SYM, yytext); }
{LAST_INSERT_ID}				{ /*LAST_INSERT_ID*/ *yylval= yytext; return yy_token_match(LAST_INSERT_ID, yytext); }
{GEOMFROMWKB}				{ /*GEOMFROMWKB*/ *yylval= yytext; return yy_token_match(GEOMFROMWKB, yytext); }
{DATABASES}				{ /*DATABASES*/ *yylval= yytext; return yy_token_match(DATABASES, yytext); }
{DATA_SYM}				{ /*DATA_SYM*/ *yylval= yytext; return yy_token_match(DATA_SYM, yytext); }
{MINUTE_MICROSECOND_SYM}				{ /*MINUTE_MICROSECOND_SYM*/ *yylval= yytext; return yy_token_match(MINUTE_MICROSECOND_SYM, yytext); }
{TABLESPACE}				{ /*TABLESPACE*/ *yylval= yytext; return yy_token_match(TABLESPACE, yytext); }
{ANY_SYM}				{ /*ANY_SYM*/ *yylval= yytext; return yy_token_match(ANY_SYM, yytext); }
{RESOURCES}				{ /*RESOURCES*/ *yylval= yytext; return yy_token_match(RESOURCES, yytext); }
{TRIGGERS_SYM}				{ /*TRIGGERS_SYM*/ *yylval= yytext; return yy_token_match(TRIGGERS_SYM, yytext); }
{CUBE_SYM}				{ /*CUBE_SYM*/ *yylval= yytext; return yy_token_match(CUBE_SYM, yytext); }
{MOD_SYM}				{ /*MOD_SYM*/ *yylval= yytext; return yy_token_match(MOD_SYM, yytext); }
{COLUMN_SYM}				{ /*COLUMN_SYM*/ *yylval= yytext; return yy_token_match(COLUMN_SYM, yytext); }
{RAID_0_SYM}				{ /*RAID_0_SYM*/ *yylval= yytext; return yy_token_match(RAID_0_SYM, yytext); }
{REQUIRE_SYM}				{ /*REQUIRE_SYM*/ *yylval= yytext; return yy_token_match(REQUIRE_SYM, yytext); }
{UNIX_TIMESTAMP}				{ /*UNIX_TIMESTAMP*/ *yylval= yytext; return yy_token_match(UNIX_TIMESTAMP, yytext); }
{TIME_SYM}				{ /*TIME_SYM*/ *yylval= yytext; return yy_token_match(TIME_SYM, yytext); }
{ENCLOSED}				{ /*ENCLOSED*/ *yylval= yytext; return yy_token_match(ENCLOSED, yytext); }
{DES_KEY_FILE}				{ /*DES_KEY_FILE*/ *yylval= yytext; return yy_token_match(DES_KEY_FILE, yytext); }
{WRITE_SYM}				{ /*WRITE_SYM*/ *yylval= yytext; return yy_token_match(WRITE_SYM, yytext); }
{NOW_SYM}				{ /*NOW_SYM*/ *yylval= yytext; return yy_token_match(NOW_SYM, yytext); }
{CONSISTENT_SYM}				{ /*CONSISTENT_SYM*/ *yylval= yytext; return yy_token_match(CONSISTENT_SYM, yytext); }
{LEFT}				{ /*LEFT*/ *yylval= yytext; return yy_token_match(LEFT, yytext); }
{DECODE_SYM}				{ /*DECODE_SYM*/ *yylval= yytext; return yy_token_match(DECODE_SYM, yytext); }
{MERGE_SYM}				{ /*MERGE_SYM*/ *yylval= yytext; return yy_token_match(MERGE_SYM, yytext); }
{PURGE}				{ /*PURGE*/ *yylval= yytext; return yy_token_match(PURGE, yytext); }
{MASTER_USER_SYM}				{ /*MASTER_USER_SYM*/ *yylval= yytext; return yy_token_match(MASTER_USER_SYM, yytext); }
{MASTER_SSL_CA_SYM}				{ /*MASTER_SSL_CA_SYM*/ *yylval= yytext; return yy_token_match(MASTER_SSL_CA_SYM, yytext); }
{CHAR_SYM}				{ /*CHAR_SYM*/ *yylval= yytext; return yy_token_match(CHAR_SYM, yytext); }
{SYSDATE}				{ /*SYSDATE*/ *yylval= yytext; return yy_token_match(SYSDATE, yytext); }
{WORK_SYM}				{ /*WORK_SYM*/ *yylval= yytext; return yy_token_match(WORK_SYM, yytext); }
{LOCK_SYM}				{ /*LOCK_SYM*/ *yylval= yytext; return yy_token_match(LOCK_SYM, yytext); }
{CONVERT_TZ_SYM}				{ /*CONVERT_TZ_SYM*/ *yylval= yytext; return yy_token_match(CONVERT_TZ_SYM, yytext); }
{ISOLATION}				{ /*ISOLATION*/ *yylval= yytext; return yy_token_match(ISOLATION, yytext); }
{JOIN_SYM}				{ /*JOIN_SYM*/ *yylval= yytext; return yy_token_match(JOIN_SYM, yytext); }
{UNKNOWN_SYM}				{ /*UNKNOWN_SYM*/ *yylval= yytext; return yy_token_match(UNKNOWN_SYM, yytext); }
{IS}				{ /*IS*/ *yylval= yytext; return yy_token_match(IS, yytext); }
{ORDER_SYM}				{ /*ORDER_SYM*/ *yylval= yytext; return yy_token_match(ORDER_SYM, yytext); }
{DATE_SYM}				{ /*DATE_SYM*/ *yylval= yytext; return yy_token_match(DATE_SYM, yytext); }
{LOW_PRIORITY}				{ /*LOW_PRIORITY*/ *yylval= yytext; return yy_token_match(LOW_PRIORITY, yytext); }
{REPLACE}				{ /*REPLACE*/ *yylval= yytext; return yy_token_match(REPLACE, yytext); }
{SERIAL_SYM}				{ /*SERIAL_SYM*/ *yylval= yytext; return yy_token_match(SERIAL_SYM, yytext); }
{SHUTDOWN}				{ /*SHUTDOWN*/ *yylval= yytext; return yy_token_match(SHUTDOWN, yytext); }
{ACTION}				{ /*ACTION*/ *yylval= yytext; return yy_token_match(ACTION, yytext); }
{ASC}				{ /*ASC*/ *yylval= yytext; return yy_token_match(ASC, yytext); }
{LANGUAGE_SYM}				{ /*LANGUAGE_SYM*/ *yylval= yytext; return yy_token_match(LANGUAGE_SYM, yytext); }
{ENABLE_SYM}				{ /*ENABLE_SYM*/ *yylval= yytext; return yy_token_match(ENABLE_SYM, yytext); }
{FILE_SYM}				{ /*FILE_SYM*/ *yylval= yytext; return yy_token_match(FILE_SYM, yytext); }
{SNAPSHOT_SYM}				{ /*SNAPSHOT_SYM*/ *yylval= yytext; return yy_token_match(SNAPSHOT_SYM, yytext); }
{ASENSITIVE_SYM}				{ /*ASENSITIVE_SYM*/ *yylval= yytext; return yy_token_match(ASENSITIVE_SYM, yytext); }
{START_SYM}				{ /*START_SYM*/ *yylval= yytext; return yy_token_match(START_SYM, yytext); }
{PASSWORD}				{ /*PASSWORD*/ *yylval= yytext; return yy_token_match(PASSWORD, yytext); }
{RESUME_SYM}				{ /*RESUME_SYM*/ *yylval= yytext; return yy_token_match(RESUME_SYM, yytext); }
{POLYFROMTEXT}				{ /*POLYFROMTEXT*/ *yylval= yytext; return yy_token_match(POLYFROMTEXT, yytext); }
{CROSS}				{ /*CROSS*/ *yylval= yytext; return yy_token_match(CROSS, yytext); }
{SECURITY_SYM}				{ /*SECURITY_SYM*/ *yylval= yytext; return yy_token_match(SECURITY_SYM, yytext); }
{STOP_SYM}				{ /*STOP_SYM*/ *yylval= yytext; return yy_token_match(STOP_SYM, yytext); }
{HOUR_SECOND_SYM}				{ /*HOUR_SECOND_SYM*/ *yylval= yytext; return yy_token_match(HOUR_SECOND_SYM, yytext); }
{SQL_SYM}				{ /*SQL_SYM*/ *yylval= yytext; return yy_token_match(SQL_SYM, yytext); }
{ENCODE_SYM}				{ /*ENCODE_SYM*/ *yylval= yytext; return yy_token_match(ENCODE_SYM, yytext); }
{MODIFY_SYM}				{ /*MODIFY_SYM*/ *yylval= yytext; return yy_token_match(MODIFY_SYM, yytext); }
{RESET_SYM}				{ /*RESET_SYM*/ *yylval= yytext; return yy_token_match(RESET_SYM, yytext); }
{SELECT_SYM}				{ /*SELECT_SYM*/ *yylval= yytext; return yy_token_match(SELECT_SYM, yytext); }
{WARNINGS}				{ /*WARNINGS*/ *yylval= yytext; return yy_token_match(WARNINGS, yytext); }
{DUAL_SYM}				{ /*DUAL_SYM*/ *yylval= yytext; return yy_token_match(DUAL_SYM, yytext); }
{IN_SYM}				{ /*IN_SYM*/ *yylval= yytext; return yy_token_match(IN_SYM, yytext); }
{PREV_SYM}				{ /*PREV_SYM*/ *yylval= yytext; return yy_token_match(PREV_SYM, yytext); } 

{DIGIT}           { *yylval= strcpy(malloc(strlen(yytext)+1), yytext); return yy_token_match(NUM, yytext); }
{DIGIT}("."{DIGIT})?(("e"|"E")("+"|"-")?{DIGIT})? { *yylval= strcpy(malloc(strlen(yytext)+1), yytext); return yy_token_match(FLOAT_NUM, yytext); }
x'{HEXDIGIT}'     { *yylval= strcpy(malloc(strlen(yytext)+1), yytext); return yy_token_match(HEX_NUM, yytext); }
b'{BINDIGIT}'     { *yylval= strcpy(malloc(strlen(yytext)+1), yytext); return yy_token_match(BIN_NUM, yytext); }
{IDENT}           { *yylval= strcpy(malloc(strlen(yytext)+1), yytext); return yy_token_match(IDENT, yytext); }
`[^`\r\n]*`       { *yylval= strcpy(malloc(strlen(yytext)+1), yytext); return yy_token_match(QUOTED, yytext); }

":"               { *yylval= yytext; return yy_token_match(COL_SYM, yytext); }
"<"               { *yylval= yytext; return yy_token_match(LT_SYM, yytext); }
">"               { *yylval= yytext; return yy_token_match(GT_SYM, yytext); }
"="               { *yylval= yytext; return yy_token_match(EQ, yytext); }
"\."              { *yylval= yytext; return yy_token_match(DOT_SYM, yytext); }
"&&"              { *yylval= yytext; return yy_token_match(ANDAND_SYM, yytext); }
">="              { *yylval= yytext; return yy_token_match(GE_SYM, yytext); }
"<="              { *yylval= yytext; return yy_token_match(LE_SYM, yytext); }
">>"              { *yylval= yytext; return yy_token_match(SHR_SYM, yytext); }
"<<"              { *yylval= yytext; return yy_token_match(SHL_SYM, yytext); }
"||"              { *yylval= yytext; return yy_token_match(OROR_SYM, yytext); }
"<>"              { *yylval= yytext; return yy_token_match(NE_SYM, yytext); }
"!="              { *yylval= yytext; return yy_token_match(NE_SYM, yytext); }
"<=>"             { *yylval= yytext; return yy_token_match(EQUAL_SYM, yytext); }
":="              { *yylval= yytext; return yy_token_match(SET_VAR, yytext); }
"("               { *yylval= yytext; return yy_token_match(LP_SYM, yytext); }
")"               { *yylval= yytext; return yy_token_match(RP_SYM, yytext); }
","               { *yylval= yytext; return yy_token_match(COMMA_SYM, yytext); }
"%"               { *yylval= yytext; return yy_token_match(PERCENT_SYM, yytext); }
";"               { *yylval= yytext; return yy_token_match(SEMICOL_SYM, yytext); }
"@"               { *yylval= yytext; return yy_token_match(AT_SYM, yytext); }
"?"               { *yylval= yytext; return yy_token_match(PARAM_MARKER, yytext); }
"!"               { *yylval= yytext; return yy_token_match(NOT_EXCL_MARKER, yytext); }
"+"               { *yylval= yytext; return yy_token_match(PLUS_SYM, yytext); }
"-"               { *yylval= yytext; return yy_token_match(MINUS_SYM, yytext); }
"*"               { *yylval= yytext; return yy_token_match(MULL_SYM, yytext); }
"/"               { *yylval= yytext; return yy_token_match(DIV_DIV_SYM, yytext); }
"^"               { *yylval= yytext; return yy_token_match(UP_SYM, yytext); }
"|"               { *yylval= yytext; return yy_token_match(VERT_LINE_SYM, yytext); }
"&"               { *yylval= yytext; return yy_token_match(BITAND_SYM, yytext); }
"{"               { *yylval= yytext; return yy_token_match(CLB_SYM, yytext); }
"}"               { *yylval= yytext; return yy_token_match(CRB_SYM, yytext); }

\'                { 
                    BEGIN(str1); 
                    if(str_buffer == 0) {
                      str_buffer= malloc(128); str_buffer_size= 128; 
                    }
                    str_buffer_ptr= str_buffer;
                    *str_buffer_ptr++= *yytext;
                  }
<str1,str2>\n     { yy_unknown_token(yytext); }
<str1,str2>\r     { yy_unknown_token(yytext); }
<str1,str2>\\.    { 
                    /* comsume a string char */
                    while(str_buffer + str_buffer_size < str_buffer_ptr + yyleng) {
                      realloc_str_buffer();
                    }
                    *str_buffer_ptr++= yytext[0];
                    *str_buffer_ptr++= yytext[1];
                  }
<str1>[^\\\n\r\']+ { 
                    /* comsume a string char */
                    while(str_buffer + str_buffer_size < str_buffer_ptr + yyleng) {
                      realloc_str_buffer();
                    }
                    memcpy(str_buffer_ptr, yytext, yyleng);
                    str_buffer_ptr+= yyleng;
                  }
<str1>\'          { 
                    /* comsume a string char */
                    while(str_buffer + str_buffer_size < str_buffer_ptr + yyleng + 1) {
                      realloc_str_buffer();
                    }
                    *str_buffer_ptr++= *yytext;
                    *str_buffer_ptr++= '\0';
                    BEGIN(INITIAL);
                    *yylval= str_buffer; return yy_token_match(STRING, str_buffer);
                  }

\"                { 
                    BEGIN(str2); 
                    if(str_buffer == 0) {
                      str_buffer= malloc(128); str_buffer_size= 128; 
                    }
                    str_buffer_ptr= str_buffer;
                    *str_buffer_ptr++= *yytext;
                  }
<str2>[^\\\n\r\"]+ { 
                    /* comsume a string char */
                    while(str_buffer + str_buffer_size < str_buffer_ptr + yyleng) {
                      realloc_str_buffer();
                    }
                    memcpy(str_buffer_ptr, yytext, yyleng);
                    str_buffer_ptr+= yyleng;
                  } 
<str2>\"          { 
                    /* comsume a string char */
                    while(str_buffer + str_buffer_size < str_buffer_ptr + yyleng + 1) {
                      realloc_str_buffer();
                    }
                    *str_buffer_ptr++= *yytext;
                    *str_buffer_ptr++= '\0';
                    BEGIN(INITIAL);
                    *yylval= str_buffer; return yy_token_match(STRING, str_buffer);
                  }

"/*"              { BEGIN(comment); }
<comment>[^*]*    { /* eat anything that's not a '*' */ }
<comment>"*"+[^*/]* { /* eat up '*'s not followed by '/'s */ }
<comment>"*"+"/"  { BEGIN(INITIAL); }

<INITIAL>#[^\n\r]*         { /* comment */ }
<INITIAL>--[^\n\r]*        { /* comment */ }

<INITIAL>[ \t\n\r]+  /* eat up whitespace */

<<EOF>>           { return 0; }

.                 { yy_unknown_token(yytext); }
 
%%
