@echo off
cls

echo .
echo MySQL Workbench Release Build Script
echo --------------------------------------------------------------------------------
echo This script will create a runtime image of the MySQL Workbench
echo in a special release folder above the project folder, which gets also
echo all DLLs and working files.
echo .

call ..\common\build\ParseCommandline.cmd %1 %2 %3 %4 %5 %6 %7 %8 %9

echo Cleaning previous builds...
if exist ..\release\intermediate del ..\release\intermediate\*.* /S /Q > nul 2> nul
if exist ..\release\MySQLWorkbench.exe del ..\release\MySQLWorkbench.exe
echo .

echo Preparing application folder ...
pushd build
call PrepareReleaseFolder.cmd
popd
echo.
if errorlevel 1 goto error

if %copyThirdParty% == 1 (
  echo --------------------------------------------------------------------------------
  echo Copying third-party libraries...
  echo --------------------------------------------------------------------------------
  pushd ..\common\build
  call Copy3rdPartyLibraries.cmd ..\..\release
  popd
  echo.
  if errorlevel 1 goto error
)

rem Compile all resource files.
pushd source\windows
call ..\..\..\common\build\BuildResourceFiles.cmd MySQLWorkbench.dpr
popd
echo.
if errorlevel 1 goto error

if %compileCommon% == 1 (
  echo Compiling common libraries...
  pushd ..\common\
  call BuildRelease.cmd
  popd
  echo.
  if errorlevel 1 goto error
)

echo ================================================================================
echo Building Workbench application
echo --------------------------------------------------------------------------------
pushd source\windows
dcc32 -$A8 -$B- -$C- -$D- -$E- -$F- -$G+ -$H+ -$I- -$J- -$K+ -$L- -$M- -$N+ -$O+ -$P+ -$Q- -$R- -$S- -$T- -$U- -$V+ -$W- -$X+ -$Y- -H+ -W -$M4096,1048576 -$K4194304 -B -CG -E..\..\..\release -N0..\..\..\release\intermediate -O"%ProgramFiles%\borland\bds\4.0\lib";"%ProgramFiles%\borland\bds\4.0\Imports" -R"%ProgramFiles%\borland\bds\4.0\lib";"%ProgramFiles%\borland\bds\4.0\Imports";..\..\..\common\source\windows\Unicode\Resources -NSBorland.Vcl -LE..\..\..\release -LN..\..\..\release -AWinTypes=Windows;WinProcs=Windows;DbiTypes=BDE;DbiProcs=BDE;DbiErrs=BDE; -NO..\..\..\release\intermediate -NB..\..\..\release\intermediate -W-UNSAFE_TYPE -W-UNSAFE_CODE -W-UNSAFE_CAST -U..\..\..\common\source\windows\Common;..\..\..\common\source\windows;..\..\..\common\source\windows\png;..\..\..\common\source\windows\TNT;..\..\..\common\source\windows\VirtualTreeView\Source;..\..\..\common\source\windows\embeddedwb;..\..\..\common\source\windows\UniCodeEditor\Source;..\..\..\common\source\windows\GenericCanvasViewer\Source;..\..\..\common\source\windows\tools;..\..\..\common\source\windows\Unicode\Source;"%ProgramFiles%\borland\bds\4.0\lib";"%ProgramFiles%\borland\bds\4.0\Imports" -O..\..\..\common\obj\Windows -I..\..\..\common\source\windows\Common --no-config MySQLWorkbench.dpr -Q
popd
echo.
if errorlevel 1 goto error

echo ================================================================================
echo Fetching Docs
echo --------------------------------------------------------------------------------
pushd build
call UpdateDocs.cmd
popd


if %cleanUp% == 1 (
  echo --------------------------------------------------------------------------------
  echo Do some housekeeping...
  echo --------------------------------------------------------------------------------
  pushd ..\common\build
  call CleanupRelease.cmd
  popd
)

if not errorlevel 1 goto finish

:error
echo ##### Batch build cannot be fully completed due to an problem. #####
goto end

:finish
echo --------------------------------------------------------------------------------
echo Finished Workbench successfully.
echo ================================================================================

:end