//
//  MWSynchronizeDB.m
//  MySQL Workbench
//
//  Created by Alfredo Kojima on 05/8/30.
//  Copyright 2005, 2006 MySQL AB. All rights reserved.
//

#import "MWSynchronizeDB.h"
#import <MySQLGRT/MGRTRevEngFilterPane.h>
#import <MySQLToolsCommon/myxutil.h>
#import <MySQLToolsCommon/mxUtils.h>
#import <MySQLToolsCommon/MVerticalBox.h>
#import <MySQLToolsCommon/MTextImageCell.h>

@implementation MWSynchronizeDB

- (id)initWithMGRT:(MGRT*)grt
{
  self= [super initWithWindowNibName:@"SynchronizeDB"];
  if (self)
  {
    _grt= [grt retain];
    [tabView selectFirstTabViewItem:nil];

    [self loadWindow];

    _taskUnchecked= [[NSImage imageNamed:@"task_unchecked"] retain];
    _taskChecked= [[NSImage imageNamed:@"task_checked"] retain];
    _taskError= [[NSImage imageNamed:@"task_error"] retain];
    _taskDisabled= [[NSImage imageNamed:@"task_disabled"] retain];
    
    _tableIcon= [[NSImage imageNamed:@"db.Table.16x16"] retain];
    _viewIcon= [[NSImage imageNamed:@"db.View.16x16"] retain];
    _schemaIcon= [[NSImage imageNamed:@"db.Schema.16x16"] retain];
    _routineIcon= [[NSImage imageNamed:@"db.Routine.16x16"] retain];

    _section= 0;
    _schemaListObjects= [[NSMutableArray alloc] init];
    
    MGRTValue sync(MGRTValue::createObject([_grt grt], "db.DatabaseSync", "DatabaseSync"));
    [_grt setGlobalValue:sync.grtValue() forPath:"/databaseSync"];
  }
  return self;
}



- (void)dealloc 
{
  [_taskUnchecked release];
  [_taskChecked release];
  [_taskError release];
  [_taskDisabled release];
  
  [_syncObjects release];
  [_schemaListObjects release];

  delete _catalog;
  delete _schemaList;
  
  [[NSNotificationCenter defaultCenter] removeObserver:self];
  [_grt release];
  [super dealloc];
}


- (void)awakeFromNib
{
  NSView *rdbmsV;
  NSView *paramsV;
  NSView *advParamsV;

  [scriptEditor setShowGutter:NO];
  [[scriptEditor textView] setEditable:NO];
  
  _connPanel= [[MGRTConnectionPanel alloc] initWithMGRT:_grt
                                        connectionsPath:@"/rdbmsMgmt"
                                             targetPath:@"/workbench/connection"];
  [_connPanel setDelegate:self];

  rdbmsV= [_connPanel rdbmsPanel];
  paramsV= [_connPanel paramsPanel];
  advParamsV= [_connPanel advParamsPanel]; 
  
  [rdbmsV retain];
  [rdbmsV removeFromSuperview];
  [rdbmsBox addSubview:rdbmsV];
  [rdbmsV release];

  [rdbmsV setFrame:NSMakeRect(16, 11, NSWidth([rdbmsBox frame])-32, NSHeight([rdbmsV frame]))];
  
  
  [paramsV retain];
  [paramsV removeFromSuperview];
  [paramBox addSubview:paramsV];
  [paramsV release];
  [paramsV setPostsFrameChangedNotifications:YES];
  
  [[NSNotificationCenter defaultCenter] addObserver:self
                                           selector:@selector(panelResized:)
                                               name:NSViewFrameDidChangeNotification
                                             object:paramsV];
    
  [paramsV setFrame:NSMakeRect(16, 11, NSWidth([paramBox frame])-32, NSHeight([paramBox frame])-35)];
  
  [advParamsV retain];
  [advParamsV removeFromSuperview];
  [advParamBox addSubview:advParamsV];
  [advParamsV release];
  [advParamsV setPostsFrameChangedNotifications:YES];
  
  [[NSNotificationCenter defaultCenter] addObserver:self
                                           selector:@selector(panelResized:)
                                               name:NSViewFrameDidChangeNotification
                                             object:advParamsV];
  
  [advParamsV setFrame:NSMakeRect(16, 11, NSWidth([advParamBox frame])-32, NSHeight([advParamBox frame])-35)];
  
  
  [_connPanel setSelectRdbms];
  // add the connect panel pieces
  [_connPanel refreshRdbmsInfo];

  _syncObjects= [[NSMutableDictionary alloc] init];  
  
  [[[syncTree tableColumnWithIdentifier:@"action"] dataCell] addItemWithTitle:@"No Changes"];
  [[[syncTree tableColumnWithIdentifier:@"action"] dataCell] addItemWithTitle:[NSString stringWithUTF8String:"← Update DB"]];
  [[[syncTree tableColumnWithIdentifier:@"action"] dataCell] addItemWithTitle:[NSString stringWithUTF8String:"Update Model →"]];
}


- (void)connectionPanel:(MGRTConnectionPanel*)panel readinessChanged:(BOOL)flag
{
  if (_section == 0)
  {
    [nextButton setEnabled:flag];
  }
}


- (void)panelResized:(NSNotification*)notif
{
  if ([notif object] == [_connPanel paramsPanel])
  {
    [[_connPanel paramsPanel] setFrame:NSMakeRect(16, 11, NSWidth([paramBox frame])-32, NSHeight([paramBox frame])-35)];
  }
  else
  {
    [[_connPanel advParamsPanel] setFrame:NSMakeRect(16, 11, NSWidth([advParamBox frame])-32, NSHeight([advParamBox frame])-35)];
  }
}



- (void)addLogText:(NSString*)text
{
  [[logText textStorage] appendAttributedString:[[[NSAttributedString alloc] initWithString:text] autorelease]];
}


- (void)beginWork
{
  [sakila setImage:[NSImage imageNamed:@"dolphin_anim.gif"]];
  [sakila setAnimates:YES];
  
  _backWasEnabled= [backButton isEnabled];
  _nextWasEnabled= [nextButton isEnabled];

  [backButton setEnabled:NO];
  [nextButton setEnabled:NO];
  [cancelButton setEnabled:NO];

  [_grt setOutputHandler:self
                selector:@selector(addLogText:)];
  [_grt setMessageHandler:self
                 selector:@selector(addLogText:)];
}


- (void)endWork
{
  [_grt resetOutputHandler];
  [_grt resetMessageHandler];
  
  [sakila setAnimates:NO];
  [sakila setImage:[NSImage imageNamed:@"sakila.png"]];
 
  [backButton setEnabled:_backWasEnabled];
  [nextButton setEnabled:_nextWasEnabled];
  [cancelButton setEnabled:YES];
}


- (void)performSchemataFetches:(BOOL)goingBack
{
  const char *revEngModule;
  MYX_GRT_VALUE *result;
  
  MGRTValue connection([_connPanel writeConnectionToTarget]);

  [caption setStringValue:@"Source Schemata"];
  [description setStringValue:@"The list of available schemata is fetched."];

  revEngModule= connection["modules"]["ReverseEngineeringModule"].asString();
  
  [connImage setImage:_taskUnchecked];
  [schemaListImage setImage:_taskUnchecked];
  
  [fetchSchemaResult setHidden:YES];
  
  [tabView selectTabViewItemAtIndex:_section];

  [backButton setEnabled:YES];
  [nextButton setEnabled:YES];

  if (goingBack)
    return;
  
  [self beginWork];
  
  [_grt outText:@"Fetching schemata...\n"];

  if (_schemaList)
    delete _schemaList;
  _schemaList= 0;

  result= [_grt performModule:NSStr(revEngModule)
                     function:@"getSchemata"
                    arguments:[NSArray arrayWithObject:[NSValue valueWithPointer:[_grt globalValue:"/workbench/connection"]]]];
  if (result)
  {
    [connImage setImage:_taskChecked];
    [schemaListImage setImage:_taskChecked];
    [fetchSchemaResult setHidden:NO];
    
    [_grt outText:@"Schemata fetched.\n"];
    
    _schemaList= new MGRTValue(result);
  }
  else
  {
    [connImage setImage:_taskError];
    [schemaListImage setImage:_taskError];

    [_grt outText:[NSString stringWithFormat:@"The list of schema names could not be retrieved (error: %i)\n%@\n",
      [_grt lastError], [_grt lastErrorDescription]]];
    if ([fetchSchemaAdvBox isHidden])
      [self showDetails:nil];
  }

  [self endWork];
}


- (void)refreshSchemataList
{
  [_schemaListObjects removeAllObjects];
  for (int i= 0; i < _schemaList->count(); i++)
  {
    [_schemaListObjects addObject:[NSString stringWithFormat:@"0%s", (*_schemaList)[i].asString()]];
  }
  
  
  [schemaSelectionList reloadData];
  
  [nextButton setEnabled:NO];
}


- (void)performSchemataSelection:(BOOL)goingBack
{
  MGRTValue connection([_connPanel writeConnectionToTarget]);

  [tabView selectTabViewItemAtIndex:_section];
  
  [caption setStringValue:@"Schema Selection"];
  [description setStringValue:@"Please select the schemata to reverse engineer."];
  
  [backButton setEnabled:YES];
  [nextButton setEnabled:YES];
  
  if (goingBack)
    return;
  
  [self refreshSchemataList];
  
  [[[[schemaSelectionList enclosingScrollView] superview] viewWithTag:1] setStringValue:[NSString stringWithFormat:@"%i items selected.", 0]];
}


- (void)performReverseEngineering:(BOOL)goingBack
{
  const char *revEngModule;
  MYX_GRT_VALUE *result;
  
  MGRTValue connection([_connPanel writeConnectionToTarget]);
  
  [caption setStringValue:@"Process Changes"];
  [description setStringValue:@"The database schemata is fetched and compared with the model."];
  
  
  revEngModule= connection["modules"]["ReverseEngineeringModule"].asString();
  
  [revEngImage setImage:_taskUnchecked];
  [getChangesImage setImage:_taskUnchecked];

  [revEngResult setHidden:YES];
  
  [tabView selectTabViewItemAtIndex:_section];
  
  [backButton setEnabled:YES];
  
  if (goingBack)
  {
    [nextButton setEnabled:YES];
    return;
  }

  MGRTValue selectedSchemas(MGRTValue::createList(MYX_STRING_VALUE));
    
  [self beginWork];
  
  for (int i= 0; i < [_schemaListObjects count]; i++)
  {
    NSString *item= [_schemaListObjects objectAtIndex:i];
    if ([item hasPrefix:@"1"])
      selectedSchemas.append(MGRTValue([[item substringFromIndex:1] UTF8String]));
  }

  if (_catalog)
    delete _catalog;
  _catalog= 0;

  [_grt outText:@"Reverse engineering schema..."];
  
  result= [_grt performModule:NSStr(revEngModule)
                     function:@"reverseEngineer"
                    arguments:[NSArray arrayWithObjects:@"global::/workbench/connection", 
                      [NSValue valueWithPointer:selectedSchemas.grtValue()], nil]];
  if (result)
  {
    _catalog = new MGRTValue(result);

    [_grt setGlobalValue:result
                 forPath:"/databaseSync/dbCatalog"];
  
    [revEngImage setImage:_taskChecked];
    [getChangesImage setImage:_taskUnchecked];
    
    result= [_grt performModule:@"TransformationMysql"
                       function:@"getCatalogsChanges"
                      arguments:[NSArray arrayWithObjects:@"global::/workbench/catalog",
                                                 @"global::/databaseSync/dbCatalog", nil]];
    
    if ([_grt lastError] == MYX_GRT_NO_ERROR)
    {
      [getChangesImage setImage:_taskChecked];

      [_grt outText:@"Changes list retrieved.\n"];
      
      delete _changesTree;
      if (result)
        _changesTree= new MGRTValue(result);
      else
        _changesTree= 0;
      
      [revEngResult setHidden:NO];
      [_grt outText:@"Reverse engineering finished.\n"];
    }
    else
    {
      [getChangesImage setImage:_taskError];
      [_grt outText:@"Error checking for changes.\n"];
    }
  }
  else
  {
    [revEngImage setImage:_taskError];
    
    [_grt outText:[NSString stringWithFormat:@"The schema(ta) could not be reverse engineered (error: %i)\n%@\n",
      [_grt lastError], [_grt lastErrorDescription]]];
  }
  
  [self endWork];
}



- (void)performActionSelection
{
  [caption setStringValue:@"Select Actions"];
  [description setStringValue:@"Select actions to be performed for synchronization."];

  [_syncObjects removeAllObjects];
  
  [syncTree reloadData];
  
  [tabView selectTabViewItemAtIndex:_section];
}


- (void)performScriptPreview
{
  NSArray *args;
  
  [caption setStringValue:@"Preview Script"];
  [description setStringValue:@"Preview and edit the SQL script to be sent for synchronization."];
  
  [tabView selectTabViewItemAtIndex:_section];

  args= [NSArray arrayWithObject:[NSValue valueWithPointer:_changesTree->grtValue()]];
  [_grt performModule:@"TransformationMysql"
             procedure:@"getSqlChanges"
            arguments:args];

  NSString *script= [_grt performModule:@"Workbench"
                         stringFunction:@"collectSqlScript"
                              arguments:args];

  [[scriptEditor textView] setString:script];
}


- (void)finishedSynchronization:(NSDictionary*)data
{
  [self endWork];
  
  if ([data objectForKey:@"error"])
  {
    [finResult setStringValue:@"Database update failed."];
  }
  else
  {
    [finResult setStringValue:@"Database update finished."];
  }
  [finResult setHidden:NO];
}


- (void)finalizeSynchronization
{
  NSArray *args= [NSArray arrayWithObjects:
    [NSGRTValue grtValueWithValue:_changesTree->grtValue()],
    [NSGRTValue grtValueWithValue:[_connPanel writeConnectionToTarget]],
    nil];                            
  
  [caption setStringValue:@"Finalize Synchronization"];
  [description setStringValue:@"Changes will be saved to the database.\nClick on [Show More] to view the execution log."];

  [tabView selectTabViewItemAtIndex:_section];

  [self beginWork];
  [_grt performAsyncModule:@"TransformationMysql"
                  function:@"applySqlChanges"
                 arguments:args
          finishedSelector:@selector(finishedSynchronization:)
                    target:self
                  userData:nil];
}


- (void)updateSection:(BOOL)goingBack
{
  if (_section == 0)
    [backButton setEnabled:NO];
  else 
    [backButton setEnabled:YES];

  if (_section == 6)
    [nextButton setTitle:@"Finish"];
  else
    [nextButton setTitle:@"Next >"];

  
  NSView *advView= nil;  
  switch (_section)
  {
    case 0: advView= advParamBox; break;
    case 1:      
      advView= fetchSchemaAdvBox;
      [[logText enclosingScrollView] retain];
      [[logText enclosingScrollView] removeFromSuperview];
      [advView addSubview:[logText enclosingScrollView]];
      [[logText enclosingScrollView] release];
      break;
    case 3:
      advView= revEngAdvBox;
      [[logText enclosingScrollView] retain];
      [[logText enclosingScrollView] removeFromSuperview];
      [advView addSubview:[logText enclosingScrollView]];
      [[logText enclosingScrollView] release];
      break;
    case 6:
      advView= finAdvBox; 
      [[logText enclosingScrollView] retain];
      [[logText enclosingScrollView] removeFromSuperview];
      [advView addSubview:[logText enclosingScrollView]];
      [[logText enclosingScrollView] release];
      break;
  }
  if (advView)
    [detailsButton setEnabled:YES];
  else
    [detailsButton setEnabled:NO];
  
  switch (_section)
  {
    case 0:
      [caption setStringValue:@"Source Connection"];
      [description setStringValue:@"Please specify the source connection."];
      [tabView selectTabViewItemAtIndex:_section];
      break;
    case 1:
      [self performSchemataFetches:goingBack];
      break;
    case 2:
      [self performSchemataSelection:goingBack];
      break;
    case 3:
      [self performReverseEngineering:goingBack];
      break;
    case 4:
      [self performActionSelection];
      break;
    case 5:
      [self performScriptPreview];
      break;
    case 6:
      [self finalizeSynchronization];
      break;
  }
}


- (IBAction)goBack:(id)sender
{
  if (_section > 0)
  {
    _section--;
    [self updateSection:YES];
  }
}


- (IBAction)goNext:(id)sender
{
  if (_section < 6)
  {
    _section++;
    [self updateSection:NO];
  }
  else if (_section == 6)
  {
    [NSApp abortModal];
  }
}


- (IBAction)cancel:(id)sender
{
  [NSApp abortModal];
}


- (IBAction)showDetails:(id)sender
{
  _advancedShown= !_advancedShown;
  if (_advancedShown)
    [detailsButton setTitle:@"Show Less"];
  else
    [detailsButton setTitle:@"Show More"];

  [advParamBox setHidden:!_advancedShown];
  [fetchSchemaAdvBox setHidden:!_advancedShown];
  [revEngAdvBox setHidden:!_advancedShown];
  [finAdvBox setHidden:!_advancedShown];  
}




- (BOOL)run
{
  [[self window] makeKeyAndOrderFront:nil];
  [self updateSection:NO];
  [NSApp runModalForWindow:[self window]];
  [self close];
  return NO;
}


- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
  if (aTableView == schemaSelectionList)
  {
    return [_schemaListObjects count];
  }
  return 0;
}


- (void)tableView:(NSTableView *)aTableView setObjectValue:(id)anObject forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
  if (aTableView == schemaSelectionList)
  {
    if ([anObject intValue] == NSOnState)
      [_schemaListObjects replaceObjectAtIndex:rowIndex
                                    withObject:[@"1" stringByAppendingString:[[_schemaListObjects objectAtIndex:rowIndex] substringFromIndex:1]]];
    else
      [_schemaListObjects replaceObjectAtIndex:rowIndex
                                    withObject:[@"0" stringByAppendingString:[[_schemaListObjects objectAtIndex:rowIndex] substringFromIndex:1]]];        
  }
  
  int count= 0;
  for (int i= 0; i < [_schemaListObjects count]; i++)
  {
    if ([[_schemaListObjects objectAtIndex:i] hasPrefix:@"1"])
      count++;
  }
  [[[[schemaSelectionList enclosingScrollView] superview] viewWithTag:1] setStringValue:[NSString stringWithFormat:@"%i items selected.", count]];
  
  [nextButton setEnabled:count > 0];
}


- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
  if (aTableView == schemaSelectionList)
  {
    return [NSNumber numberWithInt:[[_schemaListObjects objectAtIndex:rowIndex] hasPrefix:@"1"] ? NSOnState : NSOffState];
  }
  return nil;
}


- (void)tableView:(NSTableView *)aTableView willDisplayCell:(id)aCell forTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex
{
  if (aTableView == schemaSelectionList)
  {
    [aCell setTitle:[[_schemaListObjects objectAtIndex:rowIndex] substringFromIndex:1]];
  }
}



- (int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item
{
  if (_changesTree == 0)
  {
    if (item == nil)
      return 1;
    return 0;
  }

  if (item == nil)
  {
    return 1;
  }
  else
  {
    MGRTValue value((MYX_GRT_VALUE*)[item pointerValue]);

    if (value["children"].isValid())
      return value["children"].count();
    return 0;
  }
  return 0;
}

- (id)outlineView:(NSOutlineView *)outlineView child:(int)index ofItem:(id)item
{
  MGRTValue value((MYX_GRT_VALUE*)[item pointerValue]);

  if (!value.isValid())
    value= *_changesTree;
  
  if (!value.isValid())
    return nil;

  if (value["children"].isValid())
  {
    id obj;
    id key= NSStr(value["children"][index]["_id"].asString());
    
    obj= [_syncObjects objectForKey:key];
    if (!obj)
    {
      obj= [NSValue valueWithPointer:value["children"][index].grtValue()];
    
      [_syncObjects setObject:obj forKey:key];
    }
    return obj;
  }
  
  return nil;
}

- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable:(id)item
{
  if (_changesTree == 0)
    return NO;

  MGRTValue value((MYX_GRT_VALUE*)[item pointerValue]);
    
  if (value["children"].isValid())
    return YES;
  
  return NO;
}


- (void)outlineView:(NSOutlineView *)outlineView setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn byItem:(id)item
{
  MGRTValue value((MYX_GRT_VALUE*)[item pointerValue]);
  
  if ([object intValue] == 0)
    value.set("alterDirection", 0);
  else
    value.set("alterDirection", 1);
}


- (id)outlineView:(NSOutlineView *)outlineView objectValueForTableColumn:(NSTableColumn *)tableColumn byItem:(id)item
{
  MGRTValue value((MYX_GRT_VALUE*)[item pointerValue]);
  
  if (_changesTree == 0)
  {
    return @"No Changes";
  }
  
  if ([[tableColumn identifier] isEqualToString:@"db"])
  {
    MGRTValue obj(MGRTValue::refObject([_grt grt], value["dbObject"].asString()));
    
    if (obj.isValid())
      return NSStr(obj["name"].asString());
    else
      return @"???";
  }
  else if ([[tableColumn identifier] isEqualToString:@"model"])
  {
    MGRTValue modelObj(value["modelObject"]);
    if (modelObj.isValid())
    {
      MGRTValue obj(MGRTValue::refObject([_grt grt], modelObj.asString()));
    
      if (obj.isValid())
        return NSStr(obj["name"].asString());
    }
    return @"???";
  }
  else
  {
    if (value["changed"].asInt())
      return [NSNumber numberWithInt:value["alterDirection"].isValid()?value["alterDirection"].asInt():0];
    else
      return [NSNumber numberWithInt:0];
  }
    
  
  return @"";
}


- (void)outlineView:(NSOutlineView *)outlineView willDisplayCell:(id)cell forTableColumn:(NSTableColumn *)tableColumn item:(id)item
{
  MGRTValue value((MYX_GRT_VALUE*)[item pointerValue]);
  
  if ([[tableColumn identifier] isEqualToString:@"db"]
      || [[tableColumn identifier] isEqualToString:@"model"])
  {
    const char *key;
    if ([[tableColumn identifier] isEqualToString:@"db"])
      key= "dbObject";
    else
      key= "modelObject";
    if (value[key].isValid())
    {
      MGRTValue obj(MGRTValue::refObject([_grt grt], value[key].asString()));

      if (obj.isKindOf([_grt grt], "db.Table"))
        [cell setImage:_tableIcon];
      else if (obj.isKindOf([_grt grt], "db.View"))
        [cell setImage:_viewIcon];
      else if (obj.isKindOf([_grt grt], "db.Routine"))
        [cell setImage:_routineIcon];
      else if (obj.isKindOf([_grt grt], "db.Schema"))
        [cell setImage:_schemaIcon];
      else
        [cell setImage:nil];
    }
  }
  else
  {
    if (value["changed"].asInt())
    {
      if ([cell numberOfItems] == 3)
        [cell removeItemAtIndex:0];
      [cell setEnabled:YES];
    }
    else
    {
      if ([cell numberOfItems] == 2)
      {
        [cell insertItemWithTitle:@"No Change" atIndex:0];
        [cell selectItemAtIndex:0];
      }
      [cell setEnabled:NO];
    }
  }    
}


@end
