unit Main;

// Copyright (C) 2003, 2004 MySQL AB
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of ok, the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

interface

uses
  gnugettext, Messages, TntMenus, TntComCtrls, TntForms, Windows,
  SysUtils, TntSysUtils, Variants, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, ComCtrls, Contnrs,
  StdCtrls, Clipbrd, TntDialogs, Types, TntSystem, TntStdActns,
  ActnList, TntActnList, StdActns, ExtCtrls, TntExtCtrls, TntStdCtrls,
  myx_public_interface, myx_grt_public_interface, myx_grt_builtin_module_public_interface, TntClasses,
  AuxFuncs, PNGImage, CommonFuncs, Grt, GrtWb, GrtForms,
  MyxBaseForm, MyxOptions, MyxAppOptions, MySQLCommonFuncs,
  About, XGrtShell, MyxTabHeader, Toolbar, LayerTree,
  GenericCanvasViewer, GrtObjectTree, AppInstanceMgmt,
  ReverseEngineering, VirtualTrees,
  MyxEditor, MyxTableEditor, AdvancedEdit, MyxViewEditor,
  MyxSchemaEditor, MyxRoutineGroupEditor, MyxDbUtils, Math,
  UniCodeEditor, UniCodeConsole, MyxConnectionDialog,
  DatabaseSynchronisation, StrUtils, ModelProperties,
  TntClipbrd;

{$include Consts.ini}

const
  WM_OBJECT_EDITOR_CALL = WM_APP + 9989;

type
  TWorkbenchTool = (
    wbToolArrow = 0,
    wbToolHand = 10,

    wbToolRubber = 100,

    wbToolLayer = 200,

    wbToolTable = 300,
    wbToolView = 310,
    wbToolRoutine = 320,

    wbToolRel1n = 400,
    wbToolRel11 = 410,
    wbToolRelnm = 420,

    wbToolNote = 500,
    wbToolImage = 510,

    wbToolCBSelect = 600
  );


const
  ToolArrayCursor = Integer(wbToolArrow) * -1;
  ToolHandCursor = Integer(wbToolHand) * -1;
  ToolRubberCursor = Integer(wbToolRubber) * -1;
  ToolLayerCursor = Integer(wbToolLayer) * -1;
  ToolTableCursor = Integer(wbToolTable) * -1;
  ToolViewCursor = Integer(wbToolView) * -1;
  ToolRoutineCursor = Integer(wbToolRoutine) * -1;
  ToolRel1nCursor = Integer(wbToolRel1n) * -1;
  ToolRel11Cursor = Integer(wbToolRel11) * -1;
  ToolRelnmCursor = Integer(wbToolRelnm) * -1;
  ToolNoteCursor = Integer(wbToolNote) * -1;
  ToolImageCursor = Integer(wbToolImage) * -1;
  ToolCBSelectCursor = Integer(wbToolCBSelect) * -1;

type
  TElementType = (
    ET_Unknown,
    ET_Note,
    ET_Rel,
    ET_Layer
  );

  PStatusMessage = ^TStatusMessage;
  TStatusMessage = record
    MessageString: WideString;
    Time: TDateTime;
  end;

  TMainForm = class(TMyxBaseForm, IGrtModuleImplementor,
    IOptionChangeListener)

    MainMenu: TTntMainMenu;
    FileMI: TTntMenuItem;
    Edit1: TTntMenuItem;
    ToolsMI: TTntMenuItem;
    HelpMI: TTntMenuItem;
    StatusBar: TTntStatusBar;
    ModelMI: TTntMenuItem;
    ChangeDefaultSchemaMI: TTntMenuItem;
    NewWorkbenchMI: TTntMenuItem;
    N2: TTntMenuItem;
    ManageConnectionsMI: TTntMenuItem;
    N4: TTntMenuItem;
    CloseMI: TTntMenuItem;
    OptionsMI: TTntMenuItem;
    LaunchHelpMI: TTntMenuItem;
    VisitMySQLcomMI: TTntMenuItem;
    ReportBugMI: TTntMenuItem;
    N7: TTntMenuItem;
    AboutMI: TTntMenuItem;
    SelectAllMI: TTntMenuItem;
    N10: TTntMenuItem;
    PrintMI: TTntMenuItem;
    MySQLAdministratorMI: TTntMenuItem;
    MySQLCommandLineClientMI: TTntMenuItem;
    N11: TTntMenuItem;
    WindowsCommandLineMI: TTntMenuItem;
    N12: TTntMenuItem;
    N13: TTntMenuItem;
    ListreportedBugsMI: TTntMenuItem;
    SaveMI: TTntMenuItem;
    OpenMI: TTntMenuItem;
    SaveAsMI: TTntMenuItem;
    CloseTabMI: TTntMenuItem;
    ExportResultsetMI: TTntMenuItem;
    CenterModelMI: TTntMenuItem;
    N8: TTntMenuItem;
    Database1: TTntMenuItem;
    ReverseEngineer1: TTntMenuItem;
    DatabaseSynchronisation1: TTntMenuItem;
    N14: TTntMenuItem;
    ExportSQLCreateScriptMI: TTntMenuItem;
    ExportSQLDropScriptMI: TTntMenuItem;
    ExportModelasImageMI: TTntMenuItem;
    N15: TTntMenuItem;
    ExportSelectedObjectsasImageMI: TTntMenuItem;
    ImportDBDesigner4ModelMi: TTntMenuItem;
    N16: TTntMenuItem;
    CopyToClipboardItem: TTntMenuItem;
    N17: TTntMenuItem;
    DeleteMI: TTntMenuItem;
    NotationMI: TTntMenuItem;
    EER1: TTntMenuItem;
    raditional1: TTntMenuItem;
    EER1n1: TTntMenuItem;
    TableMI: TTntMenuItem;
    TableVizDefaultMI: TTntMenuItem;
    TableVizSimpleMI: TTntMenuItem;
    N9: TTntMenuItem;
    PhysicalSchemaLevelMI: TTntMenuItem;
    N19: TTntMenuItem;
    N20: TTntMenuItem;
    DisplayGridMI: TTntMenuItem;
    CutMI: TTntMenuItem;
    CopyMI: TTntMenuItem;
    PasteMI: TTntMenuItem;
    N21: TTntMenuItem;
    AligntoGridMI: TTntMenuItem;
    BringtoFrontMI: TTntMenuItem;
    SendtoBackMI: TTntMenuItem;
    N1: TTntMenuItem;
    OnlineDocsMI: TTntMenuItem;
    PluginsMI: TTntMenuItem;
    N22: TTntMenuItem;
    N5: TTntMenuItem;
    DisplayRulersMI: TTntMenuItem;
    SnaptoGridMI: TTntMenuItem;
    N24: TTntMenuItem;
    GRTShellMI: TTntMenuItem;
    N25: TTntMenuItem;
    ActionList: TTntActionList;
    FileOpenAction: TTntAction;
    FileOpenFromDbAction: TTntAction;
    FileSaveAction: TTntAction;
    FileSaveAsAction: TTntFileSaveAs;
    FileSaveInDbAction: TTntAction;
    FileClearAction: TTntAction;
    FileExitAction: TTntFileExit;
    DisplayGridAction: TTntAction;
    SnapToGridAction: TTntAction;
    DisplayRulersAction: TTntAction;
    WindowMI: TTntMenuItem;
    AboutAction: TTntAction;
    PalettePages: TTntPageControl;
    TntTabSheet2: TTntTabSheet;
    PalInfoPnl: TTntPanel;
    TntShape2: TTntShape;
    TntLabel1: TTntLabel;
    TntLabel2: TTntLabel;
    TntEdit1: TTntEdit;
    TntEdit2: TTntEdit;
    TntTabSheet3: TTntTabSheet;
    PalColorPnl: TTntPanel;
    TntShape3: TTntShape;
    TntShape4: TTntShape;
    TntShape5: TTntShape;
    TntTabSheet4: TTntTabSheet;
    PalTransformPnl: TTntPanel;
    TntShape6: TTntShape;
    TntTabSheet5: TTntTabSheet;
    PalAlignPnl: TTntPanel;
    TntShape7: TTntShape;
    TntTabSheet6: TTntTabSheet;
    PalSchemaPnl: TTntPanel;
    TntTabSheet8: TTntTabSheet;
    PalDatatypePnl: TTntPanel;
    TntShape10: TTntShape;
    TntTabSheet7: TTntTabSheet;
    PalModelPnl: TTntPanel;
    TntTabSheet9: TTntTabSheet;
    PalHistroyPnl: TTntPanel;
    TntShape1: TTntShape;
    TntTabSheet10: TTntTabSheet;
    PalPropertiesPnl: TTntPanel;
    DockPanel: TTntPanel;
    SidebarPnl: TTntPanel;
    PalettesSizerPnl: TTntPanel;
    ViewPalettesPanel: TTntPanel;
    Pal1Pnl: TTntPanel;
    Pal1SpacerPnl: TTntPanel;
    Pal2Pnl: TTntPanel;
    RightSpacerPnl: TTntPanel;
    ToolbarPnl: TTntPanel;
    TntBevel1: TTntBevel;
    ToolOptionsToolbarPnl: TPanel;
    BottomSpacerPnl: TTntPanel;
    ModelToolbarBottomBevel: TTntBevel;
    TopSpacerPnl: TTntPanel;
    ModelToolbarTopBevel: TTntBevel;
    CanvasPanel: TPanel;
    CursorsPnl: TPanel;
    ModelToolbarSepBevel: TTntBevel;
    ModelToolbarPnl: TTntPanel;
    ShowXGrtShellAction: TTntAction;
    ViewTabFrame: TMyxTabHeaderFrame;
    Pal1TabFrame: TMyxTabHeaderFrame;
    Pal2TabFrame: TMyxTabHeaderFrame;
    N01: TTntMenuItem;
    ReverseEngineerAction: TTntAction;
    ModelToolbarSepShape: TTntShape;
    BottomShape: TTntShape;
    ModelToolbarBottomShape: TTntShape;
    PaletteSpacerShape: TTntShape;
    ModelToolbarTopShape: TTntShape;
    ToolbarSpacerShape: TTntShape;
    Pal1SpacerShape: TTntShape;
    RightSpacerShape: TTntShape;
    SchemaPopupMenu: TTntPopupMenu;
    SchemaFilterAdvEdit: TAdvancedEditFrame;
    TntShape8: TTntShape;
    SchemaTreeEditMI: TTntMenuItem;
    SchemaTreeDropMI: TTntMenuItem;
    SchemaTreeCopySQLtoClipboardMI: TTntMenuItem;
    N26: TTntMenuItem;
    FileOpenScriptAction: TTntAction;
    OpenScript1: TTntMenuItem;
    RefreshModelAction: TTntAction;
    FpsTimer: TTimer;
    ZoomPopupMenu: TTntPopupMenu;
    StoreMarker1Action: TTntAction;
    RecallMarker1Action: TTntAction;
    StoreMarker2Action: TTntAction;
    StoreMarker3Action: TTntAction;
    StoreMarker4Action: TTntAction;
    StoreMarker5Action: TTntAction;
    StoreMarker6Action: TTntAction;
    StoreMarker7Action: TTntAction;
    StoreMarker8Action: TTntAction;
    StoreMarker9Action: TTntAction;
    StoreMarker0Action: TTntAction;
    RecallMarker2Action: TTntAction;
    RecallMarker3Action: TTntAction;
    RecallMarker4Action: TTntAction;
    RecallMarker5Action: TTntAction;
    RecallMarker6Action: TTntAction;
    RecallMarker7Action: TTntAction;
    RecallMarker8Action: TTntAction;
    RecallMarker9Action: TTntAction;
    RecallMarker0Action: TTntAction;
    StoreMarkersMI: TTntMenuItem;
    N27: TTntMenuItem;
    StoreMarker11: TTntMenuItem;
    StoreMarker21: TTntMenuItem;
    StoreMarker31: TTntMenuItem;
    StoreMarker41: TTntMenuItem;
    StoreMarker51: TTntMenuItem;
    StoreMarker61: TTntMenuItem;
    StoreMarker71: TTntMenuItem;
    StoreMarker81: TTntMenuItem;
    StoreMarker91: TTntMenuItem;
    StoreMarker01: TTntMenuItem;
    RecallMarkersMI: TTntMenuItem;
    RecallMarker11: TTntMenuItem;
    RecallMarker21: TTntMenuItem;
    RecallMarker31: TTntMenuItem;
    RecallMarker41: TTntMenuItem;
    About1: TTntMenuItem;
    RecallMarker61: TTntMenuItem;
    RecallMarker71: TTntMenuItem;
    RecallMarker81: TTntMenuItem;
    StoreMarker92: TTntMenuItem;
    RecallMarker01: TTntMenuItem;
    DatabaseSynchronizeAction: TTntAction;
    DeleteSelectionAction: TTntAction;
    PlaceCancelAction: TTntAction;
    PropertiesPageControl: TTntPageControl;
    PropNoteSheet: TTntTabSheet;
    PropRelationshipSheet: TTntTabSheet;
    PropCoordsPnl: TTntPanel;
    TntLabel3: TTntLabel;
    PropXEd: TTntEdit;
    PropYEd: TTntEdit;
    TntLabel4: TTntLabel;
    TntLabel5: TTntLabel;
    PropWEd: TTntEdit;
    TntLabel6: TTntLabel;
    PropHEd: TTntEdit;
    TntShape12: TTntShape;
    TntShape11: TTntShape;
    PropNotePnl: TTntPanel;
    TntShape9: TTntShape;
    TntLabel7: TTntLabel;
    PropNoteText: TTntMemo;
    PropRelPnl: TTntPanel;
    TntShape13: TTntShape;
    TntLabel10: TTntLabel;
    PropRelCaptionEd: TTntEdit;
    TntLabel9: TTntLabel;
    PropRelTypeComboBox: TTntComboBox;
    PropRelSrcOptCheckBox: TTntCheckBox;
    PropRelTarOptCheckBox: TTntCheckBox;
    TntLabel11: TTntLabel;
    PropRelCommentMemo: TTntMemo;
    MySQLQueryBrowserMI: TTntMenuItem;
    PlaceTableAction: TTntAction;
    PlaceViewAction: TTntAction;
    PlaceRoutineGroupAction: TTntAction;
    PlaceRelationship1nAction: TTntAction;
    PlaceRelationship11Action: TTntAction;
    PlaceRelationshipnmAction: TTntAction;
    PlaceNoteAction: TTntAction;
    PlaceLayerAction: TTntAction;
    ExportSqlCreateScriptAction: TTntFileSaveAs;
    PropLayerSheet: TTntTabSheet;
    PropLayerPnl: TTntPanel;
    PropLayerCaptionLbl: TTntLabel;
    PropLayerCaptionEd: TTntEdit;
    PropLayerShape: TTntShape;
    LayerCommentMemo: TTntMemo;
    TntLabel8: TTntLabel;
    OverviewAction: TTntAction;
    ViewMi: TTntMenuItem;
    OverviewMI: TTntMenuItem;
    N28: TTntMenuItem;
    ZoomInAction: TTntAction;
    ZoomOutAction: TTntAction;
    ZoomDefaultAction: TTntAction;
    N29: TTntMenuItem;
    DefaultZoom1: TTntMenuItem;
    ZoomIn1: TTntMenuItem;
    ZoomOut1: TTntMenuItem;
    TabNextAction: TTntAction;
    TabPreviousAction: TTntAction;
    NewViewAction: TTntAction;
    TntShapeLeft: TTntShape;
    TntShapeRight: TTntShape;
    TntShapeBottom: TTntShape;
    TntShapeTop: TTntShape;
    PalettesPnl: TTntPanel;
    ShowXGrtCodeSnippetsAction: TTntAction;
    ShowGRTCodeSnippets1: TTntMenuItem;
    DockXGrtShellAction: TTntAction;
    ViewAdvancedMI: TTntMenuItem;
    Dock1: TTntMenuItem;
    N30: TTntMenuItem;
    SelectDefaultConnectionAction: TTntAction;
    ImportSqlScriptAction: TTntFileOpen;
    ImportSQLScriptMI: TTntMenuItem;
    PrintAction: TTntAction;
    N32: TTntMenuItem;
    Arrangeelements1: TTntMenuItem;
    Arrangeselectedelements1: TTntMenuItem;
    ArrangeAction: TTntAction;
    PluginsTabSheet: TTntTabSheet;
    PalPluginOutputPnl: TTntPanel;
    PluginOuputMemo: TTntMemo;
    PluginSearchFrame: TAdvancedEditFrame;
    PluginVirtualStringTree: TVirtualStringTree;
    PluginOutputHeaderPnl: TTntPanel;
    TntLabel12: TTntLabel;
    PluginSeachSpacerPnl: TTntPanel;
    TntShape14: TTntShape;
    BrintToFrontAction: TTntAction;
    SendToBackAction: TTntAction;
    SelectAllAction: TTntAction;
    ExportToImageAction: TTntAction;
    CopyToClipboardAction: TTntAction;
    TntShape15: TTntShape;
    ImportDbd4ModelAction: TTntFileOpen;
    DatabaseResyncAction: TTntAction;
    Resynchronize1: TTntMenuItem;
    ModelPropertiesAction: TTntAction;
    PropertiesMI: TTntMenuItem;
    N3: TTntMenuItem;
    TableVizDefaultAction: TTntAction;
    TableVizSimpleAction: TTntAction;
    NotationVizDefaultAction: TTntAction;
    NotationVizEerAction: TTntAction;
    MainPnl: TTntPanel;
    EditorPnl: TTntPanel;
    EditorSizerPnl: TTntPanel;
    EditorSizerShape: TTntShape;
    EditorTabFrame: TMyxTabHeaderFrame;
    MessagesTabSheet: TTntTabSheet;
    MessagesPnl: TTntPanel;
    TntShape16: TTntShape;
    TntShape17: TTntShape;
    TntShape18: TTntShape;
    TntShape20: TTntShape;
    TntShape21: TTntShape;
    TntShape22: TTntShape;
    TntShape23: TTntShape;
    MessagesVT: TVirtualStringTree;
    ShowStatusMessagesAction: TTntAction;
    EditorTabsMinimizePnl: TTntPanel;
    EditorTabsMinimizeShape: TTntShape;
    EditorTabsMinimizeIconShape: TTntShape;
    EditorTabsMinimizeAction: TTntAction;
    DockEditorsAction: TTntAction;
    OpenEditorsDocked1: TTntMenuItem;
    N6: TTntMenuItem;
    ApplyChangesAndCloseAction: TTntAction;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);

    procedure CloseMIClick(Sender: TObject);

    procedure ReportBugMIClick(Sender: TObject);
    procedure VisitMySQLcomMIClick(Sender: TObject);

    procedure NewWorkbenchMIClick(Sender: TObject);

    procedure CheckFonts;

    procedure MySQLAdministratorMIClick(Sender: TObject);
    procedure MySQLCommandLineClientMIClick(Sender: TObject);
    procedure WindowsCommandLineMIClick(Sender: TObject);
    procedure AboutActionExecute(Sender: TObject);
    procedure ListreportedBugsMIClick(Sender: TObject);

    procedure LaunchHelpMIClick(Sender: TObject);


    procedure DoException(Sender: TObject; E: Exception);
    procedure StatusBarDrawPanel(StatusBar: TStatusBar;
      Panel: TStatusPanel; const Rect: TRect);
    procedure StatusBarMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ShowXGrtShellActionExecute(Sender: TObject);
    procedure ReverseEngineerActionExecute(Sender: TObject);
    procedure SchemaPopupMenuPopup(Sender: TObject);
    procedure SchemaPopupMenuAddObjectClick(Sender: TObject);
    procedure SchemaPopupMenuRefreshClick(Sender: TObject);
    procedure FileOpenScriptActionExecute(Sender: TObject);
    procedure RefreshModelActionExecute(Sender: TObject);
    procedure SchemaTreeEditMIClick(Sender: TObject);
    procedure FpsTimerTimer(Sender: TObject);
    procedure StoreMarker1ActionExecute(Sender: TObject);
    procedure RecallMarker1ActionExecute(Sender: TObject);
    procedure DeleteSelectionActionExecute(Sender: TObject);
    procedure FileSaveAsActionAccept(Sender: TObject);
    procedure FileSaveActionExecute(Sender: TObject);
    procedure SelectionAvailableActionUpdate(Sender: TObject);
    procedure PlaceCancelActionExecute(Sender: TObject);
    procedure PlaceCancelActionUpdate(Sender: TObject);
    procedure DoPropChange(Sender: TObject);
    procedure DoPropKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure MySQLQueryBrowserMIClick(Sender: TObject);
    procedure PlaceTableActionExecute(Sender: TObject);
    procedure PlaceActionUpdate(Sender: TObject);
    procedure PlaceViewActionExecute(Sender: TObject);
    procedure PlaceRoutineGroupActionExecute(Sender: TObject);
    procedure PlaceRelationship1nActionExecute(Sender: TObject);
    procedure PlaceRelationship11ActionExecute(Sender: TObject);
    procedure PlaceRelationshipnmActionExecute(Sender: TObject);
    procedure PlaceNoteActionExecute(Sender: TObject);
    procedure PlaceLayerActionExecute(Sender: TObject);
    procedure ExportSqlCreateScriptActionAccept(Sender: TObject);
    procedure OverviewActionUpdate(Sender: TObject);
    procedure OverviewActionExecute(Sender: TObject);
    procedure ZoomInActionExecute(Sender: TObject);
    procedure ZoomOutActionExecute(Sender: TObject);
    procedure ZoomDefaultActionExecute(Sender: TObject);
    procedure TabNextActionExecute(Sender: TObject);
    procedure TabPreviousActionExecute(Sender: TObject);
    procedure NewViewActionExecute(Sender: TObject);
    procedure ShowXGrtCodeSnippetsActionExecute(Sender: TObject);
    procedure PaletteSpacerShapeMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure PaletteSpacerShapeMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure PaletteSpacerShapeMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure DockXGrtShellActionExecute(Sender: TObject);
    procedure SelectDefaultConnectionActionExecute(Sender: TObject);
    procedure ImportSqlScriptActionAccept(Sender: TObject);
    procedure DatabaseSynchronizeActionExecute(Sender: TObject);
    procedure PrintActionExecute(Sender: TObject);
    procedure ArrangeActionExecute(Sender: TObject);
    procedure ArrangeSelectedActionExecute(Sender: TObject);
    procedure OnSeachEdChange(Sender: TObject);
    procedure PluginSearchGetText(Sender: TBaseVirtualTree; Node: PVirtualNode;
      Column: TColumnIndex; TextType: TVSTTextType;
      var CellText: WideString);
    procedure ObjectEditMiClick(Sender: TObject);
    procedure CreateConnectionPopupMenu(X: Integer; Y: Integer; Connection: Pointer);
    procedure CreateFigurePopupMenu(X: Integer; Y: Integer; Obj: Pointer; Figure: Pointer);
    procedure VirtualTreeDblClick(Sender: TObject);
    procedure BrintToFrontActionExecute(Sender: TObject);
    procedure SendToBackActionExecute(Sender: TObject);
    procedure SelectAllActionExecute(Sender: TObject);
    procedure PluginMenuMIClick(Sender : TObject);
    procedure ExportToImageActionExecute(Sender: TObject);
    procedure ExportToImageActionUpdate(Sender: TObject);
    procedure CopyToClipboardActionExecute(Sender: TObject);
    procedure DisplayGridActionExecute(Sender: TObject);
    procedure OnlineDocsMIClick(Sender: TObject);
    procedure ImportDbd4ModelActionAccept(Sender: TObject);
    procedure ModelPropertiesActionExecute(Sender: TObject);
    procedure ChangeViewLayoutClass(
      ChangeElementsClass: Boolean; ClassName: WideString);
    procedure TableVizDefaultActionExecute(Sender: TObject);
    procedure TableVizSimpleActionExecute(Sender: TObject);
    procedure NotationVizDefaultActionExecute(Sender: TObject);
    procedure NotationVizEerActionExecute(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure DisplayGrtSidebar;
    procedure DisplayViewSidebar;
    procedure MessagesVTGetText(Sender: TBaseVirtualTree;
      Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
      var CellText: WideString);
    procedure MessagesVTFreeNode(Sender: TBaseVirtualTree;
      Node: PVirtualNode);
    procedure MessagesVTKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EditorSizerShapeMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure EditorSizerShapeMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure EditorSizerShapeMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ShowStatusMessagesActionExecute(Sender: TObject);
    procedure EditorTabsMinimizeActionExecute(Sender: TObject);
    procedure EditorTabsMinimizeActionUpdate(Sender: TObject);
    procedure EditorTabsMinimizeShapeMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure DockEditorsActionExecute(Sender: TObject);
    procedure ApplyChangesAndCloseActionExecute(Sender: TObject);
    procedure FormActivate(Sender: TObject);

    procedure ConnectionEditMiClick(Sender: TObject);
    procedure FileOpenActionExecute(Sender: TObject);
  private
    FTextToClear: Boolean;
    FStatusbarHistoryPNGImg: TPNGObject;
    FLoading: Boolean;

    FCanvasViewer: TGenericCanvasViewer;

    FCurrentTool: TWorkbenchTool;

    FGrtObjectTree: TGrtObjectTree;
    FLayerTree: TLayerTree;
    FXGrtShellForm: TXGrtShellForm;

    FViewerContainer: TTntPanel;
    FManualChangeView: Boolean;

    FToolbars: TToolbars;
    FPaletteContainer: TToolbarContainer;
    FToolbarContainer: TToolbarContainer;

    FGrtInitialized: Boolean;

    FDockPnlWindowProc: TWndMethod;

    FGrtForms: TXGrtFormApplication;

    FNewTableCounter: Integer;

    FSourceFigure: Pointer;
    FTargetFigure: Pointer;
    FRelationshipContext: Pointer;
    FRubberBandClickVertex: TVertex;

    FModelFileName: WideString;

    FModuleFunctionCallList: TList;

    FCurrentObject: Pointer;
    FCurrentElement: Pointer;
    FCurrentElementType: TElementType;
    FCurrentElementChanging: Boolean;

    FCancelingCurrentTool: Boolean; // used to prevent infinite loop

    FDockedShellTab,
    FDockedCodeSnippetsTab,
    FDockedMessagesTab: TTab;

    FInitWidth,
    FInitMousePos: Integer;

    FDragging: Boolean;
    FInGrtCallback: Boolean;

    FFigurePopupMenu: TTntPopupMenu;
    FConnectionPopupMenu: TTntPopupMenu;

    FStatusBarCleanerCounter: Integer;

    FEditorPnlMinimized: Boolean;
    FModified: Boolean;

    procedure SetModified(const Value: Boolean);

    procedure WMInitMenuPopup(var MSG: TWMInitMenuPopup); message WM_INITMENUPOPUP;
    procedure WmObjectEditorCall(var Message: TMessage); message WM_OBJECT_EDITOR_CALL;
  protected
    procedure LoadStyleFromTemplate(Canvas: TGenericCanvas; FileName: WideString; Vars: Pointer);
    procedure InitializeCanvas;

    procedure RunScript;
    procedure ProcessGrtOutput(Text: WideString);

    procedure GrtShutDown(Grt: TGrt);

    procedure BuildPalettes;
    procedure BuildToolbars;

    procedure DoTabChange(Sender: TObject; PreviousSelectedTab: Integer; PreviousSelectedObj: TObject;
      NewSelectedTab: Integer; obj: TObject);

    procedure ViewTabPageChange(Sender: TObject; PreviousSelectedTab: Integer; PreviousSelectedObj: TObject;
      NewSelectedTab: Integer; Obj: TObject);

    procedure ViewTabPageDelete(Sender: TObject);
    procedure ViewTabPageCanClose(Sender: TObject; var CanClose: Boolean);
    procedure ViewTabPageRequestNew(Sender: TObject);

    procedure EditorTabPageDelete(Sender: TObject);
    procedure EditorTabPageChange(Sender: TObject; PreviousSelectedTab: Integer; PreviousSelectedObj: TObject;
      NewSelectedTab: Integer; Obj: TObject);
    procedure EditorTabPageCanClose(Sender: TObject; var CanClose: Boolean);

    procedure SetCurrentTool(CurrentTool: TWorkbenchTool);

    procedure ToolBtnClick(Sender: TObject);
    procedure AlignBtnClick(Sender: TObject);

    procedure ViewerChange(Sender: TObject; Source: TGCBase; Reason: TGCChangeReason);
    procedure ViewerError(Sender: TObject; const Message: string);
    procedure ViewerFocusChanged(Sender: TObject; HasFocus: Boolean);
    procedure ViewerZoomChange(Sender: TObject);
    procedure ViewerMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer;
      var Handled: Boolean);
    procedure ViewerMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer;
      var Handled: Boolean);
    procedure ViewerDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure ViewerDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure ViewerAction(Sender: TObject; Origin: TGCBase; var ActionType: TActionType);

    procedure GrtWbViewChange(View, ViewObject: Pointer; Reason: GrtWbCallbackReason);
    procedure GrtWbLayerChange(Layer, LayerObject: Pointer; Reason: GrtWbCallbackReason);
    procedure GrtWbFigureChange(Figure, FigureObject: Pointer; Reason: GrtWbCallbackReason);

    procedure ConsoleFocusChanged(Sender: TObject; HasFocus: Boolean);

    function InitializeGrt: Boolean;
    procedure RegisterWorkbenchUi;

    procedure DoReverseEngineeringFormClose(Sender: TObject; var Action: TCloseAction);
    procedure DoDatabaseSynchronisationFormClose(Sender: TObject; var Action: TCloseAction);

    procedure DockPnlIgnoreWMEraseBkGnd(var Msg: TMessage);

    function GrtExecuteModuleFunction(ModuleName: WideString; FunctionName: WideString; arguments: Pointer): Pointer;

    procedure LoadCursors;

    procedure UpdateSchemaListings;

    procedure DoZoomMenuItemClick(Sender: TObject);

    procedure SetStatusBarText(Text: WideString);
    procedure SetPermanentStatusBarText(Text: WideString);

    procedure SetStatusBarMessageText(Text: WideString;
      KeepMessageInStatusbar: Boolean = False);

    procedure ProcessNewDocument;

    procedure UpdateProperties;

    procedure SetCurrentElement(Element: Pointer);
    procedure SetCurrentObject(Obj: Pointer);

    procedure DoCollationComboBoxCloseUp(Sender: TObject);

    procedure OptionChanged;

    function GrtSheetIsActive: Boolean;

    procedure BuildSubMenu(List: Pointer; Plugins: Pointer; ParentMenu : TMenuItem);
    procedure PluginMenuActionExecute(Sender : TObject);
    procedure PluginMenuActionUpdate(Sender : TObject);
    procedure ProcessGrtPluginOutput(Text: WideString);
    function PerformGrtPluginInput(Description: WideString): WideString;
    procedure ProcessGrtPluginMessages(Messages: TMYX_GRT_MSGS);
    procedure LaunchPlugin(Plugin : Pointer; Selection: Pointer);

    function GetKeywordList(S: WideString): TTntStringList;
    procedure ResetModified;
  public
    RevEngForm: TReverseEngineeringForm;
    SyncForm: TDatabaseSynchronisationForm;
    SchemaComboBox,
    TableEngineComboBox,
    TableCollationComboBox: TTntComboBox;
    GlobalObjectLockCBox: TTntCheckBox;
    RelSourceOptionalCBox,
    RelTargetOptionalCBox: TTntCheckBox;

    function ActivateView(View: TView): Integer;

    property CurrentTool: TWorkbenchTool read FCurrentTool write SetCurrentTool;
    property GrtInitialized: Boolean read FGrtInitialized;

    property StatusBarText: WideString write SetStatusBarText;
    property PermanentStatusbarText: WideString write SetPermanentStatusbarText;

    procedure InitializeGui;
    procedure FinalizeGui;

    procedure RefreshDisplay;

    procedure StoreMarker(Number: Integer);
    procedure RestoreMarker(Number: Integer);

    property CurrentElement: Pointer read FCurrentElement write SetCurrentElement;
    property CurrentObject: Pointer read FCurrentObject write SetCurrentObject;
    property Modified: Boolean read FModified write SetModified;
  end;

  ModuleFunction =
  (
    EditSchema,
    EditTable,
    EditView,
    EditRoutine,
    EditRoutineGroup,
    PopupPluginsMenu,
    PopupConnectionMenu
  );

  PModuleFunctionCallEntry = ^TModuleFunctionCallEntry;
  TModuleFunctionCallEntry = record
    Type_: ModuleFunction;
    Obj: Pointer;
    GrtValue: Pointer;
    ActionId: Integer;
  end;

var
  MainForm: TMainForm;

//----------------------------------------------------------------------------------------------------------------------

implementation

uses
  MyxError, PNGTools, Unicode,
  Printers, ModelPrintSetup, PrintProgress;

{$R *.dfm}

//----------------------------------------------------------------------------------------------------------------------

function IsDelphiClass(Obj: Pointer): Boolean;

// Returns true if Obj is a Delphi class.

var
  ClassPointer: Pointer;

begin
  if Assigned(Obj) then
  begin
    ClassPointer := PPointer(Obj)^;
    Result := PPointer(Integer(ClassPointer) + vmtSelfPtr)^ = ClassPointer;
  end
  else
    Result := False;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FormCreate(Sender: TObject);

var
  ModalDialog: TMyxModalDialog;
  Val: WideString;

begin
  FModified := True;
  
  if (Not(CommonOptions.OptionInt['NoRegEntries'] = 1)) then
    RegisterMySQLApplication(Application.Title,
      product_version, WideExtractFilePath(TntApplication.ExeName));

  FGrtInitialized := False;
  FXGrtShellForm := nil;

  RevEngForm := nil;

  FDockedShellTab := nil;
  FDockedCodeSnippetsTab := nil;
  FDockedMessagesTab := nil;

  FModelFileName := '';

  MainMenu.AutoHotkeys := maAutomatic;

  Application.OnException := MainForm.DoException;
  Application.HintHidePause := 1000000;

  CheckFonts;

  FGrtInitialized := InitializeGrt;
  FInGrtCallback := False;
  
  if GrtInitialized then
  begin
    BuildToolbars;
    BuildPalettes;
    FCurrentTool := wbToolArrow;

    // Create views tabframe
    ViewTabFrame.ClearTabSheets;
    ViewTabFrame.ShowButtons := True;
    ViewTabFrame.SelectedTab := 0;
    ViewTabFrame.OnPageChange := ViewTabPageChange;
    ViewTabFrame.OnCanClosePage := ViewTabPageCanClose;
    ViewTabFrame.OnPageDelete := ViewTabPageDelete;
    ViewTabFrame.OnRequestNewPage := ViewTabPageRequestNew;

    // Create editors tabframe
    EditorTabFrame.ClearTabSheets;
    EditorTabFrame.ShowDeleteButtons := True;
    EditorTabFrame.AllowToCloseLastTab := True;
    EditorTabFrame.SelectedTab := 0;
    EditorTabFrame.OnPageChange := EditorTabPageChange;
    EditorTabFrame.OnCanClosePage := EditorTabPageCanClose;
    EditorTabFrame.OnPageDelete := EditorTabPageDelete;

    // Eliminate flicker
    FDockPnlWindowProc := DockPanel.WindowProc;
    DockPanel.WindowProc := DockPnlIgnoreWMEraseBkGnd;
  end;

  LoadCursors;

  FNewTableCounter := 0;

  FModuleFunctionCallList := TList.Create;

  FCurrentElementChanging := False;

  FCancelingCurrentTool := False;
  FEditorPnlMinimized := False;

  FStatusBarCleanerCounter := 0;

  // Add Option listener
  AppOptions.AddListener(self);

  SidebarPnl.Width := AppOptions.OptionInt['SideBarWidthView'];
  EditorPnl.Height := AppOptions.OptionInt['EditorPanelHeight'];

  TTntAction(DockXGrtShellAction).Checked :=
    (AppOptions.OptionInt['DockGrtShell'] = 1);

  TTntAction(DockEditorsAction).Checked :=
    (AppOptions.OptionInt['DockEditors'] = 1);

  FFigurePopupMenu := nil;

  // Initializes MessagesVT
  MessagesVT.NodeDataSize := sizeof(TStatusMessage);
  MessagesVT.RootNodeCount := 0;

  StatusBarText := WideFormat(_('Welcome to %s'),
    ['MySQL Workbench ' + product_version + ' ' +
      product_build_level]);

  // Show Alpha warning dialog
  if AppOptions.OptionInt['HideAlphaWarning'] <> 1 then
  begin
    ModalDialog := TMyxModalDialog.Create(_('Alpha Status Warning'),
      _('This version of the MySQL Workbench is an alpha version. This means ' +
      'that not all functionality is yet completed and that the tool may still ' +
      'suffer from serious bugs that can cause data damage.' + #13#10#13#10 +
      'Before you proceed please make sure that you have a backup of ALL your ' +
      'databases so you do not lose any important data.'),
      myx_mtWarning, _('Yes, I have made backups and want to try MySQL Workbench') + #13#10 +
       _('Abort'),
      False, '', Val, 0, False,
      True, '');
    try
      if (ModalDialog.ShowModal = 2) then
        Application.Terminate;

      if(ModalDialog.DisableMessageCheckbox<>nil)then
        if(ModalDialog.DisableMessageCheckbox.Checked)then
          if(AppOptions.OptionInt['HideAlphaWarning']<>1)then
            AppOptions.OptionInt['HideAlphaWarning'] := 1;
    finally
      ModalDialog.Free;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FormDestroy(Sender: TObject);

begin
  FpsTimer.Enabled := False;

  // Remove Option listener.
  AppOptions.RemoveListener(self);

  FStatusbarHistoryPNGImg.Free;

  FModuleFunctionCallList.Free;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);

begin
  Action := caFree;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);

var
  I: Integer;
  DialogResult: Integer;

begin
  CanClose := True;

  // First check individual editors if they have something to save.
  for I := 0 to Screen.FormCount - 1 do
    if Screen.Forms[I] is TMyxEditorForm then
    begin
      CanClose := TMyxEditorForm(Screen.Forms[I]).CloseQuery;
      if not CanClose then
        Break;
    end;

  // Then see if any of the tabbed editors needs saving.
  if CanClose then
    CanClose := EditorTabFrame.CanClose;

  // Finally check the main editor for changes.
  if CanClose and Modified then
  begin
    DialogResult := ShowModalDialog(_('Confirm'), _('There are unsaved changes. Would you like to save them now?'),
      myx_mtConfirmation, _('Save') + #13#10 + _('Ignore') + #13#10 + _('Cancel'));
    case DialogResult of
      1: // Apply and close
        begin
          FileSaveAction.Execute;
          CanClose := not Modified;
        end;
      2: // Ignore and close
        ;
      3: // Cancel and stop closing
        CanClose := False;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ProcessGrtPluginOutput(Text: WideString);

begin
  if (Trim(Text) <> '') then
    PluginOuputMemo.Text := PluginOuputMemo.Text + #13#10 + Text;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ProcessGrtPluginMessages(Messages: TMYX_GRT_MSGS);

begin
  if (Messages.msgs.Count > 0) then
    PluginOuputMemo.Text := PluginOuputMemo.Text + FormatGrtMessagesAsString(Messages);
end;

//----------------------------------------------------------------------------------------------------------------------

function TMainForm.PerformGrtPluginInput(Description: WideString): WideString;

var
  InputText: WideString;

begin
  Enabled := False;
  try
    InputText := '';

    ShowModalEditDialog(_('Input'),
      Description+'                            ',
      myx_mtEdit, _('Ok'), True, '', InputText);

    Result := InputText;
  finally
    Enabled := True;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------
procedure TMainForm.LaunchPlugin(Plugin : Pointer; Selection: Pointer);

var
  CurrentView: Pointer;
  func, module: WideString;
  Task: IGrtTask;

begin
  module := Grt.DictString[Plugin, 'moduleName'];
  func := Grt.DictString[Plugin, 'moduleFunctionName'];

  if(Selection = nil)then
  begin
  CurrentView := Grt.GlobalRef['/workbench/model/currentView'];
    if(CurrentView <> nil)then
      Selection := Grt.DictItem[CurrentView, 'selection'];
  end;

  if (Selection <> nil) then
  begin
    Task := Grt.CreateStandardTask(_('Executing plugin'), module, func,
      [Selection], ProcessGrtPluginOutput, ProcessGrtPluginMessages, True,
      False, -1, PerformGrtPluginInput, nil, nil);
    Grt.AddTask(Task);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PluginMenuActionExecute(Sender : TObject);

var
  Plugin: Pointer;

begin
  Plugin := Pointer(TTntAction(Sender).Tag);
  LaunchPlugin(Plugin, nil);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PluginMenuMIClick(Sender : TObject);

var
  L, Plugin: Pointer;

begin
  Plugin := Pointer(TTntMenuItem(Sender).Tag);
  L := Grt.ListNew(GrtAnyValue);
  Grt.ListAdd(L, CurrentElement);
  LaunchPlugin(Plugin, L);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PluginMenuActionUpdate(Sender : TObject);

var
  AllowedClasses, CurrentView, Plugin, Selection, SelectionObj: Pointer;
  i, j, count, count2: integer;
  ClsName: WideString;
  Enable: boolean;

begin
  Enable := false;
  Plugin := Pointer(TTntAction(Sender).Tag);
  CurrentView := Grt.GlobalRef['/workbench/model/currentView'];
  if (CurrentView <> nil) then
  begin
    Selection := Grt.DictItem[CurrentView, 'selection'];
    AllowedClasses := Grt.DictItem[Plugin, 'objectStructNames'];
    if(Selection <> nil)then
      count := Grt.ListCount(Selection)
    else
      count := 0;

    if (Grt.ValueType(AllowedClasses) = GrtDictValue) or
      (Grt.ListCount(AllowedClasses) = 0) then
      Enable := True
    else
    begin
      if (AllowedClasses <> nil) and (Grt.ValueType(AllowedClasses) = GrtListValue) then
        count2 := Grt.ListCount(AllowedClasses)
      else
        count2 := 0;

      if count > 0 then
        Enable := True;

      if (count2 > 0) and (Selection <> nil) then
        for i := 1 to count do
        begin
          SelectionObj := Grt.ListItem[Selection, i-1];
          for j := 1 to count2 do
          begin
            ClsName := Grt.ListString[AllowedClasses, j - 1];
            if((Grt.DictStructName[SelectionObj] <> ClsName) and
              not Grt.StructInheritsFrom(Grt.DictStructName[SelectionObj], ClsName))
            then begin
              Enable := false;
              break;
            end;
          end;
        end;
    end;
  end;

  TTntAction(Sender).Enabled := Enable;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.BuildSubMenu(List: Pointer; Plugins: Pointer; ParentMenu : TMenuItem);

var
  i, count : Integer;
  m: TTntMenuItem;
  PluginGroup : Pointer;
  SubGroups: Pointer;
  Plugin: Pointer;
  a: TTntAction;

begin
  count := Grt.ListCount(List);
  for i := 1 to count do
  begin
    PluginGroup := Grt.ListItem[List, i-1];
    m := TTntMenuItem.Create(ParentMenu);
    m.Caption := Grt.DictString[PluginGroup, 'name'];
    ParentMenu.Add(m);
    SubGroups := Grt.DictItem[PluginGroup, 'subGroups'];
    if(SubGroups <> nil) then
      BuildSubMenu(SubGroups, Grt.DictItem[PluginGroup, 'plugins'],  m);
  end;

  if(Plugins <> nil) then
  begin
    count := Grt.ListCount(Plugins);
    for i := 1 to count do
    begin
      Plugin := Grt.ListRefItem[Plugins, i-1];
      m := TTntMenuItem.Create(ParentMenu);
      a := TTntAction.Create(m);
      a.Tag := Integer(Plugin);
      a.OnExecute := PluginMenuActionExecute;
      a.OnUpdate := PluginMenuActionUpdate;
      a.Caption := Grt.DictString[Plugin, 'caption'];
      m.Action := a;
      ParentMenu.Add(m);
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.InitializeGui;

var
  Plugins: TMenuItem;
  Hier: Pointer;

begin
  Caption := TntApplication.Title;

  InitializeCanvas;

  {if (ApplicationDM.Options.AssociateFileExtensions) then
  begin
    RegisterFileType('mwb', Application.ExeName, 1, '"%1"');
  end;}

  //Enable Tools Menu Items
  MySQLAdministratorMI.Enabled := (GetMySQLAdministratorCmd <> '');
  MySQLQueryBrowserMI.Enabled := (GetMySQLQueryBrowserCmd <> '');
  MySQLCommandlineclientMI.Enabled := (GetMySQLCommandLineClientPath <> '');
  WindowsCommandLineMI.Enabled := FileExists(GetSystemDir + 'cmd.exe');

  FTextToClear := False;
  FStatusbarHistoryPNGImg := LoadPNGImageFromResource('statusbar_history');
  StatusBar.Font.Size := ((CommonOptions.OptionInt['DefaultFontHeight'] * 10) div 12);
  StatusBar.Font.Color := clGray;

  PluginOuputMemo.Text := '';

  PluginVirtualStringTree.NodeDataSize := SizeOf(Pointer);

  // build the plugins menu
  Plugins := MainMenu.Items.Find('Plugins');
  Hier := Grt.Global['/app/pluginGroups'];
  if(Hier <> nil) then
  begin
    BuildSubMenu(Hier, nil, Plugins);
  end;

  // Once everything is initialized execute the given script.
  RunScript;

  RefreshModelActionExecute(self);

  UpdateCollations(TableCollationComboBox);

  ResetModified;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FinalizeGui;

var
  I: Integer;

begin
  FpsTimer.Enabled := False;

  // if the viewer is created and the /workbench/model is accessable
  if Assigned(FCanvasViewer) and
    (Grt.Global['/workbench/model'] <> nil) then
    TGrtWb(Grt).FreeGcWbBridge(FCanvasViewer.Canvas, '/workbench/model');

  for I := 0 to Screen.FormCount - 1 do
    Screen.Forms[I].Hide;

  Application.ProcessMessages;
end;

//----------------------------------------------------------------------------------------------------------------------

function TMainForm.InitializeGrt: Boolean;

var
  Task: IGrtTask;

begin
  Result := True;

  // create workbench environment
  try
    Task := Grt.CreateStandardTask(_('Initializing the workbench'),
      'Workbench', 'initWorkbench', [], ProcessGrtOutput);
    Grt.AddTaskAndWait(Task, True);

    Grt.OnShutDown := GrtShutDown;

    FXGrtShellForm := TXGrtShellForm.Create(nil);
    FXGrtShellForm.CommandLineUCE.OnFocusChanged :=
      ConsoleFocusChanged;

    Grt.Console := FXGrtShellForm.CommandLineUCE;

    FGrtForms := TXGrtFormApplication.Create;

    RegisterWorkbenchUi;
  except
    on X: Exception do
    begin
      Result := False;

      ShowModalDialog(_('Workbench Error'),
        Format(_('The runtime environment (GRT) could not be initialized.' + #13#10 +
        'Please check your installation then try to restart ' +
        'the tool.' + #13#10#13#10 + 'Error details:' + #13#10 +
        '%s' + #13#10#13#10 +
        'Shell output: '+ #13#10 +
        Grt.OutputBuffer),
        [X.Message]), myx_mtError);
    end;
  end;
end;

// -----------------------------------------------------------------------------

procedure TMainForm.GrtShutDown(Grt: TGrt);

var
  Task: IGrtTask;

begin
  FGrtForms.Free;
  FXGrtShellForm.Free;

  Task := Grt.CreateStandardTask(_('Shutting down the workbench'), 'Workbench', 'shutdownWorkbench', [], ProcessGrtOutput);
  Grt.AddTaskAndWait(Task, False);
end;


//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.CloseMIClick(Sender: TObject);

begin
  Close;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ReportBugMIClick(Sender: TObject);

begin
  BrowseWebPage('http://bugs.mysql.com');
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.VisitMySQLcomMIClick(Sender: TObject);

begin
  BrowseWebPage('http://www.mysql.com');
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.NewWorkbenchMIClick(Sender: TObject);

begin
  CreateSubProcess(Application.ExeName + ' -nologo');
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.CheckFonts;

var
  i: integer;
  FontsInstalled: Boolean;

begin
  //PostMessage(HWND_BROADCAST, WM_FONTCHANGE, 0, 0);

  Screen.ResetFonts;

  FontsInstalled := False;
  for i := 0 to Screen.Fonts.Count - 1 do
    if (CompareText(Screen.Fonts[i], 'Bitstream Vera Sans Mono') = 0) then
      FontsInstalled := True;

  if (not (FontsInstalled)) then
  begin
    if (not (FileExists(ExtractFilePath(Application.ExeName) + 'fonts\VeraMoBd.ttf'))) then
      raise EInOutError.Create(Format(_('The Bitstream Vera Sans Mono fonts cannot be found. Please download ' +
        'the font files from http://www.gnome.org/fonts and copy them into the fonts directory %s. The following files are needed: VeraMoBd.ttf, ' +
        'VeraMoBI.ttf, VeraMoIt.ttf, VeraMono.ttf.'),
        [ExtractFilePath(Application.ExeName) + 'fonts\']));

    try
      CopyDiskFile(ExtractFilePath(Application.ExeName) + 'fonts\VeraMoBd.ttf',
        GetWindowsDir + 'fonts\VeraMoBd.ttf', False);
      CopyDiskFile(ExtractFilePath(Application.ExeName) + 'fonts\VeraMoBI.ttf',
        GetWindowsDir + 'fonts\VeraMoBI.ttf', False);
      CopyDiskFile(ExtractFilePath(Application.ExeName) + 'fonts\VeraMoIt.ttf',
        GetWindowsDir + 'fonts\VeraMoIt.ttf', False);
      CopyDiskFile(ExtractFilePath(Application.ExeName) + 'fonts\VeraMono.ttf',
        GetWindowsDir + 'fonts\VeraMono.ttf', False);
    except
      on E: Exception do
      begin
        StatusbarText := E.Message;
        FTextToClear := True;
        StatusBar.Invalidate;
      end;
    end;

    AddFontResourceW(PWideChar(GetWindowsDir + 'fonts\VeraMoBd.ttf'));
    AddFontResourceW(PWideChar(GetWindowsDir + 'fonts\VeraMoBI.ttf'));
    AddFontResourceW(PWideChar(GetWindowsDir + 'fonts\VeraMoIt.ttf'));
    AddFontResourceW(PWideChar(GetWindowsDir + 'fonts\VeraMono.ttf'));

    PostMessage(HWND_BROADCAST, WM_FONTCHANGE, 0, 0);

    Screen.ResetFonts;
  end;
end;


//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.MySQLAdministratorMIClick(Sender: TObject);

var
  cmd: WideString;

begin
  cmd := GetMySQLAdministratorCmd;
  if (cmd <> '') then
  begin
    CreateSubProcess(cmd, '');
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.MySQLQueryBrowserMIClick(Sender: TObject);

var
  cmd: WideString;

begin
  cmd := GetMySQLQueryBrowserCmd;
  if (cmd <> '') then
  begin
    CreateSubProcess(cmd, '');
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.MySQLCommandLineClientMIClick(Sender: TObject);

var
  cmd: WideString;

begin
  cmd := GetMySQLCommandLineClientPath;
  if (cmd <> '') then
    CreateSubProcess(cmd, '');
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.WindowsCommandLineMIClick(Sender: TObject);

var
  cmd: WideString;

begin
  cmd := GetSystemDir + 'cmd.exe';
  if (FileExists(cmd)) then
    CreateSubProcess(cmd, GetHomeDir);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.AboutActionExecute(Sender: TObject);

begin
  ShowAboutDialog('MySQL Workbench',
    product_version + ' ' + product_build_level,
    'Michael G. Zinner, main concept, graphical design, ' +
    'Windows development, library coding | ' +
    'Alfredo Kengi Kojima, OS X development, Linux development, ' +
    'library coding | ' +
    'Mike Lischke, User interface, Windows development, library coding | ' +
    'Vladimir Kolesnikov | library coding | ' +
    'Mike Hillyer, documentation');
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ListreportedBugsMIClick(Sender: TObject);

begin
  BrowseWebPage('http://bugs.mysql.com/search.php?search_for=&limit=All&order_by=&direction=ASC&cmd=display&status=Active&severity=&showstopper=&bug_type=MySQL+Workbench&php_os=&phpver=&assign=&bug_age=0');
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.LaunchHelpMIClick(Sender: TObject);

begin
  ShowHelp;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DoException(Sender: TObject; E: Exception);

begin
  if E is EMyxError then
    StatusbarText := EMyxError(E).FormattedMessage
  else
    StatusbarText := E.Message;
  FTextToClear := True;
  StatusBar.Invalidate;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SetStatusbarText(Text: WideString);

begin
  SetStatusbarMessageText(Text, False);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SetPermanentStatusbarText(Text: WideString);

begin
  SetStatusbarMessageText(Text, True);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SetStatusbarMessageText(Text: WideString;
  KeepMessageInStatusbar: Boolean);

var
  NodeData: PStatusMessage;
  Node: PVirtualNode;

begin
  // deactivate the automatic cleaning of the statusbar
  if (KeepMessageInStatusbar) then
    FStatusBarCleanerCounter := 0;

  StatusBar.Panels[1].Text := Text;
  StatusBar.Update;

  Node := MessagesVT.InsertNode(MessagesVt.GetFirst, amInsertBefore);
  NodeData := MessagesVT.GetNodeData(Node);
  NodeData.MessageString := Text;
  NodeData.Time := Now;
  MessagesVT.Invalidate;

  // set automatic cleaning of the statusbar
  if not(KeepMessageInStatusbar) then
    FStatusBarCleanerCounter := 5;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.StatusBarDrawPanel(StatusBar: TStatusBar; Panel: TStatusPanel; const Rect: TRect);

var
  I, W: Integer;

begin
  with StatusBar.Canvas do
  begin
    // draw edit box for zoom
    if (Panel = StatusBar.Panels[0]) then
    begin
      Pen.Color := clGray;
      Brush.Color := clWhite;
      Rectangle(1, 3, Rect.Right - 3, Rect.Bottom);

      // draw v
      Pen.Color := clBlack;
      MoveTo(Rect.Right - 11, 9);
      LineTo(Rect.Right - 6, 9);
      MoveTo(Rect.Right - 10, 10);
      LineTo(Rect.Right - 7, 10);
      MoveTo(Rect.Right - 9, 10);
      LineTo(Rect.Right - 9, 12);
    end;

    Font.Height := -10;
    Font.Color := clBlack;

    W := 0;
    for I := 0 to StatusBar.Panels.Count -1  do
    begin
      if (Panel = StatusBar.Panels[I]) then
      begin
        if (I = 3) then
          Font.Color := clGray;

        if (StatusBar.Panels[I].Text <> '') then
          TextOut(W + 4, 4,
            StatusBar.Panels[I].Text);

        break;
      end;

      W := W + StatusBar.Panels[I].Width;
    end;

  end;

  W := StatusBar.Panels[0].Width + StatusBar.Panels[1].Width;

  FStatusbarHistoryPNGImg.Draw(StatusBar.Canvas,
      Types.Rect(W + 3, 5,
      W + 3 + FStatusbarHistoryPNGImg.Width,
      5 + FStatusbarHistoryPNGImg.Height));
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.StatusBarMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

begin
  if (X > 0) and (X < StatusBar.Panels[0].Width) then
  begin
    ZoomPopupMenu.Popup(Mouse.CursorPos.X, Mouse.CursorPos.Y);
  end
  else
    if (X > StatusBar.Panels[0].Width + StatusBar.Panels[1].Width) and
      (X < StatusBar.Panels[0].Width + StatusBar.Panels[1].Width +
        StatusBar.Panels[2].Width) then
      ShowStatusMessagesActionExecute(self);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DoZoomMenuItemClick(Sender: TObject);

begin
  if (Sender is TTntMenuItem) then
    FCanvasViewer.CurrentZoomStep := TTntMenuItem(Sender).Tag;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.RunScript;

var
  ScriptFileName: WideString;

begin
  ScriptFileName := GetStringOptionFromCommandLine('script');
  if (ScriptFileName <> '') and (FileExists(ScriptFileName)) then
    Grt.ExecuteScriptTask(ScriptFileName, True, ProcessGrtOutput);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ProcessGrtOutput(Text: WideString);

begin
  if (Trim(Text) <> '') then
    ShowModalDialog(Application.Title, Text, myx_mtInformation, _('Ok'));
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ShowXGrtShellActionExecute(Sender: TObject);

begin
  if Assigned(FXGrtShellForm) then
  begin
    if (FXGrtShellForm.Active) then
      FXGrtShellForm.Hide
    else
    begin
      if (FXGrtShellForm.Visible) then
        FXGrtShellForm.RefreshDisplay;

      if (AppOptions.OptionInt['DockGrtShell'] = 1) then
      begin
        if (FDockedShellTab = nil) then
        begin
          // add sidebar palettes
          FXGrtShellForm.GrtShellPalettePnl.Visible := False;
          FXGrtShellForm.GrtShellPalettePnl.Parent := SidebarPnl;

          // add shell to main tabsheet
          FDockedShellTab := EditorTabFrame.TabSheets[
            EditorTabFrame.AddTabSheet(Self,
            _('GRT Shell'),
            'tabsheet_icon_layer',
            FXGrtShellForm.CommandLinePnl,
            FXGrtShellForm.CommandLineUCE,
            False, False, -1, [], True)];

          if (AppOptions.OptionInt['DockGrtShellAutoAddSnippets'] = 1) then
            ShowXGrtCodeSnippetsActionExecute(Sender);
        end;

        EditorPnl.Visible := True;
        EditorTabFrame.SelectedTabSheet := FDockedShellTab;
      end
      else
      begin
        FXGrtShellForm.Show;
        if (FXGrtShellForm.MainPageControl.ActivePageIndex = 0) then
          FXGrtShellForm.ActiveControl := FXGrtShellForm.CommandLineUCE;
      end;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ToolBtnClick(Sender: TObject);

var
  Item: TToolbarItem;
  Group: TToolbarItemGroup;
  Container: TToolbarContainer;
  
begin
  if (Sender is TPNGButton) then
  begin
    Item := TToolbarItem(TPNGButton(Sender).Owner);
    Group := Item.ToolbarItemGroup;
    Container := Group.ToolbarContainer;

    CurrentTool := TWorkbenchTool(
      Container.GetGroupIndex(Group) * 100 +
      Item.ToolbarItemGroup.GetItemIndex(Item) * 10);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SetCurrentTool(CurrentTool: TWorkbenchTool);

var
  I: Integer;
  J: Integer;
  Group: TToolbarItemGroup;
  RelType: WideString;

begin
  if (FCurrentTool <> CurrentTool) then
  begin
    if ((FCurrentTool = wbToolRel1n) or
      (FCurrentTool = wbToolRel11) or
      (FCurrentTool = wbToolRelnm)) and
      (not (FCancelingCurrentTool)) then
    begin
      Grt.ExecuteStandardTask(_('Cancelling relationship tool'), 'Workbench', 'relationshipCancel', [], False);
    end;

    FCurrentTool := CurrentTool;

    for I := 0 to FPaletteContainer.GroupCount - 1 do
    begin
      Group := FPaletteContainer.GroupsByIndex[I];

      for J := 0 to Group.ItemCount - 1 do
      begin
        if (I * 100 + J * 10 <> Ord(CurrentTool)) and
          (Group.ItemsByIndex[J].Down) then
          Group.ItemsByIndex[J].Down := False
        else
          if (I * 100 + J * 10 = Ord(CurrentTool)) then
            Group.ItemsByIndex[J].Down := True;
      end;
    end;

    // -----------------------------------------------------------
    // Tool options toolbar groups

    // wbToolArrow
    {FToolbarContainer.Groups['GlobalObjectLock'].Visible :=
      (FCurrentTool = wbToolArrow);}
    FToolbarContainer.Groups['AlignV'].Visible :=
      (FCurrentTool = wbToolArrow);
    FToolbarContainer.Groups['AlignH'].Visible :=
      (FCurrentTool = wbToolArrow);
    FToolbarContainer.Groups['Dist'].Visible :=
      (FCurrentTool = wbToolArrow);

    // wbToolTable
    FToolbarContainer.Groups['Schema'].Visible :=
      (FCurrentTool = wbToolTable) or
      (FCurrentTool = wbToolView) or
      (FCurrentTool = wbToolRoutine);
    FToolbarContainer.Groups['TableEngine'].Visible :=
      (FCurrentTool = wbToolTable);
    FToolbarContainer.Groups['TableCharset'].Visible :=
      (FCurrentTool = wbToolTable);

    // wbToolRel
    FToolbarContainer.Groups['RelEnds'].Visible :=
      (FCurrentTool = wbToolRel1n) or
      (FCurrentTool = wbToolRel11) or
      (FCurrentTool = wbToolRelnm);

    // -----------------------------------------------------------
    // Tool settings

    case FCurrentTool of
      wbToolRubber:
        FCanvasViewer.Cursor := ToolRubberCursor;

      wbToolLayer:
        FCanvasViewer.Cursor := ToolLayerCursor;
      wbToolNote:
        FCanvasViewer.Cursor := ToolNoteCursor;
      wbToolImage:
        FCanvasViewer.Cursor := ToolImageCursor;

      wbToolTable:
        FCanvasViewer.Cursor := ToolTableCursor;
      wbToolView:
        FCanvasViewer.Cursor := ToolViewCursor;
      wbToolRoutine:
        FCanvasViewer.Cursor := ToolRoutineCursor;

      wbToolRel1n:
        begin
          FCanvasViewer.Cursor := ToolRel1nCursor;
          RelSourceOptionalCBox.Checked :=
            (AppOptions.OptionInt['Rel1nSourceOptional'] = 1);
          RelTargetOptionalCBox.Checked :=
            (AppOptions.OptionInt['Rel1nTargetOptional'] = 1);
        end;
      wbToolRel11:
        begin
          FCanvasViewer.Cursor := ToolRel11Cursor;
          RelSourceOptionalCBox.Checked :=
            (AppOptions.OptionInt['Rel11SourceOptional'] = 1);
          RelTargetOptionalCBox.Checked :=
            (AppOptions.OptionInt['Rel11TargetOptional'] = 1);
        end;
      wbToolRelnm:
        begin
          FCanvasViewer.Cursor := ToolRelnmCursor;
          RelSourceOptionalCBox.Checked :=
            (AppOptions.OptionInt['RelnmSourceOptional'] = 1);
          RelTargetOptionalCBox.Checked :=
            (AppOptions.OptionInt['RelnmTargetOptional'] = 1);
        end;
    else
      FCanvasViewer.Cursor := crDefault;
    end;

    if (FCurrentTool = wbToolRel1n) or
      (FCurrentTool = wbToolRel11) or
      (FCurrentTool = wbToolRelnm) then
    begin
      case FCurrentTool of
        wbToolRel11:
          RelType := '11';
        wbToolRelnm:
          RelType := 'nm';
      else
        RelType := '1n';
      end;

      // start relationship
      FRelationshipContext := Grt.ExecuteStandardTask(_('Starting the relationship tool'), 'Workbench',
        'relationshipStart', [RelType, Ord(RelSourceOptionalCBox.Checked), Ord(RelTargetOptionalCBox.Checked)], True);
    end;
  end;

  FSourceFigure := nil;
  FTargetFigure := nil;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.AlignBtnClick(Sender: TObject);

var
  Item: TToolbarItem;
  Group: TToolbarItemGroup;
  Container: TToolbarContainer;

begin
  if (Sender is TPNGButton) then
  begin
    Item := TToolbarItem(TPNGButton(Sender).Owner);
    Group := Item.ToolbarItemGroup;
    Container := Group.ToolbarContainer;

    case Container.GetGroupIndex(Group) * 10 +
      Item.ToolbarItemGroup.GetItemIndex(Item) of
      40:
        Grt.ExecuteStandardTask(_('Aligning objects'), 'Workbench', 'verticalAlign', ['T'], False);
      41:
        Grt.ExecuteStandardTask(_('Aligning objects'), 'Workbench', 'verticalAlign', ['C'], False);
      42:
        Grt.ExecuteStandardTask(_('Aligning objects'), 'Workbench', 'verticalAlign', ['B'], False);
      50:
        Grt.ExecuteStandardTask(_('Aligning objects'), 'Workbench', 'horizontalAlign', ['L'], False);
      51:
        Grt.ExecuteStandardTask(_('Aligning objects'), 'Workbench', 'horizontalAlign', ['C'], False);
      52:
        Grt.ExecuteStandardTask(_('Aligning objects'), 'Workbench', 'horizontalAlign', ['R'], False);
      60:
        Grt.ExecuteStandardTask(_('Aligning objects'), 'Workbench', 'autoSpaceElements', [1, 200], False);
      61:
        Grt.ExecuteStandardTask(_('Aligning objects'), 'Workbench', 'autoSpaceElements', [0, 300], False);
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.BuildPalettes;

begin
  FGrtObjectTree := TGrtObjectTree.Create(Self);
  FGrtObjectTree.Parent := PalSchemaPnl;
  FGrtObjectTree.Align := alClient;
  FGrtObjectTree.Grt := Grt;
  FGrtObjectTree.PopupMenu := SchemaPopupMenu;
  FGrtObjectTree.TreeOptions.SelectionOptions :=
    FGrtObjectTree.TreeOptions.SelectionOptions +
    [toMultiSelect, toLevelSelectConstraint];
  FGrtObjectTree.DragMode := dmAutomatic;

  FLayerTree := TLayerTree.Create(Self);
  FLayerTree.Parent := PalModelPnl;
  FLayerTree.Align := alClient;
  FLayerTree.Grt := Grt;

  //Set properties of sidebar tabcontrols
  Pal1TabFrame.DrawBottom := True;
  Pal1TabFrame.ShowDeleteButtons := False;
  Pal1TabFrame.ClearTabSheets;
  Pal1TabFrame.AddTabSheet(Pal1Pnl, _('Schemata'), '', PalSchemaPnl, nil, True, True, -1, []);
  //Pal1TabFrame.AddTabSheet(Pal1Pnl, _('Datatypes'), '', PalDatatypePnl, nil, False, True, -1, []);
  Pal1TabFrame.AddTabSheet(Pal1Pnl, _('Plugins'), '', PalPluginOutputPnl, nil, False, True, -1, []);
  Pal1TabFrame.OnPageChange := DoTabChange;

  Pal2TabFrame.DrawBottom := True;
  Pal2TabFrame.ShowDeleteButtons := False;
  Pal2TabFrame.ClearTabSheets;
  Pal2TabFrame.AddTabSheet(Pal2Pnl, _('Layers'), '', PalModelPnl, nil, True, True, -1, []);
  //Pal2TabFrame.AddTabSheet(Pal2Pnl, _('History'), '', PalHistroyPnl, nil, False, True, -1, []);
  Pal2TabFrame.AddTabSheet(Pal2Pnl, _('Properties'), '', PalPropertiesPnl, nil, False, True, -1, []);
  Pal2TabFrame.OnPageChange := DoTabChange;

  DisableEnableControls(PropCoordsPnl, False);
  PropNotePnl.Parent := PalPropertiesPnl;
  PropRelPnl.Parent := PalPropertiesPnl;
  PropLayerPnl.Parent := PalPropertiesPnl;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.BuildToolbars;

var
  PNGImg: TPNGObject;
  ToolbarBGBitmap: TBitmap;
  CurrentGroup: TToolbarItemGroup;

begin
  FToolbars := TToolbars.Create;

  FPaletteContainer := FToolbars.AddToolbar(ModelToolbarPnl,
    'Model', False, True, -10);

  FToolbarContainer := FToolbars.AddToolbar(ToolOptionsToolbarPnl,
   'Toolbar', True{ApplicationDM.Options.UseToolbarGradient}, False);

  //Make background
  if (True{ApplicationDM.Options.UseToolbarGradient}) then
  begin
    //Toolbar BG
    PNGImg := LoadPNGImageFromResource('toolbar_bg2');
    ToolbarBGBitmap := TBitmap.Create;
    ToolbarBGBitmap.Width := PNGImg.Width;
    ToolbarBGBitmap.Height := PNGImg.Height;
    ToolbarBGBitmap.Canvas.Brush.Color := clBtnFace;
    ToolbarBGBitmap.Canvas.FillRect(Rect(0, 0,
      ToolbarBGBitmap.Width, ToolbarBGBitmap.Height));
    PNGImg.Draw(ToolbarBGBitmap.Canvas, Rect(0, 0,
      PNGImg.Width, PNGImg.Height));
    PNGImg.Free;

    FToolbarContainer.BGBitmap := ToolbarBGBitmap;

    ToolbarBGBitmap.Free;
  end;

  CurrentGroup := FPaletteContainer.AddGroup('MouseStd', False);

  // -----------------------------------------
  CurrentGroup.AddItem(
    'CursorArrowBtn', 'wb_arrow',
    _('Arrow'), _('Standard mouse pointer'),
    2, False, False, False, ToolBtnClick,
    nil, nil, True, True, True);

  CurrentGroup.AddItem(
    'CursorHandBtn', 'wb_hand',
    _('Hand'), _('The hand tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, False, False, True);

  {CurrentGroup.AddItem(
    'CursorMaginifierBtn', 'wb_magnifier',
    _('Magnifier'), _('The magnifier tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, True, False, True);

  CurrentGroup.AddItem(
    'CursorExposeBtn', 'wb_expose',
    _('Expose'), _('The expose tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, True, False, True);}

  // -----------------------------------------

  CurrentGroup := FPaletteContainer.AddGroup('MouseRubber',
    True, False, 2);
  CurrentGroup.Space := 0;

  CurrentGroup.AddItem(
    'CursorRubberBtn', 'wb_rubber',
    _('Rubber'), _('The rubber tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, False, False, True);

  // -----------------------------------------

  CurrentGroup := FPaletteContainer.AddGroup('MouseLayer',
    True, False, 2);
  CurrentGroup.Space := 0;

  CurrentGroup.AddItem(
    'CursorRegionBtn', 'wb_layer',
    _('Layer'), _('The layer tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, True, False, True);

  // -----------------------------------------

  CurrentGroup := FPaletteContainer.AddGroup('MouseDb',
    True, False, 2);
  CurrentGroup.Space := 0;

  CurrentGroup.AddItem(
    'CursorTableBtn', 'wb_db_table',
    _('Table'), _('The table tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, True, False, True);

  CurrentGroup.AddItem(
    'CursorViewBtn', 'wb_db_view',
    _('View'), _('The view tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, True, False, True);

  CurrentGroup.AddItem(
    'CursorSPBtn', 'wb_db_sp',
    _('Stored procedure'), _('The routine group tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, True, False, True);

  // -----------------------------------------

  CurrentGroup := FPaletteContainer.AddGroup('MouseRel',
    True, False, 2);
  CurrentGroup.Space := 0;

  CurrentGroup.AddItem(
    'CursorRel1nBtn', 'wb_rel_1n',
    _('Relationship 1 to many'), _('The 1:n relationship tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, True, False, True);

  CurrentGroup.AddItem(
    'CursorRel11Btn', 'wb_rel_11',
    _('Relationship 1 to 1'), _('The 1:1 relationship tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, True, False, True);

  CurrentGroup.AddItem(
    'CursorRelnmBtn', 'wb_rel_nm',
    _('Relationship many to many'), _('The n:m relationship tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, True, False, True);

  // -----------------------------------------

  CurrentGroup := FPaletteContainer.AddGroup('MouseDoc',
    True, False, 2);
  CurrentGroup.Space := 0;

  CurrentGroup.AddItem(
    'CursorNoteBtn', 'wb_note',
    _('Note'), _('The note tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, True, False, True);

  {CurrentGroup.AddItem(
    'CursorImageBtn', 'wb_image',
    _('Image'), _('The image tool'),
    2, False, False, False, ToolBtnClick,
    nil, nil, True, False, True);}


  // -----------------------------------------
  // Toolbar

  CurrentGroup := FToolbarContainer.AddGroup('View',
    True, False, 5);
  CurrentGroup.Space := 6;

  CurrentGroup.AddItem(
    'OverviewBtn', 'tiny_overview',
    _('Overview'), _('Overview [Space + Shift]'),
    3, False, False, False, nil,
    nil, nil, True, False, True,
    OverviewAction);

  CurrentGroup.AddItem(
    'GridBtn', 'tiny_grid',
    _('Grid'), _('Display grid'),
    3, False, False, False, nil,
    nil, nil, False, False, True,
    nil);

  CurrentGroup.AddItem(
    'LockBtn', 'tiny_lock',
    _('Lock'), _('Lock all Objects'),
    3, False, False, False, nil,
    nil, nil, False, False, True,
    nil);

  // -----------------------------------------

  CurrentGroup := FToolbarContainer.AddGroup('UndoRedoSync',
    True, False, 5);
  CurrentGroup.Space := 6;

  CurrentGroup.AddItem(
    'UndoBtn', 'tiny_undo',
    _('Undo'), _('Undo recent changes'),
    3, False, False, False, nil,
    nil, nil, False, False, True);

  CurrentGroup.AddItem(
    'RedoBtn', 'tiny_redo',
    _('Redo'), _('Redo last undone change'),
    3, False, False, False, nil,
    nil, nil, False, False, True);

  {CurrentGroup.AddItem(
    'SyncBtn', 'tiny_execute',
    _('Synchronize'), _('Synchronize model with database'),
    3, False, False, False, nil,
    nil, nil, False, False, True);}

  // -----------------------------------------

  CurrentGroup := FToolbarContainer.AddGroup('OpenSave',
    True, False, 5);
  CurrentGroup.Space := 6;

  {CurrentGroup.AddItem(
    'OpenBtn', 'tiny_open',
    _('Open'), _('Open model'),
    3, False, False, False, nil,
    nil, nil, True, False, True,
    FileOpenAction);}

  CurrentGroup.AddItem(
    'SaveBtn', 'tiny_save',
    _('Save'), _('Save model'),
    3, False, False, False, nil,
    nil, nil, True, False, True,
    FileSaveAction);

  // -----------------------------------------

  CurrentGroup := FToolbarContainer.AddGroup('ToolsOptions');

  CurrentGroup.AddItem(
    'ToolsOptionsLbl', '',
    _('Tool Options:'), '',
    7, True, False, False, nil);


  // -----------------------------------------
  // Arrow
  // -----------------------------------------

  {CurrentGroup := FToolbarContainer.AddGroup('GlobalObjectLock');

  GlobalObjectLockCBox := TTntCheckBox.Create(ToolOptionsToolbarPnl);
  with GlobalObjectLockCBox do
  begin
    Parent := ToolOptionsToolbarPnl;
    Font.Name := 'Tahoma';
    Font.Size := 7;
    Caption := ' ' + _('Global Object Lock');
    Top := 7;
    Height := 12;
    Width := 100;
    TabStop := False;
    //OnChange := DoScriptTypeChange;
    //OnCloseUp := DoScriptTypeChange;
  end;

  CurrentGroup.AddItem(
    'GlobalObjectLockCBox', '',
    '', '',
    10, True, False, False, nil, nil, GlobalObjectLockCBox,
    False);}

  // -----------------------------------------

  CurrentGroup := FToolbarContainer.AddGroup('AlignV',
    True, False, 4);

  CurrentGroup.AddItem(
    'AlignTopBtn', 'tiny_align_v_top',
    '', _('Align top edges'),
    4, False, False, False, AlignBtnClick,
    nil, nil, True, False, True);

  CurrentGroup.AddItem(
    'AlignVBtn', 'tiny_align_v_middle',
    '', _('Align vertical centers'),
    4, False, False, False, AlignBtnClick,
    nil, nil, True, False, True);

  CurrentGroup.AddItem(
    'AlignBottomBtn', 'tiny_align_v_bottom',
    '', _('Align bottom edges'),
    4, False, False, False, AlignBtnClick,
    nil, nil, True, False, True);


  CurrentGroup := FToolbarContainer.AddGroup('AlignH',
    False, False, 8);

  CurrentGroup.AddItem(
    'AlignTopBtn', 'tiny_align_h_left',
    '', _('Align top edges'),
    4, False, False, False, AlignBtnClick,
    nil, nil, True, False, True);

  CurrentGroup.AddItem(
    'AlignVBtn', 'tiny_align_h_middle',
    '', _('Align vertical centers'),
    4, False, False, False, AlignBtnClick,
    nil, nil, True, False, True);

  CurrentGroup.AddItem(
    'AlignBottomBtn', 'tiny_align_h_right',
    '', _('Align bottom edges'),
    4, False, False, False, AlignBtnClick,
    nil, nil, True, False, True);


  CurrentGroup := FToolbarContainer.AddGroup('Dist',
    False, False, 8);

  CurrentGroup.AddItem(
    'AlignVBtn', 'tiny_align_v_middle2',
    '', _('Align vertical centers'),
    4, False, False, False, AlignBtnClick,
    nil, nil, True, False, True);

  CurrentGroup.AddItem(
    'AlignVBtn', 'tiny_align_h_middle2',
    '', _('Align vertical centers'),
    4, False, False, False, AlignBtnClick,
    nil, nil, True, False, True);

  {CurrentGroup.AddItem(
    'AlignBottomBtn', 'tiny_align_v_bottom2',
    '', _('Align bottom edges'),
    4, False, False, False, AlignBtnClick,
    nil, nil, True, False, True);}

  // -----------------------------------------
  // Table
  // -----------------------------------------

  CurrentGroup := FToolbarContainer.AddGroup('Schema');

  CurrentGroup.AddItem(
    'SchemaLbl', '',
    _('Schema:'), '',
    8, True, False, False, nil);

  SchemaComboBox := TTntComboBox.Create(ToolOptionsToolbarPnl);
  with SchemaComboBox do
  begin
    Parent := ToolOptionsToolbarPnl;
    Font.Name := 'Tahoma';
    Font.Size := 7;
    Top := 4;
    Width := 120;

    Style := csDropDownList;
    TabStop := False;
    ItemIndex := 0;
  end;

  CurrentGroup.AddItem(
    'SchemaCBox', '',
    '', '',
    10, True, False, False, nil, nil, SchemaComboBox);

  CurrentGroup.Visible := False;

  // -----------------------------------------

  CurrentGroup := FToolbarContainer.AddGroup('TableEngine');

  CurrentGroup.AddItem(
    'TableEngineLbl', '',
    _('Engine:'), '',
    8, True, False, False, nil);

  TableEngineComboBox := TTntComboBox.Create(ToolOptionsToolbarPnl);
  with TableEngineComboBox do
  begin
    Parent := ToolOptionsToolbarPnl;
    Font.Name := 'Tahoma';
    Font.Size := 7;
    Top := 4;
    Width := 120;
    Items.Add('InnoDB');
    Items.Add('MyISAM');
    Items.Add('Memory');
    Items.Add('Merge');
    Items.Add('NDB');
    Items.Add('BDB');
    Style := csDropDownList;
    TabStop := False;
    ItemIndex := 0;
  end;

  CurrentGroup.AddItem(
    'TableEngineCBox', '',
    '', '',
    10, True, False, False, nil, nil, TableEngineComboBox);

  CurrentGroup.Visible := False;

  // -----------------------------------------

  CurrentGroup := FToolbarContainer.AddGroup('TableCharset');

  CurrentGroup.AddItem(
    'TableCharsetLbl', '',
    _('Collation:'), '',
    8, True, False, False, nil);

  TableCollationComboBox := TTntComboBox.Create(ToolOptionsToolbarPnl);
  with TableCollationComboBox do
  begin
    Parent := ToolOptionsToolbarPnl;
    Font.Name := 'Tahoma';
    Font.Size := 7;
    Top := 4;
    Width := 120;

    DropDownCount := 50;
    OnCloseUp := DoCollationComboBoxCloseUp;

    Style := csDropDownList;
    TabStop := False;
  end;

  CurrentGroup.AddItem(
    'TableCharsetCBox', '',
    '', '',
    10, True, False, False, nil, nil, TableCollationComboBox);

  CurrentGroup.Visible := False;


  // -----------------------------------------
  // Relationship
  // -----------------------------------------

  CurrentGroup := FToolbarContainer.AddGroup('RelEnds');

  RelSourceOptionalCBox := TTntCheckBox.Create(ToolOptionsToolbarPnl);
  with RelSourceOptionalCBox do
  begin
    Parent := ToolOptionsToolbarPnl;
    Font.Name := 'Tahoma';
    Font.Size := 7;
    Caption := ' ' + _('Source Optional');
    Top := 7;
    Height := 12;
    Width := 100;
    TabStop := False;
    //OnChange := DoScriptTypeChange;
    //OnCloseUp := DoScriptTypeChange;
  end;

  CurrentGroup.AddItem(
    'RelSourceOptionalCBox', '',
    '', '',
    10, True, False, False, nil, nil, RelSourceOptionalCBox,
    False);

  RelTargetOptionalCBox := TTntCheckBox.Create(ToolOptionsToolbarPnl);
  with RelTargetOptionalCBox do
  begin
    Parent := ToolOptionsToolbarPnl;
    Font.Name := 'Tahoma';
    Font.Size := 7;
    Caption := ' ' + _('Target Optional');
    Top := 7;
    Height := 12;
    Width := 100;
    TabStop := False;
    //OnChange := DoScriptTypeChange;
    //OnCloseUp := DoScriptTypeChange;
  end;

  CurrentGroup.AddItem(
    'RelTargetOptionalCBox', '',
    '', '',
    10, True, False, False, nil, nil, RelTargetOptionalCBox,
    False);

  CurrentGroup.Visible := False;
end;


//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DoCollationComboBoxCloseUp(Sender: TObject);

begin
  if (Copy(TableCollationComboBox.Text, 1, 4) = '____') then
    TableCollationComboBox.ItemIndex := 0;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.LoadCursors;

begin
  Screen.Cursors[ToolRubberCursor] :=
    LoadCursor(HInstance, 'cursor_rubber');

  Screen.Cursors[ToolLayerCursor] :=
    LoadCursor(HInstance, 'cursor_layer');
  Screen.Cursors[ToolNoteCursor] :=
    LoadCursor(HInstance, 'cursor_note');
  Screen.Cursors[ToolImageCursor] :=
    LoadCursor(HInstance, 'cursor_image');

  Screen.Cursors[ToolTableCursor] :=
    LoadCursor(HInstance, 'cursor_table');
  Screen.Cursors[ToolViewCursor] :=
    LoadCursor(HInstance, 'cursor_view');
  Screen.Cursors[ToolRoutineCursor] :=
    LoadCursor(HInstance, 'cursor_routine');

  Screen.Cursors[ToolRel1nCursor] :=
    LoadCursor(HInstance, 'cursor_rel1n');
  Screen.Cursors[ToolRel11Cursor] :=
    LoadCursor(HInstance, 'cursor_rel11');
  Screen.Cursors[ToolRelnmCursor] :=
    LoadCursor(HInstance, 'cursor_relnm');
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DoTabChange(Sender: TObject; PreviousSelectedTab: Integer; PreviousSelectedObj: TObject;
  NewSelectedTab: Integer; obj: TObject);

begin
  //
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.LoadStyleFromTemplate(Canvas: TGenericCanvas; FileName: WideString; Vars: Pointer);

var
  Count: Integer;

begin
  Count := TGrtWb(Grt).LoadStylesFromFile(Canvas, FileName, Vars);
  if (Count <> 0) then
    raise Exception.Create(Format('XML parse error of file %s',
      [FileName]));
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.InitializeCanvas;

var
  StyleParamPresets: Pointer;
  I: Integer;
  ZoomMenuItem: TTntMenuItem;

begin
  if FViewerContainer = nil then
  begin
    FViewerContainer := TTntPanel.Create(Self);
    FViewerContainer.Parent := CanvasPanel;
    FViewerContainer.Align := alClient;
    FViewerContainer.BevelOuter := bvNone;
  end;

  FCanvasViewer := TGenericCanvasViewer.Create(Self);
  with FCanvasViewer do
  begin
    OnError := ViewerError;

    OnFocusChanged := ViewerFocusChanged;

    OnChange := ViewerChange;
    OnZoomChange := ViewerZoomChange;

    OnMouseDown := ViewerMouseDown;
    OnMouseUp := ViewerMouseUp;

    OnDragOver := ViewerDragOver;
    OnDragDrop := ViewerDragDrop;

    OnAction := ViewerAction;

    Parent := FViewerContainer;
    Align := alClient;
    BaseSizeX := AppOptions.OptionInt['DefaultModelBaseWidth'];
    BaseSizeY := AppOptions.OptionInt['DefaultModelBaseHeight'];

    Canvas.SetTexturePath('../images');
    AutoScrollDelay := 200;
    AutoScrollInterval := 10;
    AnimationInterval := 10;

    // load fixed styles
    LoadStyles('./xml/layout.styles.db.connection.xml');
    LoadStyles('./xml/layout.styles.db.routine.xml');
    LoadStyles('./xml/layout.styles.db.table.xml');
    LoadStyles('./xml/layout.styles.db.view.xml');

    // load dynamic styles
    StyleParamPresets := Grt.ExecuteStandardTask(_('Getting color presets'), 'Workbench', 'getColorPresets', [], True);

    LoadStyleFromTemplate(Canvas,
      './xml/layout.styles.db.table.tmpl.xml', Grt.DictItem[StyleParamPresets, 'table']);
    LoadStyleFromTemplate(Canvas,
      './xml/layout.styles.layer.tmpl.xml', Grt.DictItem[StyleParamPresets, 'layer']);
    LoadStyleFromTemplate(Canvas,
      './xml/layout.styles.note.tmpl.xml', Grt.DictItem[StyleParamPresets, 'note']);
    LoadStyleFromTemplate(Canvas,
      './xml/layout.styles.db.view.tmpl.xml', Grt.DictItem[StyleParamPresets, 'view']);

    Grt.ValueRelease(StyleParamPresets);


    // load figures
    LoadLayouts('./xml/layout.figures.db.xml');

    // Initialize Workbench controller bridge
    TGrtWb(Grt).InitializeGcWbBridge(Canvas, '/workbench/model');

    // Set bridge callbacks
    TGrtWb(Grt).RegisterGcWbBridgeCallbacks(GrtWbViewChange, GrtWbLayerChange, GrtWbFigureChange);

    // initialize a new doc
    Grt.ExecuteStandardTask(_('Creating a new document'), 'Workbench', 'newDocument',
      [AppOptions.OptionString['DefaultRbdms'], AppOptions.OptionString['DefaultRbdmsVersion']], True);

    ProcessNewDocument;

    // Create Zoom menu entries
    for I := 0 to ZoomStepCount - 1 do
    begin
      ZoomMenuItem := TTntMenuItem.Create(self);
      ZoomMenuItem.Caption := FormatFloat('##0.##',
        FCanvasViewer.ZoomStep[I] * 100) + '%';
      ZoomMenuItem.OnClick := DoZoomMenuItemClick;
      ZoomMenuItem.Tag := I;

      ZoomPopupMenu.Items.Add(ZoomMenuItem);
    end;

    // default to 75%
    CurrentZoom := AppOptions.OptionFloat['InitialZoom'];
  end;

  PrintAction.Enabled := FCanvasViewer.Canvas.SupportsExtension(GC_OE_FRAME_BUFFER_OBJECTS);

  // Start FPS display
  FpsTimer.Enabled := True;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ProcessNewDocument;

var
  I: Integer;
  Number: Integer;

var
  Marker, MarkerList: Pointer;

begin
  UpdateSchemaListings;

  // enabled marker actions based on markers in list
  MarkerList := Grt.Global['/workbench/model/markers'];
  for I := 0 to ActionList.ActionCount - 1 do
    if (Copy(ActionList.Actions[I].Name, 1, 12) = 'RecallMarker') then
    begin
      Number := StrToIntDef(Copy(ActionList.Actions[I].Name, 13, 1), -1);

      if (Number > -1) then
      begin
        Marker := Grt.ListItemByObjectName[MarkerList,
          'Marker' + IntToStr(Number)];

        if (Marker <> nil) then
          TTntAction(ActionList.Actions[I]).Enabled := True;
      end;
    end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewerChange(Sender: TObject; Source: TGCBase; Reason: TGCChangeReason);

begin
  case Reason of
    GC_CHANGE_VIEW_OVERVIEW_START,
    GC_CHANGE_VIEW_OVERVIEW_STOP:
      OverviewActionUpdate(OverviewAction);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewerError(Sender: TObject; const Message: string);

begin
  StatusbarText := Message;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewerZoomChange(Sender: TObject);

begin
  StatusBar.Panels[0].Text :=
    FormatFloat('##0.##', FCanvasViewer.CurrentZoom * 100) + '%';
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewerMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer;
  var Handled: Boolean);

var
  V: TVertex;
  Msg: Pointer;
  Element: Pointer;
  Task: IGrtTask;
  
begin
  FCanvasViewer.Canvas.GetCurrentView.WindowToView(X, Y, V);
  Element := nil;

  case CurrentTool of
    wbToolTable:
      begin
        Handled := True;

        inc(FNewTableCounter);

        Element := Grt.ExecuteStandardTask(_('Placing new table element'), 'Workbench', 'placeNewTableElement',
          [V.X, V.Y, 'table_' + FormatFloat('00', FNewTableCounter),
            Grt.Global['/workbench/catalog/schemata/' +
              IntToStr(SchemaComboBox.ItemIndex)],
              TableEngineComboBox.Items[TableEngineComboBox.ItemIndex],
              TableCollationComboBox.Items[TableCollationComboBox.ItemIndex]], True);
      end;
    wbToolView:
      begin
        Handled := True;

        inc(FNewTableCounter);

        Element := Grt.ExecuteStandardTask(_('Placing new view element'), 'Workbench', 'placeNewViewElement',
          [V.X, V.Y, 'view_' + FormatFloat('00', FNewTableCounter),
            Grt.Global['/workbench/catalog/schemata/' +
              IntToStr(SchemaComboBox.ItemIndex)]], True);
      end;
    wbToolRoutine:
      begin
        Handled := True;

        inc(FNewTableCounter);

        Element := Grt.ExecuteStandardTask(_('Placing new routine group element'), 'Workbench', 'placeNewRoutineGroupElement',
          [V.X, V.Y, 'routine_group_' + FormatFloat('00', FNewTableCounter),
            Grt.Global['/workbench/catalog/schemata/' +
              IntToStr(SchemaComboBox.ItemIndex)]], True);
      end;
    wbToolLayer, wbToolNote:
      begin
        Handled := True;
        FCanvasViewer.Canvas.GetCurrentView.RubberRectStart(GC_RRSTYLE_SOLID_THIN, V, False);
      end;
    wbToolRel1n, wbToolRel11, wbToolRelnm:
      begin
        Handled := True;
        FRubberBandClickVertex := V;

        try
          Msg := Grt.ExecuteStandardTask(_('Selecting relationship end point'),
            'Workbench', 'relationshipClickedPoint', [FRelationshipContext, V.X, V.Y], True);

          if (Msg <> nil) then
            StatusbarText := Grt.ValueString[Msg];

          Grt.ValueRelease(Msg);
        except
          // ignore no object error
        end;
      end;
    wbToolCBSelect:
      begin
        Handled := True;
        FCanvasViewer.Canvas.GetCurrentView.RubberRectStart(GC_RRSTYLE_BLENDED_CHECKERBOARD, V, False);
      end;
  end;

  // if mouse down did not generate a new element,
  // check if one was clicked
  if (Element = nil) then
  begin
    Task := Grt.CreateStandardTask(_('Getting object from position'), 'WorkbenchController', 'objectAtPoint',
      [V.X, V.Y], nil, nil, True);
    Grt.AddTaskAndWait(Task, False);

    if Assigned(Task.Result) then
    begin
      Element := Grt.DictItem[Task.Result, 'element'];
      if Assigned(Element) then
        Grt.ValueRetain(Element);

      Grt.ValueRelease(Task.Result);
    end;
  end;

  // Store CurrentElement
  CurrentElement := Element;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewerMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer;
  var Handled: Boolean);

var
  Bounds: TBoundingBox;
  Element: Pointer;

begin
  case CurrentTool of
    wbToolLayer:
      begin
        Handled := True;

        FCanvasViewer.Canvas.GetCurrentView.GetLastRubberBounds(Bounds);
        FCanvasViewer.Canvas.GetCurrentView.RubberRectStop;

        CurrentTool := wbToolArrow;

        Element := Grt.ExecuteStandardTask(_('Placing new layer element'), 'Workbench', 'placeNewLayerElement',
          [Bounds.Upper.X, Bounds.Upper.Y, Bounds.Lower.X - Bounds.Upper.X, Bounds.Lower.Y - Bounds.Upper.Y, 'New Layer'],
          True);

        CurrentElement := Element;
      end;
    wbToolNote:
      begin
        Handled := True;

        FCanvasViewer.Canvas.GetCurrentView.GetLastRubberBounds(Bounds);
        FCanvasViewer.Canvas.GetCurrentView.RubberRectStop;

        CurrentTool := wbToolArrow;

        Element := Grt.ExecuteStandardTask(_('Placing new note element'), 'Workbench', 'placeNewNoteElement',
          [Bounds.Upper.X, Bounds.Upper.Y, Bounds.Lower.X - Bounds.Upper.X, Bounds.Lower.Y - Bounds.Upper.Y, 'yellow'],
          True);

        CurrentElement := Element;
      end;
    wbToolCBSelect:
      begin
        Handled := True;
        CurrentTool := wbToolArrow;

        StatusbarText := _('Converting image. This may take few moments...');
        Screen.Cursor := crHourGlass;
        try
          FCanvasViewer.Canvas.GetCurrentView.GetLastRubberBounds(Bounds);
          FCanvasViewer.Canvas.GetCurrentView.RubberRectStop;
          FCanvasViewer.CopyToClipboard(Bounds);
        finally
          StatusBarText := _('');
          Screen.Cursor := crDefault;
        end;
      end;
  else
    if (CurrentTool <> wbToolRel1n) and
      (CurrentTool <> wbToolRel11) and
      (CurrentTool <> wbToolRelnm) then
    begin
      CurrentTool := wbToolArrow;

      UpdateProperties;
    end;
  end;
  
  TGrtWb(Grt).ProcessRelocations;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewerDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);

var
  Selection: TNodeArray;
  I: Integer;
  NodeData: PGrtObjTreeData;
  ObjNum: Integer;

begin
  Accept := False;
  Selection := nil;

  if (Sender = FCanvasViewer) then
  begin
    Selection := FGrtObjectTree.GetSortedSelection(True);
    Accept := True;
    ObjNum := 0;

    for I := 0 to FGrtObjectTree.SelectedCount - 1 do
    begin
      NodeData := FGrtObjectTree.GetNodeData(Selection[I]);

      if (Grt.StructInheritsFrom(NodeData.StructName, 'db.Schema')) then
      begin
        Accept := False;
        break;
      end;

      if (Grt.ValueType(NodeData.Value) = GrtDictValue) then
        inc(ObjNum);
    end;

    Accept := (ObjNum > 0);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewerDragDrop(Sender, Source: TObject; X,
  Y: Integer);

var
  Selection: TNodeArray;
  I: Integer;
  NodeData: PGrtObjTreeData;
  ObjList: Pointer;
  V: TVertex;

begin
  Selection := nil;
  if (Sender = FCanvasViewer) then
  begin
    Selection := FGrtObjectTree.GetSortedSelection(True);

    ObjList := Grt.ListNew(GrtAnyValue, '');

    for I := 0 to FGrtObjectTree.SelectedCount - 1 do
    begin
      NodeData := FGrtObjectTree.GetNodeData(Selection[I]);

      if (Grt.ValueType(NodeData.Value) = GrtDictValue) then
        Grt.ListAdd(ObjList, NodeData.Value);
    end;

    FCanvasViewer.Canvas.GetCurrentView.WindowToView(X, Y, V);

    Grt.ExecuteStandardTask(_('Arranging objects on view'), 'Workbench', 'arrangeObjectsOnCurrentView',
      [ObjList, V.X, V.Y], False);
    
    // build relationships
    Grt.ExecuteStandardTask(_('Creating relationships from foreign keys'), 'Workbench', 'createRelationshipsFromFKs',
      [Grt.DictRef[Grt.Global['/workbench/model'], 'currentView']], True);

    Grt.ValueRelease(ObjList);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewerAction(Sender: TObject; Origin: TGCBase; var ActionType: TActionType);

begin
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.GrtWbViewChange(View, ViewObject: Pointer; Reason: GrtWbCallbackReason);

var
  Background: array[0..3] of Single;
  WbView: Pointer;
  I: Integer;

begin
  FInGrtCallback := True;
  try
    // A new view is added
    case Reason of
      GrtWbRefresh:
        FCanvasViewer.Refresh;
      GrtWbChangeAdded:
        begin
          Modified := True;
          
          // Set background color
          Background[0] := 255;
          Background[1] := 255;
          Background[2] := 255;
          Background[3] := 0;

          TView(ViewObject).ColorV(Background);

          // Set paper size
          FCanvasViewer.BaseSizeX :=
            AppOptions.OptionInt['DefaultModelBaseWidth'];
          FCanvasViewer.BaseSizeY :=
            AppOptions.OptionInt['DefaultModelBaseHeight'];

          TView(ViewObject).WorkspaceSet(FCanvasViewer.BaseSizeX, FCanvasViewer.BaseSizeY);
          FCanvasViewer.CurrentZoom := AppOptions.OptionFloat['InitialZoom'];

          WbView := TGrtWb(Grt).GetWbObjectForView(ViewObject);

          // Add View to tabsheet
          ViewTabFrame.AddTabSheet(Self,
            Grt.DictString[WbView, 'name'],
            'tabsheet_icon_layer',
            FViewerContainer, TView(ViewObject),
            (ViewTabFrame.TabCount = 0), False, -1, [], True);
        end;
      GrtWbChangeRemove:
        begin
          Modified := True;
          for I := 0 to ViewTabFrame.TabCount - 1 do
          begin
            if (ViewTabFrame.TabSheets[I].Obj = View) then
            begin
              ViewTabFrame.DeleteTab(I, True, True);
              Break;
            end;
          end;
        end;
      GrtWbChangeSwitched:
        ActivateView(TView(ViewObject));
      GrtWbChangeRubberbandStarted,
      GrtWbChangeRubberbandStopped:
        TGrtWb(Grt).ProcessPendingWbBridge;
      GrtWbChangeTaskCompleted,
      GrtWbChangeTaskCanceled:
        begin
          if (CurrentTool <> wbToolArrow) then
          begin
            FCancelingCurrentTool := True;
            try
              CurrentTool := wbToolArrow;
            finally
              FCancelingCurrentTool := False;
            end;
          end;
        end;
    end;
  finally
    FInGrtCallback := False;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.GrtWbLayerChange(Layer, LayerObject: Pointer; Reason: GrtWbCallbackReason);

begin
  FInGrtCallback := True;
  try
    Modified := True;
    RefreshDisplay;
  finally
    FInGrtCallback := False;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.GrtWbFigureChange(Figure, FigureObject: Pointer; Reason: GrtWbCallbackReason);

var
  Task: IGrtTask;

begin
  FInGrtCallback := True;
  try
    Modified := True;
    case Reason of
      GrtWbChangeRemove:
      begin
        Task := Grt.CreateStandardTask(_('Remove obsolete FKs'),
          'Workbench', 'deleteFKsWithTable', [Figure]);
        Grt.AddTask(Task);
      end;
    end;
    RefreshDisplay;
  finally
    FInGrtCallback := False;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SetModified(const Value: Boolean);

var
  FileName: WideString;

begin
  if FModified <> Value then
  begin
    FModified := Value;
    if FModelFileName = '' then
      FileName := _('New Model')
    else
      FileName := FModelFileName;
    if FModified then
      Caption := 'MySQL Workbench - ' + ExtractFileName(FileName) + ' *'
    else
      Caption := 'MySQL Workbench - ' + ExtractFileName(FileName);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.WMInitMenuPopup(var MSG: TWMInitMenuPopup);

begin
  if (Msg.MenuPopup = WindowMI.Handle) then
    BuildRegisterApplicationMenuItems(WindowMI);

  inherited;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DisplayGrtSidebar;

begin
  if (FXGrtShellForm.GrtShellPalettePnl.Visible = False) then
  begin
    //Refresh
    FXGrtShellForm.RefreshDisplay;

    ViewPalettesPanel.Visible := False;
    FXGrtShellForm.GrtShellPalettePnl.Visible := True;

    if (AppOptions.OptionInt['SideBarOneWidth'] = 0) then
      SidebarPnl.Width := AppOptions.OptionInt['SideBarWidthGrtShell']
    else
      SidebarPnl.Width := AppOptions.OptionInt['SideBarWidthView'];
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DisplayViewSidebar;

begin
  if (ViewPalettesPanel.Visible = False) then
  begin
    FXGrtShellForm.GrtShellPalettePnl.Visible := False;
    ViewPalettesPanel.Visible := True;

    SidebarPnl.Width := AppOptions.OptionInt['SideBarWidthView'];
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewTabPageChange(Sender: TObject; PreviousSelectedTab: Integer; PreviousSelectedObj: TObject;
  NewSelectedTab: Integer; Obj: TObject);

var
  Base: TGCBase;
  View: TView;

begin
  if not IsDelphiClass(Obj) then
  begin
    Base := TGCBase(Obj);
    if Base.ClassIs('CGCView') then
    begin
      if (Not(FManualChangeView)) and (NewSelectedTab < ViewTabFrame.TabCount) then
      begin
        View := TView(ViewTabFrame.TabSheets[NewSelectedTab].Obj);
        ActivateView(View);
        ActiveControl := FCanvasViewer;
      end;

      DisplayViewSidebar;
    end;
  end
  else
    if (GrtSheetIsActive) then
    begin
      if Obj is TUniCodeEdit then
        TUniCodeEdit(Obj).SetFocus;

      DisplayGrtSidebar;
    end;
end;

//----------------------------------------------------------------------------------------------------------------------

function TMainForm.ActivateView(View: TView): Integer;

var
  I: Integer;

begin
  Result := -1;

  FManualChangeView := True;
  try
    FCanvasViewer.Canvas.CurrentViewSet(View);

    for I := 0 to ViewTabFrame.TabCount - 1 do
      if (ViewTabFrame.TabSheets[I].Obj = View) then
      begin
        Result := I;
        ViewTabFrame.SelectedTab := I;
        break;
      end;
  finally
    FManualChangeView := False;
    if Visible and FCanvasViewer.CanFocus then
      FCanvasViewer.SetFocus;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewTabPageCanClose(Sender: TObject; var CanClose: Boolean);

var
  Base: TGCBase;

begin
  if not Application.Terminated then
  begin
    if not IsDelphiClass(TTab(Sender).Obj) then
    begin
      Base := TGCBase(TTab(Sender).Obj);
      if Base.ClassIs('CGCView') then
        CanClose := (ShowModalDialog(_('Delete View'),
          _('Are you sure you want to delete the View?'),
          myx_mtConfirmation, _('Yes') + #13#10 + _('No')) = 1);
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewTabPageDelete(Sender: TObject);

var
  WbView: Pointer;
  Base: TGCBase;

begin
  if not FInGrtCallback and (Sender is TTab) and (not(Application.Terminated)) then
  begin
    if not IsDelphiClass(TTab(Sender).Obj) then
    begin
      Base := TGCBase(TTab(Sender).Obj);
      if Base.ClassIs('CGCView') then
      begin
        WbView := TGrtWb(Grt).GetWbObjectForView(Base);
        Grt.ListDel(Grt.Global['/workbench/model/views'], WbView);
      end;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewTabPageRequestNew(Sender: TObject);

var
  ViewName: WideString;

begin
  if (ShowModalEditDialog(_('New Model View'),
    _('Please enter the name of the model view.'),
    myx_mtEdit, _('Create Model View') + #13#10 + _('Cancel'),
    True, _('Model View Name:'), ViewName) = 1) then
  begin
    Grt.ExecuteStandardTask(_('Adding a vew'), 'Workbench', 'addView', [Grt.Global['/workbench/model'], ViewName], True);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ReverseEngineerActionExecute(Sender: TObject);

begin
  if (RevEngForm = nil) then
  begin
    RevEngForm := TReverseEngineeringForm.Create(nil);
    RevEngForm.OnClose := DoReverseEngineeringFormClose;
  end;

  RevEngForm.Show;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DoReverseEngineeringFormClose(Sender: TObject; var Action: TCloseAction);

begin
  RevEngForm := nil;

  Action := caFree;

  RefreshModelActionExecute(self);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DockPnlIgnoreWMEraseBkGnd(var Msg: TMessage);

begin
  if (Msg.Msg = WM_ERASEBKGND) then
    Msg.Result := 0
  else
    FDockPnlWindowProc(Msg);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.RegisterWorkbenchUi;

begin
  // Register WorkbenchUi module
  Grt.AddDelphiModule('WorkbenchUi',
    'editSchema' + #13#10 +
    'editTable' + #13#10 +
    'editView' + #13#10 +
    'editRoutine' + #13#10 +
    'editRoutineGroup' + #13#10 +
    'popupPluginsMenu' + #13#10 +
    'popupConnectionMenu',
    self);

  Grt.ExecuteStandardTask(_('Registering module editors'), 'Workbench', 'registerEditors', [], True);
end;

//----------------------------------------------------------------------------------------------------------------------

function TMainForm.GrtExecuteModuleFunction(
  ModuleName: WideString; FunctionName: WideString; arguments: Pointer): Pointer;

var
  Entry: PModuleFunctionCallEntry;
  Obj: Pointer;

begin
  Result := nil;

  Obj := nil;

  if (arguments <> nil) then
    if (Grt.ValueType(arguments) = GrtListValue) then
    begin
      if (Grt.ListCount(arguments) > 0) then
        Obj := Grt.ListItem[arguments, 0];
    end;

  if (Obj <> nil) then
  begin
    // create new entry for FModuleFunctionCallList
    New(Entry);
    Entry.GrtValue := nil;
    Entry.ActionId := 0;

    if (FunctionName = 'editSchema') then
      Entry.Type_ := EditSchema
    else
      if (FunctionName = 'editTable') then
        Entry.Type_ := EditTable
      else
        if (FunctionName = 'editView') then
          Entry.Type_ := EditView
      else
        if (FunctionName = 'editRoutine') then
          Entry.Type_ := EditRoutine
        else
          if (FunctionName = 'editRoutineGroup') then
            Entry.Type_ := EditRoutineGroup
          else
            if (FunctionName = 'popupPluginsMenu') then
            begin
              Entry.Type_ := PopupPluginsMenu;
              Entry.GrtValue := Grt.ListItem[arguments, 1];
              Grt.ValueRetain(Entry.GrtValue);
            end
            else
              if (FunctionName = 'popupConnectionMenu') then
                Entry.Type_ := PopupConnectionMenu;

    Grt.ValueRetain(Obj);
    Entry.Obj := Obj;

    FModuleFunctionCallList.Add(Entry);

    PostMessage(Handle, WM_OBJECT_EDITOR_CALL, 0, 0);
  end
  else
    Result := Grt.FunctionError(
      _('This function needs an object as argument.'));
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.WmObjectEditorCall(var Message: TMessage);

var
  Entry: PModuleFunctionCallEntry;
  MyxEditorForm: TMyxEditorForm;

begin
  repeat
    with FModuleFunctionCallList do
    begin
      if Count > 0 then
      begin
        Entry := First;
        Remove(Entry);
      end
      else
        Entry := nil;
    end;

    if Entry = nil then
      Break;

    MyxEditorForm := nil;

    case Entry.Type_ of
      EditSchema:
        MyxEditorForm := TMyxSchemaEditorForm.Create(nil);

      EditTable:
        MyxEditorForm := TMyxTableEditorForm.Create(nil);

      EditView:
        MyxEditorForm := TMyxViewEditorForm.Create(nil);

      EditRoutine:
        MyxEditorForm := nil;

      EditRoutineGroup:
        MyxEditorForm := TMyxRoutineGroupEditorForm.Create(nil);
    end;

    try
      if (MyxEditorForm <> nil) then
      begin
        StatusBarText := WideFormat(_('Start editing %s.'),
          [Grt.DictString[Entry.Obj, 'name']]);

        try
          MyxEditorForm.FormStyle := fsStayOnTop;

          MyxEditorForm.StartEditObject(Entry.Obj);

          if (AppOptions.OptionInt['DockEditors'] = 1) then
          begin
            MyxEditorForm.DockEditor;

            if (MyxEditorForm.DockPanel <> nil) then
            begin
              EditorTabFrame.AddTabSheet(self,
               Grt.DictString[Entry.Obj, 'name'],
                '',
                MyxEditorForm.DockPanel,
                MyxEditorForm,
                True, False, -1, [], True);

              EditorPnl.Visible := True;
              MyxEditorForm.FocusFirstControl;
            end;
          end
          else
            MyxEditorForm.Show;
        except
          on x: Exception do
            ShowModalDialog(_('Object Editor Error'),
              Format(_('The following error occured while launching ' +
                'the object editor. ' + #13#10#10#13 + '%s'), [x.Message]),
              myx_mtError, _('Ok'));
        end;
      end
      else
        if (Entry.Type_ = PopupPluginsMenu) then
        begin
          CreateFigurePopupMenu(Mouse.CursorPos.X,
            Mouse.CursorPos.Y, Entry.Obj, Entry.GrtValue)
        end
        else
          if (Entry.Type_ = PopupConnectionMenu) then
          begin
            CreateConnectionPopupMenu(Mouse.CursorPos.X, Mouse.CursorPos.Y, Entry.Obj);
          end;
    finally
      if Assigned(Entry.GrtValue) then
        Grt.ValueRelease(Entry.GrtValue);
      Grt.ValueRelease(Entry.Obj);

      Dispose(Entry);
    end;
  until False;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SchemaPopupMenuPopup(Sender: TObject);

var
  MenuItem: TTntMenuItem;
  I: Integer;
  CatalogStructName,
  SchemaStructName,
  SchemaObjectStructName: WideString;
  NodeData: PGrtObjTreeData;
  Editor: Pointer;

begin
  // remove all items except the first 4
  while (SchemaPopupMenu.Items.Count > 4) do
    SchemaPopupMenu.Items.Delete(SchemaPopupMenu.Items.Count - 1);

  if (FGrtObjectTree.FocusedNode <> nil) then
  begin
    NodeData := FGrtObjectTree.GetNodeData(FGrtObjectTree.FocusedNode);

    SchemaTreeEditMI.Caption := Format(_('Edit %s'),
      [Grt.GetStructCaption(NodeData.StructName)]);
    SchemaTreeDropMI.Caption := Format(_('Drop %s'),
      [Grt.GetStructCaption(NodeData.StructName)]);

    SchemaTreeEditMI.Enabled := True;
    SchemaTreeDropMI.Enabled := True;
    SchemaTreeCopySQLtoClipboardMI.Enabled := True;
  end
  else
  begin
    SchemaTreeEditMI.Caption := _('Edit Object');
    SchemaTreeDropMI.Caption := _('Drop Object');

    SchemaTreeEditMI.Enabled := False;
    SchemaTreeDropMI.Enabled := False;
    SchemaTreeCopySQLtoClipboardMI.Enabled := False;
  end;

  CatalogStructName := Grt.DictStructName[Grt.Global['/workbench/catalog']];
  SchemaStructName := Grt.GetStructMemberContentStructName(CatalogStructName, 'schemata');

  // Add create schema item
  MenuItem := TTntMenuItem.Create(SchemaPopupMenu);
  MenuItem.Caption := Format(_('Create %s'),
    [Grt.GetStructCaption(SchemaStructName)]);
  MenuItem.OnClick := SchemaPopupMenuAddObjectClick;
  MenuItem.Tag := -1;
  SchemaPopupMenu.Items.Add(MenuItem);

  // Add create database object items
  for I := 0 to Grt.GetStructMemberCount(SchemaStructName)-1 do
  begin
    SchemaObjectStructName := Grt.GetStructMemberContentStructName(
      SchemaStructName, I);

    if (Grt.StructInheritsFrom(
      SchemaObjectStructName, 'db.DatabaseObject')) then
    begin
      MenuItem := TTntMenuItem.Create(SchemaPopupMenu);
      MenuItem.Caption := Format(_('Create %s'),
        [Grt.GetStructCaption(SchemaObjectStructName)]);
      MenuItem.OnClick := SchemaPopupMenuAddObjectClick;
      MenuItem.Tag := I;

      // check if an editor is available for this type
      Editor := Grt.ExecuteStandardTask(_('Gettting an object editor'), 'Base', 'getObjEditor',
        [SchemaObjectStructName, 0, Ord(EDIT_ACTION)], False);

      if (Grt.ValueType(Editor) <> GrtDictValue) then
        MenuItem.Enabled := False;

      Grt.ValueRelease(Editor);

      SchemaPopupMenu.Items.Add(MenuItem);
    end;
  end;

  MenuItem := TTntMenuItem.Create(SchemaPopupMenu);
  MenuItem.Caption := '-';
  SchemaPopupMenu.Items.Add(MenuItem);

  MenuItem := TTntMenuItem.Create(SchemaPopupMenu);
  MenuItem.Caption := _('Refresh');
  MenuItem.OnClick := SchemaPopupMenuRefreshClick;
  SchemaPopupMenu.Items.Add(MenuItem);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SchemaPopupMenuAddObjectClick(Sender: TObject);

var
  CatalogStructName,
  SchemaStructName,
  SchemaObjectStructName: WideString;
  Schema,
  Obj,
  List: Pointer;
  Index: Integer;
  Task: IGrtTask;

begin
  Index := TTntMenuItem(Sender).Tag;

  if (Index > -1) then
  begin
    if (FGrtObjectTree.FocusedNode <> nil) then
    begin
      Schema := Grt.Global['/workbench/catalog/schemata/0'];
    end
    else
      Schema := Grt.Global['/workbench/catalog/schemata/0'];

    // Get types
    CatalogStructName := Grt.DictStructName[
      Grt.Global['/workbench/catalog']];
    SchemaStructName := Grt.GetStructMemberContentStructName(
      CatalogStructName, 'schemata');
    SchemaObjectStructName := Grt.GetStructMemberContentStructName(
      SchemaStructName, Index);

    // Create new object of correct type
    Obj := Grt.ObjectNew(SchemaObjectStructName,
      Format(_('New %s'), [Grt.GetStructCaption(SchemaObjectStructName)]),
      '',
      Grt.DictString[Schema, '_id']);

    // Add new object to schema list
    List := Grt.DictItem[Schema,
      Grt.GetStructMemberName(SchemaStructName, Index)];

    Grt.ListAdd(List, Obj, False);

    FGrtObjectTree.RefreshTree;

    // Edit added object
    Task := Grt.CreateStandardTask(_('Editing an object'), 'Base', 'editObj', [Obj, 0, Ord(EDIT_ACTION)]);
    Grt.AddTask(Task);
  end
  else
  begin
    // Schema

    CatalogStructName := Grt.DictStructName[
      Grt.Global['/workbench/catalog']];
    SchemaStructName := Grt.GetStructMemberContentStructName(
      CatalogStructName, 'schemata');

    Obj := Grt.ObjectNew(SchemaStructName,
      _('New Schema'), '', Grt.GlobalAsString['/workbench/catalog/name']);

    List := Grt.Global['/workbench/catalog/schemata'];

    Grt.ListAdd(List, Obj, False);

    FGrtObjectTree.RefreshTree;

    // Edit added object
    Task := Grt.CreateStandardTask(_('Editing an object'), 'Base', 'editObj', [Obj, 0, Ord(EDIT_ACTION)]);
    Grt.AddTask(Task);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SchemaPopupMenuRefreshClick(Sender: TObject);

begin
  FGrtObjectTree.RefreshTree;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FileOpenScriptActionExecute(Sender: TObject);

begin
  if (FXGrtShellForm.ScriptOpenAction.Execute) then
  begin
    FXGrtShellForm.RefreshDisplay;
    FXGrtShellForm.Show;

    Application.ProcessMessages;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.RefreshDisplay;

begin
  FGrtObjectTree.ObjectTreeRoot := '/workbench/catalog/schemata';
  FLayerTree.RootLayer := Grt.ValueReference(Grt.Global['/workbench/model/currentView/rootLayer']);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.RefreshModelActionExecute(Sender: TObject);

begin
  RefreshDisplay;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SchemaTreeEditMIClick(Sender: TObject);

var
  Selection: TNodeArray;
  NodeData: PGrtObjTreeData;
  I: Integer;
  Task: IGrtTask;

begin
  Selection := FGrtObjectTree.GetSortedSelection(False);

  for I := 0 to FGrtObjectTree.SelectedCount - 1 do
  begin
    NodeData := FGrtObjectTree.GetNodeData(Selection[I]);

    if GrtValueType(NodeData.ValueType) = GrtDictValue then
    begin
      Task := Grt.CreateStandardTask(_('Editing an object'), 'Base', 'editObj', [NodeData.Value, 0, Ord(EDIT_ACTION)]);
      Grt.AddTask(Task);
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FpsTimerTimer(Sender: TObject);

begin
  StatusBar.Panels[3].Text := FormatFloat('##0.##',
    FCanvasViewer.FPS) + ' ' + _('fps');

  // count down FStatusBarCleanerCounter and
  // clear statusbar text if needed
  if (FStatusBarCleanerCounter > 0) then
  begin
    dec(FStatusBarCleanerCounter);

    if (FStatusBarCleanerCounter = 0) then
      StatusBar.Panels[1].Text := '';
  end;

  StatusBar.Update;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.UpdateSchemaListings;

var
  I, SelIndex: Integer;
  SchemaList, Schema: Pointer;

begin
  SelIndex := SchemaComboBox.ItemIndex;
  SchemaList := Grt.Global['/workbench/catalog/schemata'];
  SchemaComboBox.Items.Clear;

  for I := 0 to Grt.ListCount(SchemaList) - 1 do
  begin
    Schema := Grt.ListItem[SchemaList, I];

    SchemaComboBox.Items.Add(Grt.DictString[Schema, 'name']);
  end;

  if (SelIndex > -1) and (SelIndex < SchemaComboBox.Items.Count) then
    SchemaComboBox.ItemIndex := SelIndex
  else
    SchemaComboBox.ItemIndex := 0;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.StoreMarker(Number: Integer);

var
  Marker, MarkerList: Pointer;
  MarkerName: WideString;
  I: Integer;

begin
  MarkerName := 'Marker' + IntToStr(Number);
  Marker := Grt.ObjectNew('model.Marker', MarkerName, '', '');

  Grt.DictString[Marker, 'view'] := Grt.GlobalAsString['/workbench/model/currentView'];
  Grt.DictReal[Marker, 'zoom'] := FCanvasViewer.CurrentZoom;
  Grt.DictInt[Marker, 'x'] := FCanvasViewer.Position.X;
  Grt.DictInt[Marker, 'y'] := FCanvasViewer.Position.Y;

  MarkerList := Grt.Global['/workbench/model/markers'];

  Grt.ListDelObject(MarkerList, MarkerName);

  Grt.ListAdd(MarkerList, Marker, False);

  if (Number < 10) then
    StatusbarText := Format(_('Marker #%d stored.'), [Number]);

  for I := 0 to ActionList.ActionCount - 1 do
    if (ActionList.Actions[I].Name =
      'Recall' + MarkerName + 'Action') then
    begin
      TTntAction(ActionList.Actions[I]).Enabled := True;
      break;
    end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.RestoreMarker(Number: Integer);

var
  Marker, MarkerList: Pointer;
  MarkerName: WideString;

begin
  MarkerName := 'Marker' + IntToStr(Number);
  MarkerList := Grt.Global['/workbench/model/markers'];
  Marker := Grt.ListItemByObjectName[MarkerList, MarkerName];

  // select tabsheet
  {if (Grt.GlobalAsString['/workbench/model/currentView'] <>
    Grt.DictString[Marker, 'view']) then
    Grt.GlobalAsString['/workbench/model/currentView'] :=
      Grt.DictString[Marker, 'view'];}

  if (Marker <> nil) then
  begin
    FCanvasViewer.ApplyZoomAndPosition(
      Grt.DictReal[Marker, 'zoom'],
      Point(Grt.DictInt[Marker, 'x'], Grt.DictInt[Marker, 'y']), not FLoading);

    if (Number < 10) then
      StatusbarText := Format(_('Marker #%d restored.'), [Number]);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.StoreMarker1ActionExecute(Sender: TObject);

begin
  if (Sender is TTntAction) then
    StoreMarker(TTntAction(Sender).Tag);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.RecallMarker1ActionExecute(Sender: TObject);

begin
  if (Sender is TTntAction) then
    RestoreMarker(TTntAction(Sender).Tag);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SelectionAvailableActionUpdate(Sender: TObject);

var
  Selection: Pointer;
  CurrentView: Pointer;
  Count: Integer;

begin
  Count := 0;

  CurrentView := Grt.GlobalRef['/workbench/model/currentView'];
  if (CurrentView <> nil) then
  begin
    Selection := Grt.DictItem[CurrentView, 'selection'];
    Count := Grt.ListCount(Selection);
  end;

  TTntAction(Sender).Enabled := (Count > 0);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DeleteSelectionActionExecute(Sender: TObject);

var
  Selection: Pointer;
  CurrentView: Pointer;
  Count: Integer;
  Txt: WideString;

begin
  CurrentView := Grt.GlobalRef['/workbench/model/currentView'];

  if (CurrentView <> nil) then
  begin
    Selection := Grt.DictItem[CurrentView, 'selection'];
    Count := Grt.ListCount(Selection);

    if (Count > 0) then
    begin
      if (Count = 1) then
        Txt := _('Are you sure you want to delete the selected object?')
      else
        Txt := Format(_('Are you sure you want to delete %d selected objects?'), [Count]);

      if (ShowModalDialog(_('Delete Selection'), Txt,
        myx_mtConfirmation, _('Delete') + #13#10 + _('Cancel')) = 1) then
      begin
        CurrentElement := nil;

        Grt.ExecuteStandardTask(_('Deleting current selection'), 'Workbench', 'deleteSelection', [], False);
      end;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FileSaveAsActionAccept(Sender: TObject);

begin
  if Sender is TTntFileSaveAs then
  begin
    StoreMarker(10);
    FModelFileName := TTntFileSaveAs(Sender).Dialog.FileName;
    Grt.ValueSaveToFile(FModelFileName, Grt.Global['/workbench']);
    StatusBarText := Format(_('Model saved to %s'), [FModelFileName]);
    ResetModified;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FileSaveActionExecute(Sender: TObject);

begin
  if FModelFileName = '' then
    FileSaveAsAction.Execute
  else
  begin
    StoreMarker(10);
    Grt.ValueSaveToFile(FModelFileName, Grt.Global['/workbench']);
    StatusBarText := Format(_('Model saved to %s'), [FModelFileName]);
    ResetModified;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PlaceCancelActionExecute(Sender: TObject);

begin
  if (CurrentTool = wbToolRel1n) or
    (CurrentTool = wbToolRel11) or
    (CurrentTool = wbToolRelnm) then
  begin
    Grt.ExecuteStandardTask(_('Cancelling relationship tool'), 'Workbench', 'relationshipCancel', [], False);
  end;

  CurrentTool := wbToolArrow;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PlaceCancelActionUpdate(Sender: TObject);

begin
  if (Sender is TTntAction) and (Screen.ActiveForm = self) then
    TTntAction(Sender).Enabled := (CurrentTool <> wbToolArrow);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DoPropChange(Sender: TObject);

var
  PosVal: Extended;

begin
  if (FCurrentElement <> nil) and (not(FCurrentElementChanging)) then
  begin
    // left
    PosVal := StrToFloatDef(PropXEd.Text, -999999);
    if (PosVal <> -999999) then
      Grt.DictReal[FCurrentElement, 'left'] := PosVal;
    PropXEd.Text := FormatFloat('#####0.##',
      Grt.DictReal[FCurrentElement, 'left']);

    // top
    PosVal := StrToFloatDef(PropYEd.Text, -999999);
    if (PosVal <> -999999) then
      Grt.DictReal[FCurrentElement, 'top'] := PosVal;
    PropYEd.Text := FormatFloat('#####0.##',
      Grt.DictReal[FCurrentElement, 'top']);

    // width
    PosVal := StrToFloatDef(PropWEd.Text, -999999);
    if (PosVal <> -999999) then
      Grt.DictReal[FCurrentElement, 'width'] := PosVal;
    PropWEd.Text := FormatFloat('#####0.##',
      Grt.DictReal[FCurrentElement, 'width']);

    // height
    PosVal := StrToFloatDef(PropHEd.Text, -999999);
    if (PosVal <> -999999) then
      Grt.DictReal[FCurrentElement, 'height'] := PosVal;
    PropHEd.Text := FormatFloat('#####0.##',
      Grt.DictReal[FCurrentElement, 'height']);

    if (FCurrentElementType = ET_Note) then
    begin
      Grt.DictString[FCurrentElement, 'text'] := PropNoteText.Text;
    end
    else
      if (FCurrentElementType = ET_Rel) then
      begin
        Grt.DictString[FCurrentElement, 'caption'] :=
          PropRelCaptionEd.Text;

        case PropRelTypeComboBox.ItemIndex of
          0:
            begin
              Grt.DictInt[FCurrentElement, 'startMany'] := 0;
              Grt.DictInt[FCurrentElement, 'endMany'] := 1;
            end;
          1:
            begin
              Grt.DictInt[FCurrentElement, 'startMany'] := 0;
              Grt.DictInt[FCurrentElement, 'endMany'] := 0;
            end;
        end;

        Grt.DictInt[FCurrentElement, 'startMandatory'] :=
          Ord(Not(PropRelSrcOptCheckBox.Checked));

        Grt.DictInt[FCurrentElement, 'endMandatory'] :=
          Ord(Not(PropRelTarOptCheckBox.Checked));

        Grt.DictString[FCurrentElement, 'comment'] :=
          PropRelCommentMemo.Text;
      end
      else
        if (FCurrentElementType = ET_Layer) then
        begin
          Grt.DictString[FCurrentElement, 'name'] :=
            PropLayerCaptionEd.Text;

          Grt.DictString[FCurrentElement, 'description'] :=
            LayerCommentMemo.Text;
        end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.UpdateProperties;

var
  Pnl: TTntPanel;

begin
  Pnl := nil;

  if (FCurrentElement <> nil) then
  begin
    DisableEnableControls(PropCoordsPnl, True);

    FCurrentElementChanging := True;
    try
      PropXEd.Text := FormatFloat('#####0.##',
        Grt.DictReal[FCurrentElement, 'left']);
      PropYEd.Text := FormatFloat('#####0.##',
        Grt.DictReal[FCurrentElement, 'top']);
      PropWEd.Text := FormatFloat('#####0.##',
        Grt.DictReal[FCurrentElement, 'width']);
      PropHEd.Text := FormatFloat('#####0.##',
        Grt.DictReal[FCurrentElement, 'height']);

      if (FCurrentElementType = ET_Note) then
      begin
        PropNoteText.Text := Grt.DictString[FCurrentElement, 'text'];

        Pnl := PropNotePnl;
      end
      else if (FCurrentElementType = ET_Rel) then
      begin
        PropRelCaptionEd.Text :=
          Grt.DictString[FCurrentElement, 'caption'];

        case Grt.DictInt[FCurrentElement, 'startMany'] +
          Grt.DictInt[FCurrentElement, 'endMany'] of
          0:
            PropRelTypeComboBox.ItemIndex := 1;
          1:
            PropRelTypeComboBox.ItemIndex := 0;
          2:
            PropRelTypeComboBox.ItemIndex := 2;
        end;

        PropRelSrcOptCheckBox.Checked :=
          (Grt.DictInt[FCurrentElement, 'startMandatory'] = 0);

        PropRelTarOptCheckBox.Checked :=
          (Grt.DictInt[FCurrentElement, 'endMandatory'] = 0);

        PropRelCommentMemo.Text :=
          Grt.DictString[FCurrentElement, 'comment'];

        Pnl := PropRelPnl;
      end
      else if (FCurrentElementType = ET_Layer) then
      begin
        PropLayerCaptionEd.Text :=
          Grt.DictString[FCurrentElement, 'name'];

        LayerCommentMemo.Text :=
          Grt.DictString[FCurrentElement, 'description'];

        Pnl := PropLayerPnl;
      end;
    finally
      FCurrentElementChanging := False;
    end;
  end
  else
  begin
    PropNotePnl.Visible := False;
    DisableEnableControls(PropCoordsPnl, False);
  end;

  PropNotePnl.Visible := (Pnl = PropNotePnl);
  PropRelPnl.Visible := (Pnl = PropRelPnl);
  PropLayerPnl.Visible := (Pnl = PropLayerPnl);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SetCurrentElement(Element: Pointer);

var
  StructName: WideString;

begin
  if (Element <> nil) then
  begin
    FCurrentElement := Element;

    StructName := Grt.DictStructName[FCurrentElement];
    if (StructName = 'db.workbench.NoteElement') then
      FCurrentElementType := ET_Note
    else
      if (StructName = 'db.workbench.Relationship') then
        FCurrentElementType := ET_Rel
      else
        if (StructName = 'db.workbench.Layer') then
          FCurrentElementType := ET_Layer
        else
          FCurrentElementType := ET_Unknown;

    UpdateProperties;
  end
  else
  begin
    Grt.ValueRelease(FCurrentElement);
    FCurrentElement := nil;
    FCurrentElementType := ET_Unknown;
  end;

  UpdateProperties;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DoPropKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);

begin
  if (Key = VK_Return) then
    DoPropChange(self);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PlaceActionUpdate(Sender: TObject);

begin
  if (Sender is TTntAction) then
    TTntAction(Sender).Enabled :=
      (ActiveControl = FCanvasViewer) and
      (Screen.ActiveForm = self);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PlaceTableActionExecute(Sender: TObject);

begin
  CurrentTool := wbToolTable;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PlaceViewActionExecute(Sender: TObject);

begin
  CurrentTool := wbToolView;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PlaceRoutineGroupActionExecute(Sender: TObject);

begin
  CurrentTool := wbToolRoutine;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PlaceRelationship1nActionExecute(Sender: TObject);

begin
  CurrentTool := wbToolRel1n;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PlaceRelationship11ActionExecute(Sender: TObject);

begin
  CurrentTool := wbToolRel11;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PlaceRelationshipnmActionExecute(Sender: TObject);

begin
  CurrentTool := wbToolRelnm;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PlaceNoteActionExecute(Sender: TObject);

begin
  CurrentTool := wbToolNote;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PlaceLayerActionExecute(Sender: TObject);

begin
  CurrentTool := wbToolLayer;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ExportSqlCreateScriptActionAccept(Sender: TObject);

var
  SqlValue: Pointer;
  Sql: TStringList;
  FModelFileName: WideString;

begin
  if (Sender is TTntFileSaveAs) then
  begin
    SqlValue := Grt.ExecuteStandardTask(_('Generating SQL script'), 'Workbench', 'generateSqlCreateScript', [], True);

    if Assigned(SqlValue) then
    begin
      Sql := TStringList.Create;
      try
        FModelFileName := TTntFileSaveAs(Sender).Dialog.FileName;

        Sql.Text := Utf8Encode(Grt.ValueString[SqlValue]);
        Sql.SaveToFile(FModelFileName);

        StatusBarText := Format(_('SQL create script saved to %s'), [FModelFileName]);
      finally
        Grt.ValueRelease(SqlValue);
        Sql.Free;
      end;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.OverviewActionUpdate(Sender: TObject);

begin
  if (Sender is TTntAction) then
    TTntAction(Sender).Checked := FCanvasViewer.Overview;

  FToolbars.Items['OverviewBtn'].Down := TTntAction(Sender).Checked;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.OverviewActionExecute(Sender: TObject);

begin
  FCanvasViewer.Overview := Not(FCanvasViewer.Overview);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ZoomInActionExecute(Sender: TObject);

begin
  FCanvasViewer.CurrentZoomStep := FCanvasViewer.CurrentZoomStep + 1;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ZoomOutActionExecute(Sender: TObject);

begin
  FCanvasViewer.CurrentZoomStep := FCanvasViewer.CurrentZoomStep - 1;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ZoomDefaultActionExecute(Sender: TObject);

begin
  FCanvasViewer.CurrentZoom := 0.75;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.TabNextActionExecute(Sender: TObject);

begin
  if (ViewTabFrame.SelectedTab < ViewTabFrame.TabCount - 1) then
    ViewTabFrame.SelectedTab := ViewTabFrame.SelectedTab + 1
  else
    ViewTabFrame.SelectedTab := 0;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.TabPreviousActionExecute(Sender: TObject);

begin
  if (ViewTabFrame.SelectedTab > 0) then
    ViewTabFrame.SelectedTab := ViewTabFrame.SelectedTab - 1
  else
    ViewTabFrame.SelectedTab := ViewTabFrame.TabCount - 1;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.NewViewActionExecute(Sender: TObject);

begin
  ViewTabPageRequestNew(Sender);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ShowXGrtCodeSnippetsActionExecute(Sender: TObject);

begin
  if (AppOptions.OptionInt['DockGrtShell'] = 1) then
  begin
    if (FDockedCodeSnippetsTab = nil) then
    begin
      FDockedCodeSnippetsTab := EditorTabFrame.TabSheets[
        EditorTabFrame.AddTabSheet(Self,
        _('Code Snippets'),
        'tabsheet_icon_layer',
        FXGrtShellForm.CodeSnippetPnl,
        FXGrtShellForm.CodeSnippetUCE,
        (Sender <> ShowXGrtShellAction), False, -1, [], True)];
    end
    else
    begin
      EditorTabFrame.SelectedTabSheet := FDockedCodeSnippetsTab;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PaletteSpacerShapeMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

begin
  FInitMousePos := Mouse.CursorPos.X;
  FInitWidth := SidebarPnl.Width;
  FDragging := True;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PaletteSpacerShapeMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);

begin
  if (FDragging) then
  begin
    SidebarPnl.Width := Max(
      FInitWidth + (FInitMousePos - Mouse.CursorPos.X),
      100);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PaletteSpacerShapeMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

begin
  if (FDragging) then
  begin
    FDragging := False;

    if (GrtSheetIsActive) and
      (AppOptions.OptionInt['SideBarOneWidth'] = 0) then
      AppOptions.OptionInt['SideBarWidthGrtShell'] := SidebarPnl.Width
    else
      AppOptions.OptionInt['SideBarWidthView'] := SidebarPnl.Width;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.OptionChanged;

begin
  if (GrtSheetIsActive) and
    (AppOptions.OptionInt['SideBarOneWidth'] = 0) then
  begin
    if (AppOptions.OptionInt['SideBarWidthGrtShell'] <> SidebarPnl.Width) then
      SidebarPnl.Width := AppOptions.OptionInt['SideBarWidthGrtShell'];
  end
  else
  begin
    if (AppOptions.OptionInt['SideBarWidthView'] <> SidebarPnl.Width) then
      SidebarPnl.Width := AppOptions.OptionInt['SideBarWidthView'];
  end;

  if (AppOptions.OptionInt['DockGrtShell'] = 0) and
    ((FDockedShellTab <> nil) or
    (FDockedCodeSnippetsTab <> nil)) then
  begin
    if (FDockedShellTab <> nil) then
      EditorTabFrame.DeleteTab(
        EditorTabFrame.GetTabIndex(FDockedShellTab),
        True, True);

    if (FDockedCodeSnippetsTab <> nil) then
      EditorTabFrame.DeleteTab(
        EditorTabFrame.GetTabIndex(FDockedCodeSnippetsTab),
        True, True);

    FXGrtShellForm.CommandLinePnl.Parent := FXGrtShellForm.GtrShellSheet;
    FXGrtShellForm.CommandLinePnl.Visible := True;
    FXGrtShellForm.GrtShellPalettePnl.Parent := FXGrtShellForm.SidebarPnl;
    FXGrtShellForm.GrtShellPalettePnl.Visible := True;

    FXGrtShellForm.Visible := True;
  end
  else
    if (AppOptions.OptionInt['DockGrtShell'] = 1) and
      (FXGrtShellForm.Visible) then
    begin
      FXGrtShellForm.Visible := False;

      ShowXGrtShellAction.Execute;
    end;

end;

//----------------------------------------------------------------------------------------------------------------------

function TMainForm.GrtSheetIsActive: Boolean;

var
  Obj: TObject;

begin
  Result := False;

  if Assigned(EditorTabFrame.SelectedTabSheet) and IsDelphiClass(EditorTabFrame.SelectedTabSheet.Obj) then
  begin
    Obj := EditorTabFrame.SelectedTabSheet.Obj;

    if ((Obj is TUniCodeConsole) and (TUniCodeConsole(Obj).Name = 'CommandLineUCE')) or
      ((Obj is TUniCodeEdit) and (TUniCodeEdit(Obj).Name = 'CodeSnippetUCE')) then
      Result := True;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DockXGrtShellActionExecute(Sender: TObject);

begin
  AppOptions.OptionInt['DockGrtShell'] := Ord(TTntAction(Sender).Checked);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SelectDefaultConnectionActionExecute(Sender: TObject);

var
  ConnDlg: TMyxConnectionDialogForm;

begin
  ConnDlg := TMyxConnectionDialogForm.Create(self);
  try
    ConnDlg.ConnInfoPath := '/rdbmsMgmt';
    ConnDlg.ConnTargetPath := '/workbench/connection';

    ConnDlg.DisplayRdbmsSelection := True;
    ConnDlg.DisplaySchemaSelection := False;

    ConnDlg.RefreshConnInfo;

    ConnDlg.SelectedRdbms := 'Mysql';

    ConnDlg.ShowModal;
  finally
    ConnDlg.Free;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DatabaseSynchronizeActionExecute(Sender: TObject);

begin
  if (SyncForm = nil) then
  begin
    SyncForm := TDatabaseSynchronisationForm.Create(nil);
    SyncForm.OnClose := DoDatabaseSynchronisationFormClose;
  end;

  SyncForm.Show;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DoDatabaseSynchronisationFormClose(Sender: TObject; var Action: TCloseAction);

begin
  SyncForm := nil;

  Action := caFree;

  RefreshModelActionExecute(self);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PrintActionExecute(Sender: TObject);

const
  MaxPixelsPerStripe = 50 * 1024 * 1024 div 4; // 4 bytes per pixel and a maximum of 50 MB memory.
  
var
  PrintDlg: TModelPrintSetupForm;
  Preview: TBitmap;
  Memory: Pointer;
  Bounds: TViewport;

  HCount: Integer;
  VCount: Integer;
  Selection: TPageSelection;

begin
  // Update screen display first to avoid menu artefacts and similar.
  Application.ProcessMessages;

  Bounds.Left := 0;
  Bounds.Width := -1; // Means full width.
  Preview := TBitmap.Create;
  try
    Screen.Cursor := crHourGlass;
    try
      Preview.PixelFormat := pf32Bit;

      // First create a small image of the current canvas content.
      if (FCanvasViewer.BaseSizeX > MaxPreviewSize) or (FCanvasViewer.BaseSizeY > MaxPreviewSize) then
      begin
        if FCanvasViewer.BaseSizeX > FCanvasViewer.BaseSizeY then
        begin
          Preview.Width := MaxPreviewSize;
          Preview.Height := Round(MaxPreviewSize * FCanvasViewer.BaseSizeY / FCanvasViewer.BaseSizeX);
        end
        else
        begin
          Preview.Width := Round(MaxPreviewSize * FCanvasViewer.BaseSizeX / FCanvasViewer.BaseSizeY);
          Preview.Height := MaxPreviewSize;
        end;
      end
      else
      begin
        Preview.Width := FCanvasViewer.BaseSizeX;
        Preview.Height := FCanvasViewer.BaseSizeY;
      end;

      // Render the canvas content in stripes onto the preview image. For this task an intermediate bitmap is created
      // which is filled and then stretched to the preview image. This greatly limits the required memory for the preview.
      Bounds.Left := 0;
      Bounds.Top := 0;
      Bounds.Width := Preview.Width;
      Bounds.Height := Preview.Height;
      Memory := Preview.ScanLine[0];
      if Cardinal(Preview.ScanLine[1]) < Cardinal(Memory) then
        Memory := Preview.ScanLine[Preview.Height - 1];
      FCanvasViewer.Canvas.RenderToMemory(Memory, GC_COLOR_FORMAT_BGRA, GC_RENDER_CONNECTIONS or GC_RENDER_FEEDBACK,
        Preview.Width / FCanvasViewer.BaseSizeX, Bounds);
    finally
      Screen.Cursor := crDefault;
    end;

    PrintDlg := TModelPrintSetupForm.Create(Self);
    try
      PrintDlg.PresetsLoad(AppOptions.OptionString['PrintPresets']);
      PrintDlg.PreviewUse(Preview);
      if PrintDlg.ShowModal = mrOK then
      begin
        PrintDlg.PrintParametersGet(HCount, VCount, Selection);
        CanvasPrint(FCanvasViewer, HCount, VCount, Selection);
      end;
      AppOptions.OptionString['PrintPresets'] := PrintDlg.PresetsSerialize;
    finally
      PrintDlg.Free;
    end;
  finally
    Preview.Free;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ArrangeActionExecute(Sender: TObject);

var
  Task: IGrtTask;
  
begin
  Task := Grt.CreateStandardTask(_('Arrange objects in current view'), 'WorkbenchController', 'arrangeObjects',
    [Grt.DictRef[Grt.Global['/workbench/model'], 'currentView'], 0], nil, nil, True);
  Grt.AddTask(Task);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ArrangeSelectedActionExecute(Sender: TObject);

var
  Task: IGrtTask;
  
begin
  Task := Grt.CreateStandardTask(_('Arrange selected objects in current view'), 'WorkbenchController', 'arrangeObjects',
    [Grt.DictRef[Grt.Global['/workbench/model'], 'currentView'], 1], nil, nil, True);
  Grt.AddTask(Task);
end;

//----------------------------------------------------------------------------------------------------------------------

function StartsWith(S: WideString; Prefix: WideString) : Boolean;

var
  L1, L2, i: Integer;
  Match: Boolean;

begin

  L1 := Length(S);
  L2 := Length(Prefix);

  if(L1 < L2) then
    Result := false
  else
  begin
    Match := true;
    for i := 1 to L2 do
      if UpperCase(S[i]) <> UpperCase(Prefix[i]) then
      begin
        Match := false;
        break;
      end;
    Result := Match;  
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

function TMainForm.GetKeywordList(S: WideString): TTntStringList;

var
  N: WideString;
  L: TTntStringList;
  i, start, finish, len: Integer;

begin
  len := Length(s);
  i := 1;
  L := TTntStringList.Create;

  while(i <= len) do
  begin

    while (S[i] = ' ') and (i <= len) do
      inc(i);
    start := i;
    while (S[i] <> ' ') and (i <= len) do
      inc(i);
    finish := i;

    if(finish > start) then
    begin
      N := MidStr(S, start, finish - start);
      L.Add(N);
    end;
  end;

  Result := L;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.OnSeachEdChange(Sender: TObject);

var
  Plugins, Plugin, PluginWords: Pointer;
  i, j, k, count, count2, count3: Integer;
  SearchWords: TTntStringList;
  Found: boolean;

begin
  PluginSearchFrame.SearchEdChange(Sender);
  if (Length(PluginSearchFrame.SearchEd.Text) > 0) then
  begin
    PluginVirtualStringTree.Visible := true;
    PluginVirtualStringTree.Clear;
    Plugins := Grt.Global['/app/plugins'];
    count := Grt.ListCount(Plugins);
    SearchWords := GetKeywordList(PluginSearchFrame.SearchEd.Text);
    count2 := SearchWords.Count;

    for i := 1 to count do
    begin
      Plugin := Grt.ListItem[Plugins, i-1];
      PluginWords := Grt.DictItem[Plugin, 'categories'];
      count3 := Grt.ListCount(PluginWords);

      Found := StartsWith(Grt.DictString[Plugin, 'caption'], PluginSearchFrame.SearchEd.Text);

      if(found = false)then
        for j := 1 to count2 do
        begin
          for k := 1 to count3 do
          begin
            //if(SearchWords[j-1] = Grt.ListString[PluginWords, k-1])then
            if(StartsWith(Grt.ListString[PluginWords, k-1], SearchWords[j-1]))then
            begin
              Found := true;
              break;
            end;
          end;
          if(Found = true) then
            break;
        end;

      if(Found)then
        PluginVirtualStringTree.AddChild(nil, Plugin);
    end;
  end
  else
    PluginVirtualStringTree.Visible := false;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.PluginSearchGetText(Sender: TBaseVirtualTree;
  Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
  var CellText: WideString);

var
  Plugin: Pointer;

begin
  Plugin := Pointer(Sender.GetNodeData(Node)^);
  CellText := Grt.DictString[Plugin, 'caption'];
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ObjectEditMiClick(Sender: TObject);

var
  FunctionName: WideString;

begin
  FCanvasViewer.Invalidate;

  if Assigned(CurrentObject) then
  begin
    FunctionName := '';

    // check with editor to use
    if (Grt.StructIsOrInheritsFrom(Grt.DictStructName[CurrentObject],
      'db.Table')) then
      FunctionName := 'editTable'
    else
      if (Grt.StructIsOrInheritsFrom(Grt.DictStructName[CurrentObject],
        'db.View')) then
        FunctionName := 'editView'
      else
        if (Grt.StructIsOrInheritsFrom(Grt.DictStructName[CurrentObject],
          'db.RoutineGroup')) then
          FunctionName := 'editRoutineGroup'
        else
          if (Grt.StructIsOrInheritsFrom(Grt.DictStructName[CurrentObject],
            'db.Connection')) then
            FunctionName := 'PopupConnectionMenu';

    // directly call editor
    if (FunctionName <> '') then
      GrtExecuteModuleFunction('WorkbenchUi', FunctionName,
        Grt.BuildGrtParamList([CurrentObject, CurrentElement]));
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.CreateConnectionPopupMenu(X: Integer; Y: Integer; Connection: Pointer);

var
  MenuItem: TTntMenuItem;

begin
  CurrentElement := Connection;

  if FConnectionPopupMenu = nil then
    FConnectionPopupMenu := TTntPopupMenu.Create(Self)
  else
    FConnectionPopupMenu.Items.Clear;

  MenuItem := TTntMenuItem.Create(FConnectionPopupMenu);
  MenuItem.Caption := _('Edit');
  MenuItem.OnClick := ConnectionEditMiClick;
  MenuItem.Tag := 1;
  FConnectionPopupMenu.Items.Add(MenuItem);

  MenuItem := TTntMenuItem.Create(FConnectionPopupMenu);
  MenuItem.Caption := _('-');
  MenuItem.Tag := 0;
  FConnectionPopupMenu.Items.Add(MenuItem);

  MenuItem := TTntMenuItem.Create(FConnectionPopupMenu);
  MenuItem.Caption := _('Delete');
  MenuItem.OnClick := ConnectionEditMiClick;
  MenuItem.Tag := 2;
  FConnectionPopupMenu.Items.Add(MenuItem);

  FConnectionPopupMenu.Popup(X, Y);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.CreateFigurePopupMenu(X: Integer; Y: Integer; Obj: Pointer; Figure: Pointer);

var
  MenuItem: TTntMenuItem;
  i, j, count, count2: Integer;
  Name: WideString;
  Plugins, Plugin, Cats: Pointer;
  Match: boolean; 

begin
  // set current objects entries
  CurrentObject := Obj;
  CurrentElement := Figure;

  if (FFigurePopupMenu <> nil) then
    FFigurePopupMenu.Free;

  FFigurePopupMenu := TTntPopupMenu.Create(self);

  MenuItem := TTntMenuItem.Create(FFigurePopupMenu);
  MenuItem.Caption := _('Edit');
  MenuItem.OnClick := ObjectEditMiClick;
  FFigurePopupMenu.Items.Add(MenuItem);

  MenuItem := TTntMenuItem.Create(FFigurePopupMenu);
  MenuItem.Caption := _('-');
  FFigurePopupMenu.Items.Add(MenuItem);

  Name := Grt.DictStructName[CurrentElement];
  Plugins := Grt.Global['/app/plugins'];
  count := Grt.ListCount(Plugins);

  for i := 1 to count do
  begin
    Plugin := Grt.ListItem[Plugins, i-1];
    Cats := Grt.DictItem[Plugin, 'objectStructNames'];
    count2 := Grt.ListCount(Cats);
    Match := false;
    for j := 1 to count2 do
      if(Grt.ListString[Cats, j-1] = Name)then
      begin
        Match := true;
        break;
      end;
    if(Match = true)then
    begin
      MenuItem := TTntMenuItem.Create(FFigurePopupMenu);
      MenuItem.Tag := Integer(Plugin);
      MenuItem.Caption := Grt.DictString[Plugin, 'caption'];
      MenuItem.OnClick := PluginMenuMIClick;
      FFigurePopupMenu.Items.Add(MenuItem);
    end;
  end;

  FFigurePopupMenu.Popup(X, Y);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.VirtualTreeDblClick(Sender: TObject);

var
  Node: PVirtualNode;
  Plugin: Pointer;

begin
  Node := PluginVirtualStringTree.FocusedNode;
  Plugin := Pointer(PluginVirtualStringTree.GetNodeData(Node)^);
  LaunchPlugin(Plugin, nil);
end;

procedure TMainForm.BrintToFrontActionExecute(Sender: TObject);

var Task: IGrtTask;

begin
  Task := Grt.CreateStandardTask(_('Brint to Front'),
    'Workbench', 'bringSelectionToFront', []);

  Grt.AddTask(Task);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SendToBackActionExecute(Sender: TObject);

var Task: IGrtTask;

begin
  Task := Grt.CreateStandardTask(_('Send to Back'),
    'Workbench', 'sendSelectionToBack', []);

  Grt.AddTask(Task);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SelectAllActionExecute(Sender: TObject);

var Task: IGrtTask;

begin
  Task := Grt.CreateStandardTask(_('Select All'),
    'Workbench', 'selectAll', []);

  Grt.AddTask(Task);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ExportToImageActionExecute(Sender: TObject);

var
  Bounds: TViewport;
  CurrentView: Pointer;
  CurrentViewName: WideString;
  RenderingContent: Cardinal;

begin
  with TSaveDialog.Create(nil) do
  try
    DefaultExt := 'png';
    Filter := 'Portable Network Graphic (*.png)|*.png';
    FilterIndex := 1;
    Title := 'Export model to image file';
    if Execute then
    begin
      Application.ProcessMessages;
      Screen.Cursor := crHourGlass;
      try
        Bounds.Left := 0;
        Bounds.Top := 0;
        Bounds.Width := -1;
        Bounds.Height := -1;

        CurrentView := Grt.GlobalRef['/workbench/model/currentView'];
        CurrentViewName := Grt.DictString[CurrentView, 'name'];
        RenderingContent := GC_RENDER_GRID or GC_RENDER_CONNECTIONS or GC_RENDER_FEEDBACK or GC_RENDER_FRAME;

        StatusbarText := _('Converting image. This may take few moments...');
        try
          FCanvasViewer.Canvas.RenderToFile(PChar(Utf8Encode(FileName)), GC_FILE_FORMAT_PNG,
            PChar(Utf8Encode(CurrentViewName)), 'MySQL Workbench', RenderingContent, 1, Bounds);
        finally
          StatusBarText := '';
        end;
      finally
        Screen.Cursor := crDefault;
      end;
    end;
  finally
    Free;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ExportToImageActionUpdate(Sender: TObject);

begin
  TAction(Sender).Enabled := FCanvasViewer.Canvas.SupportsExtension(GC_OE_FRAME_BUFFER_OBJECTS);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.CopyToClipboardActionExecute(Sender: TObject);

begin
  StatusBarText := _('Select the area to copy.');
  CurrentTool := wbToolCBSelect;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DisplayGridActionExecute(Sender: TObject);

begin
  with FCanvasViewer do
    if TAction(Sender).Checked then
      RenderingContent := RenderingContent + [rcGrid]
    else
      RenderingContent := RenderingContent - [rcGrid];
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.OnlineDocsMIClick(Sender: TObject);

begin
  BrowseWebPage('http://dev.mysql.com/doc/refman/5.1/en/');
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ImportDbd4ModelActionAccept(Sender: TObject);

var
  Task: IGrtTask;

begin
  if (Sender is TTntFileOpen) then
  begin
    FModelFileName := TTntFileOpen(Sender).Dialog.FileName;

    Task := Grt.CreateStandardTask(_('Imported DBDesigner4 model'),
      'WorkbenchImport', 'importDbd4', [FModelFileName]);

    Grt.AddTask(Task);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ImportSqlScriptActionAccept(Sender: TObject);

begin
  //
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ModelPropertiesActionExecute(Sender: TObject);

var
  ModelPropertiesForm : TModelPropertiesForm;

begin
  ModelPropertiesForm := TModelPropertiesForm.Create(self);
  try
    ModelPropertiesForm.ShowModal;
  finally
    ModelPropertiesForm.Free;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ChangeViewLayoutClass(
  ChangeElementsClass: Boolean; ClassName: WideString);

var Task: IGrtTask;
  CurrentView: Pointer;

begin
  CurrentView := Grt.GlobalRef['/workbench/model/currentView'];
  if(CurrentView <> nil)then
  begin
    if (ChangeElementsClass) then
    begin
      Grt.DictString[CurrentView, 'elementLayoutClass'] :=
        ClassName;

      Task := Grt.CreateStandardTask(_('Update Layout Classes'),
        'WorkbenchController', 'reconstructViewElements', []);

      Grt.AddTask(Task);
    end
    else
    begin
      Grt.DictString[CurrentView, 'connectionLayoutClass'] :=
        ClassName;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.TableVizDefaultActionExecute(Sender: TObject);

begin
  ChangeViewLayoutClass(True, 'default');
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.TableVizSimpleActionExecute(Sender: TObject);

begin
  ChangeViewLayoutClass(True, 'simple');
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.NotationVizDefaultActionExecute(Sender: TObject);

begin
  ChangeViewLayoutClass(False, 'default');
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.NotationVizEerActionExecute(Sender: TObject);

begin
  ChangeViewLayoutClass(False, 'eer');
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FormResize(Sender: TObject);

begin
  StatusBar.Panels[1].Width := Width -
    (StatusBar.Panels[0].Width + StatusBar.Panels[2].Width +
      StatusBar.Panels[3].Width + 26);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.EditorTabPageChange(Sender: TObject; PreviousSelectedTab: Integer; PreviousSelectedObj: TObject;
  NewSelectedTab: Integer; Obj: TObject);

begin
  if GrtSheetIsActive then
  begin
    EditorPnl.Show;
    with TUniCodeEdit(Obj) do
    begin
      Show;
      SetFocus;
    end;

    DisplayGrtSidebar;
  end
  else
  begin
    DisplayViewSidebar;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.EditorTabPageDelete(Sender: TObject);

var
  Obj: TObject;

begin
  if not Application.Terminated and (Sender is TTab) and IsDelphiClass(TTab(Sender).Obj) then
  begin
    Obj := TTab(Sender).Obj;

    if (Obj is TUniCodeConsole) and
      (TUniCodeConsole(Obj).Name = 'CommandLineUCE') then
    begin
      FDockedShellTab := nil;
    end
    else
      if (Obj is TUniCodeEdit) and
        (TUniCodeEdit(Obj).Name = 'CodeSnippetUCE') then
      begin
        FDockedCodeSnippetsTab := nil;
      end
      else
        if (Obj is TVirtualStringTree) and
          (TVirtualStringTree(Obj).Name = 'MessagesVT') then
        begin
          FDockedMessagesTab := nil;
        end
        else
          if (Obj is TMyxEditorForm) then
          begin
            TMyxEditorForm(Obj).Close;
          end;

    // if this is the last page that gets deleted, hide tabs
    if (EditorTabFrame.TabCount = 1) then
    begin
      EditorPnl.Hide;

      FDockedMessagesTab := nil;
      FDockedShellTab := nil;
      FDockedCodeSnippetsTab := nil;

      DisplayViewSidebar;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.EditorTabPageCanClose(Sender: TObject; var CanClose: Boolean);

var
  Obj: TObject;

begin
  CanClose := True;

  if (Sender is TTab) and not(Application.Terminated) then
  begin
    Obj := TTab(Sender).Obj;
    if (Obj is TMyxEditorForm) then
      CanClose := TMyxEditorForm(Obj).CloseQuery;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ViewerFocusChanged(Sender: TObject; HasFocus: Boolean);

begin
  if HasFocus then
    DisplayViewSidebar;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ConsoleFocusChanged(Sender: TObject; HasFocus: Boolean);

begin
  if HasFocus then
    DisplayGrtSidebar;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.MessagesVTGetText(Sender: TBaseVirtualTree;
  Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
  var CellText: WideString);

var
  NodeData: PStatusMessage;

begin
  if (Node <> nil) then
  begin
    NodeData := Sender.GetNodeData(Node);

    if (Column = 0) then
      CellText := NodeData.MessageString
    else
      CellText := FormatDateTime('hh:nn:ss', NodeData.Time);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.MessagesVTFreeNode(Sender: TBaseVirtualTree;
  Node: PVirtualNode);

var
  NodeData: PStatusMessage;

begin
  NodeData := Sender.GetNodeData(Node);
  Finalize(NodeData^);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.MessagesVTKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);

var
  Selection: TNodeArray;
  I: Integer;
  Txt: WideString;
  NodeData: PStatusMessage;

begin
  Selection := nil;
  
  if (Key = Ord('C')) and (Shift = [ssCtrl]) then
  begin
    Selection := MessagesVT.GetSortedSelection(False);

    Txt := '';

    for I := 0 to High(Selection) do
    begin
      NodeData := MessagesVT.GetNodeData(Selection[I]);

      Txt := Txt + NodeData.MessageString + #13#10;
    end;

    TntClipboard.AsText := Txt;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.EditorSizerShapeMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

begin
  if not(FEditorPnlMinimized) then
  begin
    FInitMousePos := Mouse.CursorPos.Y;
    FInitWidth := EditorPnl.Height;
    FDragging := True;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.EditorSizerShapeMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);

begin
  if (FDragging) then
  begin
    EditorPnl.Height := Max(
      FInitWidth + (FInitMousePos - Mouse.CursorPos.Y),
      100);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.EditorSizerShapeMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

begin
  if (FDragging) then
  begin
    FDragging := False;

    AppOptions.OptionInt['EditorPanelHeight'] := EditorPnl.Height;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ShowStatusMessagesActionExecute(Sender: TObject);

begin
  if (FDockedMessagesTab = nil) then
  begin
    // add messages to editor tabsheet
    FDockedMessagesTab := EditorTabFrame.TabSheets[
      EditorTabFrame.AddTabSheet(self,
        _('Messages'),
        '',
        MessagesPnl,
        MessagesVT,
        True, False, -1, [], True)];
  end
  else
  begin
    EditorTabFrame.SelectedTabSheet := FDockedMessagesTab;
  end;

  EditorPnl.Visible := True;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.EditorTabsMinimizeActionExecute(Sender: TObject);

begin
  if (EditorPnl.Visible) then
  begin
    if (FEditorPnlMinimized) then
    begin
      EditorPnl.Height := AppOptions.OptionInt['EditorPanelHeight'];

      FEditorPnlMinimized := False;
      EditorSizerShape.Cursor := crVSplit;
    end
    else
    begin
      EditorPnl.Height := EditorSizerShape.Height + EditorTabFrame.Height - 4;
      FEditorPnlMinimized := True;
      EditorSizerShape.Cursor := crDefault;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.EditorTabsMinimizeActionUpdate(Sender: TObject);

begin
  if (Sender is TTntAction) then
    TTntAction(Sender).Enabled := EditorPnl.Visible;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.EditorTabsMinimizeShapeMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

begin
  EditorTabsMinimizeActionExecute(self);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.DockEditorsActionExecute(Sender: TObject);

begin
  AppOptions.OptionInt['DockEditors'] := Ord(TTntAction(Sender).Checked);
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ApplyChangesAndCloseActionExecute(Sender: TObject);

var
  Tab: TTab;

begin
  Tab := EditorTabFrame.SelectedTabSheet;

  if (Tab <> nil) and (Tab.Obj is TMyxEditorForm) then
  begin
    TMyxEditorForm(Tab.Obj).ApplyChanges;
    EditorTabFrame.DeleteTab(EditorTabFrame.SelectedTab);

    FCanvasViewer.SetFocus;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FormActivate(Sender: TObject);

begin
  FCanvasViewer.SetFocus;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ConnectionEditMiClick(Sender: TObject);

var
  Task: IGrtTask;
  
begin
  case TTntMenuItem(Sender).Tag of
    1: // Edit entry
      Pal2TabFrame.SelectedTab := 1;
    2: // Delete entry
      begin
        Task := Grt.CreateStandardTask(_('Deleting relationship'),
          'Workbench', 'deleteRelationship', [FCurrentElement]);
        Grt.AddTask(Task);
      end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.SetCurrentObject(Obj: Pointer);

begin
  if FCurrentObject <> Obj then
  begin
    if Assigned(FCurrentObject) then
      Grt.ValueRelease(FCurrentObject);
    FCurrentObject := Obj;
    if Assigned(FCurrentObject) then
      Grt.ValueRetain(FCurrentObject);
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.ResetModified;

// Ensures that all pending changes are done and resets the modified flag to False (e.g. used after loading a model).

begin
  TGrtWb(Grt).ProcessPendingWbBridge;
  Application.ProcessMessages;
  Modified := False;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.FileOpenActionExecute(Sender: TObject);

var
  OPD: TOpenDialog;
  Model: Pointer;

begin
  if CloseQuery then
  begin
    OPD := TOpenDialog.Create(nil);
    with OPD do
    try
      DefaultExt := 'mwb';
      Filter := 'MySQL Workbench model files (*.mwb)|*.mwb|All files (*.*)|*.*';
      Title := 'Open Model...';
      if Execute then
      begin
        Update;
        LockWindowUpdate(Self.Handle);
        
        FModelFileName := FileName;

        // Workaround for remaining tabs
        while (ViewTabFrame.TabCount > 0) do
          ViewTabFrame.DeleteTab(0, True, True);
        
        try
          Update;
          Screen.Cursor := crHourGlass;
          FLoading := True;
          try
            Model := Grt.ValueLoadFromFile(FModelFileName);

            // First clear what is there and make sure all callbacks are finished in order to release everything.
            Grt.ExecuteStandardTask(_('Clearing document'), 'Workbench', 'clearDocument', [], False);

            // Update screen and finish pending tasks in the GRT/WB controller
            Application.ProcessMessages;

            Grt.ExecuteStandardTask(_('Loading a model from file'), 'Workbench', 'loadDocumentData', [Model], True);

            // get markers
            Grt.Global['/workbench/model/markers'] := Grt.DictItem[Grt.DictItem[Model, 'model'], 'markers'];
            Grt.ValueRelease(Model);

            // Update screen.
            Update;

            ProcessNewDocument;

            StatusBarText := Format(_('Opened model from %s'), [FModelFileName]);
            ResetModified;
            RestoreMarker(10);
          finally
            FLoading := False;
            Screen.Cursor := crDefault;
          end;
        finally
          LockWindowUpdate(0);
          FCanvasViewer.SetFocus;
        end;
      end;
    finally
      Free;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

end.

