#include "xcombobox.h"
#include <qmessagebox.h>
#include <qlineedit.h>

XComboBox::XComboBox(QWidget *parent, int flag)
	: QComboBox(FALSE, parent)
{
	this->flag = flag;
	connect(this, SIGNAL(activated(int)), this, SLOT(slot_activated(int)));

	//QPalette z(palette());
	//z.setColor(QColorGroup::Text, Qt::red);
	//setPalette(z);	
}

XComboBox::~XComboBox()
{
}

void XComboBox::slot_value(QList<QString> &value)
{
	clear();

	if(flag == FLAG_FIND)
		insertItem("*");

	unsigned int s;

	for(s = 0; s < value.count(); s++)
		insertItem(*value.at(s));
	
	if(data.isEmpty())
		data = text(0);

	for(int z = 0; z < count(); z++)
	{
		if(text(z) == data)
			setCurrentItem(z);
	}

	for(s = 0; s < value.count(); s++)
		delete value.at(s);
}

void XComboBox::slot_activated(int value)
{
	data = text(value);
}

QList<QString> XComboBox::get_value()
{
	QList<QString> value;

	for(int s = 0; s < count(); s++)
	{
		QString *z = new QString;
		*z = text(s);
		value.append(z);
	}

	return value;
}