[comment {-*- tcl -*- mysqltcl manpage}]
[manpage_begin mysqltcl n 3.0]
[comment {
Copyright (c) 1994, 1995 Hakan Soderstrom and Tom Poindexter
Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice and this permission notice
appear in all copies of the software and related documentation.
 
THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 
IN NO EVENT SHALL HAKAN SODERSTROM OR SODERSTROM PROGRAMVARUVERKSTAD
AB BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY
OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 
$Id: mysqltcl.n,v 1.1.1.1 2002/02/15 18:21:17 artur Exp $

Updates by Tobias Ritzau 1998-03-18
Replaced all mysql by mysql
Updated the mysqlconnect documentation
 
1998-07-06
Changed some mysql back to msql
Updaated the name and introduction
Updated the mysqlcol documentation

Copyright (c) 1998 Tobias Ritzau

Updates by Artur Trzewik 2002-11-31
for mysqltcl2.1 (mysql::query mysq::endquery)

Updates by Artur Trzewik 2002-11-31
for mysqltcl3.0
}]

[titledesc {MySQL server access commands for Tcl}]

[require Tcl 8.4]
[require mysqltcl 3.0]
[description]
MySQLTcl is a collection of Tcl commands and a Tcl global array that
provide access to MySQL database servers.
[para]
MySQLTcl is nothing more than a patched version of a patched version
of Hakan Soderstrom's patch of Tom Poindexter's Sybtcl.
[para]
Mysqltcl is binary Tcl library (extension) written in C language that use direkt
official MySQL C-API. Almost all Tcl commands correspond to MySQL C-API functions.
For detail documentation see official MySQL C-API manual.

[section {MYSQLTCL COMMANDS}]

[list_begin definitions]

[call [cmd ::mysql::connect] [opt [arg "option value"]...]]

Connect to a MySQL server.
A handle is returned which should be used in other mysqltcl
commands using this connection.
::mysql::connect raises a Tcl error if the connection fails.
::mysql::connect read first the options from my.cnf file group mysqltcl.
See MySQL documentation chapter "options files".
Possible connection options are:

[list_begin opt]

[opt_def -host [arg hostname]]
The host on which the server is located. The local host is used by default.

[opt_def -user [arg user]]
The user whose name is used for the connection.
The current Unix user-name is used by default.

[opt_def -password [arg password]]
The password that must be used for the connection.
If it is not present, the connection is possible only for users with
no password on the server.

[opt_def -db [arg db]]
If this option is present, [arg db] is used as current database, with no need
for a call to [emph mysql::use].

[opt_def -port [arg port]]
The port number for the TCP/IP connection, if it's different from the default.

[opt_def -socket [arg socket]]
The socket or named pipe for the connection.

[opt_def -encoding [arg encodingname]]
The option works similar to -encoding option in fconfigure. It support also
special encoding name binary. By option -binary no converting will be done be reading or writing to/from MySQL.
If option is not set the system encoding (see [encoding system]) is used.
Please test all input and outputs with another program to check that all 
is the way you expect it. If option binary is not used the system procedures
Tcl_ExternalToUtfDString (writing) and Tcl_ExternalToUtf (reading) will be used
by option binary the function Tcl_GetByteArrayFromObj and Tcl_NewByteArrayObj are used.
If you want to manipulate binary date use -encoding binary. By handling textes set your
special encoding that you want to use in your database. Consider what another system access the
database and what encoding they expect. It can useful
to use -encoding utf-8. That is standard encoding in some linux distributions and newer systems.

[opt_def -compress [arg boolean]]
Use compression protocol. Default is false

[opt_def -odbc [arg boolean]]
The client is an ODBC client. This changes mysqld to be more ODBC-friendly. Default is false

[opt_def -noschema [arg boolean]]
Don't allow the db_name.tbl_name.col_name syntax. This is for ODBC. It causes the parser to generate an error if you use that syntax, which is useful for trapping bugs in some ODBC programs. This changes mysqld to be more ODBC-friendly. Default is false

[opt_def -multistatement [arg boolean]]
Tell the server that the client may send multiple-row-queries (separated by `;').
If this flag is not set, multiple-row-queries are disabled. Default is false.

[opt_def -multiresult [arg boolean]]
Tell the server that the client can handle multiple-result sets from multi-queries or stored procedures.
This is automatically set if CLIENT_MULTI_STATEMENTS is set.

[opt_def -localfiles [arg boolean]]
Enable LOAD DATA LOCAL handling. Default is false.

[opt_def -foundrows [arg boolean]]
Return the number of found (matched) rows, not the number of affected rows.
Default is false.

[opt_def -interactive [arg boolean]]
Allow interactive_timeout seconds (instead of wait_timeout seconds) of inactivity before closing the connection.
The client's session wait_timeout variable will be set to the value of the session interactive_timeout variable.
Default is false.

[opt_def -ssl [arg boolean]]
Switch to SSL after handshake. Default is  false

[opt_def -sslkey [arg string]]
is the pathname to the key file. 
Used if -ssl is true

[opt_def -sslcert [arg string]]
is the pathname to the certificate file.
Used if -ssl is true

[opt_def -sslca [arg string]]
is the pathname to the certificate authority file. 
Used if -ssl is true

[opt_def -sslcapath [arg string]]
is the pathname to a directory that contains trusted SSL CA certificates in pem format. 
Used if -ssl is true

[opt_def -sslcipher [arg string]]
is a list of allowable ciphers to use for SSL encryption. 
Used if -ssl is true

[list_end]

[call [cmd ::mysql::use] [arg handle] [arg database]]

Associate a connected handle with a particular database.
[arg handle] must be a valid handle previously obtained from ::mysql::connect.
mysql::use raises a Tcl error if the handle is not valid or
if the database name specified could not be used.
[nl]
Consider you can use mysqltcl without to specify the database, in this case
you must use explizit schema notation to specify the table in sql.
[example_begin]
::mysql::sel $handle {select * from uni.student}
[example_end]
with option connection [arg -noschema] you can prohibit such syntax.

[call [cmd ::mysql::sel] [arg handle] [arg sql-statement] [opt [arg -list|-flatlist]]]

Send [arg sql-statement] to the server.
[nl]
If [arg sql-statement] is a SELECT statement and no [arg -list] or
[arg -flatlist] option is specified, the command returns the
number of rows returned as the result of the query.
The rows can be obtained by the [arg ::mysql::fetch] and/or the
[arg ::mysql::map] commands.
The resulting rows are called the [term "pending result"].
[nl]
If [arg sql-statement] is a SELECT statement and [arg -list] or [arg -flatlist]
is specified, the command returns the full list of rows returned as 
the result of the query in one of two possible formats:

[list_begin opt]

[opt_def -list]
generates a list of lists, in which each element is a row of the result.

[opt_def -flatlist]
generates the concatenation of all rows in a single list, which 
is useful for scanning with a single [emph foreach].

[list_end]

Example:

[example_begin]
% ::mysql::sel $db "SELECT ID, NAME FROM FRIENDS" -list
{1 Joe} {2 Phil} {3 John}
% ::mysql::sel $db "SELECT ID, NAME FROM FRIENDS" -flatlist
{1 Joe 2 Phil 3 John}
[example_end]

Note that both list syntaxes are faster than something like

[example_begin]
% ::mysql::sel $db "SELECT ID, NAME FROM FRIENDS"
% ::mysql::map $db {id name} {lappend result $id $name}
% set $result
{1 Joe 2 Phil 3 John}
[example_end]

If [arg sql-statement] is a valid MySQL statement, but not a SELECT
statement, the command returns -1 after executing the statement, or an empty 
string if [arg -list] or [arg -flatlist] is specified.
There is no pending result in this case.
[nl]
In any case ::mysql::sel implicitly cancels any previous result still
pending for the handle.

[call [cmd ::mysql::fetch] [arg handle]]

Returns the next row from result set as Tcl list.
mysql::fetch raises a Tcl error if there is no pending result for [arg handle].
mysql::fetch was former named mysqlnext.

[call [cmd ::mysql::exec] [arg handle] [arg sql-statement]]

Send [arg sql-statement], a MySQL non-SELECT statement, to the server.
The [arg handle] must be in use (through ::mysql::connect and ::mysql::use).
[nl]
::mysql::exec implicitly cancels any previous result pending for the handle.
[nl]
If [arg sql-statement] is a valid MySQL SELECT statement, the statement
is executed, but the result is discarded.
No Tcl error is generated.
This amounts to a (potentially costly) no-op.
Use the ::mysql::sel command for SELECT statements.
[nl]
::mysql::exec return the number of affected rows (DELETE, UPDATE)
[nl]

[call [cmd ::mysql::query] [arg handle] [arg sql-select-statement]]

Send [arg sql-select-statement] to the server.
[nl]
[arg mysql::query] allow to send multiple nested queries on one handle (without need to build
new handle or caching results).
mysql::query return a query handle that can be used as handle in commands as (mysql::fetch,
::mysql::map, mysql::seek, mysql::col, mysql::result).
After result proceeding all query must be
freed with [emph "::mysql::endquery query-hanlde"] command.
[nl]
Example:
[example_begin]
set query1 [lb]::mysql::query $db {SELECT ID, NAME FROM FRIENDS}\[rb]
while {[lb]set row [lb]::mysql::fetch $query1[rb][rb]!=""} {
    set id [lb]lindex $row 0[rb]
    set query2 [lb]::mysql::query $db "SELECT ADDRESS FROM ADDRESS WHERE FRIENDID=$ID"[rb]
    ::mysql::map $query2 address { puts "address = $address" }
    ::mysql::endquery $query2
}
::mysql::endquery $query1
[example_end]
In most cases one should use sql-joins and avoid nested queries.
SQL-sever can optimize such queries.
But in some applications (GUI-Forms) where the results are used long time the inner
query is not known before.

[call [cmd ::mysql::endquery] [arg query-handle]]

free result memory after [arg ::mysql::query] command.
You must invoke ::mysql::endquery after each mysqlquery to not cause memory leaks. See mysqlquery command.
[nl]
Using [arg ::mysql::endquery] on db-handle will free also memory (pending result) after [arg ::mysql::sel] command.
[nl]


[call [cmd ::mysql::map] [arg handle] [arg binding-list] [arg script]]

Iterate a script over the rows of the pending result.
::mysql::map may consume all rows or only some of the rows of the pending
result.
Any remaining rows may be obtained by further ::mysql::fetch or ::mysql::map
commands.
[nl]
[arg handle] must be a handle with a pending result from a previous
::mysql::sel command.
[arg binding-list] must be a list of one or more variable names.
[arg script] must be a Tcl script.
It may be empty, but usually it contains one or more commands.
[nl]
::mysql::map processes one row at a time from the pending result.
For each row the column values are bound to the variables in the
binding list, then the script is executed.
Binding is strictly positional.
The first variable in the binding list is bound to the first column of
the row, and so on.
The variables are created in the current context (if they do not
already exist).
A variable name begining with a hyphen is not bound; it serves as a
placeholder in the binding list.
If there are more columns than variables the extra columns are
ignored.
[nl]
The ::mysql::map command is similar to an ordinary [emph foreach].
A [emph foreach] iterates over the elements of a list, ::mysql::map
iterates over the rows of a pending result.
In both cases iteration is affected by [emph break] and [emph continue]
Tcl commands.
The binding list variables retain their last values after the command
has completed.
[nl]
A simple example follows.
Assume $db is a handle in use.
[example_begin]
::mysql::sel $db {
    select lname, fname, area, phone from friends order by lname, fname
}
::mysql::map $db {ln fn - phone} {
   if {$phone == {}} continue
   puts [lb]format "%16s %-8s %s" $ln $fn $phone[rb]
}
[example_end]
The ::mysql::sel command gets and sorts all rows from table friends.
The ::mysql::map command is used to format and print the result in a way
suitable for a phone list.
For demonstration purposes one of the columns (area) is not used.
The script begins by skipping over rows which have no phone number.
The second command in the script formats and prints values from the row.
[nl]
::mysql::map raises a Tcl error if there is no pending result for
[arg handle], or if [arg binding-list] contains more variables than
there are columns in the pending result.
[nl]

[call [cmd ::mysql::receive] [arg handle] [arg sql-statment] [arg binding-list] [arg script]]

This command works the same way as the command mysqtclmap but
it do not need leading ::mysql::sel command.
The main difference is internal using of MySQL client library.
This command use mysql_use_result from C-API that do not
store result on client but try to receive the rows directly
from server.
There is also no client cache.
This command can be faster as using of ::mysql::sel and by
very big resultset will not overload client machine.
The scipt should process the result immadiatly because
it can block table (or tables) for another clients.
If performance matter please test all alternatives separatly.
You must consider two aspects: memory consumption and performance.

[call [cmd ::mysql::seek] [arg handle] [arg row-index]]

Moves the current position among the rows in the pending result.
This may cause [term ::mysql::fetch] and [term ::mysql::map] to re-read rows, or to
skip over rows.
[nl]
Row index 0 is the position just before the first row in the pending result;
row index 1 is the position just before the second row, and so
on.
You may specify a negative row index.
Row index -1 is the position just before the last row;
row index -2 is the position just before the second last row,
and so on.
An out-of-bounds row index will cause ::mysql::seek to set the new current
position either just before the first row (if the index is too negative),
or just after the last row (if the index exceeds the number of rows).
This is not an error condition.
[nl]
::mysql::seek returns the number of rows that can be read sequentially from
the new current position.
::mysql::seek raises a Tcl error if there is no pending result for [arg handle].
[nl]
Portability note: The functionality of [arg ::mysql::seek] is frequently
absent in other Tcl extensions for SQL.
That is because MySQL C-API client library ofers own result set caching functionality
that lacks another SQL-APIs.
That increase the performance because all rows are received at once and the query does
not block the server for another clienst , on the other
hand you works on the cached data can use a lot of memory and are up to date only in the moment
of query but not fetch.
[nl]

[call [cmd ::mysql::col] [arg handle] [arg table-name] [arg option]]
[call [cmd ::mysql::col] [arg handle] [arg table-name] [arg optionkist]]
[call [cmd ::mysql::col] [arg handle] [opt [arg option]...]]

Return information about the columns of a table.
[arg handle] must be in use.
[arg table-name] must be the name of a table; it may be a table name
or [arg -current] if there is a pending result.
One or more options control what information to return.
Each option must be one of the following keywords.
[list_begin opt]

[opt_def name] Return the name of a column.

[opt_def type]
Return the type of a column; one of the strings [emph decimal],
[emph tiny], [emph short], [emph long], [emph float], [emph double],
[emph null], [emph timestamp], [emph "long long"], [emph int24], [emph date],
[emph time], [emph "date time"], [emph year], [emph "new date"], [emph enum],
[emph set], [emph "tiny blob"], [emph "medium blob"], [emph "long blob"],
[emph blob], [emph "var string"], or [emph string].
Note that a column of type [emph char] will return tiny, while they are 
represented equally.

[opt_def length] Return the length of a column in bytes.

[opt_def table] Return the name of the table in which this column occurs.

[opt_def non_null] Return the string "1" if the column is non-null; otherwise "0".

[opt_def prim_key] Return the string "1" if the column is part of the primary key;
otherwise "0".

[opt_def numeric] Return the string "1" if the column is numeric; otherwise "0".

[opt_def decimals] Return the string "1" if the column is non-null; otherwise "0".
[list_end]

The three forms of this command generate their result in a
particular way.
[list_begin enum]
[enum]
If a single option is present the result is a simple list of
values; one for each column.
[enum]
If the options are given in the form of an option list the
result is a list of lists.
Each sublist corresponds to a column and contains the information
specified by the options.
[enum]
If several options are given, but not in a list, the result is also
a list of lists.
In this case each sublist corresponds to an option and contains one
value for each column.
[list_end]

The following is a sample interactive session containing all forms of
the ::mysql::col command and their results.
The last command uses the [emph -current] option.
It could alternatively specify the table name explicitly.
[example_begin]
%::mysql::col $db friends name
name lname area phone
% ::mysql::col $db friends {name type length}
{fname char 12} {lname char 20} {area char 5} {phone char 12}
% ::mysql::sel $db {select * from friends}
% ::mysql::col $db -current name type length
{fname lname area phone} {char char char char} {12 20 5 12}]
[example_end]

[call [cmd ::mysql::info] [arg handle] [arg  option]]

Return various database information depending on the [arg option].
The option must be one of the following keywords.

[list_begin opt]
[opt_def info]
Return a String with information about last operation.
"Records: 3 Duplicates: 0 Warnings: 0" by INSERT or 
"Rows matched: 40 Changed: 40 Warnings: 0" by UPDATE statements
(read the manual for mysql_info in MySQL C API documentation) 

[opt_def databases]
Return a list of all database names known to the server.
The handle must be connected.

[opt_def dbname]
Return the name of the database with which the handle is associated.
The handle must be in use.

[opt_def dbname?]
Return the name of the database with which the handle is associated;
an empty string if the handle is connected, but not in use.

[opt_def host]
Return the name of the host to which the handle is connected.
The handle must be connected.

[opt_def host]
Return the name of the host to which the handle is connected; an empty
string if the handle is not valid.

[opt_def tables]
Return a list of all table names in the database with which the handle
is associated.
The handle must be in use.

[opt_def serverversion] 
Returns the version number of the server as a string.

[opt_def serverversionid]
Returns the version number of the server as an integer.

[opt_def sqlstate]
Returns a string containing the SQLSTATE error code for the last error.
The error code consists of five characters. '00000' means ``no error.''
The values are specified by ANSI SQL and ODBC.

Note that not all MySQL errors are yet mapped to SQLSTATE's.
The value 'HY000' (general error) is used for unmapped errors. 

[opt_def state]
Returns a character string containing information similar to that provided by the mysqladmin status command.
This includes uptime in seconds and the number of running threads, questions, reloads, and open tables.

[list_end]

[call [cmd ::mysql::baseinfo] [arg option]]

return information information that do not need handle.
[list_begin opt]

[opt_def connectparameters]
return all supported connecting options

[opt_def clientversion]
return the version of underlying MYSQL C-API library
[list_end]

[call [cmd ::mysql::ping] [arg handle]]

Checks whether the connection to the server is working. If it has gone down, an automatic reconnection is attempted.
[nl]
This function can be used by clients that remain idle for a long while, to check whether the server has closed the connection and reconnect if necessary.
[nl]
Return True if server is alive

[call [cmd ::mysql::changeuser] [arg user] [arg password] [opt [arg database]]]

Changes the user and causes the database specified by database to become the default (current) database on the connection specified by MySQL. In subsequent queries, this database is the default for table references that do not include an explicit database specifier.
[nl]
::mysql::changeuser fails unless the connected user can be authenticated or if he doesn't have permission to use the database. In this case the user and database are not changed
[nl]
if database parameter may be set were is no default database. 
[nl]
Cause Error if operation is not succesed

[call [cmd ::mysql::result] [arg handle] [arg option]]

Return information about the pending result.
Note that a result is pending until canceled by a ::mysql::exec command,
even if no rows remain to be read.
[arg Option] must be one of the following keywords.

[list_begin opt]

[opt_def cols]
Return the number of columns in the pending result.
There must be a pending result.

[opt_def cols]
Return the number of columns in the pending result; an empty string if
no result is pending.

[opt_def current]
Return the current position in the pending result; a non-negative integer.
This value can be used as [arg row-index] in the ::mysql::seek command.
An error is raised if there is no pending result.

[opt_def current?]
As above, but returns an empty string if there is no pending result.

[opt_def rows]
Return the number of rows that can be read sequentially from the
current position in the pending result.
There must be a pending result.

[opt_def rows]
Return the number of rows that can be read sequentially from the
current position in the pending result; an empty string if no result
is pending.
[nl]
[lb]::mysql::result $db current[rb] + [lb]::mysql::result $db rows[rb]
always equals the total number of rows in the pending result.
[list_end]

[call [cmd ::mysql::state] [arg handle] [opt [arg -numeric]]]

Return the state of a handle as a string or in numeric form.
There is no requirement on [arg handle]; it may be any string.
The return value is one of the following strings, or the corresponding
numeric value if [arg -numeric] is specified.
The states form a progression where each state builds on the previous.
[list_begin opt]

[opt_def "NOT_A_HANDLE (0)"]
The string supplied for [arg handle] is not a mysqltcl handle at all.

[opt_def "UNCONNECTED (1)"]
The string supplied for [arg handle] is one of the possible mysqltcl
handles, but it is not valid to any server.

[opt_def "CONNECTED (2)"]
The handle is connected to a server, but not associated with a database.

[opt_def "IN_USE (3)"]
The handle is connected and associated with a database, but there is
no pending result.

[opt_def "RESULT_PENDING (4)"]
The handle is connected, associated with a database, and there is a
pending result.
[list_end]

[call [cmd ::mysql::close] [opt [arg handle]]]

Closes the server connection associated with [arg handle], causing it
to go back to the unconnected state.
Closes all connections if [arg handle] is omitted.
Returns an empty string.
::mysql::close raises a Tcl error if a handle is specified which is not
valid.

[call [cmd ::mysql::insertid] [arg handle]]

Returns the auto increment id of the last INSERT statement.

[call [cmd ::mysql::escape] [opt [arg handle]] [arg string]]

Returns the content of [arg string], with all special characters escaped,
so that it is suitable for use in an SQL statement. This is simpler (faster)
than using a general [emph regexp] or string map.
If handle is specified C-API function mysql_real_escape_string is used.
This is the recommended usage because in this case current character set is respected.

[call [cmd ::mysql::autocommit] [arg handle] [arg boolean]]
Sets autocommit mode on if mode is 1, off if mode is 0.

[call [cmd ::mysql::commit] [arg handle]]
Commits the current transaction.

[call [cmd ::mysql::rollback] [arg handle]]
Rollback the current transaction.

[call [cmd ::mysql::nextresult] [arg handle]]
If more query results exist, mysql::nextresult() reads the next query results and returns the status back to application.
returns -1 if no result or number of rows in the result set.

[call [cmd ::mysql::moreresult] [arg handle]]
Returns true if more results exist from the currently executed query, and the application must call mysql::result to fetch the results.

[call [cmd ::mysql::warningcount] [arg handle]]
Returns the number of warnings generated during execution of the previous SQL statement.


[call [cmd ::mysql::isnull] [arg value]]
Null handling is a known problem with Tcl, especially with DB interaction.
The mysql "varchar" type has two valid blank values, NULL and an empty
string. This is where the problem arises; Tcl is not able to differentiate
between the two because of the way it handles strings.
Mysql has new internal Tcl type for null that string representation is stored
in global array mysqltcl(nullvalue) and as default empty string.
mysql::isnull can be used for safe check for null value.
Warning mysql::isnull works only reliable if there are no type conversation on
returned rows.
Consider row is always Tcl list even when there are only one column in the row.
[example_begin]
set row [lb]::mysql::next $handle[rb]
if {[lb]mysql::isnull [lb]lindex $row 1[rb]]} {
   puts "2. column of $row is null"
}
if {[lb]mysql::isnull $row[rb]} {
   puts "this does not work, because of type conversation list to string"
}
[example_end]

[call [cmd ::mysql::newnull]]
create new null object. It can be used to simulate returned row contents.

[call [cmd ::mysql::setserveroption] [arg handle] [arg option]]
there are only 2 options now: -multi_statment_on and -multi_statment_off

[call [cmd ::mysql::shutdown] [arg handle]]
Asks the database server to shut down. The connected user must have SHUTDOWN privileges. 

[call [cmd ::mysql::encoding] [arg handle] [opt encoding]]
Ask or change a encoding of connection.
There are special encoding "binary" for binary data transfers.

[list_end]

[section "STATUS INFORMATION"]
Mysqltcl creates and maintains a Tcl global array to provide status
information. 
Its name is [emph mysqlstatus].
.P
Mysqlstatus elements:
[list_begin definitions]
[lst_item code]

A numeric conflict code set after every mysqltcl command.
Zero means no conflict; non-zero means some kind of conflict.
All conflicts also generate a Tcl error.
[nl]
All MySQL server conflicts set mysqlstatus(code) to the numeric
code of the MySQL error.
[nl]
Any other conflict sets mysqlstatus(code) to -1.

[lst_item command]
The last failing mysqltcl command.
Not updated for successful commands.

[lst_item message]
Message string for the last conflict detected.
The same string is returned as the result of the failing mysqltcl
command.
Not updated for successful commands.

[lst_item nullvalue]
The string to use in query results to represent the SQL null value.
The empty string is used initially.
You may set it to another value.
[list_end]

[section "Backward compatibility"]
Up from version 3.0 all mysql commands are declared in ::mysql namespace.
All names for example mysqlconnect are also aviable but deprecated.
All old commands have the name pattern mysql{name} and the most of them are now mysql::{name}.
The exception is mysqlnext, which  was renamed to mysql::fetch.

[section "BUGS & POSSIBLE MISFEATURES"]

Deleting any of the mysqltcl commands closes all connections.

[section AUTHORS]

[list_begin bullet]
[bullet]
Tobias Ritzau
[bullet]
Paolo Brutti
[bullet]
Artur Trzewik (mail@xdobry.de) - active maintainer

[list_end]

MySQLTcl is derived from a patch of msql by Hakan Soderstrom, Soderstrom Programvaruverkstad,
S-12242 Enskede, Sweden.
msql is derived from Sybtcl by Tom Poindexter.
There are many contributors and bug reporter that are not mentioned.
If you have contributed to mysqltcl and wants to be on the list contact Artur Trzewik.
[manpage_end]
