#!/bin/sh
#Mythbuntu Install & Settings Session
# Copyright © 2007  Mario Limonciello

#Set the background to black
xsetroot -solid black

#source frontend session settings
if [ -f /etc/mythtv/session-settings ]; then
    . /etc/mythtv/session-settings
fi

#Mythbuntu live configuration
if [ -x /usr/bin/mythbuntu-startup ]; then
    gksudo -k "mythbuntu-startup --load"
#Mythbuntu normal session
else
    #if nvidia settings are saved and nvidia drivers installed, load them
    if [ -x /usr/bin/nvidia-settings ] && [ -f ~/.nvidia-settings-rc ]; then
        nvidia-settings -l
    fi

    #If we have mtd around (and not running), good idea to start it too
    if ! `pgrep mtd>/dev/null`; then
        if [ -x /usr/bin/mtd ]; then
            /usr/bin/mtd -d
        fi
    fi
    #check if irexec is needed, and start if need be
    if [ -x /usr/bin/irexec ] && [ ! -f ~/.noirexec ] && [ -f ~/.lircrc ]; then
        if [ -n "$(cat ~/.lirc/* | grep --invert-match "#" | grep irexec | grep prog)" ]
        then
            killall irexec
            irexec -d
        fi
    fi
    #x11vnc
    if [ -x /usr/bin/x11vnc ] && [ -f /root/.vnc/passwd ]; then
        x11vnc -rfbauth /root/.vnc/passwd -rfbport 5900 -shared -forever -nowf -norc -notruecolor -bg
    fi
    #Customized home commands
    if [ -x $HOME/.mythtv/session ]; then
        $HOME/.mythtv/session &
    fi
fi

#Start window manager
export XDG_CONFIG_DIRS=/etc/xdg/mythbuntu
export XDG_DATA_DIRS=/etc/xdg/mythbuntu
exec startxfce4
