/* nawmmod.h: Include file for nawm modules. These are the only
 * interfaces guaranteed to stay stable.
 */

/* Copyright (C) 1999 by the Massachusetts Institute of Technology.
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in
 * advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 * M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 */

#include <sys/types.h>
#include <X11/Xlib.h>

/* Interface version */
#define NAWM_MODREV 1

typedef long nawmval;

/* Types (opaque) */
typedef struct _array array;
typedef struct _arrayiter arrayiter;

typedef nawmval dtype;
#define T_INT 1
#define T_WIN 2
#define T_STR 3
#define T_ARRAY 4

#define is_simple_type(t) (t < 4)
#define is_atomic_type(t) (t < 3)

/* Prototypes from array.c */
dtype array_type(dtype base, dtype sub);
array *create_array(dtype type, int nbuckets);
void free_array(array *arr);
nawmval array_lookup(array *arr, nawmval subscript);
void array_insert(array *arr, nawmval subscript, nawmval value);
void array_delete(array *arr, nawmval subscript);
nawmval array_first(array *arr, arrayiter *ai);
nawmval array_next(array *arr, arrayiter *ai);
int array_contains(array *arr, nawmval value);

/* Prototypes from cache.c */
Window client_window(Window win);
Window manager_window(Window win);

/* Prototypes from keymap.c */
void set_modifier_state(int state);
void reset_modifier_state(void);

/* Prototypes from mem.c */
void *xmalloc(size_t size);
void *xrealloc(void *ptr, size_t size);
char *xstrdup(const char *str);

void *gcmalloc(size_t size, void (*freeer)(void *));
char *gcstrdup(const char *str);
void *ref(void *ptr);
void unref(void *ptr);

/* Prototypes from mod.c */
void module_define_procedure(char *name, dtype rtype, void (*body)(),
                             int numargs, ...);
int module_define_type(char *name);
int module_lookup_type(char *name);
void module_define_event_handler(void (*handler)(XEvent *), long mask);
