using Nemerle.IO;
using Nemerle.Utility;
using System;

module a {
 public Main () : void {
  def x = array [1,2];
  def y = array [4,5,6];
  def z = Add (y, x);
  foreach (a in z)
   Console.WriteLine (a.ToString ());

   NArrayTest.Run ();
 }

 public static Add ['a] (arg1: array ['a], arg2: array ['a]) : array ['a] {
   def tmp = array (arg1.Length + arg2.Length);
   System.Array.Copy (arg1, tmp, arg1.Length);
   System.Array.Copy (arg2, 0, tmp, arg1.Length, arg2.Length);
   tmp
 }
}

public class NArrayTest
{
  public static Run () : void
  {
    printf ("NArray test.\n");

    mutable b = array [4, 6, 8, 10, 12, 14, 16, 18];

    if (NArray.ForAll (b, fun (x : int) { x % 2 == 0 }))
      printf ("For all!\n")
    else
      printf ("Not quite for all!\n");

    _ = System.Array.IndexOf (System.Environment.GetCommandLineArgs (), "-dump");
  }
}


/*
BEGIN-OUTPUT
4
5
6
1
2
NArray test.
For all!
END-OUTPUT
*/
