/* some test cases for algorithm that turns decision tree into decision DAG */

module M 
{
  foo (a : int, b : int) : void
  {
    def n = 
      match ((a, b))
      {
        | (1, 1) => 1
        | (1, 2) with y = 2
        | (2, 1) with y = 4 => y
        | (a, b) when (a < b) => a + b        
        | (2, 2) with x = 8 
        | (a, b) when (a > b) with x = 16 => x
        | _ => 3
      };
    System.Console.WriteLine (n.ToString ())
  }

  goo (x : list [int] * list [int]) : void
  {
    def n =
      match (x) {
        | ([1,2], _) => 0
        | (_, [1,2]) => 1
        | _ => 2
      };
    System.Console.WriteLine (n.ToString ())
  }  

  public Main () : void
  {
    foo (1, 1);  
    foo (1, 2);
    foo (2, 1);
    foo (2, 2);
    foo (0, 1);
    foo (1, 0);
    foo (3, 3);
    goo (([1,2], [1,2]));
    goo (([1,3], [1,2]));
    goo (([1,2,3], [1,2]));
    goo (([], []));
    goo (([], [1,2]));
    goo (([], [1,2,3]));
  }
}

/*
BEGIN-OUTPUT
1
2
4
8
1
16
3
0
1
1
2
1
2
END-OUTPUT
*/
  
