#! /bin/sh
### BEGIN INIT INFO
# Provides:          nepenthes
# Required-Start:    $network
# Required-Stop:     $network
# Should-Start:
# Should-Stop:
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: versatile tool to collect malware by emulating widespread vulnerabilities
# Description:       Nepenthes is a low interaction honeypot which emulates known vulnerabilities
#  to collect information about potential attacks. It is designed to emulate
#  vulnerabilities worms use to spread, and to capture these worms. As there are
#  many possible ways for worms to spread, Nepenthes is modular.
### END INIT INFO

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/nepenthes
NAME=nepenthes
GROUP=nepenthes
DAEMON_OPTS="--user=$NAME --group=$GROUP -D"

test -x $DAEMON || exit 0

set -e

case "$1" in
  start)
	echo -n "Starting $NAME: "
	start-stop-daemon --start --quiet --pidfile /var/run/$NAME.pid \
	--make-pidfile --exec $DAEMON -- $DAEMON_OPTS
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $NAME: "
	start-stop-daemon --stop --quiet --pidfile /var/run/$NAME.pid \
	--signal 15 --exec $DAEMON
	echo "$NAME."
	;;
  restart|force-reload)
	echo -n "Restarting $NAME: "
	start-stop-daemon --stop --quiet --pidfile /var/run/$NAME.pid \
	--signal 15 --exec $DAEMON
	sleep 1
	start-stop-daemon --start --quiet --pidfile /var/run/$NAME.pid \
	--make-pidfile --exec $DAEMON -- $DAEMON_OPTS
	echo "$NAME."
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
