#TRUSTED 56b7822b6bddec4d85ea8f7409a594bbb3d37b392510858d6dcb86fe53f9f52cc08274f7cebc19dc38136e54b0a3f1ac6f135a5d42c0de589fba647c5b3a96babc1fa1a0c9d91ade93b287ea7b3d47ca345e618af22c4f246be75e0bf5d2869e639ef3bcfff6802219f9f40add7b95e961bdad13a2fea328d721f98ac0a9cfc061e7401a1248603a366eaeabe027d072e11614bc5dbc68effa005d5712d18726a333ccc3050a0eb344a884ecda3c64b1b823cd8cef06ec4d79550ab0eaebc76e7ecf8c03602ed637f75c5517be0f4f22c58bcf3419501c7c16f935aea396267195b749730e61b0df866087139c4ca60ec0bdbd4d657e49b0e320e6a93e88b042548dab1dff7810dcaa4a6263f1934b63037fe87cc49b6b66e869c133afa798f762b954a122161893502f634552e6336d8032eb7c46c2fc2a397c1174655cb9fdb9ebec0c1db88c129a50991f32626d8abfc3887b1238e67c56a6f0ca24c263e9465927e04ffc759c0f0912c490f93560b7d9ee4aae578c50aa68830f17b4a23d4e221953bfc89ec5bf660b37ea23ffac8c8b7e0edb6a8ea67ee179ed8f1a27bbe994b938e13953e20ba3da52093811f658c48e604a18131c5de5582ceaa74d814af0457418ff5638d55cd81da365fd8cd519caf163b6a2e140ddefb6e57c8cf8c8cdd21c0d9c12a6189040a8ede29f899892975cfe194bd87b79f2ddf916cb5c
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

# No use to run this one if the other plugins cannot run!
if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15879);
 script_version ("1.3");
 name["english"] = "Hydra: NNTP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find NNTP accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force NNTP authentication with Hydra";
 script_summary(english:summary["english"]);
 script_timeout(0);
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/nntp", 119);
 script_dependencies("hydra_options.nasl", "nntpserver_detect.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/nntp");
if (! port) exit(0);
if (! get_port_state(port)) exit(0);

# Check that the NNTP server is up & running
soc = open_sock_tcp(port);
if (! soc) exit(0);
r = recv_line(socket: soc, length: 1024);
close(soc);
if (r !~ '^2[0-9][0-9] ') exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "nntp";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/nntp/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following NNTP accounts:\n' + report);
