/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.j2ee.refactoring.safedelete;

import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.J2EERefactoring;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.openide.filesystems.FileObject;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Iterator;
import java.io.IOException;
import org.openide.loaders.DataObject;

/**
 * @author pfiala
 */
public class BaseRefactoring implements J2EERefactoring {
    final private Collection childRefactorings = new LinkedList();
    protected BaseRefactoringHelper helper;

    public BaseRefactoring(BaseRefactoringHelper helper) {
        this.helper = helper;
    }

    public void addChildRefactoring(AbstractRefactoring refactoring) {
        childRefactorings.add(refactoring);
    }

    public Problem preCheck() {
        Problem problem = preCheckThis();
        for (Iterator it = childRefactorings.iterator(); it.hasNext();) {
            AbstractRefactoring refactoring = (AbstractRefactoring) it.next();
            problem = Utility.addProblemsToEnd(problem, refactoring.preCheck());
        }
        return problem;
    }

    public Problem checkParameters() {
        Problem problem = checkParametersThis();
        for (Iterator it = childRefactorings.iterator(); it.hasNext();) {
            AbstractRefactoring refactoring = (AbstractRefactoring) it.next();
            problem = Utility.addProblemsToEnd(problem, refactoring.checkParameters());
        }
        return problem;
    }


    public Problem fastCheckParameters() {
        Problem problem = fastCheckParametersThis();
        for (Iterator it = childRefactorings.iterator(); it.hasNext();) {
            AbstractRefactoring refactoring = (AbstractRefactoring) it.next();
            problem = Utility.addProblemsToEnd(problem, refactoring.fastCheckParameters());
        }
        return problem;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Problem problem = prepareThis(refactoringElementsBag);
        final RefactoringSession session = refactoringElementsBag.getSession();
        for (Iterator it = childRefactorings.iterator(); it.hasNext();) {
            AbstractRefactoring refactoring = (AbstractRefactoring) it.next();
            problem = Utility.addProblemsToEnd(problem, refactoring.prepare(session));
        }
        return problem;
    }

    protected Problem preCheckThis() {
        return null;
    }

    protected Problem checkParametersThis() {
        return null;
    }

    protected Problem fastCheckParametersThis() {
        return null;
    }

    protected Problem prepareThis(RefactoringElementsBag refactoringElementsBag) {
        return null;
    }


    public static class EjbHelper extends BaseRefactoringHelper {
        private final EjbJar ejbJar;

        public EjbHelper(AbstractRefactoring refactoring, FileObject fileObject, EjbJar ejbJar) {
            super(refactoring, fileObject);
            this.ejbJar = ejbJar;
        }

        public void writeDD() {
            try {
                ejbJar.write(getFileObject());
            } catch (IOException e) {
                //todo
            }
        }

        public EjbJar getEjbJar() {
            return ejbJar;
        }

    }

    public static class TldHelper extends BaseRefactoringHelper {
        private final Taglib taglib;

        public TldHelper(AbstractRefactoring refactoring, FileObject fileObject, Taglib taglib) {
            super(refactoring, fileObject);
            this.taglib = taglib;
        }

        public void writeDD() {
            try {
                TLDDataObject tdo =(TLDDataObject)DataObject.find(getFileObject());
                if (tdo != null) {
                    tdo.write(taglib);
                }
            } catch (IOException ioe) {
                //TODO
            }
        }

        public Taglib getTaglib() {
            return taglib;
        }
    }
    
}