/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.exceptions.web.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
import org.netbeans.modules.exceptions.entity.Exceptions;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;
import org.netbeans.modules.exceptions.web.ExceptionsComparator;
import org.netbeans.modules.exceptions.web.Utils;
/**
 *
 * @author Jan Horvath
 * @version
 */

public class ListAction extends Action {
    
    /* forward name="success" path="" */
    private final static String SUCCESS = "success";
    private final static String QUERY = "query";
    private final static String COUNT = "count";
    
    private final static String DEFAULT_ORDER = "id";
    
    
    /**
     * This is the action called from the Struts framework.
     * @param mapping The ActionMapping used to select this instance.
     * @param form The optional ActionForm bean for this request.
     * @param request The HTTP Request we are processing.
     * @param response The HTTP Response we are processing.
     * @throws java.lang.Exception
     * @return
     */
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        request.setAttribute("startActionTime", new Long(System.currentTimeMillis()));
        String order = request.getParameter("order");
        String query = request.getParameter("query");
        String unmapped = request.getParameter("unmapped");
        String count = request.getParameter("count");
        boolean duplicates = "on".equals(request.getParameter("duplicates")); //show only issues with one or more duplicates
        boolean originals = "on".equals(request.getParameter("originals"));
        
        Map params = Utils.getParamsFromRequest(request);
        
        if (order != null) {
            request.getSession().setAttribute("order", order);
        } else {
            Object o = request.getSession().getAttribute("order");
            if (o == null) {
                order = DEFAULT_ORDER;
            } else {
                order = (String) o;
            }
        }
        
        
        if (query != null) {
            return mapping.findForward(QUERY);
        }
        
        if (count != null) {
            request.setAttribute("count",PersistenceUtils.getInstance().count(Exceptions.class, params, originals, duplicates));
            System.out.println("** " + request.getQueryString());
            return mapping.findForward(COUNT);
        }
        
        if (unmapped != null) {
            request.setAttribute("exceptions", PersistenceUtils.getInstance().findUnmapped());
            return mapping.findForward(SUCCESS);
        }
        
//        if (duplicates) {
//            request.setAttribute("exceptions",duplicateFilter(PersistenceUtils.lookupInstance().find(Exceptions.class, params, duplicates)));
//        } else {
        if ("duplicates".equals(order) || "build".equals(order)) {
            List<Exceptions> e = new ArrayList(PersistenceUtils.getInstance().find(Exceptions.class, params, duplicates, originals, null));                
                Collections.sort(e, new ExceptionsComparator(order));
            request.setAttribute("exceptions", e);
        } else {
            request.setAttribute("exceptions",PersistenceUtils.getInstance().find(Exceptions.class, params, duplicates, originals, order));
        }
//        }
        return mapping.findForward(SUCCESS);
        
    }
    
    private List duplicateFilter(Collection col) {
        ArrayList result = new ArrayList();
        for(Exceptions e: (Collection<Exceptions>) col) {
            if (e.getExceptionsCollection().size() > 0) {
                result.add(e);
            }
        }
        return result;
    }
    
    
}
