/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.groovy.support;

import org.netbeans.modules.groovy.support.api.GroovyErrorOutputSupport;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.netbeans.modules.groovy.support.common.ScriptHyperlink;
import org.netbeans.modules.groovy.support.common.ScriptDataObject;
import org.netbeans.modules.groovy.support.api.GroovySettings;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.OutputListener;

/** 
 * Represents a file with Groovy script
 *
 * @author Petr Hamernik
 */
public class GroovyDataObject extends ScriptDataObject {

    private static final String EXT = ".groovy"; // NOI18N
    private static final String CAUGHT = "Caught: "; // NOI18N
    
    private final FileObject fileObject;
    
    public GroovyDataObject(FileObject pf, GroovyLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.fileObject = pf;
    }

    public String getScriptExec() {
        GroovySettings groovyOption = new GroovySettings();
        File home = new File(groovyOption.getGroovyHome());
        if ( ( home == null ) || (!home.exists() ) ) {
            String msg = NbBundle.getMessage( GroovyDataObject.class, "MSG_HomeNotSet" );
            throw new IllegalStateException( msg );
        }
        
        StringBuffer buf = new StringBuffer();
        
        buf.append( home.getAbsolutePath() );
        buf.append( Utilities.isWindows() ? "\\bin\\groovy.bat" : "/bin/groovy" ); //NOI18N
        
        return buf.toString();
    }

    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    @Override
    protected Node createNodeDelegate() {
        return new GroovyDataNode(this);
    }

    @Override
    protected DataObject handleCreateFromTemplate( DataFolder df, String name ) throws IOException {
        GroovyDataObject scriptDO = (GroovyDataObject) super.handleCreateFromTemplate( df, name );
        return scriptDO;
    }

    public OutputListener checkErrorLine(String line) {
        GroovyErrorOutputSupport.HyperlinkData data = GroovyErrorOutputSupport.checkErrorLine(line, fileObject);
        if ( data != null ) {
            try {
                return new ScriptHyperlink(data.file.toURI().toURL(), data.message, data.line1, data.column1, data.line2, data.column2);
            } catch (MalformedURLException e) {
                assert false : e;
            }
        }
        return null;
    }

}
