/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.scripting.php.dbginterface.models;

import java.text.MessageFormat;
import org.netbeans.modules.scripting.php.dbginterface.DbgConstants;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.text.Line;
import org.openide.util.NbBundle;

/**
 *
 * @author marcow
 */
public class DebugError {
    private Line line;
    private int type;
    private String description;
    
    /** Creates a new instance of DebugError */
    public DebugError(Line line, int type, String desc) {
        this.line = line;
        this.type = type;
        this.description = desc;
    }
    
    public boolean isError() {
        return type == DbgConstants.ERR_CORE_ERROR || type == DbgConstants.ERR_ERROR ||
                type == DbgConstants.ERR_PARSE;
    }
    
    public boolean isWarning() {
        return type == DbgConstants.ERR_CORE_WARNING || type == DbgConstants.ERR_WARNING;
    }
    
    public boolean isNotice() {
        return type == DbgConstants.ERR_NOTICE;
    }
    
    public Line getLine() {
        return line;
    }
    
    public FileObject getSourceFile() {
        return (FileObject)line.getLookup().lookup(FileObject.class);
    }
    
    public String getDisplayName() {
        String ret = "";
        
        try {
            ret += getSourceFile().getURL().toString() + ":" + (line.getLineNumber() + 1);
        }
        catch (FileStateInvalidException fsie) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, fsie);
            
            ret += getSourceFile().getPath() + ":" + (line.getLineNumber() + 1);
        }

        ret += " : " + getString();
        
        return ret;
    }
    
    public String getString() {
        String ret;
        String id = null;
        
        switch (type) {
        case DbgConstants.ERR_CORE_ERROR:
            id = "ERR_coreError";
            break;
            
        case DbgConstants.ERR_CORE_WARNING:
            id = "ERR_coreWarning";
            break;
            
        case DbgConstants.ERR_ERROR:
            id = "ERR_error";
            break;
            
        case DbgConstants.ERR_NOTICE:
            id = "ERR_notice";
            break;
            
        case DbgConstants.ERR_PARSE:
            id = "ERR_parseError";
            break;
            
        case DbgConstants.ERR_WARNING:
            id = "ERR_warning";
            break;
        }

        if (id != null) {
            ret = MessageFormat.format(NbBundle.getMessage(DebugError.class, id), description);
        }
        else {
            ret = description;
        }
        
        return ret;
    }
}
