/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.php.rt.providers.impl.local;

import java.io.File;
import java.util.Collection;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.rt.providers.impl.*;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.rt.WebServerRegistry;
import org.netbeans.modules.php.rt.spi.providers.Host;
import org.netbeans.modules.php.rt.spi.providers.WebServerProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileUtil;


/**
 * @author  ads
 */
public class LocalHostCustomizer extends AbstractProjectCustomizerComponent {

    private static final long serialVersionUID = 6233510568797205953L;

    public LocalHostCustomizer(WebServerProvider provider, Project project) {
        myProvider = provider;
        initComponents();
        init();
    }

    protected void init() {
        DocumentListener listener = new ContextListener();
        getContextPath().getDocument().addDocumentListener(listener);
    }

    public void store(EditableProperties properties) {
        String context = getContextPath().getText();
        properties.setProperty(AbstractProjectConfigProvider.CONTEXT, context);
    }

    public void read(EditableProperties properties) {
        myProperties = properties;
        String context = getProperties().getProperty(AbstractProjectConfigProvider.CONTEXT);
        myContextPath.setText(context);
        updateHost();
        contextUpdated();
    }

    protected void contextUpdated() {

        Host hostCandidate = getHost();
        if (hostCandidate != null && hostCandidate instanceof LocalHostImpl) {
            LocalHostImpl host = (LocalHostImpl) hostCandidate;

            updateDocumentPath(host);
        }
        if (isContentValid()) {
            fireCustomizerPropertyChanged();
        }
    }

    private boolean isContentValid() {
        // use fireCustomizerErrorMessage(""); here in case of any error
        return true;
    }

    private void updateDocumentPath(LocalHostImpl host) {

        Object obj = host.getProperty(HostImpl.DOCUMENT_PATH);
        if (!(obj instanceof String)) {
            return;
        }

        String path = (String) obj;
        path = path.replace('/', File.separatorChar);
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }

        String context = myContextPath.getText();
        if (context != null) {
            context = context.replace('/', File.separatorChar);
        }
        if (!context.startsWith(File.separator)) {
            context = File.separator + context;
        }
        myDocumentPath.setText(path + context);
        myDocumentPath.setToolTipText(path + context);
    }


    /**
     * reloads host from WebServerRegistry if host id in properties was changed
     */
    private Host updateHost() {
        String hostId = getProperties().getProperty(WebServerProvider.HOST_ID);
        if (myHost != null && myHost.getId().equals(hostId)) {
            return myHost;
        }
        Collection<Host> collection = WebServerRegistry.getInstance().getHosts();
        for (Host host : collection) {
            if (host.getId().equals(hostId)) {
                myHost = host;
                break;
            }
        }
        return myHost;
    }

    private class ContextListener implements DocumentListener {

        /* (non-Javadoc)
         * @see javax.swing.event.DocumentListener#changedUpdate(javax.swing.event.DocumentEvent)
         */
        public void changedUpdate(DocumentEvent arg0) {
            contextUpdated();
        }

        /* (non-Javadoc)
         * @see javax.swing.event.DocumentListener#insertUpdate(javax.swing.event.DocumentEvent)
         */
        public void insertUpdate(DocumentEvent arg0) {
            contextUpdated();
        }

        /* (non-Javadoc)
         * @see javax.swing.event.DocumentListener#removeUpdate(javax.swing.event.DocumentEvent)
         */
        public void removeUpdate(DocumentEvent arg0) {
            contextUpdated();
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        myContextPathLbl = new javax.swing.JLabel();
        myDocumentPathLbl = new javax.swing.JLabel();
        myContextPath = new javax.swing.JTextField();
        myDocumentPath = new javax.swing.JTextField();

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/php/rt/providers/impl/local/Bundle"); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(myContextPathLbl, bundle.getString("LBL_Context_Path")); // NOI18N

        myDocumentPathLbl.setText(bundle.getString("LBL_Destination")); // NOI18N

        myDocumentPath.setEditable(false);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(myContextPathLbl)
                    .add(myDocumentPathLbl))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(myDocumentPath)
                    .add(myContextPath, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 285, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myContextPathLbl)
                    .add(myContextPath, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(myDocumentPathLbl)
                    .add(myDocumentPath, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField myContextPath;
    private javax.swing.JLabel myContextPathLbl;
    private javax.swing.JTextField myDocumentPath;
    private javax.swing.JLabel myDocumentPathLbl;
    // End of variables declaration//GEN-END:variables

    protected JTextField getContextPath() {
        return myContextPath;
    }

    protected JTextField getDocumentPath() {
        return myDocumentPath;
    }

    private WebServerProvider getProvider() {
        return myProvider;
    }

    private Project getProject() {
        return myProject;
    }

    private Host getHost() {
        return myHost;
    }

    private EditableProperties getProperties() {
        return myProperties;
    }

    private AntProjectHelper getAntProjectHelper(Project project) {
        return project.getLookup().lookup(AntProjectHelper.class);
    }

    private Project myProject;

    private WebServerProvider myProvider;

    private EditableProperties myProperties;

    private Host myHost;
}
