/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.php.rt.providers.impl.local.apache;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;




/**
 * @author ads
 *
 */
class SolarisPackageFinder {
    
    static final String PKGINFO                 = "pkginfo";    // NOI18N
    
    static final String GREP                    = "grep";       // NOI18N

    static final String USR_BIN                 = "/usr/bin";   // NOI18N
    
    static final String WHICH                   = "which";      // NOI18N
    
    static final String CATEGORY                = "application";// NOI18N
    
    static final String PKG_KEY                 = "apache";     // NOI18N
    
    static final String SADM_CONTENTS           = 
                        "/var/sadm/install/contents";           // NOI18N
    

    public String[] getPlatformLocations() {
        if ( !whichExists() ) {
            return null;
        }
        Collection<String> pkgNames = getPkgNames();
        if ( pkgNames == null ) {
            return null;
        }
        Set<String> list = new HashSet<String>();
        for ( String name : pkgNames ) {
            String location = getLocation( name );
            list.add( location );
        }
        return list.toArray( new String[ list.size()] );
    }

    private String getLocation( String name ) {
        String grep = getGrep();
        Runtime runtime = Runtime.getRuntime(); 
        try {
            Process process = 
                runtime.exec( new String[] { grep , name , SADM_CONTENTS} );
            InputStream stream = process.getInputStream();
            BufferedReader reader = new BufferedReader( 
                    new InputStreamReader( stream ) );
            String line;
            while ( (line = reader.readLine()) != null ) {
                if ( line.contains( ServerChooserVisual.PATH_TO_HTTPD_CONF)) {
                    return line.substring( 0, 
                            line.indexOf(ServerChooserVisual.PATH_TO_HTTPD_CONF)
                            +ServerChooserVisual.PATH_TO_HTTPD_CONF.length());
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    private boolean whichExists() {
        String which = getProgramPath(WHICH);
        if (which != null) {
            myWhich = which;
            return true;
        }
        else {
            // try to check which in specified place
            myWhich = USR_BIN+ File.separator +WHICH;
            myWhich = getProgramPath( myWhich );
            if ( myWhich == null ) {
                return false;
            }
            else {
                return true;
            }
        }
    }
    
    private String getPkgInfo() {
        if ( myPkgInfo == null ) {
            myPkgInfo = getProgramPath( PKGINFO );
            if ( myPkgInfo == null ) {
                myPkgInfo = getProgramPath( USR_BIN + File.separator +PKGINFO);
            }
        }
        return myPkgInfo;
    }
    
    private String getGrep() {
        if ( myGrep == null ) {
            myGrep = getProgramPath( GREP );
            if ( myGrep == null ) {
                myGrep = getProgramPath( USR_BIN +File.separator +GREP );
            }
        }
        return myGrep;
    }
    
    private Collection<String> getPkgNames( ) {
        Runtime runtime = Runtime.getRuntime();
        String pkgInfo = getPkgInfo();
        String grep = getGrep();
        if ( pkgInfo == null || grep == null ) {
            return null;
        }
        try {
            Process process = runtime.exec( pkgInfo +" -c " +CATEGORY + " -i ");    // NOI18N
            BufferedReader reader = new BufferedReader( 
                    new InputStreamReader( process.getInputStream()));
            String line;
            Collection<String> collection = new LinkedList<String>();
            while( (line = reader.readLine())!=null ) {
                if ( !line.toLowerCase().contains(PKG_KEY)) {
                    continue;
                }
                line = cutName(line);
                if ( line != null ) {
                    collection.add( line );
                }
            }
            return collection;
        }
        catch (IOException e) {
            return null;
        }
    }
    
    private String getProgramPath( String program ) {
        Runtime runtime = Runtime.getRuntime();
        String which = myWhich == null? WHICH : myWhich;
        try {
            Process process = runtime.exec( new String[] { which , program} );
            BufferedReader reader = new BufferedReader( 
                    new InputStreamReader( process.getInputStream()));
            String line;
            while( (line = reader.readLine())!=null ) {
                if ( line.endsWith( program )) {
                    return line;
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
    
    private static String cutName( String str ) {
        if ( str.startsWith( CATEGORY )) {
            str = str.replace( '\t', ' ');
            int index = str.indexOf( ' ');
            str = str.substring( index );
            str = str.trim();
            index = str.indexOf( ' ');
            str = str.substring( 0, index );
            return str.trim();
        }
        return null;
    }
    
    private String myPkgInfo;
    
    private String myGrep;
    
    private String myWhich;
}
