/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.xml.xam.ui.customizer;

import java.awt.Color;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.Utilities;

/**
 *
 * @author  Ajit Bhate
 */
public class MessagePanel extends javax.swing.JPanel implements MessageDisplayer
{
	static final long serialVersionUID = 1L;
	
	/** Creates new form MessagePanel */
	public MessagePanel()
	{
		initComponents();
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {
        panel = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        panel.setLayout(null);

        GroupLayout panelLayout = new GroupLayout(panel);
        panel.setLayout(panelLayout);
        panelLayout.setAutocreateGaps(true);
        panelLayout.setAutocreateContainerGaps(true);
        GroupLayout.ParallelGroup hGroup =
        panelLayout.createParallelGroup();
        panelLayout.setHorizontalGroup(hGroup);
        GroupLayout.SequentialGroup vGroup =
        panelLayout.createSequentialGroup();
        panelLayout.setVerticalGroup(vGroup);
        add(panel, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents

	public void annotate(String message, MessageDisplayer.Type type)
	{
		if(!isVisible()) setVisible(true);
		JLabel messageLabel = new JLabel(message);
		switch(type)
		{
			case ERROR:
                                messageLabel.setForeground(Color.RED);
				messageLabel.setIcon(new ImageIcon(Utilities.loadImage(
						"org/netbeans/modules/xml/xam/ui/resources/error.gif"))); // NOI18N
				break;
			case WARNING:
				messageLabel.setIcon(new ImageIcon(Utilities.loadImage(
						"org/netbeans/modules/xml/xam/ui/resources/warning.gif"))); // NOI18N
				break;
			case INFO:
			default:
		}
		GroupLayout layout = (GroupLayout)panel.getLayout();
		((GroupLayout.ParallelGroup)layout.getHorizontalGroup()).add(messageLabel);
		((GroupLayout.SequentialGroup)layout.getVerticalGroup()).add(messageLabel);
	}

	public void clear()
	{
		remove(panel);
		initComponents();
		setVisible(false);
	}

	public JComponent getComponent()
	{
		return this;
	}
	
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel panel;
    // End of variables declaration//GEN-END:variables
	
}
