/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xslt.model.impl;

import java.util.List;

import org.netbeans.modules.xslt.model.CharacterMap;
import org.netbeans.modules.xslt.model.Output;
import org.netbeans.modules.xslt.model.XslComponent;
import org.netbeans.modules.xslt.model.XslReference;
import org.netbeans.modules.xslt.model.XslVisitor;
import org.netbeans.modules.xslt.model.enums.Standalone;
import org.netbeans.modules.xslt.model.enums.TBoolean;
import org.w3c.dom.Element;


/**
 * @author ads
 *
 */
class OutputImpl extends QNameableImpl implements Output {

    OutputImpl( XslModelImpl model, Element element ) {
        super( model , element );
    }

    OutputImpl( XslModelImpl model ) {
        super( model , XslElements.OUTPUT );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.impl.XslComponentImpl#accept(org.netbeans.modules.xslt.model.XslVisitor)
     */
    @Override
    public void accept( XslVisitor visitor )
    {
        visitor.visit( this );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.impl.XslComponentImpl#getComponentType()
     */
    @Override
    public Class<? extends XslComponent> getComponentType()
    {
        return Output.class;
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.EncodingSpec#getEncoding()
     */
    public String getEncoding() {
        return getAttribute( XslAttributes.ENCODING );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.EncodingSpec#setEncoding(java.lang.String)
     */
    public void setEncoding( String encoding ) {
        setAttribute( XslAttributes.ENCODING, encoding );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.IndentSpec#getIndent()
     */
    public TBoolean getIndent() {
        return TBoolean.forString( getAttribute( XslAttributes.INDENT ) );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.IndentSpec#setIndent(org.netbeans.modules.xslt.model.enums.TBoolean)
     */
    public void setIndent( TBoolean value ) {
        setAttribute( XslAttributes.INDENT, value );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Output#getStandalone()
     */
    public Standalone getStandalone() {
        return Standalone.forString( getAttribute( XslAttributes.STANDALONE ));
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Output#setStandalone(org.netbeans.modules.xslt.model.enums.Standalone)
     */
    public void setStandalone( Standalone value ) {
        setAttribute( XslAttributes.STANDALONE, value );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Output#getUndeclarePrefixes()
     */
    public TBoolean getUndeclarePrefixes() {
        return TBoolean.forString( getAttribute( XslAttributes.UNDECLARE_PREFIXES));
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Output#setUndeclarePrefixes(org.netbeans.modules.xslt.model.enums.TBoolean)
     */
    public void setUndeclarePrefixes( TBoolean value ) {
        setAttribute( XslAttributes.UNDECLARE_PREFIXES, value );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.UseCharacterMapsSpec#getUseCharacterMaps()
     */
    public List<XslReference<CharacterMap>> getUseCharacterMaps() {
        return resolveGlobalReferenceList( CharacterMap.class, 
                XslAttributes.USE_CHARACTER_MAPS );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.UseCharacterMapsSpec#setUseCharacterMaps(java.util.List)
     */
    public void setUseCharacterMaps( List<XslReference<CharacterMap>> list ) {
        setAttribute( XslAttributes.USE_CHARACTER_MAPS, list );
    }

}
