#ifndef FILE_NGBLA
#define FILE_NGBLA


#ifdef USE_BLAS

extern "C"
{
  // #include <cblas.h>
#include <mkl_cblas.h>
}
#endif


/// namespace for basic linear algebra
namespace ngbla
{
  using namespace std;
  using namespace ngstd;


  typedef std::complex<double> Complex;
  inline double fabs (Complex v) { return std::abs (v); }


#include "expr3.hpp"
#include "vector.hpp"
#include "matrix.hpp"
#include "cholesky.hpp"
#include "bandmatrix.hpp"


  /// Computes eigenvalues and vectors of the symmetric matrix mat.
  extern void CalcEigenSystem (const FlatMatrix<double> & mat,
			       FlatVector<double> & lami,
			       FlatMatrix<double> & eigenvecs);
}


#endif
