/* Copyright (C) 2004 Per Johansson
	
	This file is part of netGo.

    netGo is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    netGo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with netGo; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <qlineedit.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qdialog.h>
#include <qdir.h>
#include <qsettings.h>
#include <qvalidator.h>
#include <qstring.h>

#include "setup.h"
#include "settings.h"

// Default constructor for the setup wizard.
Setup::Setup()
{
	setFinishEnabled(pathPage, 1);
	setHelpEnabled(pathPage, 0);
	
	// Enable the dhcpcd checkbox and line-edit by default.
	dhcpcdBox->setChecked(1);
	dhcpcdPath->setEnabled(1);
	
	// Disable the dhclient checkbox and line-edit by default.
	dhclientBox->setChecked(0);
	dhclientPath->setEnabled(0);

	// Signals and slots.
	connect(dhcpcdBox, SIGNAL(clicked()), this, SLOT(onDhcpcdCheck()) );
	connect(dhclientBox, SIGNAL(clicked()), this, SLOT(onDhclientCheck()) );
	
	// Regexps.
	path = QRegExp("[^ ]*");
	
	// Apply validators to the line edits.
	ifconfigPath->setValidator(new QRegExpValidator(path, this));
	routePath->setValidator(new QRegExpValidator(path, this));
	iwconfigPath->setValidator(new QRegExpValidator(path, this));
	dhcpcdPath->setValidator(new QRegExpValidator(path, this));
	dhclientPath->setValidator(new QRegExpValidator(path, this));	
}

void Setup::accept()
{
	// Make sure that all the paths are filled in before exiting.
	if (dhcpcdBox->isChecked()) {
		if (ifconfigPath->text().isEmpty() || routePath->text().isEmpty() || iwconfigPath->text().isEmpty() || dhcpcdPath->text().isEmpty() )
			QMessageBox::information(0, "Missing paths", "Please specify paths to all commands.");
		else
			saveSettings(dhcpcdPath->text() );
	}
	else if (dhclientBox->isChecked()) {
		if (ifconfigPath->text().isEmpty() || routePath->text().isEmpty() || iwconfigPath->text().isEmpty() || dhclientPath->text().isEmpty() )
			QMessageBox::information(0, "Missing paths", "Please specify paths to all commands.");
		else
			saveSettings(dhclientPath->text() );
	}
}

void Setup::saveSettings(QString dhcpPath)
{
	QSettings *paths = new QSettings();
	paths->insertSearchPath(QSettings::Unix, QDir::homeDirPath() + "/.qt");
	
	// Write the specified settings.
	paths->beginGroup("/netgo/paths");
		paths->writeEntry("ifconfig", ifconfigPath->text());
		paths->writeEntry("route", routePath->text());
		paths->writeEntry("iwconfig", iwconfigPath->text());
		paths->writeEntry("dhcp client", dhcpPath);
	paths->endGroup();
	
	// The keys are written in the destructor of QSettings.
	delete paths;
	
	// After we have saved the settings, we need to read in them.
	Settings::fetchSettings();
	
	// Exit the setup.
	QDialog::accept();
}

void Setup::onDhclientCheck()
{
	// Mark the dhclient checkbox as checked.
	dhcpcdBox->setChecked(0);
	dhclientBox->setChecked(1);
		
	// Enable and disable the appropriate line-edits.
	dhclientPath->setEnabled(1);
	dhcpcdPath->setEnabled(0);
}

void Setup::onDhcpcdCheck()
{
	// Mark the dhcpcd checkbox as checked.
	dhcpcdBox->setChecked(1);
	dhclientBox->setChecked(0);
	
	// Enable and disable the appropriate line-edits.
	dhcpcdPath->setEnabled(1);
	dhclientPath->setEnabled(0);
}
