#ifndef NOMAD_UTIL_H
#define NOMAD_UTIL_H

#include <glib.h>

gchar *seconds_to_mmss( guint seconds );
guint mmss_to_seconds( const gchar *mmss );

gpointer nomad_create( const gchar *path );
void nomad_close( gpointer handle );
gboolean nomad_write( gpointer handle, const char *buf, guint len );
gboolean nomad_seek( gpointer handle, gint pos, gint offset );
gboolean nomad_read( gpointer handle, gchar *buf, guint len );
gint nomad_tell( gpointer handle );

gboolean nomad_mkdir_recursive( const gchar *path );

gchar *nomad_filename_escape( const gchar *string );

#endif
