#!/bin/sh 

############################################################################
# The newbiedoc project archive creator 
#  version 1.1
#
# This code is protected by the GPL license: www.gnu.org/copyleft/gpl.html
#  
#
# How it works:
#
#   just cd to a directory where you have write permission
#   and call make_archive.sh filename.tar your_local_cvs:
#
#   make_archive.sh  hop.tar ~/NewbieDocDVS/newbiedoc backend [dsssl] 
#
#   backend: the 'backend' for sgmltools. Usually html or onehtml
#     it can be many things, as long as they are supported by sgmltools
#     and you have the corresponding dsssl. Default is 'html' for multiple-page
#     html.
# Optional argument:
#   dsssl: The dsssl file you may want to use to compile sgml into html.
#
#
#   As usual E-mail me for comments, bugs, improvements etc
#   rom1 at users.sourceforge.net
#
# Authors:
#
#  Romain Lerallut
#  Tom Huckstep
#
#############################################################################

# Some variable definitions

#VERBOSE_TAR=--verbose
#DEBUG=yes
DEBUG=no
BUILD=yes


# DEBUG is really only a talkative 'verbose'. Use it to display additional 
# messages.

# default setting for whether we build multiple- or single-page html docs
BUILD_TYPE=html

# so we know what to call this script when displaying an error message
	PROG_NAME=$(basename $0)

# checking for the correct number of arguments
	if [ $# -lt 3 ]; then
		echo "Usage: $PROG_NAME archive_file source_directory backend [dsssl_file]"
		exit  0
	fi

#---- Optional arguments:-----

	
# checking for non-default setting of html/onehtml:
	if [ $# -ge 3 ]; then
			BUILD_TYPE=$3
			test $DEBUG && echo "Output is $3"
	fi
# getting the dsssl if it was specified
	if [ $# -ge 4 ]; then
		DSSSL_FILE=$4
		cd $( dirname $DSSSL_FILE )
		DSSSL_FILE=$PWD/$( basename $DSSSL_FILE)
		cd -
		test $DEBUG && echo "DSSSL file is " $DSSSL_FILE $4
	else
		DSSSL_FILE=none
	fi

#------------------------------
# we're going to move around a bit, so let's remember where we started from
	INITIAL_DIR=$PWD

# we're going to temporarily write to $TEMP_DIR/$ND_DIR/ and then
# tar all the files into $TEMP_DIR/$TEMP_TAR:
	TEMP_DIR=/tmp
	ND_DIR=newbiedoc-$BUILD_TYPE    # only 1 dir deep!
	TEMP_TAR=newbie.tmp.tar.gz

# the output will be:
	WRITE_FILE=$1
	WRITE_DIR=$(dirname $WRITE_FILE)

# that's where the user said the source files are
	SOURCE_DIR=$2

#---- Functions used in the code -------------------------------------------#

#it's a " multiple backspace"
	function back_echo ()
	{
# usage: back_echo number_of_backspaces
		if [ $# != 1 ]; then
			echo "Internal error: incorrect number of parameters for back_echo"
			exit 2
		fi
		local NUM_CHARS=$1
		local i
		let i=0
		while [ $i -lt $NUM_CHARS ]; do
			echo -n -e '\b'
			# -e for 'understand the \xxx characters'
			# -n for 'forget about the trailing newline'
			let i=$i+1
		done
	}

# this is where we actually call 'sgmltools' to compile the sgml source to html (or other)
# it is a bit complicated because I wanted to have a "xx% completed" counter.
# Note: the counter works on files, not size, so it might not represent 
# anything close to the remaining compilation time...
	function actual_compilation()
	{
		local COMPLETED_STRING
		local completed_string_size
		local FILE

		for FILE in $SOURCE_FILES; do
# this is the string that display xx% completed
			COMPLETED_STRING="==> $(( $NUM_COMPILED / $NUM_SOURCE_FILES ))% completed"
			echo -n $COMPLETED_STRING

# get string size:
			completed_string_size=$( echo -n $COMPLETED_STRING | wc -c )
		
#    Backspaceing  over exactly the "xx% Completed" part
			back_echo $completed_string_size

# so we don't have to multiply current/total_number by 100 to get percents
# we just add 100. Since we don't need NUM_COMPILED for anything else,
# this is not a problem...
			let NUM_COMPILED=$NUM_COMPILED+100
# Deprecated: ------------------------------------------------------
# ndb2html builds in the current dir, in this case $TEMP_DIR/$ND_DIR
#			ndb2html single $FILE
# ------------------------------------------------------------------
#
#  sgmltools builds in a subdir of where the source file is, so
#  we had to work on a local copy. This is the actual build:
			if [ $DSSSL_FILE != none ]; then
			    if [ $BUILD_TYPE = html ]; then
				    if [ $( basename $FILE ) != index.sgml ]; then
					sgmltools -b $BUILD_TYPE -s $DSSSL_FILE $FILE || exit 1
				    else
					sgmltools -b onehtml $FILE || exit 1
				    fi
			    fi
			else
			sgmltools -b $BUILD_TYPE  $FILE || exit 1
			fi

# sgmltools creates a subdir and the index is sometimes called 't1.html', let's
# change it !
# Note: this is a horrible hack, I know.
			BASENAME=$( basename $FILE .sgml )
			if [ -e $TEMP_DIR/$ND_DIR/$BASENAME/t1.html ]; then
			test $DEBUG && echo "mv $TEMP_DIR/$ND_DIR/$BASENAME/t1.html $TEMP_DIR/$ND_DIR/$BASENAME/index-$BASENAME.html"
			mv $TEMP_DIR/$ND_DIR/$BASENAME/t1.html $TEMP_DIR/$ND_DIR/$BASENAME/index-$BASENAME.html
			fi
		done

# this prints the last 100% completed 
		COMPLETED_STRING="$(( $NUM_COMPILED / $NUM_SOURCE_FILES ))% completed"
		echo -e -n $COMPLETED_STRING
		completed_string_size=$(echo -n $COMPLETED_STRING | wc -c )
		back_echo $completed_string_size
# no, it's not useless to display 100% completed if we echo 'done'
# right after. I tried on a slow standalone X terminal, and the echo was so
# slow I could actually see the 100%.
# Besides, we might one day do fancy things before echo-ing 'done', so the
# 100% will lot cleaner.

# see the few spaces after done ? That's cuz if you don't you'll see
# "done completed" instead of "done".
		echo 'done                        '
	}


#---- Start of the main code: ----------------------------------------------#


# checking for permissions...
	if [ -d $WRITE_FILE ]; then
		echo "Fatal error in $PROG_NAME:"
		echo "$WRITE_FILE is a directory"
		exit 1
	fi

	if [ ! -w $WRITE_DIR ]; then
 		echo "Fatal error in $PROG_NAME:"
		echo "You do not have write permissions for directory $WRITE_DIR"
		exit 1
	fi

	if [ ! -r $SOURCE_DIR ]; then
		echo "Fatal error in $PROG_NAME:"
		echo "Cannot read from $SOURCE_DIR"
		exit 1
	fi
#---- obsolete -------------------------------------------------------------#
# checking that ND_DIR is one-deep:
#	if [ $( dirname $ND_DIR ) != "." ]; then
#		echo "Internal error: variable ND_DIR should be a depth 1 directory"
#		echo "Current value is $ND"
#		exit 2
#	fi
#---------------------------------------------------------------------------#

# Fully qualify $SOURCE_DIR (get rid of ./ ../ etc.)
#   we're going to need an absolute pathname  because when we move to 
#$TEMP_DIR, a relative pathname will be useless.

	cd $SOURCE_DIR
	SOURCE_DIR=$PWD
	test $DEBUG && echo "Fully qualified source directory is $SOURCE_DIR"

# Now make a $TEMP_DIR/$ND_DIR directory to build in
	test $DEBUG && echo "Moving to $TEMP_DIR from $INITIAL_DIR"
	cd $TEMP_DIR
	if [ ! -d $ND_DIR ]; then
 		test $BUILD && mkdir $ND_DIR
 		test $DEBUG && echo "Creating a $TEMP_DIR/$ND_DIR directory"
		WE_MADE_IT=yes
	else
 		test $DEBUG && echo "Using existing $TEMP_DIR/$ND_DIR directory"
		# we might want to clean this
		WE_MADE_IT=no
	fi

# move to that directory
	cd $ND_DIR
	test $DEBUG && echo "Moving to $ND_DIR"

# after this line will be appended during the compilation something like
# "xx% completed" :
	echo -n "Compiling sgml sources in $TEMP_DIR/$ND_DIR..."

#-------------------------------------------------------------------------
#             Compilation process

# $SOURCE_DIR is the source directory
#   What are the files to compile ?
	test $DEBUG && echo "find $SOURCE_DIR -follow -name *.sgml"
	SOURCE_FILES=$( find $SOURCE_DIR -follow -name '*.sgml'	)
#   Moving them to TEMP_DIR:
	for FILE in $SOURCE_FILES; do
		cp $FILE $TEMP_DIR/$ND_DIR/$( basename $FILE ) || exit 0
	done
# copying the images along:
	test $DEBUG && echo "creating a directory for the images"
	if [ ! -d $TEMP_DIR/$ND_DIR/images ]; then
		mkdir $TEMP_DIR/$ND_DIR/images 
	fi
	test $DEBUG && echo "copying from $SOURCE_DIR/images to $TEMP_DIR/$ND_DIR/images"
	cp -r $SOURCE_DIR/images/* $TEMP_DIR/$ND_DIR/images
		
# copying the non-sgml file:

	if [ $BUILD_TYPE = html ]; then
	    cp $SOURCE_DIR/metatools/test.css $TEMP_DIR/$ND_DIR
	fi
	
#   Using the temporary source files as the new SOURCE_FILES:
	SOURCE_FILES=$( find $TEMP_DIR/$ND_DIR -name '*.sgml' )
	test $DEBUG && echo "Temp. source files are $SOURCE_FILES"
#   Their number:
	NUM_SOURCE_FILES=$( echo $SOURCE_FILES | wc -w )
	test $DEBUG && echo "Source files are: "$SOURCE_FILES $NUM_SOURCE_FILES
#   The number of compiled files so far:
	NUM_COMPILED=0

# this call the function defined above
	actual_compilation
#------------------------------------------------------------------------

# removing all sgml source files
	rm $TEMP_DIR/$ND_DIR/*.sgml
#moving out of $TEMP_DIR/$ND_DIR to $TEMP_DIR
	cd $TEMP_DIR


# linking "index-whatever.sgml" to index.html

	INDEXES=$( find . -name 'index-*.html' )
	echo $INDEXES

	for FILE in $INDEXES; do
	    if [ ! -e $(dirname $FILE)/index.html ]; then
		test $DEBUG && echo $FILE
		ln -s  $( basename $FILE) $(dirname $FILE)/index.html
	    fi
	done

	test $DEBUG && echo "Exiting directory $TEMP_DIR/$ND_DIR to $PWD"
	echo -n 'Creating archive with processed files...'


	tar $VERBOSE_TAR zcf $TEMP_TAR ./$ND_DIR/* || exit 1

#the idea of having $TEMP_DIR/$ND_DIR is that when tarring from
#$TEMP_DIR all the files are in a ./$ND_DIR subdir. Besides I know I
#have write permissions to /tmp (= $TEMP_DIR)

	echo 'done'
# if this shell created the $TEMP_DIR shell, then it is its responsibility
# to remove it.:
	if [ $WE_MADE_IT = yes ]; then
		echo "Cleaning up: removing directory $TEMP_DIR/$ND_DIR"
		rm -rf $TEMP_DIR/$ND_DIR
	fi

# moving back to where the script was called
	test $DEBUG && echo "Moving back to $INITIAL_DIR"
	cd $INITIAL_DIR

# create the final archive
	echo -n 'Creating final archive...'
	mv $TEMP_DIR/$TEMP_TAR $WRITE_FILE
	echo 'done'

	echo "Process complete: archive $WRITE_FILE created"



