/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddCaEntity.cpp: implementation of the DlgAddCaEntity class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddCaEntity.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddCaEntity, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddCaEntity::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddCaEntity::OnCancel)
    EVT_RADIOBUTTON(IDC_KEY_SERVER_ENTITY, DlgAddCaEntity::OnServerKeyEntity)
    EVT_RADIOBUTTON(IDC_KEY_ENGINE_ENTITY, DlgAddCaEntity::OnEngineKeyEntity)
END_EVENT_TABLE()


DlgAddCaEntity::DlgAddCaEntity(wxWindow * wParent, PkiClient * ClientPki):DlgAddEntity(wParent, _("Add CA Entity"), ClientPki)
{
	DlgAddCaEntity_SetWindow(this);

	LoadKeyLen((wxComboBox *)FindWindow(IDC_LIST_LEN_ENTITY));

	wxCommandEvent event2;
	OnServerKeyEntity(event2);
	CenterOnScreen();
	ShowModal();
}

DlgAddCaEntity::~DlgAddCaEntity()
{
}

void DlgAddCaEntity::OnOk(wxCommandEvent& event)
{
	int nItem;
	wxString m_KeyId;
	int RsaLen;	
	GenPrivateKey entity_key;
	wxString m_EntityName;
	wxString m_EntityMail;


	m_EntityName = ((wxTextCtrl *)FindWindow(IDC_ENTITY_NAME))->GetValue();
	if(!m_EntityName.Len())
	{
		return;
	}
	m_EntityMail = ((wxTextCtrl *)FindWindow(IDC_EMAIL))->GetValue();
	if(!m_EntityMail.Len())
	{
		return;
	}

	// Entity Cert KEY
	if( ((wxRadioButton *)FindWindow(IDC_KEY_ENGINE_ENTITY))->GetValue() )
	{
		if( !((wxTextCtrl *)FindWindow(IDC_KEY_ID_ENTITY))->GetValue().Len() )
		{
			return;
		}
		m_KeyId = ENGINE_HEAD;
		m_KeyId += ((wxTextCtrl *)FindWindow(IDC_KEY_ID_ENTITY))->GetValue();
		
		if(!entity_key.set_type(GEN_PRIVATE_KEY_TYPE_ENGINE))
		{
			HandleErrorResult(NULL, this, 0);
			return;
		}
		entity_key.set_keyid(m_KeyId.GetData());
	}
	else
	{
		nItem = ((wxComboBox *)FindWindow(IDC_LIST_LEN_ENTITY))->GetSelection();
		RsaLen = (long)((wxComboBox *)FindWindow(IDC_LIST_LEN_ENTITY))->GetClientData(nItem);
		
		if(!entity_key.set_type(GEN_PRIVATE_KEY_TYPE_KEYLEN))
		{
			HandleErrorResult(NULL, this, 0);
			return;
		}
		entity_key.set_keylen(RsaLen);
	}

	if(!AddEntity(m_EntityName.GetData(), m_EntityMail.GetData(), ENTITY_TYPE_CA, entity_key, PubCreationReq::EmptyInstance, NULL, 0))
		return;

	m_IsOK = true;
	Close(TRUE);
}

void DlgAddCaEntity::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}


void DlgAddCaEntity::OnServerKeyEntity(wxCommandEvent &event)
{
	OnServerKey(IDC_LBL_KEYID_ENTITY, IDC_KEY_ID_ENTITY, IDC_LBL_KEYLEN_ENTITY, IDC_LIST_LEN_ENTITY);
}

void DlgAddCaEntity::OnEngineKeyEntity(wxCommandEvent &event)
{
	OnEngineKey(IDC_LBL_KEYID_ENTITY, IDC_KEY_ID_ENTITY, IDC_LBL_KEYLEN_ENTITY, IDC_LIST_LEN_ENTITY);
}

