/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgBashImport.h: interface for the DlgBashImport class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGBASHIMPORT_H
#define DLGBASHIMPORT_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <wx/imaglist.h>
#include <wx/listctrl.h>
#include <wx/dialog.h>

#include <stdio.h>
#include <string.h>
#include "Error.h"
#include <PkiClient.h>
#include "XmlImport.h"

#include <vector>
using namespace std;





class DlgBashImportListCtrl: public wxListCtrl
{
public:
	DlgBashImportListCtrl(wxWindow *parent, const wxWindowID id, const wxPoint& pos,
			const wxSize& size, long style):
		wxListCtrl(parent, id, pos, size, style)
		{
		}

	void OnItemClick(wxListEvent& event);
	void OnMouseEvent(wxMouseEvent & event);
private:
	DECLARE_EVENT_TABLE()
};


class DlgBashImport: public wxDialog
{
public:
	DlgBashImport(wxWindow * wParent, const EntityConf & cEntityConf, PkiClient * ClientPki);
	virtual ~DlgBashImport();
	void OnItemClick(wxListEvent& event);
	void OnCancel(wxCommandEvent& event);
	void OnImportXML(wxCommandEvent& event);
	void OnImport(wxCommandEvent& event);
	void OnSaveDtd(wxCommandEvent& event);
	void OnSaveState(wxCommandEvent& event);
	void OnMouseEvent(wxMouseEvent & event);
	void LoadXML(const mString & file);
	void ReloadList();
private:
	void Clear();
	void MouseMove(long item);
	void MouseDown(long item);
	void DrawCloseProfile(long item, XmlProfile * Profile);
	void DrawOpenProfile(long item, XmlProfile * Profile);
	XmlRequest * GetSelectedCert(long Item = -1);
	XmlProfile * GetSelectedProfile(long Item = -1);

	#define IS_BASH_PROFILE_ICON(x) (x == PlusProfileIconId || x == EmptyProfileIconId || x == MinusProfileIconId)
	#define IS_BASH_CERT_ICON(x) (x != PlusProfileIconId && x != EmptyProfileIconId && x != MinusProfileIconId)

	static void xmlErrorCB(void *ctx, const char *msg, ...);
	static void xmlWarningCB(void *ctx, const char *msg, ...);
	PkiClient * m_ClientPki;	
	wxListCtrl * m_listCtrl;
	wxImageList *m_imageListSmall;
	mString m_Errors;
	mString m_Warnings;
	xmlDtdPtr xDtd;
	vector<XmlProfile*> m_profiles;
	int EmptyProfileIconId;
	int PlusProfileIconId;
	int MinusProfileIconId;
	int ActMidConnectorIconId;
	int ActEndConnectorIconId;
	long lastItem;
	const EntityConf & m_EntityConf;
	DECLARE_EVENT_TABLE()
};

#endif

